/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.exception.JDBCExceptionHelper;

public class Isolater {
    private static final Log log = LogFactory.getLog((Class)Isolater.class);

    public static void doIsolatedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work, true);
        } else {
            new JdbcDelegate(session).delegateWork(work, true);
        }
    }

    public static void doNonTransactedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work, false);
        } else {
            new JdbcDelegate(session).delegateWork(work, false);
        }
    }

    public static class JdbcDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JdbcDelegate(SessionImplementor session) {
            this.session = session;
        }

        /*
         * Loose catch block
         */
        public void delegateWork(IsolatedWork work, boolean transacted) throws HibernateException {
            block16: {
                boolean wasAutoCommit;
                Connection connection;
                block17: {
                    block15: {
                        connection = null;
                        wasAutoCommit = false;
                        connection = this.session.getBatcher().openConnection();
                        if (transacted && connection.getAutoCommit()) {
                            wasAutoCommit = true;
                            connection.setAutoCommit(false);
                        }
                        work.doWork(connection);
                        if (!transacted) break block15;
                        connection.commit();
                    }
                    Object var8_5 = null;
                    if (connection == null) break block16;
                    if (!transacted || !wasAutoCommit) break block17;
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (Throwable ignore) {
                        log.trace((Object)"was unable to reset connection back to auto-commit");
                    }
                }
                this.session.getBatcher().closeConnection(connection);
                {
                    break block16;
                    catch (Throwable t) {
                        try {
                            if (transacted && connection != null && !connection.isClosed()) {
                                connection.rollback();
                            }
                        }
                        catch (Throwable ignore) {
                            log.trace((Object)("unable to release connection on exception [" + ignore + "]"));
                        }
                        if (t instanceof HibernateException) {
                            throw (HibernateException)t;
                        }
                        if (t instanceof SQLException) {
                            throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), (SQLException)t, "error performing isolated work");
                        }
                        throw new HibernateException("error performing isolated work", t);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    if (connection != null) {
                        if (transacted && wasAutoCommit) {
                            try {
                                connection.setAutoCommit(true);
                            }
                            catch (Throwable ignore) {
                                log.trace((Object)"was unable to reset connection back to auto-commit");
                            }
                        }
                        this.session.getBatcher().closeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static class JtaDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JtaDelegate(SessionImplementor session) {
            this.session = session;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void delegateWork(IsolatedWork work, boolean transacted) throws HibernateException {
            TransactionManager transactionManager = this.session.getFactory().getTransactionManager();
            Transaction surroundingTransaction = null;
            Connection connection = null;
            boolean caughtException = false;
            try {
                try {
                    surroundingTransaction = transactionManager.suspend();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("surrounding JTA transaction suspended [" + surroundingTransaction + "]"));
                    }
                    if (transacted) {
                        transactionManager.begin();
                    }
                    connection = this.session.getBatcher().openConnection();
                    work.doWork(connection);
                    this.session.getBatcher().closeConnection(connection);
                    if (transacted) {
                        transactionManager.commit();
                    }
                }
                catch (Throwable t) {
                    caughtException = true;
                    try {
                        if (connection != null && !connection.isClosed()) {
                            this.session.getBatcher().closeConnection(connection);
                        }
                    }
                    catch (Throwable ignore) {
                        log.trace((Object)("unable to release connection on exception [" + ignore + "]"));
                    }
                    if (transacted) {
                        try {
                            transactionManager.rollback();
                        }
                        catch (Throwable ignore) {
                            log.trace((Object)("unable to rollback new transaction on exception [" + ignore + "]"));
                        }
                    }
                    if (!(t instanceof HibernateException)) throw new HibernateException("error performing isolated work", t);
                    throw (HibernateException)t;
                }
                Object var10_7 = null;
                if (surroundingTransaction == null) return;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (surroundingTransaction == null) throw throwable;
                try {
                    transactionManager.resume(surroundingTransaction);
                    if (!log.isDebugEnabled()) throw throwable;
                    log.debug((Object)("surrounding JTA transaction resumed [" + surroundingTransaction + "]"));
                    throw throwable;
                }
                catch (Throwable t) {
                    if (caughtException) throw throwable;
                    throw new HibernateException("unable to resume previously suspended transaction", t);
                }
            }
            try {}
            catch (Throwable t) {
                if (caughtException) return;
                throw new HibernateException("unable to resume previously suspended transaction", t);
            }
            transactionManager.resume(surroundingTransaction);
            if (!log.isDebugEnabled()) return;
            log.debug((Object)("surrounding JTA transaction resumed [" + surroundingTransaction + "]"));
        }
    }

    private static interface Delegate {
        public void delegateWork(IsolatedWork var1, boolean var2) throws HibernateException;
    }
}

