var loaded = false;
var myMap = null;

$(document).ready(function() {
	$("#projectLocationTab").click(function() { 
		loadVEAPI();
	});
	$(window).unload(function() {
		UnloadMap();
	});
});

function HandleMouseClickEvent(e)
{
	//  var lat = location.Latitude;
	//   var lng = location.Longitude;
	myMap.DeleteAllPushpins();

	var x = e.mapX;
	var y = e.mapY;
	var pixel = new VEPixel(x, y);
	var LL = myMap.PixelToLatLong(pixel);
	document.getElementById("txtLatitude").value= LL.Latitude;
	document.getElementById("txtLongitude").value= LL.Longitude;
	AddShape(LL);
}

function AddShape( latlong) { 
	// Create Pushpin Shape 
	var pin = new VEPushpin(1,latlong, null, null, null);            
	myMap.AddPushpin(pin);
	myMap.SetCenter(latlong);
}

 function UnloadMap()
 {
    if (myMap != null) {
       myMap.Dispose();
    }
 }
 
 function loadVEAPI() {
     if (!loaded) {
         loaded = true;
         if (!(window.attachEvent)) {
             appendJS("http://dev.virtualearth.net/mapcontrol/v6.2/js/atlascompat.js");               
         }
         appendJS("http://dev.virtualearth.net/mapcontrol/mapcontrol.ashx?v=6.2&onScriptLoad=onscriptload");
     }
 }
 
 function onscriptload() {
     //get rid of our load animation and load the map
	 document.getElementById("mapdiv").style.background = "";
     myMap = new VEMap("mapdiv");
     myMap.LoadMap();
     myMap.SetZoomLevel(7); 
  
     //   myMap.AttachEvent("onchangeview", HandleSytleChange);

     if((document.getElementById("txtLatitude").value != "")&& (document.getElementById("txtLongitude").value !=""))
     {
	 	var latlong = new VELatLong(document.getElementById("txtLatitude").value, document.getElementById("txtLongitude").value)
	 	AddShape(latlong);
     }else {
	 	myMap.SetCenter(new VELatLong(47.635,-122.480)); 
     }

     myMap.AttachEvent("ondoubleclick",HandleMouseClickEvent);
}
 
 function appendJS(filename) {
     var fileref = document.createElement('script');
     fileref.setAttribute("type", "text/javascript");
     fileref.setAttribute("src", filename);
     document.getElementsByTagName("head")[0].appendChild(fileref);
 }