/**
 * 
 */
package com.saic.eebc.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
 
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

 
public class SessionFilter implements Filter {
	public void destroy() {}

	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		HttpServletRequest req = (HttpServletRequest)request;
		// Check whether the current user session is logged in
		if(req.getRequestURI().indexOf("login.do") == -1 && req.getRequestURI().indexOf("logout.do") == -1 && req.getRequestURI().indexOf("editUser.do") == -1 && req.getRequestURI().indexOf("editAdminUser.do") == -1) {
			if(req.getSession() == null || req.getSession().getAttribute("login_user") == null) {
				// unauthorized access
				((HttpServletResponse)(response)).sendRedirect("login.do");
				return;
			}
		}

		chain.doFilter(request, response);
	}

	public void init(FilterConfig config) throws ServletException {

	}
}