package com.saic.eebc.validator;

import java.math.BigDecimal;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import com.saic.eebc.dto.EebcProductEntryObjectDTO;
import com.saic.eebc.dto.InputUseAndEOLDTO;

@Component("eolValidator")
public class EolValidator implements Validator

{
	//private String numberExpression ="^-?(?:\\d+|\\d{1,3}(?:,\\d{3})+)(?:\\.\\d+)?$";
	private String numberExpression ="^(\\+|-)?\\d+(\\.\\d+)?$";
	private String digitExpression ="^\\d+$";

	@SuppressWarnings("unchecked")
	@Override
	public boolean supports(Class clazz)

	{
		return InputUseAndEOLDTO.class.isAssignableFrom(clazz);

	}

	@Override
	public void validate(Object model, Errors errors) {
		EebcProductEntryObjectDTO eebcProductEntryObject = (EebcProductEntryObjectDTO)model;
		InputUseAndEOLDTO inputUseeolObject = eebcProductEntryObject.getInputUseAndEolObject();
		String  totalNotPresent ="notPresent";
		if(inputUseeolObject!=null){
			if(inputUseeolObject.getDesktopComputerUse()!=null)
			{
			if(inputUseeolObject.getDesktopComputerUse().getTotalEnergy4Units() != null && inputUseeolObject.getDesktopComputerUse().getTotalEnergy4Units().trim().length()>0)
			{
				if(!inputUseeolObject.getDesktopComputerUse().getTotalEnergy4Units().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.desktopComputerUse.totalEnergy4Units","validation.empty", "Please enter a valid number for Total number of ENERGY STAR 5.* units for Desktop.");
				}
			}
			if(inputUseeolObject.getDesktopComputerUse().getTotalEnergy5Units() != null && inputUseeolObject.getDesktopComputerUse().getTotalEnergy5Units().trim().length()>0)
			{
				if(!inputUseeolObject.getDesktopComputerUse().getTotalEnergy5Units().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.desktopComputerUse.totalEnergy5Units","validation.empty", "Please enter a valid number for Total number of ENERGY STAR 6.* units for Desktop.");
				}
			}
			if(inputUseeolObject.getDesktopComputerUse().getAverageLifeSpanOfUnits() != null && inputUseeolObject.getDesktopComputerUse().getAverageLifeSpanOfUnits().trim().length()>0)
			{
				if(!inputUseeolObject.getDesktopComputerUse().getAverageLifeSpanOfUnits().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.desktopComputerUse.averageLifeSpanOfUnits","validation.empty", "Please enter a valid number for Average Lifespan of Units for Desktop.");
				}else{
					totalNotPresent ="Present";
				}
			}
			if(inputUseeolObject.getDesktopComputerUse().getPercentPowerManagedComputer() != null && inputUseeolObject.getDesktopComputerUse().getPercentPowerManagedComputer().trim().length()>0)
			{
				if(!inputUseeolObject.getDesktopComputerUse().getPercentPowerManagedComputer().matches(numberExpression))
				{
					errors.rejectValue("inputUseAndEolObject.desktopComputerUse.percentPowerManagedComputer","validation.empty", "Please enter a valid % of COMPUTERS with power management feature enabled for Desktop value.");
				}else{
					totalNotPresent ="Present";
				     if(new BigDecimal(inputUseeolObject.getDesktopComputerUse().getPercentPowerManagedComputer()).compareTo(new BigDecimal("100")) == 1)
				     {
				    	 errors.rejectValue("inputUseAndEolObject.desktopComputerUse.percentPowerManagedComputer","validation.empty", "% of COMPUTERS with power management feature enabled for Desktop value should be less than 100."); 
				     }
				}
			}
			if("Present".equalsIgnoreCase(totalNotPresent))
			{
				ValidationUtils.rejectIfEmptyOrWhitespace(errors,"inputUseAndEolObject.desktopComputerUse.totalEnergy4Units" , "total4energy.required", "Please enter Total number of ENERGY STAR 5.* units for Desktop.");
				ValidationUtils.rejectIfEmptyOrWhitespace(errors,"inputUseAndEolObject.desktopComputerUse.totalEnergy5Units" , "total5energy.required", "Please enter Total number of ENERGY STAR 6.* units for Desktop.");
				totalNotPresent ="notPresent";  
			}
			}
			if(inputUseeolObject.getCrtUse()!=null)
			{
			if(inputUseeolObject.getCrtUse().getTotalEnergy4Units() != null && inputUseeolObject.getCrtUse().getTotalEnergy4Units().trim().length()>0)
			{
				if(!inputUseeolObject.getCrtUse().getTotalEnergy4Units().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.crtUse.totalEnergy4Units","validation.empty", "Please enter a valid number for Total number of ENERGY STAR 5.* units for CRT.");
				}
			}
		
			if(inputUseeolObject.getCrtUse().getAverageLifeSpanOfUnits() != null && inputUseeolObject.getCrtUse().getAverageLifeSpanOfUnits().trim().length()>0)
			{
				if(!inputUseeolObject.getCrtUse().getAverageLifeSpanOfUnits().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.crtUse.averageLifeSpanOfUnits","validation.empty", "Please enter a valid number for Average Lifespan of Units for CRT.");
				}else{
					totalNotPresent ="Present";
				}
			}
		
			if(inputUseeolObject.getCrtUse().getPercentPowerManagedDisplay() != null && inputUseeolObject.getCrtUse().getPercentPowerManagedDisplay().trim().length()>0)
			{
				if(!inputUseeolObject.getCrtUse().getPercentPowerManagedDisplay().matches(numberExpression))
				{
					errors.rejectValue("inputUseAndEolObject.crtUse.percentPowerManagedDisplay", "validation.empty", "Please enter a valid value for % of DISPLAY with power management feature enabled for CRT.");
				}else{
					totalNotPresent ="Present";
					    if(new BigDecimal(inputUseeolObject.getCrtUse().getPercentPowerManagedDisplay()).compareTo(new BigDecimal("100")) == 1)
					     {
					    	 errors.rejectValue("inputUseAndEolObject.crtUse.percentPowerManagedDisplay","validation.empty", "% of COMPUTERS with power management feature enabled for CRT value should be less than 100."); 
					     }    
				}
			}
			if("Present".equalsIgnoreCase(totalNotPresent))
			{
				ValidationUtils.rejectIfEmptyOrWhitespace(errors,"inputUseAndEolObject.crtUse.totalEnergy4Units" , "total4energy.required", "Please enter  a valid number for Total number of ENERGY STAR 5.* units for CRT.");
				 totalNotPresent ="notPresent";  
			}
			}

			if(inputUseeolObject.getLcdUse()!=null)
			{
			if(inputUseeolObject.getLcdUse().getTotalEnergy4Units() != null && inputUseeolObject.getLcdUse().getTotalEnergy4Units().trim().length()>0)
			{
				if(!inputUseeolObject.getLcdUse().getTotalEnergy4Units().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.lcdUse.totalEnergy4Units","validation.empty", "Please enter a valid number for Total number of ENERGY STAR 6.* units for LED. If no units are in use, enter 0.");
				}
			}
			if(inputUseeolObject.getLcdUse().getTotalEnergy5Units() != null && inputUseeolObject.getLcdUse().getTotalEnergy5Units().trim().length()>0)
			{
				if(!inputUseeolObject.getLcdUse().getTotalEnergy5Units().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.lcdUse.totalEnergy5Units","validation.empty", "Please enter a valid number for Total number of ENERGY STAR 7.* units for LED. If no units are in use, enter 0.");
				}
			}
			if(inputUseeolObject.getLcdUse().getAverageLifeSpanOfUnits() != null && inputUseeolObject.getLcdUse().getAverageLifeSpanOfUnits().trim().length()>0)
			{
				if(!inputUseeolObject.getLcdUse().getAverageLifeSpanOfUnits().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.lcdUse.averageLifeSpanOfUnits", "validation.empty","Please enter a valid number for Average Lifespan of Units for LED.");
				}else{
					totalNotPresent ="Present";
				}
			}
		
			if(inputUseeolObject.getLcdUse().getPercentPowerManagedDisplay() != null && inputUseeolObject.getLcdUse().getPercentPowerManagedDisplay().trim().length()>0)
			{
				if(!inputUseeolObject.getLcdUse().getPercentPowerManagedDisplay().matches(numberExpression))
				{
					errors.rejectValue("inputUseAndEolObject.lcdUse.percentPowerManagedDisplay","validation.empty", "Please enter a valid number for % of DISPLAY with power management feature enabled for LED.");
				}else{
					totalNotPresent ="Present";
					 if(new BigDecimal(inputUseeolObject.getLcdUse().getPercentPowerManagedDisplay()).compareTo(new BigDecimal("100")) == 1)
					     {
					    	 errors.rejectValue("inputUseAndEolObject.lcdUse.percentPowerManagedDispaly","validation.empty", "% of DISPLAYS with power management feature enabled for CRT value should be less than 100."); 
					     } 
				}
			}
			if("Present".equalsIgnoreCase(totalNotPresent))
			{
				ValidationUtils.rejectIfEmptyOrWhitespace(errors,"inputUseAndEolObject.lcdUse.totalEnergy4Units" , "total4energy.required", "Please enter a valid number for Total number of ENERGY STAR 6.* units for LED. Enter 0 if no units are in use.");
				 ValidationUtils.rejectIfEmptyOrWhitespace(errors,"inputUseAndEolObject.lcdUse.totalEnergy5Units" , "total5energy.required", "Please enter a valid number for Total number of ENERGY STAR 7.* units for LED. Enter 0 if no units are in use.");
				    totalNotPresent ="notPresent";  
			}
			}
			if(inputUseeolObject.getNotebookUse()!=null)
			{
			if(inputUseeolObject.getNotebookUse().getTotalEnergy4Units() != null && inputUseeolObject.getNotebookUse().getTotalEnergy4Units().trim().length()>0)
			{
				if(!inputUseeolObject.getNotebookUse().getTotalEnergy4Units().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.notebookUse.totalEnergy4Units","validation.empty", "Please enter a valid number for Total number of ENERGY STAR 5.* units for Notebook Computers.");
				}
			}
			if(inputUseeolObject.getNotebookUse().getTotalEnergy5Units() != null && inputUseeolObject.getNotebookUse().getTotalEnergy5Units().trim().length()>0)
			{
				if(!inputUseeolObject.getNotebookUse().getTotalEnergy5Units().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.notebookUse.totalEnergy5Units","validation.empty", "Please enter a valid number for Total number of ENERGY STAR 6.* units for Notebook Computers.");
				}
			}
			if(inputUseeolObject.getNotebookUse().getAverageLifeSpanOfUnits() != null && inputUseeolObject.getNotebookUse().getAverageLifeSpanOfUnits().trim().length()>0)
			{
				if(!inputUseeolObject.getNotebookUse().getAverageLifeSpanOfUnits().matches(digitExpression))
				{
					errors.rejectValue("inputUseAndEolObject.notebookUse.averageLifeSpanOfUnits","validation.empty", "Please enter a valid number for Average Lifespan of Units for Notebook Computers.");
				}else{
					totalNotPresent ="Present";
					}
			}
			if(inputUseeolObject.getNotebookUse().getPercentPowerManagedComputer() != null && inputUseeolObject.getNotebookUse().getPercentPowerManagedComputer().trim().length()>0)
			{
				if(!inputUseeolObject.getNotebookUse().getPercentPowerManagedComputer().matches(numberExpression))
				{
					errors.rejectValue("inputUseAndEolObject.notebookUse.percentPowerManagedComputer","validation.empty", "Please enter a valid number for % of COMPUTERS with power management feature enabled for Notebook Computers.");
				}else{
					totalNotPresent ="Present";
					   if(new BigDecimal(inputUseeolObject.getNotebookUse().getPercentPowerManagedComputer()).compareTo(new BigDecimal("100")) == 1)
					     {
					    	 errors.rejectValue("inputUseAndEolObject.notebookUse.percentPowerManagedComputer","validation.empty", "% of COMPUTERS with power management feature enabled for Notebook Computers value should be less than 100."); 
					     } 
				}
			}
			if(inputUseeolObject.getNotebookUse().getPercentPowerManagedDisplay() != null && inputUseeolObject.getNotebookUse().getPercentPowerManagedDisplay().trim().length()>0)
			{
				if(!inputUseeolObject.getNotebookUse().getPercentPowerManagedDisplay().matches(numberExpression))
				{
					errors.rejectValue("inputUseAndEolObject.notebookUse.percentPowerManagedDisplay","validation.empty", "Please enter a valid number for % of DISPLAY with <br>power management feature enabled for Notebook Computers.");
				}else{
					totalNotPresent ="Present";
					    if(new BigDecimal(inputUseeolObject.getNotebookUse().getPercentPowerManagedDisplay()).compareTo(new BigDecimal("100")) == 1)
					     {
					    	 errors.rejectValue("inputUseAndEolObject.notebookUse.percentPowerManagedDisplay","validation.empty", "% of DISPLAYS with power management feature enabled for Notebook value should be less than 100."); 
					     }
				}
			}
			if("Present".equalsIgnoreCase(totalNotPresent))
			{
				ValidationUtils.rejectIfEmptyOrWhitespace(errors,"inputUseAndEolObject.notebookUse.totalEnergy4Units" , "total4energy.required", "Please enter a valid number for Total number of ENERGY STAR 5.* units for Notebook Computers.");
				 ValidationUtils.rejectIfEmptyOrWhitespace(errors,"inputUseAndEolObject.notebookUse.totalEnergy5Units" , "total5energy.required", "Please enter a valid number for Total number of ENERGY STAR 6.* units for Notebook Computers.");
					    totalNotPresent ="notPresent";  
			}
			
			if(((inputUseeolObject.getUseTotal()==null)||(inputUseeolObject.getUseTotal()!=null && inputUseeolObject.getUseTotal().trim().length()<=0)) && (inputUseeolObject.getEndOfLifeInputs()!=null &&(inputUseeolObject.getEndOfLifeInputs().getTotalUnitsReused() !=null || inputUseeolObject.getEndOfLifeInputs().getTotalUnitsRecycledExclMixedElect() !=null )))
					{
				errors.rejectValue("inputUseAndEolObject.notebookUse.percentPowerManagedDisplay","validation.empty","Please Enter Equipment Use Information values");
					}
			
			}
		}
		
	}
}
