package com.saic.eebc.validator;

import java.math.BigDecimal;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import com.saic.eebc.dto.EebcProductEntryObjectDTO;
import com.saic.eebc.dto.InputUseAndEOLDTO;
import com.saic.eebc.dto.ProductDetailsDTO;
import com.saic.eebc.dto.ProductInformationDTO;

@Component("productValidator")
public class ProductValidator implements Validator

{

	private String digitExpression ="^\\d+$";
	private String numberExpression ="^(\\+|-)?\\d+(\\.\\d+)?$";
	private String perecentExpression ="(?!^0*$)(?!^0*\\.0*$)^\\d{1,2}(\\.\\d{1,2})?$";

	@SuppressWarnings("unchecked")
	@Override
	public boolean supports(Class clazz)

	{
		return ProductInformationDTO.class.isAssignableFrom(clazz);

	}

	@Override
	public void validate(Object model, Errors errors) {
		 ProductInformationDTO productInfo = (ProductInformationDTO)model;
		 ProductDetailsDTO productDetails = productInfo.getProductDetails();
	
		if(productInfo !=null){
			if(productInfo.getProductDetails() != null)
			{
				if(productInfo.getProductDetails().getProductType() == null || (productInfo.getProductDetails().getProductType().trim().length()==0))
						{
					errors.rejectValue("productDetails.productType","productType.empty","Please select a Product Type.");
						}
				if(productInfo.getProductDetails().getIsProdEPEATRegd() == null || (productInfo.getProductDetails().getIsProdEPEATRegd().trim().length()==0))
				{
			errors.rejectValue("productDetails.isProdEPEATRegd","epeatReg.empty","Please select value for Is the product EPEAT registered?.");
				}
				if(productInfo.getProductDetails().getIsProdEPEATRegd() != null && (productInfo.getProductDetails().getIsProdEPEATRegd().trim().length()>0))
				{
					if("Yes".equalsIgnoreCase(productInfo.getProductDetails().getIsProdEPEATRegd()))
					{
				if(productInfo.getProductDetails().getEpeatRegTier() == null || (productInfo.getProductDetails().getEpeatRegTier().trim().length()==0))
				{
			errors.rejectValue("productDetails.epeatRegTier","epeatRegTier.empty","Please select EPEAT Registered Tier value.");
				}
				
					}
				
				}
				
				if(productInfo.getProductDetails().getNooFProductPurchased() != null && (productInfo.getProductDetails().getNooFProductPurchased().trim().length()>0))
				{
				if(!productInfo.getProductDetails().getNooFProductPurchased().matches(digitExpression))	
				{
			errors.rejectValue("productDetails.nooFProductPurchased","nooFProductPurchased.empty","Please enter a positive integer value for field - Number of products purchased.");
				}
				}else{
					errors.rejectValue("productDetails.nooFProductPurchased","nooFProductPurchased.empty","Please enter a positive integer value for field - Number of products purchased.");	
				}
				
				if(productInfo.getNumOfHgLampsUsed() != null && (productInfo.getNumOfHgLampsUsed().trim().length()>0))
				{
				if(!productInfo.getNumOfHgLampsUsed().matches(digitExpression))	
				{
			errors.rejectValue("productDetails.nooFHgLampUsed","nooFHgLampUsed.empty","Please enter a positive integer value for field -  Reporting on amount of mercury used in light sources (Enter number of lamps with Hg).");
				}
				}
				
				if(productInfo.getAmtHgUsedinLightSrc() != null && productInfo.getAmtHgUsedinLightSrc().trim().length()>0 )
				{
					if(!productInfo.getAmtHgUsedinLightSrc().matches(numberExpression))	
					{	
					errors.rejectValue("amtHgUsedinLightSrc","amtHgUsedinLightSrc.empty","Please enter a positive number value for the field - Reporting on amount of mercury used in light sources (Enter maximum average Hg content per lamp).");
					}
				}
				
				
				if(productInfo.getProductWeightKg() != null && productInfo.getProductWeightKg().trim().length()>0 )
				{
					if(!productInfo.getProductWeightKg().matches(numberExpression))	
					{	
					errors.rejectValue("productWeightKg","ProductWeightKg.empty","Please enter a positive number value for the field - Declaration of product weight.");
					}
				}
				
				
				
				if(productInfo.getManuDeclarationOfPostRecycledPlastic()!= null && productInfo.getManuDeclarationOfPostRecycledPlastic().trim().length()>0 )
				{
					if(!productInfo.getManuDeclarationOfPostRecycledPlastic().matches(numberExpression))	
					{	
					errors.rejectValue("manuDeclarationOfPostRecycledPlastic","manuDeclarationOfPostRecycledPlastic.invalid","Please enter a valid percentage value for the field- Enter manufacturer's declared percent recycled content for product.");
					}
				}
				
				
				
				if(productInfo.getPercentPowermkanagEnabledComp() != null && productInfo.getPercentPowermkanagEnabledComp().trim().length()>0 )
				{
					if(!productInfo.getPercentPowermkanagEnabledComp().matches(perecentExpression))	
					{	
					errors.rejectValue("manuDeclarationOfPostRecycledPlastic","manuDeclarationOfPostRecycledPlastic.invalid","Please enter a valid percentage value for the field -Percentage Power Management Enabled Computer.");
					}
				}
				
			
				
				if(productInfo.getPercentPowermkanagEnabledDisp() != null && productInfo.getPercentPowermkanagEnabledDisp().trim().length()>0 )
				{
					if(!productInfo.getPercentPowermkanagEnabledDisp().matches(perecentExpression))	
					{	
					errors.rejectValue("percentPowermkanagEnabledDisp","percentPowermkanagEnabledDisp.invalid","Please enter a valid percentage value for the field -Percentage Power Management Enabled Display.");
					}
				}
				
				
				
				if(productInfo.getLowRecycledPlasticContent() != null && productInfo.getLowRecycledPlasticContent().trim().length()>0 )
				{
					if(!productInfo.getLowRecycledPlasticContent().matches(perecentExpression))	
					{	
					errors.rejectValue("lowRecycledPlasticContent","lowRecycledPlasticContent.invalid","Please enter a valid percentage value for the field - Enter range of % recycled content for corrugated/paper fiber packaging(Lower).");
					}
				}
				
	
				
				if(productInfo.getUpperRecycledPlasticContent() != null && productInfo.getUpperRecycledPlasticContent().trim().length()>0 )
				{
					if(!productInfo.getUpperRecycledPlasticContent().matches(perecentExpression))	
					{	
					errors.rejectValue("upperRecycledPlasticContent","upperRecycledPlasticContent.invalid","Please enter a valid percentage value for the field - Enter range of % recycled content for corrugated/paper fiber packaging(Upper).");
					}
				}
				
				
				if(productInfo.getLowRecycledAddPackageContent() != null && productInfo.getLowRecycledAddPackageContent().trim().length()>0 )
				{
					if(!productInfo.getLowRecycledAddPackageContent().matches(perecentExpression))	
					{	
					errors.rejectValue("LowRecycledPlasticContent","lowRecycledPlasticContent.invalid","Please enter a valid percentage value for the field -  Enter range of % recycled content for other or additional packaging types(Lower).");
					}
				}
				
				if(productInfo.getUpperRecycledAddPackageContent() != null && productInfo.getUpperRecycledAddPackageContent().trim().length()>0 )
				{
					if(!productInfo.getUpperRecycledAddPackageContent().matches(perecentExpression))	
					{	
					errors.rejectValue("upperRecycledAddPackageContent","upperRecycledAddPackageContent.invalid","Please enter a valid percentage value for the field - Enter range of % recycled content for other or additional packaging types(Upper).");
					}
				}
				
				if((productInfo.getLowRecycledAddPackageContent() != null && productInfo.getLowRecycledAddPackageContent().trim().length()>0 ) && (productInfo.getUpperRecycledAddPackageContent() != null && productInfo.getUpperRecycledAddPackageContent().trim().length()>0 ) )
				{
					if(new BigDecimal(productInfo.getLowRecycledAddPackageContent()).compareTo(new BigDecimal(productInfo.getUpperRecycledAddPackageContent()))==1 )
					{
						errors.rejectValue("lowRecycledAddPackageContent","lowRecycledAddPackageContent.invalid","Please enter valid range value for the field - Enter range of % recycled content for other or additional packaging types.");
					}
				}
				
				
				
				if(productInfo.getLowRecycledResinContent() != null && productInfo.getLowRecycledResinContent().trim().length()>0 )
				{
					if(!productInfo.getLowRecycledResinContent().matches(perecentExpression))	
					{	
					errors.rejectValue("lowRecycledResinContent","lowRecycledResinContent.invalid","Please enter a valid percentage value for the field - Minimum postconsumer content guidelines (CPG), (Recycled content of corrugated packaging >=25% (Lower).");
					}
				}
				if(productInfo.getUpperRecycledResinContent() != null && productInfo.getUpperRecycledResinContent().trim().length()>0 )
				{
					if(!productInfo.getUpperRecycledResinContent().matches(perecentExpression))	
					{	
					errors.rejectValue("upperRecycledResinContent","upperRecycledResinContent.invalid","Please enter a valid percentage value for the field - Minimum postconsumer content guidelines (CPG), (Recycled content of corrugated packaging >=25% (Upper).");
					}
				}
				
				if((productInfo.getLowRecycledResinContent() != null && productInfo.getLowRecycledResinContent().trim().length()>0 ) && (productInfo.getUpperRecycledResinContent() != null && productInfo.getUpperRecycledResinContent().trim().length()>0 ) )
				{
					if(new BigDecimal(productInfo.getLowRecycledResinContent()).compareTo(new BigDecimal(productInfo.getUpperRecycledResinContent()))==1 )
					{
						errors.rejectValue("lowRecycledResinContent","lowRecycledResinContent.invalid","Please enter valid range value for the field - Minimum postconsumer content guidelines (CPG), (Recycled content of corrugated packaging >=25% (Lower).");
					}
				}
			}
			
		}
		
	}
}
