/*
 * Decompiled with CFR 0.152.
 */
package jem;

import java.util.ArrayList;
import pviScreen.dataContainers.Building;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.LinkedParameters;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataContainers.VadoseZone;
import pviScreen.outputWriters.JEMOutputWriter;
import uncertaintyAnalysis.MonteCarloModel;
import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.UnitConverter;

public class JEMEquations
extends MonteCarloModel {
    private ArrayList<Chemical> alChemical;
    private LinkedParameters lp;
    FileLogger flJEM;
    private VadoseZone vz;
    private Building bld;
    private VIControlData viCD;
    private UnitConverter uc;
    private JEMOutputWriter jemWrite;
    private String sModelName;

    public void initial() {
        this.sModelName = "JEM";
        this.alChemical = new ArrayList();
        this.alSDistribution = new ArrayList();
        this.iIteration = 0;
        this.jemWrite = new JEMOutputWriter();
    }

    public void loadData(VIControlData viCD) {
        this.viCD = viCD;
        this.flJEM = viCD.getOutputFileLogger();
        this.vz = viCD.getVadoseZone();
        this.bld = viCD.getBuilding();
        this.alChemical = viCD.getChemicals();
        this.alSDistribution = viCD.getStatisticalDistribution();
        this.uc = viCD.getUnitConverter();
        this.lp = viCD.getLinkedParameters();
        this.jemWrite = new JEMOutputWriter();
        this.jemWrite.setVIControlData(viCD);
        this.jemWrite.setAllChemical(this.alChemical);
        this.jemWrite.setUnitCnverter(this.uc);
        this.jemWrite.setFileLogger(this.flJEM);
        this.jemWrite.setAllStatisticalDistribution(this.alSDistribution);
    }

    @Override
    public void setMonteCarloParameters(int iInterval) {
        for (StatisticalDistribution sd : this.alSDistribution) {
            sd.setNumberOfSimulations(iInterval);
            sd.setUpIntervals(iInterval);
            sd.generateOrdering(iInterval);
        }
        this.blankTheOutputString();
    }

    @Override
    public void writeResult() {
        this.jemWrite.writeResultBase(String.valueOf(this.sModelName) + " Result", this.iIteration);
    }

    @Override
    public void writeAveragedParameterResult() {
        this.jemWrite.writeResultBase(String.valueOf(this.sModelName) + " AveragedParameterResult", 1);
    }

    @Override
    public void writeOutputHeadings() {
        this.jemWrite.writeOutputHeadings();
    }

    @Override
    public void writeAveragedParameterOutputHeadings() {
        this.jemWrite.writeAveragedParameterOutputHeadings();
    }

    @Override
    public void setVariableParametersForAMonteCarloRun(int interval) {
        for (StatisticalDistribution sd : this.alSDistribution) {
            sd.setValue(interval);
        }
        this.modifyVariables();
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.jemWrite.addToOutputString(", " + sd.getCurrentRandomValue());
        }
    }

    private void modifyVariables() {
        double dAER = 0.0;
        double dWidth = 0.0;
        double dLength = 0.0;
        double dMixingZone = 0.0;
        double dQSoil = 0.0;
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (sd.getName().equalsIgnoreCase("AirExchangeRate")) {
                dAER = sd.getCurrentRandomValue();
            }
            if (sd.getName().equalsIgnoreCase("MixingZone/CeilingHeight")) {
                dMixingZone = sd.getCurrentRandomValue();
            }
            if (sd.getName().equalsIgnoreCase("CeilingHeight")) {
                dMixingZone = sd.getCurrentRandomValue();
            }
            if (sd.getName().equalsIgnoreCase("Length")) {
                dLength = sd.getCurrentRandomValue();
            }
            if (sd.getName().equalsIgnoreCase("Width")) {
                dWidth = sd.getCurrentRandomValue();
            }
            if (!sd.getName().equalsIgnoreCase("Qsoil")) continue;
            dQSoil = sd.getCurrentRandomValue();
        }
        double dBuildingFlow = dMixingZone * dLength * dWidth * dAER;
        if (dBuildingFlow < dQSoil) {
            dQSoil = dBuildingFlow;
            for (StatisticalDistribution sd : this.alSDistribution) {
                if (!sd.getName().equalsIgnoreCase("Qsoil")) continue;
                sd.overrideStatisticalValue(dQSoil);
            }
        }
        int iNumber = this.lp.getLinkedParameterCount();
        int i = 0;
        while (i < iNumber) {
            String sIndependent = this.lp.getIndependentParameter(i);
            String sDependent = this.lp.getDependentParameter(i);
            block3: for (StatisticalDistribution sd1 : this.alSDistribution) {
                if (!sd1.getName().equalsIgnoreCase(sIndependent)) continue;
                for (StatisticalDistribution sd : this.alSDistribution) {
                    if (!sd.getName().equalsIgnoreCase(sDependent)) continue;
                    sd.overrideStatisticalValue(sd1.getCurrentRandomValue());
                    continue block3;
                }
            }
            ++i;
        }
    }

    @Override
    public void setAveragedParametersForAMonteCarloRun() {
        for (StatisticalDistribution sd : this.alSDistribution) {
            sd.setAveragedParameterValue();
        }
        this.modifyVariables();
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.jemWrite.addToOutputString(", " + sd.getCurrentRandomValue());
        }
    }

    @Override
    public void blankTheOutputString() {
        this.jemWrite.blankTheOutputString();
    }

    @Override
    public void reNewConcentrationDistributions() {
    }

    @Override
    public void runModel() {
        double oldOilZone = 0.0;
        double dLensThickness = 0.0;
        this.setParametersForEachRun();
        double dAb = this.bld.getAb();
        double dQb = this.bld.getAirExchangeRate() * dAb * this.bld.getMixingZoneHeight();
        for (Chemical c : this.alChemical) {
            double d = c.getEffectiveDiffusionCoefficient();
        }
        ++this.iIteration;
    }

    private void setParametersForEachRun() {
        double dA = 0.0;
        double dB = 0.0;
        double dC = 0.0;
        double dJEMAlpha = 0.0;
        double dWidth = this.bld.getWidth();
        double dLength = this.bld.getLength();
        double dAreaBasement = dLength * dWidth;
        this.bld.setAb(dAreaBasement += this.bld.getFoundationDepthBelowGrade() * (2.0 * dWidth + 2.0 * dLength));
        this.bld.setMassTransferCoefficient();
        double dWallThickness = this.bld.getThCrack();
        this.bld.setLCrack(2.0 * (dWidth - 2.0 * dWallThickness + dLength - 2.0 * dWallThickness));
        this.bld.setMaxExponentialValue(this.viCD.getMaxAlpha());
        double dLt = this.vz.getDepthToSample() - this.bld.getFoundationDepthBelowGrade();
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            c.setVadoseZone(this.vz);
            c.correctHenrysConstantForTemperature();
            c.determineEffectiveDiffusionCoefficient();
            c.setSourceConcentrationFromStatisticalDistribution();
            dA = c.getEffectiveDiffusionCoefficient() * dAreaBasement / (this.bld.getAirExchangeRate() * this.bld.getVolume() * dLt);
            dB = this.bld.getQs() * this.bld.getFoundationThickness() / (c.getEffectiveDiffusionCoefficient() * this.bld.getCrackRatio() * dAreaBasement);
            dC = this.bld.getQs() / (this.bld.getAirExchangeRate() * this.bld.getVolume());
            Double dExpB = Math.exp(dB);
            dJEMAlpha = dExpB.isInfinite() ? 1.0 / (1.0 / dA + 1.0 / dC) : dA * dExpB / (dExpB + dA + dA / dC * (dExpB - 1.0));
            c.getName().equalsIgnoreCase("Benzene");
            c.setIndoorAirConcentration(c.getSourceConcentration() * dJEMAlpha);
        }
    }

    public void setPVIScreenControlData(VIControlData pvisCD) {
        this.viCD = pvisCD;
    }

    public void setFileLoggerForInputs(FileLogger flJEM) {
        this.flJEM = flJEM;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public double getDepthToWater() {
        return this.vz.getDepthToWaterTable();
    }

    public boolean getIsMonteCarlo() {
        return this.viCD.getIsMonteCarlo();
    }

    public int getNumberOfRuns() {
        return this.viCD.getNumberOfRuns();
    }
}

