/*
 * Decompiled with CFR 0.152.
 */
package jem;

import java.io.IOException;
import java.util.ArrayList;
import jem.JEMEquations;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.FieldData;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataReaders.VIDataReader;
import pviScreen.outputProcessor.OutputProcessor;
import statistics.ResistantStatisticalMeasures;
import uncertaintyAnalysis.MonteCarloLHS;
import util.CalendarClock;
import util.FileLogger;
import util.UnitConverter;

public class RunJEM {
    private String sModelName;
    private String sOutputFileName;
    private String sOutputFileTime;
    private MonteCarloLHS mcLHS;
    private VIControlData viCD;
    private UnitConverter uc;
    private VIDataReader pvisReader;
    private OutputProcessor op;
    private ResistantStatisticalMeasures rsm;
    private FieldData fd;
    private String sInputFileName;
    private int iNumberOfRuns;
    private FileLogger fl;
    private FileLogger flSummary;
    private JEMEquations jemEquations;
    private boolean bSimulationCompleted;
    private CalendarClock ccEnd;

    public void runJEM() throws IOException {
        this.sModelName = "JEM";
        boolean bRun = false;
        this.jemEquations = new JEMEquations();
        this.jemEquations.initial();
        this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "JEM Simulating: " + this.sInputFileName);
        this.bSimulationCompleted = false;
        this.sOutputFileName = this.viCD.getOutputFileName();
        boolean bUnsupportedUnit = false;
        bUnsupportedUnit = this.viCD.getUnsupportedUnit();
        this.uc = this.viCD.getUnitConverter();
        this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), "JEM Results");
        if (this.viCD.getCanRunModel()) {
            this.jemEquations.loadData(this.viCD);
            boolean bMonteCarlo = this.jemEquations.getIsMonteCarlo();
            if (!bMonteCarlo && !bUnsupportedUnit) {
                this.jemEquations.runModel();
            } else if (bMonteCarlo && !bUnsupportedUnit) {
                CalendarClock ccStart = new CalendarClock();
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "JEM Monte Carlo Latin Hypercube Simulation Beginning for JEM");
                this.mcLHS = new MonteCarloLHS();
                this.mcLHS.setFileLoggers(this.fl, this.flSummary);
                this.mcLHS.setMonteCarloModel(this.jemEquations);
                this.mcLHS.setMonteCarloParameters(this.jemEquations.getNumberOfRuns());
                this.mcLHS.simulate();
                this.ccEnd = new CalendarClock();
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "JEM Monte Carlo Latin Hypercube Simulation Beginning for JEM");
                String sUnit = " seconds";
                double dSimulationTime = ccStart.timeDifferenceSeconds(this.ccEnd);
                if (dSimulationTime > 60.0) {
                    dSimulationTime /= 60.0;
                    sUnit = " minutes";
                } else if (dSimulationTime > 3600.0) {
                    dSimulationTime /= 3600.0;
                    sUnit = " hours";
                }
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "JEM Run Time " + dSimulationTime + sUnit);
                this.bSimulationCompleted = true;
            }
        }
        this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Completed JEM Simulation: " + this.sInputFileName);
    }

    public void requestOutputProcessing() throws IOException {
        if (this.bSimulationCompleted) {
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Processing and sorting JEM outputs");
            this.processMonteCarloOutput(this.sModelName, this.sInputFileName, this.sOutputFileName);
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "JEM Post-processing complete");
            CalendarClock ccPost = new CalendarClock();
            String sUnit = " seconds";
            double dSimulationTime = this.ccEnd.timeDifferenceSeconds(ccPost);
            if (dSimulationTime > 60.0) {
                dSimulationTime /= 60.0;
                sUnit = " minutes";
            } else if (dSimulationTime > 3600.0) {
                dSimulationTime /= 3600.0;
                sUnit = " hours";
            }
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "JEM Post-processing Time " + dSimulationTime + sUnit);
        }
    }

    public void processMonteCarloOutput(String sModelName, String sInputFileName, String sOutputFileName) throws IOException {
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        this.op = new OutputProcessor();
        this.op = new OutputProcessor();
        this.op.initial();
        this.op.setVIControlData(this.viCD);
        this.op.setIntervalFrequency(this.viCD.getNumberOfFrequencyDistributionIntervals());
        this.op.setResultsFileName(sOutputFileName);
        this.op.setUnitConverter(this.uc);
        this.op.setNumberOfResults(this.jemEquations.getNumberOfRuns());
        this.op.setResultsText(String.valueOf(sModelName) + " Result");
        this.op.setHeadingText(String.valueOf(sModelName) + " Heading");
        this.op.setSortedResultsText("Sorted " + sModelName + " Result");
        this.rsm = new ResistantStatisticalMeasures();
        this.rsm.setFileLogger(this.op.getOutputFileLogger());
        this.op.setResistantStatisticalMeasures(this.rsm);
        this.op.openOutputFile(sOutputFileName);
        this.op.writeRunFileInformation(sModelName, sInputFileName, sOutputFileName);
        String sHeading = "";
        for (Chemical chemical : alChemical) {
            if (!chemical.getIsUsedInSimulation()) continue;
            sHeading = String.valueOf(chemical.getName()) + " Indoor Air Concentration";
            break;
        }
        this.op.readResults(sHeading);
        this.op.sortByMergeSortAndReWrite();
        this.op.readSortedResultsToArrayList();
        this.op.generateStatistics();
        this.op.characterizeAndWriteData();
        this.op.writeStatistics();
        for (Chemical chemical : alChemical) {
            if (!(chemical.getSourceConcentration() > 0.0)) continue;
            String sChemicalName = chemical.getName();
            String sChemicalTitle = String.valueOf(sChemicalName) + " indoor air concentration";
            this.op.sortResultsColumn(sChemicalTitle);
            this.op.makeResultsColumnLogHistogram(sChemicalTitle, sChemicalName);
            this.op.writeLogHistogram(sChemicalTitle);
        }
    }

    public void setDataFileName(String sInputFileName) {
        this.sInputFileName = sInputFileName;
    }

    public void setOutputFileTime(String sOutputFileTime) {
        this.sOutputFileTime = sOutputFileTime;
    }

    public void setOutputFileLogger(FileLogger fl) {
        this.fl = fl;
    }

    public void setSummaryFileLogger(FileLogger flSummary) {
        this.flSummary = flSummary;
    }

    public void setPVIScreenControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public String getOutputFileName() {
        return this.sOutputFileName;
    }

    public ArrayList<Chemical> getChemicals() {
        return this.viCD.getChemicals();
    }
}

