/*
 * Decompiled with CFR 0.152.
 */
package numerics.bisection;

import numerics.bisection.Bisectable;

public class Bisection {
    double low;
    double high;
    double tolerance;
    double value;
    double result;
    int count;
    int maxIterations = 1000;
    boolean boolSolutionFound;

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public void setLimits(double low, double high) {
        this.low = low;
        this.high = high;
    }

    public void setValueToMatch(double value) {
        this.value = value;
    }

    public void setMaximumIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void bisect(Bisectable bi) {
        double a = this.low;
        double b = this.high;
        double fm = 10.0 * (this.value + this.tolerance);
        this.count = 0;
        double fa = bi.getFunctionValue(a);
        double fb = bi.getFunctionValue(b);
        double xInterval = fb * fa;
        if (xInterval < 0.0) {
            this.boolSolutionFound = true;
            double xf = 1.0;
            if (fb < fa) {
                xf = -1.0;
            }
            double xd = 1.0;
            if (this.value != 0.0) {
                xd = this.value;
            }
            while (this.count < this.maxIterations && Math.abs((fm - this.value) / xd) > this.tolerance) {
                ++this.count;
                this.result = 0.5 * (a + b);
                fm = bi.getFunctionValue(this.result);
                if (xf * (fm - this.value) > 0.0) {
                    b = this.result;
                    continue;
                }
                a = this.result;
            }
        } else {
            this.boolSolutionFound = false;
        }
    }

    public int getCount() {
        return this.count;
    }

    public double getResult() {
        return this.result;
    }

    public double getLowerLimit() {
        return this.low;
    }

    public double getUpperLimit() {
        return this.high;
    }

    public int getMaximumIterations() {
        return this.maxIterations;
    }

    public boolean getSolutionFound() {
        return this.boolSolutionFound;
    }
}

