/*
 * Decompiled with CFR 0.152.
 */
package numerics.sort;

public class MergeSort {
    private double[] dArray;
    private double[] dTemp;
    private String[] sArray;
    private String[] sTemp;
    private double[] dArraySort;
    private double[] dTempSort;
    private int iLength;

    public static void main(String[] a) {
        double[] dInputArr = new double[]{45.0, 23.0, 11.0, 89.0, 77.0, 98.0, 4.0, 28.0, 65.0, 43.0};
        String[] sInputArr = new String[]{"four", "two", "one", "eight", "seven", "nine", "four", "two", "six", "four"};
        int i = 0;
        while (i < dInputArr.length) {
            System.out.print(dInputArr[i]);
            System.out.print(" ");
            ++i;
        }
        System.out.println(" ");
        i = 0;
        while (i < dInputArr.length) {
            System.out.print(sInputArr[i]);
            System.out.print(" ");
            ++i;
        }
        System.out.println("");
        MergeSort ms = new MergeSort();
        ms.sortWithDependentString(dInputArr, sInputArr);
        int i2 = 0;
        while (i2 < dInputArr.length) {
            System.out.print(dInputArr[i2]);
            System.out.print(" ");
            ++i2;
        }
        System.out.println(" ");
        i2 = 0;
        while (i2 < dInputArr.length) {
            System.out.print(sInputArr[i2]);
            System.out.print(" ");
            ++i2;
        }
    }

    public double[] sort(double[] dArray) {
        this.dArray = dArray;
        this.iLength = dArray.length;
        this.dTemp = new double[this.iLength];
        this.doMergeSort(0, this.iLength - 1);
        return dArray;
    }

    private void doMergeSort(int lowerIndex, int higherIndex) {
        if (lowerIndex < higherIndex) {
            int middle = lowerIndex + (higherIndex - lowerIndex) / 2;
            this.doMergeSort(lowerIndex, middle);
            this.doMergeSort(middle + 1, higherIndex);
            this.mergeParts(lowerIndex, middle, higherIndex);
        }
    }

    private void mergeParts(int iLow, int iMid, int iHigh) {
        int i = iLow;
        while (i <= iHigh) {
            this.dTemp[i] = this.dArray[i];
            ++i;
        }
        i = iLow;
        int j = iMid + 1;
        int k = iLow;
        while (i <= iMid && j <= iHigh) {
            if (this.dTemp[i] <= this.dTemp[j]) {
                this.dArray[k] = this.dTemp[i];
                ++i;
            } else {
                this.dArray[k] = this.dTemp[j];
                ++j;
            }
            ++k;
        }
        while (i <= iMid) {
            this.dArray[k] = this.dTemp[i];
            ++k;
            ++i;
        }
    }

    public void sortWithDependentString(double[] dArray, String[] sArray) {
        this.dArray = dArray;
        this.sArray = sArray;
        this.iLength = dArray.length;
        this.dTemp = new double[this.iLength];
        this.sTemp = new String[this.iLength];
        this.doMergeSortWithDependentString(0, this.iLength - 1);
    }

    private void doMergeSortWithDependentString(int lowerIndex, int higherIndex) {
        if (lowerIndex < higherIndex) {
            int middle = lowerIndex + (higherIndex - lowerIndex) / 2;
            this.doMergeSortWithDependentString(lowerIndex, middle);
            this.doMergeSortWithDependentString(middle + 1, higherIndex);
            this.mergePartsWithDependentString(lowerIndex, middle, higherIndex);
        }
    }

    private void mergePartsWithDependentString(int iLow, int iMid, int iHigh) {
        int i = iLow;
        while (i <= iHigh) {
            this.dTemp[i] = this.dArray[i];
            this.sTemp[i] = this.sArray[i];
            ++i;
        }
        i = iLow;
        int j = iMid + 1;
        int k = iLow;
        while (i <= iMid && j <= iHigh) {
            if (this.dTemp[i] <= this.dTemp[j]) {
                this.dArray[k] = this.dTemp[i];
                this.sArray[k] = this.sTemp[i];
                ++i;
            } else {
                this.dArray[k] = this.dTemp[j];
                this.sArray[k] = this.sTemp[j];
                ++j;
            }
            ++k;
        }
        while (i <= iMid) {
            this.dArray[k] = this.dTemp[i];
            this.sArray[k] = this.sTemp[i];
            ++k;
            ++i;
        }
    }

    public void sortWithDependentDouble(double[] dArrayToSortBy, double[] dArrayToSort) {
        this.dArray = dArrayToSortBy;
        this.dArraySort = dArrayToSort;
        this.iLength = dArrayToSortBy.length;
        this.dTemp = new double[this.iLength];
        this.dTempSort = new double[this.iLength];
        this.doMergeSortWithDependentDouble(0, this.iLength - 1);
    }

    private void doMergeSortWithDependentDouble(int lowerIndex, int higherIndex) {
        if (lowerIndex < higherIndex) {
            int middle = lowerIndex + (higherIndex - lowerIndex) / 2;
            this.doMergeSortWithDependentDouble(lowerIndex, middle);
            this.doMergeSortWithDependentDouble(middle + 1, higherIndex);
            this.mergePartsWithDependentDouble(lowerIndex, middle, higherIndex);
        }
    }

    private void mergePartsWithDependentDouble(int iLow, int iMid, int iHigh) {
        int i = iLow;
        while (i <= iHigh) {
            this.dTemp[i] = this.dArray[i];
            this.dTempSort[i] = this.dArraySort[i];
            ++i;
        }
        i = iLow;
        int j = iMid + 1;
        int k = iLow;
        while (i <= iMid && j <= iHigh) {
            if (this.dTemp[i] <= this.dTemp[j]) {
                this.dArray[k] = this.dTemp[i];
                this.dArraySort[k] = this.dTempSort[i];
                ++i;
            } else {
                this.dArray[k] = this.dTemp[j];
                this.dArraySort[k] = this.dTempSort[j];
                ++j;
            }
            ++k;
        }
        while (i <= iMid) {
            this.dArray[k] = this.dTemp[i];
            this.dArraySort[k] = this.dTempSort[i];
            ++k;
            ++i;
        }
    }
}

