/*
 * Decompiled with CFR 0.152.
 */
package pviScreen;

import java.util.ArrayList;
import numerics.bisection.Bisectable;
import numerics.bisection.Bisection;
import pviScreen.dataContainers.Building;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.LinkedParameters;
import pviScreen.dataContainers.OilLens;
import pviScreen.dataContainers.Oxygen;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataContainers.VadoseZone;
import pviScreen.dataReaders.InterpretInputName;
import pviScreen.outputWriters.PVIScreenOutputWriter;
import uncertaintyAnalysis.MonteCarloModel;
import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class PVIScreenEquations
extends MonteCarloModel
implements Bisectable {
    protected Oxygen oxygen;
    protected VadoseZone vz;
    protected Building bld;
    protected Chemical c;
    protected ArrayList<Chemical> alChemical;
    private boolean boolSolutionFound;
    private boolean boolSolutionFoundFlux;
    private boolean boolSolutionFoundConcentration;
    protected double aerobicZoneThickness;
    protected double anaerobicZoneThickness;
    protected double aerobicZoneThicknessConcentration;
    protected double aerobicZoneThicknessFlux;
    protected double dTotalThickness;
    protected double dTransitionPointDepth;
    protected double soilRespiration;
    protected double efdo2;
    protected double jeo2;
    protected double ceo2;
    protected double eq29LHS;
    protected double eq37;
    private FileLogger fl;
    private FileLogger fl2;
    private String sSolutionType;
    private Bisection bisection;
    private boolean bConcentration;
    private UnitConverter uc;
    private OilLens old;
    private VIControlData viCD;
    private double dMaxAlpha;
    private LinkedParameters lp;
    private PVIScreenOutputWriter pvisOutputWriter;
    private String sModelName;
    private InterpretInputName iin;
    int iRun = 0;

    public void initial() {
        this.sModelName = "PVIScreen";
        this.boolSolutionFoundFlux = false;
        this.boolSolutionFoundConcentration = false;
        this.alChemical = new ArrayList();
        this.alSDistribution = new ArrayList();
        this.iIteration = 0;
        this.bisection = new Bisection();
        this.iin = new InterpretInputName();
    }

    @Override
    public void setMonteCarloParameters(int iInterval) {
        for (StatisticalDistribution sd : this.alSDistribution) {
            sd.setNumberOfSimulations(iInterval);
            sd.setUpIntervals(iInterval);
            sd.generateOrdering(iInterval);
        }
        this.blankTheOutputString();
    }

    @Override
    public void setVariableParametersForAMonteCarloRun(int interval) {
        for (StatisticalDistribution sd : this.alSDistribution) {
            sd.setValue(interval);
        }
        this.modifyVariables();
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.pvisOutputWriter.addToOutputString(", " + sd.getCurrentRandomValue());
        }
    }

    private void modifyVariables() {
        double dAER = 0.0;
        double dWidth = 0.0;
        double dLength = 0.0;
        double dMixingZone = 0.0;
        double dQSoil = 0.0;
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (sd.getName().equalsIgnoreCase("AirExchangeRate")) {
                dAER = sd.getCurrentRandomValue();
            }
            if (sd.getName().equalsIgnoreCase("MixingZone/CeilingHeight")) {
                dMixingZone = sd.getCurrentRandomValue();
            }
            if (sd.getName().equalsIgnoreCase("CeilingHeight")) {
                dMixingZone = sd.getCurrentRandomValue();
            }
            if (sd.getName().equalsIgnoreCase("Length")) {
                dLength = sd.getCurrentRandomValue();
            }
            if (sd.getName().equalsIgnoreCase("Width")) {
                dWidth = sd.getCurrentRandomValue();
            }
            if (!sd.getName().equalsIgnoreCase("Qsoil")) continue;
            dQSoil = sd.getCurrentRandomValue();
        }
        double dBuildingFlow = dMixingZone * dLength * dWidth * dAER;
        if (dBuildingFlow < dQSoil) {
            dQSoil = dBuildingFlow;
            for (StatisticalDistribution sd : this.alSDistribution) {
                if (!sd.getName().equalsIgnoreCase("Qsoil")) continue;
                sd.overrideStatisticalValue(dQSoil);
            }
        }
        int iNumber = this.lp.getLinkedParameterCount();
        int i = 0;
        while (i < iNumber) {
            String sIndependent = this.lp.getIndependentParameter(i);
            String sDependent = this.lp.getDependentParameter(i);
            block3: for (StatisticalDistribution sd1 : this.alSDistribution) {
                if (!sd1.getName().equalsIgnoreCase(sIndependent)) continue;
                for (StatisticalDistribution sd : this.alSDistribution) {
                    if (!sd.getName().equalsIgnoreCase(sDependent)) continue;
                    sd.overrideStatisticalValue(sd1.getCurrentRandomValue());
                    continue block3;
                }
            }
            ++i;
        }
    }

    @Override
    public void setAveragedParametersForAMonteCarloRun() {
        int ij = 0;
        while (ij < this.alSDistribution.size()) {
            if (ij == 29) {
                int ijj = 0;
                ++ijj;
            }
            ((StatisticalDistribution)this.alSDistribution.get(ij)).setAveragedParameterValue();
            ++ij;
        }
        this.modifyVariables();
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.pvisOutputWriter.addToOutputString(", " + sd.getCurrentRandomValue());
        }
    }

    @Override
    public void blankTheOutputString() {
        this.pvisOutputWriter.blankTheOutputString();
    }

    @Override
    public void reNewConcentrationDistributions() {
    }

    @Override
    public void runModel() {
        double oldOilZone = 0.0;
        double dLensThickness = 0.0;
        this.setParametersForEachRun();
        double vzDepth = this.vz.getDepthToSample();
        double bldFound = this.bld.getFoundationDepthBelowGrade();
        if (this.old.isLensUsed()) {
            oldOilZone = this.old.getOilZoneThickness();
            dLensThickness = this.old.getOilZoneThickness();
        }
        this.dTotalThickness = this.vz.getDepthToSample() - dLensThickness - this.bld.getFoundationDepthBelowGrade();
        if (this.dTotalThickness < 0.0) {
            this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), "****Sample or Oil in building****");
        }
        this.aerobicZoneThickness = this.dTotalThickness;
        this.bConcentration = true;
        this.bisection = new Bisection();
        this.bisection.setLimits(this.viCD.getBisectionLowerLimit(), this.dTotalThickness);
        this.bisection.setMaximumIterations(this.viCD.getBisectionMaxIterations());
        this.bisection.setTolerance(this.viCD.getBisectionTolerance());
        this.bisection.setValueToMatch(0.0);
        this.bisection.bisect(this);
        this.boolSolutionFoundConcentration = this.bisection.getSolutionFound();
        this.aerobicZoneThicknessConcentration = this.boolSolutionFoundConcentration ? this.bisection.getResult() : this.dTotalThickness;
        this.setParametersForEachRun();
        this.bConcentration = false;
        this.bisection = new Bisection();
        this.bisection.setLimits(this.viCD.getBisectionLowerLimit(), this.dTotalThickness);
        this.bisection.setMaximumIterations(this.viCD.getBisectionMaxIterations());
        this.bisection.setTolerance(this.viCD.getBisectionTolerance());
        this.bisection.setValueToMatch(0.0);
        this.bisection.bisect(this);
        this.boolSolutionFoundFlux = this.bisection.getSolutionFound();
        this.aerobicZoneThicknessFlux = this.boolSolutionFoundFlux ? this.bisection.getResult() : this.dTotalThickness;
        if (!this.bld.getIsItADirtFloor()) {
            if (this.boolSolutionFoundFlux && this.boolSolutionFoundConcentration || this.boolSolutionFoundFlux || this.boolSolutionFoundConcentration) {
                this.boolSolutionFound = true;
                if (this.aerobicZoneThicknessConcentration <= this.aerobicZoneThicknessFlux) {
                    this.sSolutionType = "Concentration Solution";
                    this.aerobicZoneThickness = this.aerobicZoneThicknessConcentration;
                } else {
                    this.sSolutionType = "Flux Solution";
                    this.aerobicZoneThickness = this.aerobicZoneThicknessFlux;
                }
            } else if (this.boolSolutionFoundConcentration) {
                this.sSolutionType = "ConcentrationSolution";
                this.aerobicZoneThickness = this.aerobicZoneThicknessConcentration;
            } else {
                this.aerobicZoneThickness = this.dTotalThickness;
            }
        }
        this.dTransitionPointDepth = this.bld.getFoundationDepthBelowGrade() + this.aerobicZoneThickness;
        this.boolSolutionFound = this.boolSolutionFoundConcentration;
        ++this.iIteration;
    }

    @Override
    public double getFunctionValue(double aerobicZoneDepth) {
        double returnValue = 0.0;
        if (!this.bConcentration) {
            return this.determineAerobicZoneThicknessFromFlux(aerobicZoneDepth);
        }
        return this.determineAerobicZoneThicknessFromConc(aerobicZoneDepth);
    }

    public double determineAerobicZoneThicknessFromConc(double aerobicZoneDepth) {
        double[] sum = new double[4];
        this.aerobicZoneThickness = aerobicZoneDepth;
        this.anaerobicZoneThickness = this.dTotalThickness - this.aerobicZoneThickness;
        this.soilRespiration = -this.vz.getBulkDensity() * this.vz.getSoilRespirationRate() * this.vz.getFractionOrganicCarbon();
        sum = this.calculateSums();
        double eqB49Value = this.oxygen.getNetSurfaceConcentration();
        eqB49Value -= sum[0] / this.efdo2;
        eqB49Value += 0.5 * (this.soilRespiration / this.efdo2) * this.aerobicZoneThickness * this.aerobicZoneThickness;
        return eqB49Value -= sum[1] * this.aerobicZoneThickness / this.efdo2;
    }

    public double determineAerobicZoneThicknessFromFlux(double aerobicZoneDepth) {
        double[] sum = new double[4];
        this.aerobicZoneThickness = aerobicZoneDepth;
        this.anaerobicZoneThickness = this.dTotalThickness - this.aerobicZoneThickness;
        double bulkDensity = this.vz.getBulkDensity();
        double sRR = this.vz.getSoilRespirationRate();
        double foc = this.vz.getFractionOrganicCarbon();
        this.soilRespiration = -this.vz.getBulkDensity() * this.vz.getSoilRespirationRate() * this.vz.getFractionOrganicCarbon();
        sum = this.calculateSums();
        double surfaceFlux = 0.0;
        double dSurfaceOxygenConc = this.oxygen.getSurfaceConcentration();
        double dMinBioConc = this.oxygen.getMinBiodegradationConcentration();
        double eqB46Value = surfaceFlux = -((this.bld.getQs() + this.bld.getAirFlowBelowBuilding()) / this.bld.getAb()) * (this.oxygen.getSurfaceConcentration() - this.oxygen.getMinBiodegradationConcentration());
        eqB46Value -= sum[2];
        return eqB46Value -= this.soilRespiration * this.aerobicZoneThickness;
    }

    private double[] calculateSums() {
        double[] sum = new double[]{0.0, 0.0, 0.0, 0.0};
        double k2a = this.bld.getMixingZoneHeight() * this.bld.getAirExchangeRate();
        for (Chemical ci : this.alChemical) {
            double tfe;
            double cfi;
            double denom;
            double cti;
            double csi;
            if (!(ci.getSourceConcentration() > 0.0)) continue;
            ci.setAlpha(this.aerobicZoneThickness);
            double alpha = ci.getAlpha();
            double edc = ci.getEffectiveDiffusionCoefficient();
            double phi = ci.getPhi();
            this.bld.setDCrack(edc);
            this.bld.setMassTransferCoefficient();
            double h = this.bld.getFoundationMassTransferCoefficient();
            double k2 = 1.0 / k2a + 1.0 / h;
            double k3 = this.aerobicZoneThickness / edc;
            if (alpha < this.dMaxAlpha) {
                double A = 0.5 * (Math.exp(-alpha) + Math.exp(alpha));
                double B = 0.5 * (Math.exp(alpha) - Math.exp(-alpha)) / alpha;
                csi = ci.getSourceConcentration();
                cti = csi * (A * k2 + B * k3);
                if (this.anaerobicZoneThickness <= 0.0) {
                    int iC = 0;
                    iC = iC++;
                }
                denom = (A + this.anaerobicZoneThickness / this.aerobicZoneThickness * ((A * A - 1.0) / B)) * k2;
                cfi = (cti /= (denom += (B * this.aerobicZoneThickness + A * this.anaerobicZoneThickness) / edc)) * (k2 / (A * k2 + B * k3));
                tfe = (A - 1.0) / B;
            } else {
                csi = ci.getSourceConcentration();
                double lr = ci.getDiffusiveReactionLength();
                double k4 = lr / edc;
                cti = csi * (k2 + k4);
                denom = (1.0 + this.anaerobicZoneThickness / lr) * k2 + (lr + this.anaerobicZoneThickness) / edc;
                cfi = (cti /= denom) * (k2 / (k2 + k4)) * 2.0 * Math.exp(-alpha);
                tfe = alpha;
            }
            ci.setTransitionPointConcentration(cti);
            ci.setFoundationConcentration(cfi);
            double cei = cfi * (1.0 / k2a) / k2;
            ci.setIndoorAirConcentration(cei);
            double jfi = h * (cfi - cei);
            ci.setFoundationFlux(jfi);
            double jti = jfi + 1.0 / k3 * tfe * (cti + cfi);
            ci.setTransitionPointFlux(jti);
            sum[0] = sum[0] + edc / phi * (cfi - cti);
            sum[1] = sum[1] + jti / phi;
            double dTest = -(edc / this.aerobicZoneThickness) * tfe * (cti + cfi);
            double dTest2 = dTest - (jfi - jti);
            double dDeltaFlux = -tfe * (edc / this.aerobicZoneThickness) * (cti + cfi);
            sum[2] = sum[2] + dDeltaFlux / phi;
            sum[3] = sum[3] + jfi / phi;
            double d = sum[2] - (sum[3] - sum[1]);
        }
        String sOut = "";
        sOut = String.valueOf(sOut) + "AZT, " + this.aerobicZoneThickness + ", ";
        int i = 0;
        while (i < sum.length) {
            sOut = String.valueOf(sOut) + i + ", " + sum[i] + ", ";
            ++i;
        }
        return sum;
    }

    @Override
    public void writeResult() {
        this.writeResultBase(String.valueOf(this.sModelName) + " Result");
    }

    @Override
    public void writeAveragedParameterResult() {
        this.writeResultBase(String.valueOf(this.sModelName) + " AveragedParameterResult");
    }

    @Override
    public void writeOutputHeadings() {
        this.pvisOutputWriter.writeOutputHeadings();
    }

    @Override
    public void writeAveragedParameterOutputHeadings() {
        this.pvisOutputWriter.writeAveragedParameterOutputHeadings();
    }

    private void writeResultBase(String sFirstColumnText) {
        String sTemp = "";
        double dUCF = 1.0;
        dUCF = this.uc.getOutputUCFFromType("length");
        sTemp = String.valueOf(sTemp) + ",** , " + this.aerobicZoneThicknessConcentration * dUCF + ", " + this.aerobicZoneThicknessFlux * dUCF + ", " + this.aerobicZoneThickness * dUCF;
        this.pvisOutputWriter.addToOutputString(sTemp);
        this.pvisOutputWriter.addToOutputString(", " + this.sSolutionType);
        this.pvisOutputWriter.addToOutputString(", " + this.dTransitionPointDepth * dUCF);
        this.pvisOutputWriter.addToOutputString(", **");
        dUCF = this.uc.getOutputUCFFromType("concentrationAir");
        sTemp = "";
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            sTemp = "";
            sTemp = ", " + c.getIndoorAirConcentration() * dUCF + ", " + c.getFoundationConcentration() * dUCF + ", " + c.getTransitionPointConcentration() * dUCF + ", " + c.getSourceConcentration() * dUCF;
            this.pvisOutputWriter.addToOutputString(sTemp);
        }
        String sOutput = this.pvisOutputWriter.getOutputString();
        this.pvisOutputWriter.blankTheOutputString();
        this.pvisOutputWriter.addToOutputString(String.valueOf(sFirstColumnText) + "," + this.iIteration + sOutput);
        this.pvisOutputWriter.logMessage();
    }

    public void writeResult(FileLogger fl) {
        double cz;
        OutputDigits od = new OutputDigits();
        double[] sumO2 = new double[2];
        this.setAnaerobicZoneDepth();
        double ucf = this.alChemical.get(0).getUCFmgM3();
        double dz = -0.01 * this.aerobicZoneThickness;
        double z = this.aerobicZoneThickness;
        this.soilRespiration = this.vz.getBulkDensity() * this.vz.getSoilRespirationRate();
        String stringOut = "depth, oxygen, ";
        String stringOut2 = "";
        for (Chemical chemical : this.alChemical) {
            if (!this.c.getIsUsedInSimulation()) continue;
            stringOut2 = String.valueOf(stringOut2) + chemical.getName() + ", ";
        }
        stringOut2 = String.valueOf(stringOut2) + " , , " + "oxygen, " + stringOut2;
        fl.logMessage(String.valueOf(stringOut) + stringOut2);
        stringOut = "";
        for (Chemical chemical : this.alChemical) {
            if (!this.c.getIsUsedInSimulation()) continue;
            stringOut = String.valueOf(stringOut) + chemical.getIndoorAirConcentration() * ucf + ", ";
        }
        stringOut = String.valueOf(this.oxygen.getSurfaceConcentration() * ucf) + ", " + stringOut;
        stringOut = String.valueOf(this.bld.getThCrack()) + ", " + stringOut;
        stringOut = String.valueOf(stringOut) + " , , ";
        stringOut2 = "";
        for (Chemical chemical : this.alChemical) {
            if (!this.c.getIsUsedInSimulation()) continue;
            stringOut2 = String.valueOf(stringOut2) + chemical.getIndoorAirConcentration() / chemical.getSourceConcentration() + ", ";
        }
        stringOut2 = String.valueOf(this.oxygen.getSurfaceConcentration() / this.oxygen.getSurfaceConcentration()) + ", " + stringOut2;
        fl.logMessage(String.valueOf(stringOut) + stringOut2);
        stringOut = "";
        for (Chemical chemical : this.alChemical) {
            if (!this.c.getIsUsedInSimulation()) continue;
            stringOut = String.valueOf(stringOut) + chemical.getFoundationConcentration() * ucf + ", ";
        }
        stringOut = " , " + stringOut;
        stringOut = "0.0, " + stringOut;
        stringOut = String.valueOf(stringOut) + " , , ";
        stringOut2 = "";
        for (Chemical chemical : this.alChemical) {
            if (!this.c.getIsUsedInSimulation()) continue;
            stringOut2 = String.valueOf(stringOut2) + chemical.getFoundationConcentration() / chemical.getSourceConcentration() + ", ";
        }
        stringOut2 = String.valueOf(this.oxygen.getSurfaceConcentration() / this.oxygen.getSurfaceConcentration()) + ", " + stringOut2;
        fl.logMessage(String.valueOf(stringOut) + stringOut2);
        double zTotal = 0.0;
        double k2a = this.bld.getMixingZoneHeight() * this.bld.getAirExchangeRate();
        while (0.0 <= z && z <= this.aerobicZoneThickness) {
            stringOut = "";
            stringOut = String.valueOf(stringOut) + this.getConcentration(z, true);
            stringOut = String.valueOf(stringOut) + " , , " + this.getConcentration(z, false);
            stringOut = String.valueOf(stringOut) + " , , " + this.getFlux(z);
            od.setValue(-zTotal);
            stringOut = String.valueOf(od.num2String()) + ", " + stringOut;
            fl.logMessage(stringOut);
            z += dz;
            zTotal -= dz;
        }
        zTotal = this.aerobicZoneThickness;
        stringOut = "";
        for (Chemical chemical : this.alChemical) {
            if (!this.c.getIsUsedInSimulation()) continue;
            cz = chemical.getTransitionPointConcentration();
            stringOut = String.valueOf(stringOut) + cz * ucf + ", ";
        }
        double co2 = 0.0;
        stringOut = String.valueOf(co2 * ucf) + ", " + stringOut;
        stringOut = String.valueOf(stringOut) + " , , ";
        stringOut2 = "";
        for (Chemical chemical : this.alChemical) {
            if (!this.c.getIsUsedInSimulation()) continue;
            stringOut2 = String.valueOf(stringOut2) + chemical.getTransitionPointConcentration() / chemical.getSourceConcentration() + ", ";
        }
        stringOut2 = String.valueOf(co2 / this.oxygen.getSurfaceConcentration()) + ", " + stringOut2;
        od.setValue(-zTotal);
        stringOut = String.valueOf(od.num2String()) + ", " + stringOut;
        fl.logMessage(String.valueOf(stringOut) + stringOut2);
        zTotal = this.aerobicZoneThickness + this.anaerobicZoneThickness;
        stringOut = "";
        for (Chemical chemical : this.alChemical) {
            if (!this.c.getIsUsedInSimulation()) continue;
            cz = chemical.getSourceConcentration();
            stringOut = String.valueOf(stringOut) + cz * ucf + ", ";
        }
        co2 = 0.0;
        stringOut = String.valueOf(co2 * ucf) + ", " + stringOut;
        stringOut = String.valueOf(stringOut) + " , , ";
        stringOut2 = "";
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            stringOut2 = String.valueOf(stringOut2) + c.getSourceConcentration() / c.getSourceConcentration() + ", ";
        }
        stringOut2 = String.valueOf(co2 / this.oxygen.getSurfaceConcentration()) + ", " + stringOut2;
        od.setValue(-zTotal);
        stringOut = String.valueOf(od.num2String()) + ", " + stringOut + stringOut2;
        fl.logMessage(stringOut);
    }

    private String getFlux(double z) {
        double[] sumO2 = new double[2];
        String stringOut = "";
        double ucf = this.alChemical.get(0).getUCFmgM3();
        sumO2[0] = 0.0;
        sumO2[1] = 0.0;
        for (Chemical chemical : this.alChemical) {
            double jz;
            chemical.setAlpha(this.aerobicZoneThickness);
            double alpha = chemical.getAlpha();
            double beta = chemical.getFoundationConcentration() / chemical.getTransitionPointConcentration();
            double jt = chemical.getTransitionPointFlux();
            double zPrime = z / this.aerobicZoneThickness;
            if (alpha < this.dMaxAlpha) {
                jz = (Math.exp(-alpha) - beta) * Math.exp(alpha * zPrime);
                jz += (beta - Math.exp(alpha)) * Math.exp(-alpha * zPrime);
                jz = jt * jz / (Math.exp(-alpha) - Math.exp(alpha) - 2.0 * beta);
            } else {
                jz = -Math.exp(alpha * (zPrime - 2.0));
                jz += beta * Math.exp(alpha * (zPrime - 1.0));
                jz -= beta * Math.exp(-alpha * (zPrime + 1.0));
                jz += Math.exp(alpha * -zPrime);
                jz = jt * jz;
            }
            stringOut = String.valueOf(stringOut) + jz + ", ";
        }
        return stringOut;
    }

    private String getConcentration(double z, boolean dimensional) {
        double[] sumO2 = new double[2];
        String stringOut = "";
        double ucf = this.alChemical.get(0).getUCFmgM3();
        sumO2[0] = 0.0;
        sumO2[1] = 0.0;
        for (Chemical chemical : this.alChemical) {
            double cz;
            chemical.setAlpha(this.aerobicZoneThickness);
            double alpha = chemical.getAlpha();
            double beta = chemical.getFoundationConcentration() / chemical.getTransitionPointConcentration();
            double edc = chemical.getEffectiveDiffusionCoefficient();
            double ct = chemical.getTransitionPointConcentration();
            double zPrime = z / this.aerobicZoneThickness;
            if (alpha < this.dMaxAlpha) {
                cz = (Math.exp(-alpha) - beta) * Math.exp(alpha * zPrime);
                cz += (beta - Math.exp(alpha)) * Math.exp(-alpha * zPrime);
                cz = ct * cz / (Math.exp(-alpha) - Math.exp(alpha));
            } else {
                cz = -Math.exp(alpha * (zPrime - 2.0));
                cz += beta * Math.exp(alpha * (zPrime - 1.0));
                cz -= beta * Math.exp(-alpha * (zPrime + 1.0));
                cz += Math.exp(alpha * -zPrime);
                cz = ct * cz;
            }
            double jt = chemical.getTransitionPointFlux();
            sumO2[0] = sumO2[0] + edc / chemical.getPhi() * (cz - ct);
            sumO2[1] = sumO2[1] + jt / chemical.getPhi();
            stringOut = !dimensional ? String.valueOf(stringOut) + cz / ct + ", " : String.valueOf(stringOut) + cz * ucf + ", ";
        }
        double co2 = (sumO2[0] + z * sumO2[1]) / this.efdo2 - 0.5 * (this.soilRespiration / this.efdo2) * z * z;
        co2 = !dimensional ? (co2 /= this.oxygen.getSurfaceConcentration()) : (co2 *= ucf);
        stringOut = String.valueOf(co2) + ", " + stringOut;
        return stringOut;
    }

    public void addChemical(Chemical c) {
        this.alChemical.add(c);
    }

    public void setAnaerobicZoneDepth() {
        this.anaerobicZoneThickness = this.vz.getDepthToWaterTable() - this.bld.getFoundationDepthBelowGrade() - this.aerobicZoneThickness;
    }

    public void setParametersForEachRun() {
        Stripper s = new Stripper();
        this.dMaxAlpha = this.viCD.getMaxAlpha();
        this.vz.setBulkDensity();
        double dWidth = this.bld.getWidth();
        double dLength = this.bld.getLength();
        double dAreaBasement = dLength * dWidth;
        this.bld.setAb(dAreaBasement += this.bld.getFoundationDepthBelowGrade() * (2.0 * dWidth + 2.0 * dLength));
        double dWallThickness = this.bld.getThCrack();
        this.bld.setLCrack(2.0 * (dWidth - 2.0 * dWallThickness + dLength - 2.0 * dWallThickness));
        this.bld.setMaxExponentialValue(this.viCD.getMaxAlpha());
        if (this.old.isLensUsed()) {
            this.old.setElevations();
            this.old.findTopOfOilZone();
        }
        this.oxygen.setVadoseZone(this.vz);
        this.oxygen.correctHenrysConstantForTemperature();
        this.oxygen.setSurfaceFlux(-this.oxygen.getNetSurfaceConcentration() * ((this.bld.getAirFlowBelowBuilding() + this.bld.getQs()) / this.bld.getAb()));
        this.oxygen.determineEffectiveDiffusionCoefficient();
        this.efdo2 = this.oxygen.getEffectiveDiffusionCoefficient();
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            c.setVadoseZone(this.vz);
            c.correctHenrysConstantForTemperature();
            c.determineEffectiveDiffusionCoefficient();
            c.setDiffusiveReactionLength();
            for (StatisticalDistribution sd : this.alSDistribution) {
                if (!s.areTheyEqual(sd.getParentName(), c.getName())) continue;
                c.setSourceConcentrationFromStatisticalDistribution();
            }
        }
    }

    public void loadData(VIControlData viCD) {
        this.viCD = viCD;
        this.fl = viCD.getOutputFileLogger();
        this.vz = viCD.getVadoseZone();
        this.bld = viCD.getBuilding();
        this.oxygen = viCD.getOxygen();
        this.old = viCD.getOilLens();
        this.alChemical = viCD.getChemicals();
        this.alSDistribution = viCD.getStatisticalDistribution();
        this.uc = viCD.getUnitConverter();
        this.lp = viCD.getLinkedParameters();
        this.pvisOutputWriter = new PVIScreenOutputWriter();
        this.pvisOutputWriter.setVIControlData(viCD);
        this.pvisOutputWriter.setAllChemical(this.alChemical);
        this.pvisOutputWriter.setUnitCnverter(this.uc);
        this.pvisOutputWriter.setFileLogger(this.fl);
        this.pvisOutputWriter.setAllStatisticalDistribution(this.alSDistribution);
    }

    public void setAerobicZoneDepth(double aerobicZoneDepth) {
        this.aerobicZoneThickness = aerobicZoneDepth;
    }

    public void setMaxExponential(double alphaMax) {
        this.dMaxAlpha = alphaMax;
    }

    public void setFileLoggerForInputs(FileLogger fl2) {
        this.fl2 = fl2;
    }

    public double getDepthToWater() {
        return this.vz.getDepthToWaterTable();
    }

    public boolean getIsMonteCarlo() {
        return this.viCD.getIsMonteCarlo();
    }

    public int getNumberOfRuns() {
        return this.viCD.getNumberOfRuns();
    }

    public int getNumberOfBisectionIterations() {
        return this.bisection.getCount();
    }

    public double getBisectionResult() {
        return this.bisection.getResult();
    }

    public boolean isSolutionFound() {
        return this.boolSolutionFound;
    }
}

