/*
 * Decompiled with CFR 0.152.
 */
package pviScreen;

import java.io.IOException;
import java.util.ArrayList;
import pviScreen.PVIScreenEquations;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.FieldData;
import pviScreen.dataContainers.VIControlData;
import pviScreen.outputProcessor.OutputProcessor;
import statistics.ResistantStatisticalMeasures;
import uncertaintyAnalysis.MonteCarloLHS;
import util.CalendarClock;
import util.FileLogger;
import util.UnitConverter;

public class RunPVIScreen {
    private String sModelName;
    private String sOutputFileName;
    private String sOutputFileTime;
    private boolean bSimulationCompleted;
    private CalendarClock ccEnd;
    private MonteCarloLHS mcLHS;
    private PVIScreenEquations pvisEquations;
    private OutputProcessor op;
    private VIControlData viCD;
    private UnitConverter uc;
    private ResistantStatisticalMeasures rsm;
    private FieldData fd;
    private String sInputFileName;
    private int iNumberOfRuns;

    public void runPVIScreen() {
        this.sModelName = "PVIScreen";
        boolean bRun = false;
        this.pvisEquations = new PVIScreenEquations();
        this.pvisEquations.initial();
        this.sOutputFileName = this.viCD.getOutputFileName();
        this.sOutputFileTime = this.viCD.getOutputFileTimeStamp();
        boolean bUnsupportedUnit = false;
        bUnsupportedUnit = this.viCD.getUnsupportedUnit();
        this.uc = this.viCD.getUnitConverter();
        FileLogger flOutputFile = this.viCD.getOutputFileLogger();
        flOutputFile.logMessage("Control,Results");
        bRun = this.viCD.getCanRunModel();
        this.bSimulationCompleted = false;
        if (bRun) {
            this.pvisEquations.loadData(this.viCD);
            boolean bMonteCarlo = this.pvisEquations.getIsMonteCarlo();
            if (!bMonteCarlo && !bUnsupportedUnit) {
                this.pvisEquations.runModel();
            } else if (bMonteCarlo && !bUnsupportedUnit) {
                FileLogger flSummary = new FileLogger();
                CalendarClock ccStart = new CalendarClock();
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "PVIScreen Monte Carlo Latin Hypercube Simulation Beginning");
                this.mcLHS = new MonteCarloLHS();
                this.mcLHS.setFileLoggers(flOutputFile, flSummary);
                this.mcLHS.setMonteCarloModel(this.pvisEquations);
                this.mcLHS.setMonteCarloParameters(this.pvisEquations.getNumberOfRuns());
                this.mcLHS.simulate();
                this.bSimulationCompleted = true;
                this.ccEnd = new CalendarClock();
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "PVIScreen Monte Carlo Latin Hypercube Simulation Ending");
                String sUnit = " seconds";
                double dSimulationTime = ccStart.timeDifferenceSeconds(this.ccEnd);
                if (dSimulationTime > 60.0) {
                    dSimulationTime /= 60.0;
                    sUnit = " minutes";
                } else if (dSimulationTime > 3600.0) {
                    dSimulationTime /= 3600.0;
                    sUnit = " hours";
                }
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "PVIScreen Run Time " + dSimulationTime + sUnit);
            }
        } else {
            this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), "PVIScreen Model Cannot Run");
        }
        this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Completed Simulation: " + this.sInputFileName);
    }

    public void requestOutputProcessing() throws IOException {
        if (this.bSimulationCompleted) {
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Processing and sorting PVISCreen outputs");
            this.processMonteCarloOutput(this.sModelName, this.sInputFileName, this.sOutputFileName);
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "PVIScreen Post-processing complete");
            CalendarClock ccPost = new CalendarClock();
            String sUnit = " seconds";
            double dSimulationTime = this.ccEnd.timeDifferenceSeconds(ccPost);
            if (dSimulationTime > 60.0) {
                dSimulationTime /= 60.0;
                sUnit = " minutes";
            } else if (dSimulationTime > 3600.0) {
                dSimulationTime /= 3600.0;
                sUnit = " hours";
            }
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "PVIScreen Post-processing Time " + dSimulationTime + sUnit);
        }
    }

    public void processMonteCarloOutput(String sModelName, String sInputFileName, String sOutputFileName) throws IOException {
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        this.op = new OutputProcessor();
        this.op = new OutputProcessor();
        this.op.initial();
        this.op.setVIControlData(this.viCD);
        this.op.setIntervalFrequency(this.viCD.getNumberOfFrequencyDistributionIntervals());
        this.op.setResultsFileName(sOutputFileName);
        this.op.setUnitConverter(this.uc);
        this.op.setNumberOfResults(this.pvisEquations.getNumberOfRuns());
        this.op.setResultsText(String.valueOf(sModelName) + " Result");
        this.op.setHeadingText(String.valueOf(sModelName) + " Heading");
        this.op.setSortedResultsText("Sorted " + sModelName + " Result");
        this.rsm = new ResistantStatisticalMeasures();
        this.rsm.setFileLogger(this.op.getOutputFileLogger());
        this.op.setResistantStatisticalMeasures(this.rsm);
        this.op.openOutputFile(sOutputFileName);
        this.op.writeRunFileInformation(sModelName, sInputFileName, sOutputFileName);
        String sHeading = "";
        for (Chemical chemical : alChemical) {
            if (!chemical.getIsUsedInSimulation()) continue;
            sHeading = String.valueOf(chemical.getName()) + " Indoor Air Concentration";
            break;
        }
        this.op.readResults(sHeading);
        this.op.sortByMergeSortAndReWrite();
        this.op.readSortedResultsToArrayList();
        this.op.generateStatistics();
        this.op.characterizeAndWriteData();
        this.op.writeStatistics();
        this.op.sortResultsColumn("Aerobic Zone Thickness");
        this.op.makeResultsColumnLogHistogram("Aerobic Zone Thickness", "Aerobic");
        this.op.writeLogHistogram("Aerobic Zone Thickness");
        for (Chemical chemical : alChemical) {
            if (!(chemical.getSourceConcentration() > 0.0)) continue;
            String sChemicalName = chemical.getName();
            String sChemicalTitle = String.valueOf(sChemicalName) + " indoor air concentration";
            this.op.sortResultsColumn(sChemicalTitle);
            this.op.makeResultsColumnLogHistogram(sChemicalTitle, sChemicalName);
            this.op.writeLogHistogram(sChemicalTitle);
        }
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public void setDataFileName(String sInputFileName) {
        this.sInputFileName = sInputFileName;
    }

    public void setOutputFileTime(String sOutputFileTime) {
        this.sOutputFileTime = sOutputFileTime;
    }

    public String getOutputFileName() {
        return this.sOutputFileName;
    }

    public String getOutputFileTime() {
        return this.sOutputFileTime;
    }

    public ArrayList<Chemical> getChemicals() {
        return this.viCD.getChemicals();
    }
}

