/*
 * Decompiled with CFR 0.152.
 */
package pviScreen;

import java.io.IOException;
import jem.JEMMain;
import pviScreen.PVIScreenMain;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataReaders.SystemDataFileReader;
import pviScreen.dataReaders.VIDataReader;
import util.CalendarClock;

public class VIModelController {
    private PVIScreenMain pvisMain;
    private JEMMain jemMain;
    private VIDataReader viDataReader;
    private VIControlData viCD;
    private SystemDataFileReader sdfr;

    public void manageModels() throws IOException {
        CalendarClock cc = new CalendarClock();
        this.viCD.setOutputFileTimeStamp(cc.getDateTimeString());
        this.pvisMain = new PVIScreenMain();
        this.pvisMain.setVIControlData(this.viCD);
        this.jemMain = new JEMMain();
        this.jemMain.setVIControlData(this.viCD);
    }

    public void readInputData(String sInputFileName) throws IOException {
        this.viDataReader = new VIDataReader();
        this.viDataReader.setVIControlData(this.viCD);
        this.viDataReader.initial();
        this.viDataReader.setOutputFileTime(this.viCD.getOutputFileTimeStamp());
        this.viDataReader.readFile(sInputFileName);
        this.viCD = this.viDataReader.getVIControlData();
        this.viCD.setOutputFileName(this.viDataReader.getOutputFileName());
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public PVIScreenMain getPVIScreenMain() {
        return this.pvisMain;
    }

    public JEMMain getJEMMain() {
        return this.jemMain;
    }

    public VIControlData getVIControlData() {
        return this.viCD;
    }
}

