/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataChecking;

import java.util.ArrayList;
import pviScreen.dataChecking.InputCheckList;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import util.FileLogger;

public class CheckTheInputData {
    private VIControlData viCD;
    private FileLogger fl;
    private InputCheckList icl;
    private String sCheckListType;

    public CheckTheInputData(String sCheckListType) {
        this.sCheckListType = sCheckListType;
    }

    public void check() {
        this.icl = this.viCD.getInputCheckList();
        this.icl.setVIControlData(this.viCD);
        ArrayList<RawInputLine> alRawInputLine = this.viCD.getRawInput().getAllRawInputLines();
        for (RawInputLine ril : alRawInputLine) {
            ril.setInputCheckList(this.icl);
        }
        this.icl.evaluate(alRawInputLine);
        this.icl.allItemsComplete(alRawInputLine);
        this.icl.addErrorResultsToCompilation(alRawInputLine);
        this.fl.logMessage(this.prepareOutputData());
    }

    public String prepareOutputData() {
        String sOut = "";
        ArrayList<RawInputLine> alRawInputLine = this.viCD.getRawInput().getAllRawInputLines();
        for (RawInputLine ril : alRawInputLine) {
            sOut = String.valueOf(sOut) + this.getComments(ril);
            sOut = String.valueOf(sOut) + ril.getAllTestResults();
            sOut = String.valueOf(sOut) + ril.getOutputLine();
        }
        return sOut;
    }

    public String getComments(RawInputLine ril) {
        return ril.getAllTestResults();
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public void setFileLogger(FileLogger fl) {
        this.fl = fl;
    }
}

