/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataChecking;

import java.util.ArrayList;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import util.Stripper;
import util.UnitConverter;

public class InputCheckList {
    private VIControlData viCD;
    private Stripper s = new Stripper();
    private String sCheckListName;
    private ArrayList<CheckList> alCheckList;
    private ArrayList<String> alControlNames;
    private String[][] sList;
    String[] sListItemControl = new String[]{"Begin", "Site", "SiteLocation", "City", "State", "Analyst", "GroundWaterConcentrationFactor", "Bisection", "maxAlpha", "NumberOfSimulations", "Numberoffrequencydistributionintervals", "End"};
    private String[] sListItemBuilding = new String[]{"Begin", "Dirt Floor", "Width", "Length", "FoundationDepthBelowGrade", "FoundationThickness", "MixingZone/CeilingHeight", "FoundationThickness", "CrackWidth", "AirExchangeRate", "Qsoil", "End"};
    private String[] sListItemVadoseZone = new String[]{"Begin", "DepthToSample", "DepthToWater", "DepthToHistoricWaterTable", "DepthToBottom", "MoistureContent", "Porosity", "FractionOrganicCarbon", "SoilTemperature", "SoilRespirationRate", "End"};
    private String[] sListItemOxygen = new String[]{"Begin", "DiffusionInAir", "DiffusionInWater", "SurfaceConcentration", "MinimumBiodegradationConcentration", "End"};
    private String[] sListItemChemical = new String[]{"Begin", "End"};
    private String[] sListItemScreeningLevel = new String[]{"Begin", "End"};
    boolean bRILPass;
    boolean bBeginEnd;
    boolean bCompleteFrequency;
    boolean bScreeningLevels;
    static double dTol = 1.0E-20;

    public InputCheckList(String sCheckListName) {
        this.sCheckListName = sCheckListName;
        this.initial();
    }

    public void initial() {
        this.alCheckList = new ArrayList();
        this.alControlNames = new ArrayList();
        CheckList clStandard = new CheckList();
        clStandard.setCheckListName(this.sCheckListName);
        this.alControlNames.add("Control");
        this.alControlNames.add("Building");
        this.alControlNames.add("VadoseZone");
        this.alControlNames.add("Oxygen");
        this.alControlNames.add("Chemical");
        this.alControlNames.add("ScreeningLevel");
        clStandard.setControlNames(this.alControlNames);
        int i = 0;
        while (i < this.sListItemControl.length) {
            clStandard.addItem("Control", this.sListItemControl[i]);
            ++i;
        }
        i = 0;
        while (i < this.sListItemBuilding.length) {
            clStandard.addItem("Building", this.sListItemBuilding[i]);
            ++i;
        }
        i = 0;
        while (i < this.sListItemVadoseZone.length) {
            clStandard.addItem("VadoseZone", this.sListItemVadoseZone[i]);
            ++i;
        }
        i = 0;
        while (i < this.sListItemOxygen.length) {
            clStandard.addItem("Oxygen", this.sListItemOxygen[i]);
            ++i;
        }
        i = 0;
        while (i < this.sListItemChemical.length) {
            clStandard.addItem("Chemical", this.sListItemChemical[i]);
            ++i;
        }
        i = 0;
        while (i < this.sListItemScreeningLevel.length) {
            clStandard.addItem("ScreeningLevel", this.sListItemScreeningLevel[i]);
            ++i;
        }
        this.alCheckList.add(clStandard);
    }

    public void evaluate(ArrayList<RawInputLine> alRawInputLine) {
        this.bRILPass = true;
        for (RawInputLine ril : alRawInputLine) {
            ArrayList<String> alTestString = ril.getAllTestNames();
            for (String string : alTestString) {
                this.bRILPass = ril.getTestResult(string);
                ril.addNewTestAndResult(string, ril.getValueString(), this.bRILPass);
            }
        }
        for (RawInputLine ril : alRawInputLine) {
            if (!this.s.areTheyTheSame("Chemical", ril.getGroupName())) continue;
            for (RawInputLine ril2 : alRawInputLine) {
                if (!this.s.areTheyTheSame("ScreeningLevel", ril.getGroupName()) || !this.s.areTheyTheSame(ril.getParameterName2(), ril2.getParameterName2())) continue;
                ril.addNewTestAndResult("ScreeningLevelPresent", ril.getValueString(), true);
            }
        }
        for (CheckList cl : this.alCheckList) {
            ArrayList<Item> alItem = cl.getAllItems();
            for (Item item : alItem) {
                boolean bBegin = false;
                boolean bEnd = false;
                RawInputLine rilBegin = null;
                RawInputLine rilEnd = null;
                for (String sControlNameInList : this.alControlNames) {
                    boolean bZero = false;
                    boolean bOne = false;
                    this.bBeginEnd = false;
                    String[] sP = this.getList(sControlNameInList);
                    for (RawInputLine ril : alRawInputLine) {
                        boolean bVariable = false;
                        if (this.s.areTheyEqual(ril.getParameterName(), "AirExchangeRate")) {
                            int ij = 0;
                            ++ij;
                        }
                        if (this.s.areTheyTheSame(ril.getParameterName(), "begin")) {
                            bBegin = true;
                            rilBegin = ril;
                        }
                        if (this.s.areTheyTheSame(ril.getParameterName(), "end")) {
                            bEnd = true;
                            rilEnd = ril;
                        }
                        if (sP == null) continue;
                        RawInputLine rilZero = null;
                        RawInputLine rilOne = null;
                        int j = 0;
                        while (j < sP.length) {
                            bVariable = false;
                            bZero = false;
                            bOne = false;
                            if (this.s.areTheyTheSame(sP[j], ril.getParameterName())) {
                                if (this.s.areTheyTheSame("Variable", ril.getDistributionType())) {
                                    bVariable = true;
                                    bZero = ril.getTestResult("Frequencyzero");
                                    bOne = ril.getTestResult("FrequencyOne");
                                    if (bZero) {
                                        rilZero = ril;
                                    }
                                    if (bOne) {
                                        rilOne = ril;
                                    }
                                }
                                if (bZero && bOne) {
                                    rilZero.addNewTestAndResult("AllFrequencies", String.valueOf(rilZero.getFrequency()), true);
                                    rilOne.addNewTestAndResult("AllFrequencies", String.valueOf(rilOne.getFrequency()), true);
                                }
                            }
                            ++j;
                        }
                    }
                    if (!bBegin || !bEnd) continue;
                    this.bBeginEnd = true;
                    for (RawInputLine ril : alRawInputLine) {
                        rilBegin.addNewTestAndResult("BeginAndEnd", rilBegin.getParameterName(), true);
                        rilEnd.addNewTestAndResult("BeginAndEnd", rilEnd.getParameterName(), true);
                    }
                }
            }
        }
    }

    public boolean allItemsComplete(ArrayList<RawInputLine> alRawInputLine) {
        boolean bResult = true;
        for (String sControlNameInList : this.alControlNames) {
            String[] sList = this.getList(sControlNameInList);
            int j = 0;
            while (j < sList.length) {
                for (RawInputLine ril : alRawInputLine) {
                    if (this.s.areTheyTheSame(sList[j], ril.getParameterName())) continue;
                    bResult = false;
                }
                ++j;
            }
        }
        boolean bChemicalPresent = false;
        for (RawInputLine ril : alRawInputLine) {
            if (!this.s.areTheyTheSame("Chemical", ril.getGroupName())) continue;
            bChemicalPresent = true;
        }
        if (!bChemicalPresent) {
            bResult = false;
        }
        return bResult;
    }

    public void addErrorResultsToCompilation(ArrayList<RawInputLine> alRawInputLine) {
        for (RawInputLine ril : alRawInputLine) {
            ArrayList<String> alFailedTests = ril.getAllFailedTestResults();
            for (String sFailedTest : alFailedTests) {
                this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), sFailedTest);
            }
        }
    }

    public String[] getList(String sControl) {
        if (this.s.areTheyTheSame(sControl, "Control")) {
            return this.sListItemControl;
        }
        if (this.s.areTheyTheSame(sControl, "Building")) {
            return this.sListItemBuilding;
        }
        if (this.s.areTheyTheSame(sControl, "VadoseZone")) {
            return this.sListItemVadoseZone;
        }
        if (this.s.areTheyTheSame(sControl, "Oxygen")) {
            return this.sListItemOxygen;
        }
        if (this.s.areTheyTheSame(sControl, "Chemical")) {
            return this.sListItemChemical;
        }
        if (this.s.areTheyTheSame(sControl, "ScreeningLevel")) {
            return this.sListItemScreeningLevel;
        }
        return null;
    }

    public boolean isAllowableGroupName(String sGroupNameToTest) {
        for (CheckList cl : this.alCheckList) {
            if (!this.s.areTheyTheSame(cl.getCheckListName(), this.sCheckListName)) continue;
            for (String sControlNameInList : this.alControlNames) {
                if (!this.s.areTheyTheSame(sGroupNameToTest, sControlNameInList)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAllowableControlParameterName(String sControlName, String sParameterNameToTest) {
        for (CheckList cl : this.alCheckList) {
            if (!this.s.areTheyTheSame(cl.getCheckListName(), this.sCheckListName)) continue;
            return cl.isItemInCheckList(sControlName, sParameterNameToTest);
        }
        return false;
    }

    public boolean isSpecifiedString(String sValue, String sParameterName) {
        return this.s.areTheyTheSame(sValue, sParameterName);
    }

    public boolean isNotBlank(String sParameterName) {
        return !this.s.areTheyTheSame("", sParameterName);
    }

    public boolean isNonZero(double dValue) {
        return dValue > 0.0;
    }

    public boolean isZeroOrPositiveNumber(double dValue) {
        return dValue >= 0.0;
    }

    public boolean isSpecificValue(double dStandardValue, double dValueToTest) {
        return Math.abs(dValueToTest - dStandardValue) <= dTol;
    }

    public boolean isAllowableDistributionType(String dDistributionType) {
        String[] sAllowableDistributions = new String[]{"Constant", "Variable", "Empirical"};
        int i = 0;
        while (i < sAllowableDistributions.length) {
            if (this.s.areTheyTheSame(sAllowableDistributions[i], dDistributionType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isAllowableUnit(UnitConverter uc, String sParameterName, String sUnit) {
        ArrayList<String> alAllowableUnits = uc.getAllUnitNamesForAType(uc.getUnitType(sParameterName));
        for (String string : alAllowableUnits) {
            if (!this.s.areTheyTheSame(string, sUnit)) continue;
            return true;
        }
        return false;
    }

    public boolean isAChemicalName(VIControlData viCD, String sChemicalName) {
        ArrayList<Chemical> alChemical = viCD.getChemicals();
        for (Chemical c : alChemical) {
            if (!this.s.areTheyTheSame(c.getName(), sChemicalName)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowableChemicalType(UnitConverter uc, String sChemicalType) {
        String[] sChoices = new String[]{"ConcentrationWater", "GroundwaterConcentration", "Indoor Air Concentration", "SoilGasConcentration", "ConcentrationAir"};
        int i = 0;
        while (i < sChoices.length) {
            ArrayList<String> alTypes = uc.getAllUnitNamesForAType(sChoices[i]);
            int j = 0;
            while (j < sChoices.length) {
                if (this.s.areTheyTheSame(sChoices[j], sChemicalType)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void setCheckListName(String sCheckListName) {
        this.sCheckListName = sCheckListName;
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    class CheckList {
        String sCheckListName;
        ArrayList<String> alControlNames;
        ArrayList<Item> alItems;
        Stripper s = new Stripper();

        CheckList() {
            this.alControlNames = new ArrayList();
            this.alItems = new ArrayList();
        }

        public boolean isControlNameInCheckList(String sControlName) {
            boolean bReturn = false;
            for (String sControlNameInList : this.alControlNames) {
                if (!this.s.areTheyTheSame(sControlNameInList, sControlName)) continue;
                bReturn = true;
                break;
            }
            return bReturn;
        }

        public boolean isControlInCheckList(String sControlName) {
            Stripper s = new Stripper();
            for (String sControlNameInList : this.alControlNames) {
                if (!s.areTheyEqual(sControlNameInList, sControlName)) continue;
                return true;
            }
            return false;
        }

        public boolean isItemInCheckList(String sControlName, String sItemName) {
            boolean bReturn = false;
            for (Item item : this.alItems) {
                if (!this.s.areTheyTheSame(sControlName, item.getGroupName()) || !this.s.areTheyTheSame(sItemName, item.getName())) continue;
                bReturn = true;
                break;
            }
            return bReturn;
        }

        public void addItem(String sControlName, String sName) {
            this.alItems.add(new Item(sControlName, sName));
        }

        public void setCheckListName(String sCheckListName) {
            this.sCheckListName = sCheckListName;
        }

        public void setControlNames(ArrayList<String> alControlNames) {
            this.alControlNames = alControlNames;
        }

        public String getCheckListName() {
            return this.sCheckListName;
        }

        public ArrayList<String> getControlNames() {
            return this.alControlNames;
        }

        public ArrayList<Item> getAllItems() {
            return this.alItems;
        }
    }

    class Item {
        String sParameterName = "";
        String sGroupName = "";
        boolean bStatus = false;

        Item() {
        }

        Item(String sGroupName, String sParameterName) {
            this.sGroupName = sGroupName;
            this.sParameterName = sParameterName;
        }

        public void setGroupName(String sGroupName) {
            this.sGroupName = sGroupName;
        }

        public void setName(String sParameterName) {
            this.sParameterName = sParameterName;
        }

        public void setStatus(boolean bStatus) {
            this.bStatus = bStatus;
        }

        public String getGroupName() {
            return this.sGroupName;
        }

        public String getName() {
            return this.sParameterName;
        }

        public boolean getStatus() {
            return this.bStatus;
        }
    }
}

