/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import pviScreen.dataContainers.VIDataAbstractClass;
import util.NameConstants;

public class Building
extends VIDataAbstractClass {
    private double airExchangeRate;
    private double mixingZoneHeight;
    private double h = 0.0;
    private double qs;
    private double eta;
    private double thCrack;
    private double lengthCrack;
    private double dCrack;
    private double wCrack;
    private double aCrack;
    private double dCrackRatio;
    private double aB;
    private double sq;
    private double qf;
    private double maxExponentialValue;
    private boolean bDirtFloor;
    private double dWidth;
    private double dLength;
    private double dDepthBelowGrade;
    private double dXBuildingCenter;
    private double dYBuildingCenter;
    private double dBuildingVolume;
    private String sMixingZoneName;
    private String sBuildingType;

    public Building() {
        super.setName("building");
        NameConstants nc = new NameConstants();
        nc.getClass();
        this.sBuildingType = "Residential";
    }

    public void setMassTransferCoefficient() {
        this.wCrack = this.getCrackWidth();
        this.lengthCrack = this.getLCrack();
        this.aB = this.getAb();
        this.thCrack = this.getThCrack();
        this.dCrackRatio = 4.0 * this.wCrack * Math.sqrt(this.aB) / this.aB;
        this.qs = this.getQs();
        this.mixingZoneHeight = this.getMixingZoneHeight();
        this.airExchangeRate = this.getAirExchangeRate();
        this.dWidth = this.getWidth();
        this.dLength = this.getLength();
        this.dBuildingVolume = this.mixingZoneHeight * this.dWidth * this.dLength;
        if (!this.bDirtFloor) {
            this.aCrack = this.wCrack * this.lengthCrack;
            this.eta = this.aCrack / this.aB;
            if (this.qs <= 0.0) {
                this.h = this.eta * this.dCrack / this.thCrack;
            } else {
                this.sq = this.qs / this.aB * (this.thCrack / this.dCrack) * (1.0 / this.eta);
                if (this.sq < this.maxExponentialValue) {
                    double k2 = Math.exp(this.sq);
                    double k3 = 1.0 / k2;
                    double k4 = this.mixingZoneHeight * this.airExchangeRate;
                    double k5 = (k2 - 1.0) / k2;
                    this.h = k4 / (k3 + k4 * (this.aB / this.qs) * k5 - 1.0);
                } else {
                    this.h = this.aB / this.qs - 1.0 / this.mixingZoneHeight * (1.0 / this.airExchangeRate);
                    this.h = 1.0 / this.h;
                }
            }
        } else {
            this.h = 1.0E7;
        }
    }

    public void setLocation(double dX, double dY) {
        this.dXBuildingCenter = dX;
        this.dYBuildingCenter = dY;
    }

    public void setAirExchangeRate(double dValue) {
        this.airExchangeRate = dValue;
        this.setConstantDistribution(dValue, "AirExchangeRate");
    }

    public void setMixingZoneHeight(double dValue) {
        this.mixingZoneHeight = dValue;
        this.setConstantDistribution(dValue, "CeilingHeight");
    }

    public void setQs(double dValue) {
        this.qs = dValue;
        this.setConstantDistribution(dValue, "Qsoil");
    }

    public void setThCrack(double dValue) {
        this.thCrack = dValue;
        this.setConstantDistribution(dValue, "FoundationThickness");
    }

    public void setWCrack(double dValue) {
        this.wCrack = dValue;
        this.setConstantDistribution(dValue, "CrackWidth");
    }

    public void setAirFlowBelowBuilding(double dValue) {
        this.qf = dValue;
        this.setConstantDistribution(dValue, "AirFlowBelowBuilding");
    }

    public void setWidth(double dValue) {
        this.dWidth = dValue;
        this.setConstantDistribution(dValue, "width");
    }

    public void setLength(double dValue) {
        this.dLength = dValue;
        this.setConstantDistribution(dValue, "length");
    }

    public void setDepthBelowGrade(double dValue) {
        this.dDepthBelowGrade = dValue;
        this.setConstantDistribution(dValue, "FoundationDepthBelowGrade");
    }

    public void setAb(double dValue) {
        this.aB = dValue;
    }

    public void setDCrack(double dValue) {
        this.dCrack = dValue;
    }

    public void setLCrack(double dValue) {
        this.lengthCrack = dValue;
    }

    public void setCrackRatio(double dCrackRatio) {
        this.dCrackRatio = dCrackRatio;
    }

    public void setMaxExponentialValue(double maxExponentialValue) {
        this.maxExponentialValue = maxExponentialValue;
    }

    public void setIsItADirtFloor(boolean bDirtFloor) {
        this.bDirtFloor = bDirtFloor;
    }

    public void setMixingZoneName(String sMixingZoneName) {
        this.sMixingZoneName = sMixingZoneName;
    }

    public void setBuildingType(String sBuildingType) {
        this.sBuildingType = sBuildingType;
    }

    public double getXLocation() {
        return this.dXBuildingCenter;
    }

    public double getYLocation() {
        return this.dYBuildingCenter;
    }

    public double getAirExchangeRate() {
        return this.getCurrentRandomValue("airExchangeRate", this.getName());
    }

    public double getMixingZoneHeight() {
        return this.getCurrentRandomValue(this.getMixingZoneName(), this.getName());
    }

    public double getWidth() {
        return this.getCurrentRandomValue("Width", this.getName());
    }

    public double getLength() {
        return this.getCurrentRandomValue("Length", this.getName());
    }

    public double getVolume() {
        return this.dBuildingVolume;
    }

    public double getFoundationDepthBelowGrade() {
        return this.getCurrentRandomValue("FoundationDepthBelowGrade", this.getName());
    }

    public double getFoundationThickness() {
        return this.getCurrentRandomValue("FoundationThickness", this.getName());
    }

    public double getCrackWidth() {
        return this.getCurrentRandomValue("CrackWidth", this.getName());
    }

    public double getThCrack() {
        return this.getCurrentRandomValue("FoundationThickness", this.getName());
    }

    public double getAirFlowBelowBuilding() {
        return this.getCurrentRandomValue("AirFlowBelowBuilding", this.getName());
    }

    public double getQs() {
        return this.getCurrentRandomValue("QSoil", this.getName());
    }

    public double getParameter(String sName) {
        return this.getCurrentRandomValue(sName, this.getName());
    }

    public double getMiddleValue(String sName) {
        return this.getMiddleValue(sName, this.getName());
    }

    public String getBuildingType() {
        return this.sBuildingType;
    }

    public String getMixingZoneName() {
        return this.sMixingZoneName;
    }

    public double getFoundationMassTransferCoefficient() {
        return this.h;
    }

    public double getLCrack() {
        return this.lengthCrack;
    }

    public double getCrackRatio() {
        return this.dCrackRatio;
    }

    public double getAb() {
        return this.aB;
    }

    public boolean getIsItADirtFloor() {
        return this.bDirtFloor;
    }
}

