/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import pviScreen.dataContainers.AquiferData;
import pviScreen.dataContainers.OilLens;
import pviScreen.dataContainers.VIDataAbstractClass;
import pviScreen.dataContainers.VadoseZone;
import pviScreen.dataReaders.InterpretInputName;
import uncertaintyAnalysis.StatisticalDistribution;
import util.Stripper;
import util.UnitConverter;

public class Chemical
extends VIDataAbstractClass {
    protected String sInputType;
    protected double cs;
    protected double mf = 1.0;
    protected double cSurface;
    protected double jSurface;
    protected double ce;
    protected double cf;
    protected double ct;
    protected double jt;
    protected double jf;
    protected double svc;
    protected double dFuelPhaseConcentrationByVolume;
    protected double dFuelPhaseConcentrationByMass;
    protected double kh;
    protected double dKo;
    protected double dw;
    protected double da;
    protected double kw;
    protected double dMW;
    protected double dDensity;
    protected double dSolubility;
    protected double dKoc;
    protected double moistureContent;
    protected double edf;
    protected double dDiffusiveReactionLength;
    protected double phi;
    protected double alpha;
    protected double cOne;
    protected VadoseZone vz;
    protected AquiferData aq;
    protected OilLens old;
    protected UnitConverter uc;
    protected boolean bUserRiskSet = false;
    protected double dHReferenceTemp;
    protected double dHCriticalTemp;
    protected double dHBoilingTemp;
    protected double dHReference;
    protected double dHEnthalpy;
    protected double dHCorrected;
    protected boolean bCancerLevelEntered = false;
    protected boolean bNonCancerLevelEntered = false;
    protected boolean bExternalScreeningLevelEntered = false;
    protected double dIUR;
    protected double dRfC;
    protected double dExternalScreeningLevel;
    protected double dRiskFinalChoice;
    protected boolean bRiskFinalChoiceMade = false;
    protected double dCancerRiskResidential;
    protected double dNonCancerRiskResidential;
    protected double dCancerRiskCommercial;
    protected double dNonCancerRiskCommercial;
    protected double dConcentrationAdjustmentGroundWater;
    protected double dConcentrationAdjustmentSoilSample;
    protected InterpretInputName iin;
    protected String sParentName;
    double dFvi;

    public void calculateAlpha() {
    }

    public void setAirPhaseConcentration() {
        double dSa;
        Stripper s = new Stripper();
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!s.areTheyEqual(sd.getDistributionType(), "Chemical") || !s.areTheyEqual(sd.getParentName(), this.getName())) continue;
            sd.setIsThisDistributionActuallyUsed(true);
        }
        boolean bAirPhase = false;
        boolean bSoilSample = false;
        boolean bFuelPhaseConcentrationByVolume = false;
        boolean bFuelPhaseConcentrationByMass = false;
        boolean bWaterPhase = false;
        if (s.areTheyEqual("FuelPhaseConcentrationByMass", this.sInputType, ' ') || s.areTheyEqual("FuelPhaseConcentrationByVolume", this.sInputType, ' ')) {
            double dElevation = this.old.getOilZoneTopElevation();
            double dSo = this.old.getOilSaturation(dElevation);
            dSa = this.vz.getTrappedAirSaturation();
            double dSw = 1.0 - dSo - dSa;
            this.determineKo();
            String sMassOrVolumeConc = "FuelPhaseConcentrationByMass";
            bFuelPhaseConcentrationByMass = true;
            bFuelPhaseConcentrationByVolume = false;
            if (this.sInputType.equalsIgnoreCase("FuelPhaseConcentrationByVolume") || this.sInputType.equalsIgnoreCase("Fuel Phase Concentration by Volume")) {
                sMassOrVolumeConc = "FuelPhaseConcentrationByVolume";
                bFuelPhaseConcentrationByMass = false;
                bFuelPhaseConcentrationByVolume = true;
            }
            StatisticalDistribution sdFuel = new StatisticalDistribution();
            for (StatisticalDistribution sd : this.alSDPVIScreen) {
                if (!sd.getName().equalsIgnoreCase(sMassOrVolumeConc)) continue;
                sdFuel = sd;
                break;
            }
            int iNumberOfEntries = sdFuel.getNumberOfPointsDefiningDistribution();
            int i = 0;
            while (i < iNumberOfEntries) {
                double dFrequency = sdFuel.getFrequency(i);
                double f1 = sdFuel.getConcentration(i);
                double f2 = this.old.getOilDensity();
                double f3 = dSo;
                double f4 = this.vz.getPorosity();
                double dCw = f1 * this.old.getOilDensity() * dSo * this.vz.getPorosity();
                if (this.sInputType.equalsIgnoreCase("FuelPhaseConcentrationByVolume") || this.sInputType.equalsIgnoreCase("Fuel Phase Concentration by Volume")) {
                    dCw = f1 * this.getDensity() * dSo * this.vz.getPorosity();
                }
                double denom = this.vz.getPorosity() * (dSw + this.getKo() * dSo + this.getHenrysConstant() * dSa + this.getKoc() * this.vz.getBulkDensity() * this.vz.getFractionOrganicCarbon() / this.vz.getPorosity());
                double dCa = this.getHenrysConstant() * (dCw /= denom);
                for (StatisticalDistribution sd : this.alSDPVIScreen) {
                    if (!sd.getName().equalsIgnoreCase(this.iin.getSoilGasSampleName())) continue;
                    sd.addAPoint(dCa, dFrequency);
                    break;
                }
                this.setCalculationUnit(this.iin.getSoilGasSampleName(), this.uc.getModelUnit("ConcentrationAir"));
                ++i;
            }
        } else if (s.areTheyEqual("SoilSample", this.sInputType)) {
            double dSo;
            double dSw = this.vz.getMoistureContent() * this.vz.getPorosity();
            dSa = 1.0 - dSw - (dSo = 0.05);
            if (dSa < 0.0) {
                dSa = 0.01;
                dSo = 0.04;
            }
            bSoilSample = true;
            StatisticalDistribution sdSoilSample = new StatisticalDistribution();
            for (StatisticalDistribution sd : this.alSDPVIScreen) {
                if (!sd.getName().equalsIgnoreCase("SoilSample")) continue;
                sdSoilSample = sd;
                break;
            }
            double denom = this.vz.getPorosity() * (dSw + this.getKo() * dSo + this.getHenrysConstant() * dSa + this.getKoc() * this.vz.getBulkDensity() * this.vz.getFractionOrganicCarbon() / this.vz.getPorosity());
            double dBulkHat = this.vz.getBulkDensity() + dSw * this.vz.getPorosity() * 1.0 + dSo * this.vz.getPorosity() * 0.75;
            int iNumberOfEntries = sdSoilSample.getNumberOfPointsDefiningDistribution();
            int i = 0;
            while (i < iNumberOfEntries) {
                double dFrequency = sdSoilSample.getFrequency(i);
                double dCw = dBulkHat * sdSoilSample.getConcentration(i) / denom;
                double dCa = this.getHenrysConstant() * dCw;
                dCa *= this.dConcentrationAdjustmentSoilSample;
                for (StatisticalDistribution sd : this.alSDPVIScreen) {
                    if (!sd.getName().equalsIgnoreCase(this.iin.getSoilGasSampleName())) continue;
                    sd.addAPoint(dCa, dFrequency);
                    break;
                }
                ++i;
            }
            this.setCalculationUnit(this.iin.getSoilGasSampleName(), this.uc.getModelUnit("ConcentrationAir"));
        } else if (this.iin.checkForAllowableInternalName(this.iin.getGroundWaterSampleName(), this.sInputType)) {
            StatisticalDistribution sdWaterSample = new StatisticalDistribution();
            StatisticalDistribution sdAir = new StatisticalDistribution();
            for (StatisticalDistribution sd : this.alSDPVIScreen) {
                if (!s.areTheyTheSame(sd.getName(), this.iin.getGroundWaterSampleName())) continue;
                sdWaterSample = sd;
                break;
            }
            for (StatisticalDistribution sd : this.alSDPVIScreen) {
                if (!sd.getName().equalsIgnoreCase(this.iin.getSoilGasSampleName())) continue;
                sdAir = sd;
                sdAir.setIsThisDistributionActuallyUsed(true);
                sdAir.reSetNumberOfPointsDefiningStatisticalDistribution(0);
                break;
            }
            int iNumberOfEntries = sdWaterSample.getNumberOfPointsDefiningDistribution();
            int i = 0;
            while (i < iNumberOfEntries) {
                double dFrequency = sdWaterSample.getFrequency(i);
                double dCa = this.getHenrysConstant() * sdWaterSample.getValue(dFrequency) * 0.001;
                sdAir.addAPoint(dCa *= this.dConcentrationAdjustmentGroundWater, dFrequency);
                ++i;
            }
            this.setCalculationUnit(this.iin.getSoilGasSampleName(), this.uc.getModelUnit("ConcentrationAir"));
            bWaterPhase = true;
        } else {
            bAirPhase = true;
        }
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!s.areTheyEqual(sd.getDistributionType(), "Chemical")) continue;
            if (s.areTheyEqual(sd.getName(), "SoilSample") && !bSoilSample) {
                sd.setIsThisDistributionActuallyUsed(false);
            }
            if (s.areTheyEqual(sd.getName(), "FuelPhaseConcentrationByVolume") && !bFuelPhaseConcentrationByVolume) {
                sd.setIsThisDistributionActuallyUsed(false);
            }
            if (s.areTheyEqual(sd.getName(), "FuelPhaseConcentrationByMass") && !bFuelPhaseConcentrationByMass) {
                sd.setIsThisDistributionActuallyUsed(false);
            }
            if (!s.areTheyTheSame(sd.getName(), this.iin.getGroundWaterSampleName()) || bWaterPhase) continue;
            sd.setIsThisDistributionActuallyUsed(false);
        }
    }

    public void determineKo() {
        this.dKo = this.old.getOilDensity() / this.old.getOilMolecularWeight();
        double dMw = this.getMolecularWeight();
        double dS = this.getSolubility();
        double denom = this.getSolubility() / this.getMolecularWeight();
        this.dKo /= denom;
    }

    public void determineEffectiveDiffusionCoefficient() {
        double porosity = this.vz.getPorosity();
        double moistureContent = this.vz.getMoistureContent();
        double airFilledPorosity = porosity - moistureContent;
        this.da = this.getDa();
        this.dw = this.getDw();
        this.kh = this.getHenrysConstant();
        this.edf = Math.pow(airFilledPorosity, 3.3333333333333335) / porosity * (this.da / porosity);
        this.edf += Math.pow(moistureContent, 3.3333333333333335) / porosity * (1.0 / porosity) * (this.dw / this.kh);
    }

    public void setAlpha(double d) {
        this.alpha = d / this.getDiffusiveReactionLength();
    }

    public void setDiffusiveReactionLength() {
        this.kw = this.getKw();
        this.kh = this.getHenrysConstant();
        this.moistureContent = this.vz.getMoistureContent();
        this.edf = this.getEffectiveDiffusionCoefficient();
        this.dDiffusiveReactionLength = Math.sqrt(this.edf / this.kw * (this.kh / this.moistureContent));
    }

    public void convertMassFractionToVolumeFraction() {
        this.dFuelPhaseConcentrationByVolume = this.dFuelPhaseConcentrationByMass * this.old.getOilDensity() / this.getDensity();
    }

    public void convertVolumeFractionToMassFraction() {
        this.dFuelPhaseConcentrationByMass = this.dFuelPhaseConcentrationByVolume * this.getDensity() / this.old.getOilDensity();
    }

    public void correctHenrysConstantForTemperature() {
        double dRc = 1.9872;
        double dTempSoil = this.vz.getSoilTemperature() + 273.15;
        double dTempRatio = (this.dHBoilingTemp + 273.15) / (this.dHCriticalTemp + 273.15);
        double dExponent = 0.3;
        if (dTempRatio < 0.57) {
            dExponent = 0.3;
        } else if (0.57 <= dTempRatio && dTempRatio <= 0.71) {
            dExponent = 0.74 * dTempRatio - 0.116;
        } else if (dTempRatio > 0.71) {
            dExponent = 0.41;
        }
        if (dTempRatio > 1.0) {
            dTempRatio = 0.99;
        }
        double dDeltaHVTS = this.dHEnthalpy * Math.pow((1.0 - dTempSoil / (this.dHCriticalTemp + 273.15)) / (1.0 - dTempRatio), dExponent);
        this.dHCorrected = Math.exp(-(dDeltaHVTS / dRc) * (1.0 / dTempSoil - 1.0 / (this.dHReferenceTemp + 273.15))) * this.dHReference;
    }

    public double getSoilGasEquivalentFromGroundWaterSample(double dGWConcentration) {
        return dGWConcentration * this.getHenrysConstant();
    }

    public double getGroundWaterEquivalentFromSoilGasSample(double dSGConcentration) {
        return dSGConcentration / this.getHenrysConstant();
    }

    public void determineFinalRiskChoice(boolean bExternalScreeningLevelEntered, String sBuildingType) {
        Stripper s = new Stripper();
        if (bExternalScreeningLevelEntered) {
            this.dRiskFinalChoice = this.dExternalScreeningLevel;
        } else if (s.areTheyEqual(sBuildingType, "Residential", ' ')) {
            this.dRiskFinalChoice = this.dNonCancerRiskResidential;
            if (this.dCancerRiskResidential > 0.0 && this.dCancerRiskResidential < this.dNonCancerRiskResidential) {
                this.dRiskFinalChoice = this.dCancerRiskResidential;
            }
        } else if (s.areTheyEqual(sBuildingType, "Commerical", ' ')) {
            this.dRiskFinalChoice = this.dNonCancerRiskCommercial;
            if (this.dCancerRiskCommercial > 0.0 && this.dCancerRiskCommercial < this.dNonCancerRiskCommercial) {
                this.dRiskFinalChoice = this.dCancerRiskCommercial;
            }
        }
    }

    public void setInputType(String sInputType) {
        this.sInputType = sInputType;
    }

    public void setSourceConcentrationConcentrationMultiplier(double mf) {
        this.mf = mf;
    }

    public void setSurfaceConcentration(double cSurface) {
        this.cSurface = cSurface;
    }

    public void setSurfaceFlux(double jSurface) {
        this.jSurface = jSurface;
    }

    public void setSourceConcentrationFromStatisticalDistribution() {
        this.setAirPhaseConcentration();
    }

    public void setSaturatedVaporConcentration(double dValue) {
        this.svc = dValue;
        this.setConstantDistribution(dValue, "SaturatedVaporConcentration");
    }

    public void setFuelPhaseConcentrationByVolume(double dValue) {
        this.dFuelPhaseConcentrationByVolume = dValue;
        this.setConstantDistribution(dValue, "FuelPhaseConcentrationByVolume");
    }

    public void setFuelPhaseConcentrationByMass(double dValue) {
        this.dFuelPhaseConcentrationByMass = dValue;
        this.setConstantDistribution(dValue, "FuelPhaseConcentrationByMass");
    }

    public void setHenrysConstant(double dValue) {
        this.kh = dValue;
        this.setConstantDistribution(dValue, "HenrysConstant");
    }

    public void setDa(double dValue) {
        this.da = dValue;
        this.setConstantDistribution(dValue, "DiffusionInAir");
    }

    public void setDw(double dValue) {
        this.dw = dValue;
        this.setConstantDistribution(dValue, "DiffusionInWater");
    }

    public void setKw(double dValue) {
        this.kw = dValue;
        this.setConstantDistribution(dValue, "degradation");
    }

    public void setPhi(double dValue) {
        this.phi = dValue;
        this.setConstantDistribution(dValue, "UtilizationFactor");
    }

    public void setMolecularWeight(double dValue) {
        this.dMW = dValue;
        this.setConstantDistribution(dValue, "MolecularWeight");
    }

    public void setDensity(double dValue) {
        this.dDensity = dValue;
        this.setConstantDistribution(dValue, "Density");
    }

    public void setSolubility(double dValue) {
        this.dSolubility = dValue;
        this.setConstantDistribution(dValue, "Solubility");
    }

    public void setKoc(double dValue) {
        this.dKoc = dValue;
        this.setConstantDistribution(dValue, "Koc");
    }

    public void setVadoseZone(VadoseZone vz) {
        this.vz = vz;
    }

    public void setAquifer(AquiferData aq) {
        this.aq = aq;
    }

    public void setOilLensData(OilLens old) {
        this.old = old;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setRiskDataSet(boolean bUserRiskSet) {
        this.bUserRiskSet = bUserRiskSet;
    }

    public void setTransitionPointConcentration(double ct) {
        this.ct = ct;
    }

    public void setTransitionPointFlux(double jt) {
        this.jt = jt;
    }

    public void setIndoorAirConcentration(double ce) {
        this.ce = ce;
    }

    public void setFoundationConcentration(double cf) {
        this.cf = cf;
    }

    public void setFoundationFlux(double jf) {
        this.jf = jf;
    }

    public void setReferenceHenrysConstant(double dValue) {
        this.dHReference = dValue;
    }

    public void setReferenceHenrysConstantTemp(double dValue) {
        this.dHReferenceTemp = dValue;
    }

    public void setNormalBoilingPoint(double dValue) {
        this.dHBoilingTemp = dValue;
    }

    public void setCritialTemp(double dValue) {
        this.dHCriticalTemp = dValue;
    }

    public void setEnthalpy(double dValue) {
        this.dHEnthalpy = dValue;
    }

    public void setIUR(double dIUR) {
        this.dIUR = dIUR;
    }

    public void setIURSet(boolean b) {
        this.bCancerLevelEntered = b;
    }

    public void setReferenceConcentration(double dRfC) {
        this.dRfC = dRfC;
    }

    public void setReferenceConcentrationSet(boolean b) {
        this.bNonCancerLevelEntered = b;
    }

    public void setCancerRiskResidential(double d) {
        this.dCancerRiskResidential = d;
    }

    public void setCancerRiskCommercial(double d) {
        this.dCancerRiskCommercial = d;
    }

    public void setNonCancerRiskResidential(double d) {
        this.dNonCancerRiskResidential = d;
    }

    public void setNonCancerRiskCommercial(double d) {
        this.dNonCancerRiskCommercial = d;
    }

    public void setExternalScreeningLevel(double dScreeningLevel) {
        this.dExternalScreeningLevel = dScreeningLevel;
        this.setScreeningLevelSet(true);
    }

    public void setScreeningLevelSet(boolean b) {
        this.bExternalScreeningLevelEntered = b;
    }

    public void setConcentrationAdjustmentGroundWater(double d) {
        this.dConcentrationAdjustmentGroundWater = d;
    }

    public void setConcentrationAdjustmentSoilSample(double d) {
        this.dConcentrationAdjustmentSoilSample = d;
    }

    public void setInterpretInputName(InterpretInputName iin) {
        this.iin = iin;
    }

    public double getUCFmgM3() {
        return 1000000.0;
    }

    public void determineLeachedConcentration(double dTime) {
        double dSw;
        double dOilZone = this.old.getOilZoneTopElevation() - (this.vz.getDepthToBottom() - this.vz.getDepthToHistoricWaterTable());
        double dVolumeTotal = this.old.getLensArea() * dOilZone;
        double dSatAtTop = this.old.getOilSaturation(this.old.getOilZoneTopElevation());
        double dSoAvg = 0.5 * (dSatAtTop + this.old.getResidualOilSaturation());
        double dMobileOilZone = this.old.getOilZoneTopElevation() - this.old.getMobileOilZoneBottomElevation();
        double dZResidual = this.old.getMobileOilZoneBottomElevation() - (this.vz.getDepthToBottom() - this.vz.getDepthToHistoricWaterTable());
        double dSo = (dZResidual * this.old.getResidualOilSaturation() + dSoAvg * dMobileOilZone) / (dZResidual + dMobileOilZone);
        double dBCoeff = dSw = 1.0 - dSo;
        dBCoeff += dSo * this.getKo();
        double dqw = Math.abs(this.aq.getGradient() * this.aq.getHydraulicConductivity());
        double dQw = (dqw *= 0.9) * this.old.getLensWidth() * (dZResidual + dMobileOilZone);
        double dK = 1.0 / this.vz.getPorosity();
        dK /= dVolumeTotal;
        dK /= (dBCoeff += this.vz.getBulkDensity() / this.vz.getPorosity() * this.vz.getFractionOrganicCarbon() * this.getKoc());
        dK *= dQw;
        double dFuelPhase = this.getFuelSourceByVolume();
        double dCInitial = this.getFuelSourceByVolume() * this.getDensity();
        double dKo = this.getKo();
        double dFactor = (dK *= -1.0) * dTime;
        double dMult = Math.exp(dFactor);
        dMult = Math.pow(2.7178, dFactor);
        double dCw = (dCInitial /= this.getKo()) * Math.exp(dFactor);
        this.dFvi = this.getKo() * dCw / this.getDensity();
    }

    public double getLeachedVolumeFraction() {
        return this.dFvi;
    }

    public String getInputType() {
        return this.sInputType;
    }

    public double getConcentrationMultiplier() {
        return this.mf;
    }

    public double getSurfaceConcentration() {
        return this.cSurface;
    }

    public double getSurfaceFlux() {
        return this.jSurface;
    }

    public double getPhi() {
        return this.getCurrentRandomValue("UtilizationFactor", this.getName());
    }

    public double getDa() {
        return this.getCurrentRandomValue("DiffusionCoefficientInAir", this.getName());
    }

    public double getDw() {
        return this.getCurrentRandomValue("DiffusionCoefficientInWater", this.getName());
    }

    public double getHenrysConstant() {
        return this.dHCorrected;
    }

    public double getKw() {
        return this.getCurrentRandomValue("Degradation", this.getName());
    }

    public double getMolecularWeight() {
        return this.getCurrentRandomValue("MolecularWeight", this.getName());
    }

    public double getDensity() {
        return this.getCurrentRandomValue("Density", this.getName());
    }

    public double getSolubility() {
        return this.getCurrentRandomValue("Solubility", this.getName());
    }

    public double getKoc() {
        return this.getCurrentRandomValue("Koc", this.getName());
    }

    public double getSourceConcentration() {
        return this.getCurrentRandomValue(this.iin.getSoilGasSampleName(), this.getName());
    }

    public double getSourceConcentration(String sType) {
        return this.getCurrentRandomValue(sType, this.getName());
    }

    public double getFuelSourceByVolume() {
        return this.getCurrentRandomValue("FuelPhaseConcentrationByVolume", this.getName());
    }

    public double getFuelSourceByMass() {
        return this.getCurrentRandomValue("FuelPhaseConcentrationByMass", this.getName());
    }

    public String getInputName() {
        return this.sInputType;
    }

    public double getEffectiveDiffusionCoefficient() {
        return this.edf;
    }

    public double getKo() {
        return this.dKo;
    }

    public double getDiffusiveReactionLength() {
        return this.dDiffusiveReactionLength;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getTransitionPointConcentration() {
        return this.ct;
    }

    public double getTransitionPointFlux() {
        return this.jt;
    }

    public double getIndoorAirConcentration() {
        return this.ce;
    }

    public double getFoundationConcentration() {
        return this.cf;
    }

    public double getFoundationFlux() {
        return this.jf;
    }

    public double getIUR() {
        return this.dIUR;
    }

    public boolean getIURSet() {
        return this.bCancerLevelEntered;
    }

    public double getReferenceConcentration() {
        return this.dRfC;
    }

    public boolean getReferenceConcentrationSet() {
        return this.bNonCancerLevelEntered;
    }

    public double getScreeningLevel() {
        return this.dExternalScreeningLevel;
    }

    public boolean getScreeningLevelSet() {
        return this.bExternalScreeningLevelEntered;
    }

    public double getCancerRiskResidential() {
        return this.dCancerRiskResidential;
    }

    public double getCancerRiskCommercial() {
        return this.dCancerRiskCommercial;
    }

    public double getNonCancerRiskResidential() {
        return this.dNonCancerRiskResidential;
    }

    public double getNonCancerRiskCommercial() {
        return this.dNonCancerRiskCommercial;
    }

    public double getCancerRisk() {
        return 0.0;
    }

    public double getNonCancerRisk() {
        return 0.0;
    }

    public double getFinalRiskChoice() {
        return this.dRiskFinalChoice;
    }

    public double getExternalScreeningLevel() {
        return this.dExternalScreeningLevel;
    }
}

