/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import java.util.ArrayList;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.VIDataAbstractClass;
import util.Stripper;

public class ExposureFactorData
extends VIDataAbstractClass {
    private ArrayList<ExposureFactors> alExposureFactors = new ArrayList();
    private double dResidentialCancer;
    private double dResidentialNonCancer;
    private double dCommercialCancer;
    private double dCommercialNonCancer;
    private double dTargetCancerRisk = 1.0E-6;
    private double dTargetHazardQuotient = 1.0;

    public ExposureFactorData() {
        this.createNewExposureFactorGroup("cancer", "residential");
        this.createNewExposureFactorGroup("noncancer", "residential");
        this.createNewExposureFactorGroup("cancer", "commercial");
        this.createNewExposureFactorGroup("noncancer", "commercial");
    }

    public void determineAllRiskLevels(ArrayList<Chemical> alChemical) {
        for (Chemical c : alChemical) {
            this.determineRiskLevels(c);
            c.setCancerRiskResidential(this.dResidentialCancer);
            c.setCancerRiskCommercial(this.dCommercialCancer);
            c.setNonCancerRiskResidential(this.dResidentialNonCancer);
            c.setNonCancerRiskCommercial(this.dCommercialNonCancer);
        }
    }

    public void determineRiskLevels(Chemical c) {
        this.dResidentialCancer = this.determineRisk("cancer", "residential", c, this.alExposureFactors);
        this.dResidentialNonCancer = this.determineRisk("noncancer", "residential", c, this.alExposureFactors);
        this.dCommercialCancer = this.determineRisk("cancer", "commercial", c, this.alExposureFactors);
        this.dCommercialNonCancer = this.determineRisk("noncancer", "commercial", c, this.alExposureFactors);
    }

    private double determineRisk(String sRiskType, String sBuildingType, Chemical c, ArrayList<ExposureFactors> alExposureFactors) {
        Stripper s = new Stripper();
        ExposureFactors ef = null;
        for (ExposureFactors eff : alExposureFactors) {
            if (!s.areTheyTheSame(String.valueOf(sRiskType) + sBuildingType, eff.getName())) continue;
            ef = eff;
            break;
        }
        double dRisk = 0.0;
        if (s.areTheyTheSame("cancer", sRiskType)) {
            dRisk = this.dTargetCancerRisk * ef.getAveragingTime();
            dRisk = dRisk / ef.getExposureFrequency() / ef.getExposureDuration() / ef.getExposureTime() / c.getIUR();
        } else if (s.areTheyTheSame("noncancer", sRiskType)) {
            dRisk = this.dTargetHazardQuotient * c.getReferenceConcentration() * ef.getAveragingTime();
            dRisk = dRisk / ef.getExposureFrequency() / ef.getExposureDuration() / ef.getExposureTime();
        }
        return dRisk;
    }

    public void createNewExposureFactorGroup(String sRiskType, String sBuildingType) {
        this.alExposureFactors.add(new ExposureFactors(sRiskType, sBuildingType));
    }

    public void addToExposureFactorGroup(String sRiskType, String sBuildingType, String sFactorName, double dValue, String sUnit) {
        Stripper s = new Stripper();
        for (ExposureFactors ef : this.alExposureFactors) {
            if (!s.areTheyEqual(ef.getName(), String.valueOf(sRiskType) + sBuildingType)) continue;
            ef.add(sFactorName, dValue, sUnit);
        }
    }

    public void setTargetCancerRisk(double dTargetCancerRisk) {
        this.dTargetCancerRisk = dTargetCancerRisk;
    }

    public void setTargetHazardQuotient(double dTargetHazardQuotient) {
        this.dTargetHazardQuotient = dTargetHazardQuotient;
    }

    public double getRisk(String sRiskType, String sBuildingType) {
        double dReturn = 0.0;
        Stripper s = new Stripper();
        if (s.areTheyEqual("cancer", sRiskType, ' ')) {
            if (s.areTheyEqual("Residential", sBuildingType, ' ')) {
                dReturn = this.dResidentialCancer;
            } else if (s.areTheyEqual("Commercial", sBuildingType, ' ')) {
                dReturn = this.dCommercialCancer;
            }
        } else if (s.areTheyEqual("noncancer", sRiskType, ' ')) {
            if (s.areTheyEqual("Residential", sBuildingType, ' ')) {
                dReturn = this.dResidentialNonCancer;
            } else if (s.areTheyEqual("Commercial", sBuildingType, ' ')) {
                dReturn = this.dCommercialNonCancer;
            }
        }
        return dReturn;
    }

    class ExposureFactors {
        double dAveragingTime;
        double dExposureFrequency;
        double dExposureDuration;
        double dExposureTime;
        String sName;
        String sAveragingTimeUnit;
        String sExposureFrequencyUnit;
        String sExposureDurationUnit;
        String sExposureTimeUnit;
        String sRiskType;
        String sBuildingType;

        ExposureFactors() {
        }

        ExposureFactors(String sRiskType, String sBuildingType) {
            this.sName = String.valueOf(sRiskType) + sBuildingType;
            this.sRiskType = sRiskType;
            this.sBuildingType = sBuildingType;
        }

        ExposureFactors(String sRiskType, String sBuildingType, double dAveragingTime, double dExposureFrequency, double dExposureDuration, double dExposureTime) {
            this.sName = String.valueOf(sRiskType) + sBuildingType;
            this.sRiskType = sRiskType;
            this.sBuildingType = sBuildingType;
            this.dAveragingTime = dAveragingTime;
            this.dExposureFrequency = dExposureFrequency;
            this.dExposureDuration = dExposureDuration;
            this.dExposureTime = dExposureTime;
        }

        public void add(String sFactorName, double dValue, String sUnit) {
            Stripper s = new Stripper();
            if (s.areTheyEqual(sFactorName, "AveragingTime")) {
                this.dAveragingTime = dValue;
                this.sAveragingTimeUnit = sUnit;
            } else if (s.areTheyTheSame(sFactorName, "ExposureFrequency")) {
                this.dExposureFrequency = dValue;
                this.sExposureFrequencyUnit = sUnit;
            } else if (s.areTheyTheSame(sFactorName, "ExposureDuration")) {
                this.dExposureDuration = dValue;
                this.sExposureFrequencyUnit = sUnit;
            } else if (s.areTheyTheSame(sFactorName, "ExposureTime")) {
                this.dExposureTime = dValue;
                this.sExposureTimeUnit = sUnit;
            }
        }

        public void setAveragingTime(double dAveragingTime) {
            this.dAveragingTime = dAveragingTime;
        }

        public void setExposureFrequency(double dExposureFrequency) {
            this.dExposureFrequency = dExposureFrequency;
        }

        public void setExposureDuration(double dExposureDuration) {
            this.dExposureDuration = dExposureDuration;
        }

        public void setExposureTime(double dExposureTime) {
            this.dExposureTime = dExposureTime;
        }

        public void setAveragingTimeUnit(String sAveragingTimeUnit) {
            this.sAveragingTimeUnit = sAveragingTimeUnit;
        }

        public void setExposureFrequencyUnit(String sExposureFrequencyUnit) {
            this.sExposureFrequencyUnit = sExposureFrequencyUnit;
        }

        public void setExposureDurationUnit(String sExposureDurationUnit) {
            this.sExposureDurationUnit = sExposureDurationUnit;
        }

        public void setExposureTimeUnit(String sExposureTimeUnit) {
            this.sExposureTimeUnit = sExposureTimeUnit;
        }

        public void setRiskType(String sRiskType) {
            this.sRiskType = sRiskType;
        }

        public void setBuildingType(String sBuildingTYpe) {
            this.sBuildingType = this.sBuildingType;
        }

        public double getAveragingTime() {
            return this.dAveragingTime;
        }

        public double getExposureFrequency() {
            return this.dExposureFrequency;
        }

        public double getExposureDuration() {
            return this.dExposureDuration;
        }

        public double getExposureTime() {
            return this.dExposureTime;
        }

        public String getAveragingTimeUnit() {
            return this.sAveragingTimeUnit;
        }

        public String getExposureFrequencyUnit() {
            return this.sExposureFrequencyUnit;
        }

        public String getExposureDurationUnit() {
            return this.sExposureDurationUnit;
        }

        public String getExposureTimeUnit() {
            return this.sExposureTimeUnit;
        }

        public String getRiskType() {
            return this.sRiskType;
        }

        public String getBuildingType() {
            return this.sBuildingType;
        }

        public String getName() {
            return this.sName;
        }
    }
}

