/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import pviScreen.dataContainers.CoreDataContainer;
import pviScreen.dataContainers.VIDataAbstractClass;
import util.FileLogger;
import util.OutputDigits;
import util.UnitConverter;

public class FieldData
extends VIDataAbstractClass {
    private UnitConverter uc;
    private FileLogger fl;
    private ArrayList<CoreDataContainer> alCore;
    private double dDepthToBottom;

    public void readFile(String sFieldDataFileName) throws IOException {
        String currentLine;
        String sConvertedOutput = "";
        String sErrorOutput = "";
        FileReader fr = new FileReader(sFieldDataFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        this.alCore = new ArrayList();
        while ((currentLine = br.readLine()) != null) {
            lineArray = currentLine.split(",", 0);
            String key = lineArray[0];
            if (!key.equalsIgnoreCase("Oil Lens") && !key.equalsIgnoreCase("OilLens")) continue;
            String key2 = lineArray[1];
            sConvertedOutput = "";
            sErrorOutput = "";
            if (!key2.equalsIgnoreCase("Begin Core")) {
                key2.equalsIgnoreCase("BeginCore");
            }
            if (!key2.equalsIgnoreCase("Heading")) {
                if (key2.equalsIgnoreCase("CoreData") || key2.equalsIgnoreCase("core data")) {
                    CoreDataContainer cdc = new CoreDataContainer();
                    cdc.setName(lineArray[2]);
                    double dDepth = Double.parseDouble(lineArray[3]) * this.uc.getUCF("Length", lineArray[4]);
                    cdc.setDepth(dDepth);
                    double dConcentration = Double.parseDouble(lineArray[5]) * this.uc.getUCF("MassFraction", lineArray[6]);
                    cdc.setConcentration(dConcentration);
                    OutputDigits od = new OutputDigits();
                    od.setValue(dDepth);
                    sConvertedOutput = ", converted to: ," + od.num2String() + " " + this.uc.getModelUnit("Length");
                    od.setValue(dConcentration);
                    sConvertedOutput = String.valueOf(sConvertedOutput) + ", " + od.num2String() + " " + this.uc.getModelUnit("MassFraction");
                    this.alCore.add(cdc);
                } else if (!key2.equalsIgnoreCase("EndCore")) {
                    key2.equalsIgnoreCase("End Core");
                }
            }
            String sOut = this.arrayToString(lineArray);
            this.fl.logMessage(String.valueOf(sOut) + sConvertedOutput + sErrorOutput);
        }
        fr.close();
    }

    private String arrayToString(String[] lineArray) {
        String sOut = "";
        int i = 0;
        while (i < lineArray.length) {
            sOut = String.valueOf(sOut) + lineArray[i] + ", ";
            ++i;
        }
        return sOut;
    }

    public void setElevations(double dDepthToBottom) {
        this.dDepthToBottom = dDepthToBottom;
        for (CoreDataContainer cdc : this.alCore) {
            cdc.setElevation(dDepthToBottom - cdc.getDepth());
        }
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setFileLogger(FileLogger fl) {
        this.fl = fl;
    }

    public ArrayList<CoreDataContainer> getCoreData() {
        return this.alCore;
    }
}

