/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import java.util.ArrayList;
import numerics.bisection.Bisectable;
import numerics.bisection.Bisection;
import pviScreen.dataContainers.FieldData;
import pviScreen.dataContainers.ProfilePoint;
import pviScreen.dataContainers.VIDataAbstractClass;
import pviScreen.dataContainers.VadoseZone;
import util.FileLogger;

public class OilLens
extends VIDataAbstractClass
implements Bisectable {
    private double dFuelVolume;
    private double dGasolineDensity;
    private double dOilMolecularWeight;
    private double dResidualOilSaturation;
    private double dOilWaterInterfacialTension;
    private double dLensWidth;
    private double dLensLength;
    private double dXLensCenter;
    private double dYLensCenter;
    private double dSurfaceTension;
    protected double dLensArea;
    protected double dMaxOilSaturation;
    protected double dOilZoneThickness;
    protected double dFuelVolumePerUnitArea;
    protected double dElevTopOilZone;
    protected double dElevBottomMobileOilZone;
    protected double dElevWaterTable;
    protected double dElevHistoricWaterTable;
    protected double dElevSurface;
    protected boolean bLensUsed = false;
    protected VadoseZone vz;
    protected FieldData fd;
    private double dZ1;
    private double dZWT;
    ArrayList<ProfilePoint> alProfilePoint;

    public OilLens() {
        super.setName("oilLens");
        super.createNewDistribution("oilLens", "FuelVolume");
        super.createNewDistribution("oilLens", "MaxOilSaturation");
        super.createNewDistribution("oilLens", "ResidualOilSaturation");
        super.createNewDistribution("oilLens", "LensWidth");
        super.createNewDistribution("oilLens", "LensLength");
        super.createNewDistribution("oilLens", "OilWaterInterfacialTension");
        super.createNewDistribution("oilLens", "OilMolecularWeight");
        super.createNewDistribution("oilLens", "OilDensity");
        this.bLensUsed = false;
    }

    public void setElevations() {
        this.dElevWaterTable = this.vz.getDepthToBottom() - this.vz.getDepthToWaterTable();
        this.dElevHistoricWaterTable = this.vz.getDepthToBottom() - this.vz.getDepthToHistoricWaterTable();
        this.dElevSurface = this.vz.getDepthToBottom();
    }

    public void findTopOfOilZone() {
        double result;
        Bisection bisection = new Bisection();
        this.setElevations();
        this.dLensArea = this.getLensWidth() * this.getLensLength();
        double dHce = this.vz.getAirEntryHead();
        dHce = dHce * this.getOilWaterInterfacialTension() / this.vz.getWaterSurfaceTension();
        double dZ1 = this.dElevHistoricWaterTable;
        double dZ2 = this.dElevSurface;
        double test1 = this.getFunctionValue(this.dElevWaterTable);
        bisection.setMaximumIterations(1000);
        bisection.setTolerance(1.0E-4);
        bisection.setValueToMatch(0.0);
        bisection.setLimits(dZ1, dZ2);
        bisection.bisect(this);
        this.dElevTopOilZone = result = bisection.getResult();
        this.dOilZoneThickness = this.dElevTopOilZone - this.dElevWaterTable;
        this.dElevBottomMobileOilZone = this.dElevTopOilZone - this.dOilZoneThickness;
        double dVol = this.getFuelVolume();
        double dArea = this.dLensArea;
        this.dFuelVolumePerUnitArea = this.getFuelVolume() / this.dLensArea;
        this.dMaxOilSaturation = this.getOilSaturation(this.dElevTopOilZone);
    }

    @Override
    public double getFunctionValue(double dElevation) {
        double dPor = this.vz.getPorosity();
        double dSor = this.getResidualOilSaturation();
        double dHce = this.vz.getAirEntryHead();
        double dSwr = this.vz.getResidualWaterSaturation();
        double dSar = this.vz.getTrappedAirSaturation();
        double dLambda = this.vz.getLambda();
        dHce = dHce * this.getOilWaterInterfacialTension() / this.vz.getWaterSurfaceTension();
        double dReleasedOil = this.getFuelVolume();
        double dFormationOil = 0.0;
        if (!(dElevation < this.dElevHistoricWaterTable)) {
            if (this.dElevHistoricWaterTable <= dElevation && dElevation <= this.dElevWaterTable) {
                dFormationOil = dPor * dSor * this.dLensArea * (dElevation - this.dElevHistoricWaterTable);
            } else if (this.dElevWaterTable <= dElevation && dElevation <= this.dElevWaterTable + dHce) {
                dFormationOil = dPor * dSor * this.dLensArea * (this.dElevWaterTable - this.dElevHistoricWaterTable + (this.dElevWaterTable + dHce - this.dElevWaterTable));
            } else if (this.dElevWaterTable + dHce <= dElevation && dElevation <= this.dElevSurface) {
                dFormationOil = dSor * (dElevation - this.dElevHistoricWaterTable) + (1.0 - dSar - dSwr - dSor) * (dElevation - this.dElevWaterTable - dHce) - (1.0 - dSar - dSwr - dSor) * (Math.pow(dHce, dLambda) / (1.0 - dLambda)) * (Math.pow(dElevation - this.dElevWaterTable, 1.0 - dLambda) - Math.pow(dHce, 1.0 - dLambda));
                dFormationOil = dFormationOil * dPor * this.dLensArea;
            }
        }
        return dReleasedOil - dFormationOil;
    }

    public void generateOilProfile() {
        this.alProfilePoint = new ArrayList();
        ProfilePoint pp = new ProfilePoint();
        double dElev = this.dElevHistoricWaterTable;
        double dSo = this.getOilSaturation(dElev);
        double dSw = this.getWaterSaturation(dElev);
        double dSa = this.getAirSaturation(dElev);
        pp.setPoint(dElev, dSo, dSw, dSa);
        this.alProfilePoint.add(pp);
        dElev = this.dElevWaterTable;
        pp = new ProfilePoint();
        dSo = this.getOilSaturation(dElev);
        dSw = this.getWaterSaturation(dElev);
        dSa = this.getAirSaturation(dElev);
        pp.setPoint(dElev, dSo, dSw, dSa);
        this.alProfilePoint.add(pp);
        double dHce = this.vz.getAirEntryHead();
        dHce = dHce * this.getOilWaterInterfacialTension() / this.vz.getWaterSurfaceTension();
        dElev = this.dElevWaterTable + dHce;
        dSo = this.getOilSaturation(dElev);
        dSw = this.getWaterSaturation(dElev);
        dSa = this.getAirSaturation(dElev);
        pp.setPoint(dElev, dSo, dSw, dSa);
        this.alProfilePoint.add(pp);
        double dZ = (this.dElevTopOilZone - dElev) / 20.0;
        double z = dElev;
        while (z < this.dElevTopOilZone) {
            pp = new ProfilePoint();
            dSo = this.getOilSaturation(z);
            dSw = this.getWaterSaturation(z);
            dSa = this.getAirSaturation(z);
            pp.setPoint(z, dSo, dSw, dSa);
            this.alProfilePoint.add(pp);
            z += dZ;
        }
        z = this.dElevTopOilZone;
        dZ = (this.dElevSurface - dElev) / 20.0;
        while (z < this.dElevSurface) {
            pp = new ProfilePoint();
            dSo = this.getOilSaturation(z);
            dSw = this.getWaterSaturation(z);
            dSa = this.getAirSaturation(z);
            pp.setPoint(z, dSo, dSw, dSa);
            this.alProfilePoint.add(pp);
            z += dZ;
        }
    }

    public void writeProfile(FileLogger fl) {
        String sOut = "";
        sOut = "elevation, oil saturation, water saturation, air saturation";
        for (ProfilePoint pp : this.alProfilePoint) {
            sOut = "";
            sOut = String.valueOf(pp.getElevation()) + "," + pp.getOilSaturation() + "," + pp.getWaterSaturation() + "," + pp.getAirSaturation();
            fl.logMessage(sOut);
        }
    }

    public double getOilSaturation(double dElevation) {
        double dSor = this.getResidualOilSaturation();
        double dHce = this.vz.getAirEntryHead();
        double dSwr = this.vz.getResidualWaterSaturation();
        double dSar = this.vz.getTrappedAirSaturation();
        double dLambda = this.vz.getLambda();
        dHce = dHce * this.getOilWaterInterfacialTension() / this.vz.getWaterSurfaceTension();
        double dSo = 0.0;
        if (!(dElevation < this.dElevHistoricWaterTable)) {
            if (this.dElevHistoricWaterTable <= dElevation && dElevation <= this.dElevWaterTable) {
                dSo = dSor;
            } else if (this.dElevWaterTable <= dElevation && dElevation <= this.dElevWaterTable + dHce) {
                dSo = dSor;
            } else if (this.dElevWaterTable + dHce <= dElevation && dElevation <= this.dElevTopOilZone) {
                double dSw = dSwr + (1.0 - dSar - dSwr - dSor) * Math.pow(dHce / (dElevation - this.dElevWaterTable), dLambda);
                dSo = 1.0 - dSar - dSw;
            } else if (this.dElevTopOilZone < dElevation) {
                dSo = 0.0;
            }
        }
        return dSo;
    }

    public double getWaterSaturation(double dElevation) {
        double dSor = this.getResidualOilSaturation();
        double dHce = this.vz.getAirEntryHead();
        double dSwr = this.vz.getResidualWaterSaturation();
        double dSar = this.vz.getTrappedAirSaturation();
        double dLambda = this.vz.getLambda();
        dHce = dHce * this.getOilWaterInterfacialTension() / this.vz.getWaterSurfaceTension();
        double dSw = 0.0;
        if (dElevation < this.dElevHistoricWaterTable) {
            dSw = 1.0;
        } else if (this.dElevHistoricWaterTable <= dElevation && dElevation <= this.dElevWaterTable) {
            dSw = 1.0 - dSor;
        } else if (this.dElevWaterTable <= dElevation && dElevation <= this.dElevWaterTable + dHce) {
            dSw = 1.0 - dSor;
        } else if (this.dElevWaterTable + dHce <= dElevation && dElevation <= this.dElevTopOilZone) {
            dSw = dSwr + (1.0 - dSar - dSwr - dSor) * Math.pow(dHce / (dElevation - this.dElevWaterTable), dLambda);
        } else if (this.dElevTopOilZone < dElevation) {
            dSw = dSwr + (1.0 - dSar - dSwr) * Math.pow(dHce / (dElevation - this.dElevWaterTable), dLambda);
        }
        return dSw;
    }

    public double getAirSaturation(double dElevation) {
        double dHce = this.vz.getAirEntryHead();
        double dSar = this.vz.getTrappedAirSaturation();
        double dSwr = this.vz.getResidualWaterSaturation();
        double dLambda = this.vz.getLambda();
        dHce = dHce * this.getOilWaterInterfacialTension() / this.vz.getWaterSurfaceTension();
        double dSa = 0.0;
        if (dElevation <= this.dElevWaterTable + dHce) {
            dSa = 0.0;
        } else if (this.dElevWaterTable + dHce < dElevation && dElevation <= this.dElevTopOilZone) {
            dSa = dSar;
        } else if (this.dElevTopOilZone < dElevation) {
            double dSw = dSwr + (1.0 - dSar - dSwr) * Math.pow(dHce / (dElevation - this.dElevWaterTable), dLambda);
            dSa = 1.0 - dSw;
        }
        return dSa;
    }

    public void setVadoseZone(VadoseZone vz) {
        this.vz = vz;
    }

    public void setFieldData(FieldData fd) {
        this.fd = fd;
    }

    public void setGasolineDensity(double dGasolineDensity) {
        this.dGasolineDensity = dGasolineDensity;
    }

    public void setFuelVolume(double dValue) {
        this.dFuelVolume = dValue;
        this.setConstantDistribution(dValue, "FuelVolume");
    }

    public void setMaxOilSaturation(double dValue) {
        this.dMaxOilSaturation = dValue;
        this.setConstantDistribution(dValue, "MaxOilSaturation");
    }

    public void setResidualOilSaturation(double dValue) {
        this.dResidualOilSaturation = dValue;
        this.setConstantDistribution(dValue, "ResidualOilSaturation");
    }

    public void setLensWidth(double dValue) {
        this.dLensWidth = dValue;
        this.setConstantDistribution(dValue, "LensWidth");
    }

    public void setLensLength(double dValue) {
        this.dLensLength = dValue;
        this.setConstantDistribution(dValue, "LensLength");
    }

    public void setOilWaterInterfacialTension(double dValue) {
        this.dOilWaterInterfacialTension = dValue;
        this.setConstantDistribution(dValue, "OilWaterInterfacialTension");
    }

    public void setOilMolecularWeight(double dValue) {
        this.dOilMolecularWeight = dValue;
        this.setConstantDistribution(dValue, "OilMolecularWeight");
    }

    public void setOilDensity(double dValue) {
        this.dGasolineDensity = dValue;
        this.setConstantDistribution(dValue, "OilDensity");
    }

    public void setIsLensUsed(boolean b) {
        this.bLensUsed = b;
    }

    public double getFuelVolume() {
        return this.getCurrentRandomValue("FuelVolume", this.getName());
    }

    public double getMaxOilSaturation() {
        return this.getCurrentRandomValue("MaxOilSaturation", this.getName());
    }

    public double getResidualOilSaturation() {
        return this.getCurrentRandomValue("ResidualOilSaturation", this.getName());
    }

    public double getLensWidth() {
        return this.getCurrentRandomValue("LensWidth", this.getName());
    }

    public double getLensLength() {
        return this.getCurrentRandomValue("LensLength", this.getName());
    }

    public double getOilWaterInterfacialTension() {
        return this.getCurrentRandomValue("OilWaterInterfacialTension", this.getName());
    }

    public double getOilMolecularWeight() {
        return this.getCurrentRandomValue("OilMolecularWeight", this.getName());
    }

    public double getOilDensity() {
        return this.getCurrentRandomValue("OilDensity", this.getName());
    }

    public double getLensArea() {
        return this.dLensArea;
    }

    public double getSurfaceTension() {
        return this.dSurfaceTension;
    }

    public double getOilZoneTopElevation() {
        return this.dElevTopOilZone;
    }

    public double getMobileOilZoneBottomElevation() {
        return this.dElevBottomMobileOilZone;
    }

    public double getSurfaceElevation() {
        return this.dElevSurface;
    }

    public double getOilZoneThickness() {
        if (this.bLensUsed) {
            return this.dOilZoneThickness;
        }
        return 0.0;
    }

    public double getOilVolumePerUnitArea() {
        return this.dFuelVolumePerUnitArea;
    }

    public ArrayList<ProfilePoint> getProfilePoints() {
        return this.alProfilePoint;
    }

    public boolean isLensUsed() {
        return this.bLensUsed;
    }
}

