/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import java.util.ArrayList;
import pviScreen.dataContainers.CoreDataContainer;
import pviScreen.dataContainers.OilLens;

public class OilLensField
extends OilLens {
    ArrayList<CoreDataContainer> alCore;
    private int iNumberDataPoints;
    private double[] dC;
    private double[] dZ;
    private double[] dD;
    private String[] sN;
    private double dZMin;
    private double dZMax;
    private double dCMin;
    private double dCMax;
    private double dSoMin;
    private double dSoMax;

    OilLensField() {
    }

    @Override
    public void findTopOfOilZone() {
        this.setElevations();
        this.dElevTopOilZone = this.dZMax;
        this.dOilZoneThickness = this.dElevTopOilZone - this.dElevWaterTable;
        this.dFuelVolumePerUnitArea = this.getFuelVolumePerUnitArea();
        this.dMaxOilSaturation = this.dSoMax;
    }

    @Override
    public void setElevations() {
        int i;
        this.dElevWaterTable = this.vz.getDepthToBottom() - this.vz.getDepthToWaterTable();
        this.dElevHistoricWaterTable = this.vz.getDepthToBottom() - this.vz.getDepthToHistoricWaterTable();
        this.dElevSurface = this.vz.getDepthToBottom();
        this.fd.setElevations(this.vz.getDepthToBottom());
        this.iNumberDataPoints = this.alCore.size();
        this.dC = new double[this.iNumberDataPoints];
        this.dZ = new double[this.iNumberDataPoints];
        this.dD = new double[this.iNumberDataPoints];
        this.sN = new String[this.iNumberDataPoints];
        int ii = 0;
        for (CoreDataContainer cdc : this.alCore) {
            this.dC[ii] = cdc.getConcentration();
            this.dZ[ii] = cdc.getElevation();
            this.dD[ii] = cdc.getDepth();
            this.sN[ii] = cdc.getName();
            ++ii;
        }
        this.dZMin = 1.0E20;
        this.dZMax = -1.0E20;
        this.dCMin = 1.0E20;
        this.dCMax = -1.0E20;
        boolean bChanged = true;
        while (bChanged) {
            bChanged = false;
            i = 0;
            while (i < this.iNumberDataPoints - 1) {
                if (this.dZ[i] > this.dZ[i + 1]) {
                    double dZTemp = this.dZ[i + 1];
                    double dDTemp = this.dD[i + 1];
                    double dCTemp = this.dC[i + 1];
                    String sNTemp = this.sN[i + 1];
                    this.dZ[i + 1] = this.dZ[i];
                    this.dD[i + 1] = this.dD[i];
                    this.dC[i + 1] = this.dC[i];
                    this.sN[i + 1] = this.sN[i];
                    this.dZ[i] = dZTemp;
                    this.dD[i] = dDTemp;
                    this.dC[i] = dCTemp;
                    this.sN[i] = sNTemp;
                    bChanged = true;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.iNumberDataPoints) {
            if (this.dZ[i] < this.dZMin) {
                this.dZMin = this.dZ[i];
            }
            if (this.dZ[i] > this.dZMax) {
                this.dZMax = this.dZ[i];
            }
            if (this.dC[i] < this.dCMin) {
                this.dCMin = this.dC[i];
            }
            if (this.dC[i] > this.dCMax) {
                this.dCMax = this.dC[i];
            }
            ++i;
        }
        this.dSoMin = this.dCMin * (1.0 / this.vz.getBulkDensity()) * (1.0 / this.getOilDensity()) * (1.0 / this.vz.getPorosity());
        this.dSoMax = this.dCMax * (1.0 / this.vz.getBulkDensity()) * (1.0 / this.getOilDensity()) * (1.0 / this.vz.getPorosity());
    }

    @Override
    public double getOilSaturation(double dElevation) {
        double dSo = 0.0;
        if (dElevation < this.dElevHistoricWaterTable) {
            dSo = 0.0;
        } else if (this.dElevHistoricWaterTable <= dElevation && dElevation <= this.dElevTopOilZone) {
            int i = 0;
            while (i < this.iNumberDataPoints - 1) {
                if (this.dZ[i] <= dElevation && dElevation <= this.dZ[i + 1]) {
                    double dSl = (this.dC[i + 1] - this.dC[i]) / (this.dZ[i + 1] - this.dZ[i]);
                    double dCc = this.dC[i] + (dElevation - this.dZ[i]) * dSl;
                    dSo = dCc * (1.0 / this.vz.getBulkDensity()) * (1.0 / this.getOilDensity()) * (1.0 / this.vz.getPorosity());
                }
                ++i;
            }
        } else if (this.dElevTopOilZone < dElevation) {
            dSo = 0.0;
        }
        return dSo;
    }

    public double getFuelVolumePerUnitArea() {
        double dFuelVolumePerUnitArea = 0.0;
        double dSum = 0.0;
        int i = 0;
        while (i < this.iNumberDataPoints - 1) {
            dSum += (this.dC[i + 1] - this.dC[i]) / (this.dZ[i + 1] - this.dZ[i]);
            ++i;
        }
        dSum = dSum * (1.0 / this.vz.getBulkDensity()) * (1.0 / this.getOilDensity()) * (1.0 / this.vz.getPorosity());
        dFuelVolumePerUnitArea = dSum * this.vz.getPorosity();
        return dFuelVolumePerUnitArea;
    }

    public void setFieldData() {
        this.fd = this.fd;
    }

    public void setCoreData(ArrayList<CoreDataContainer> alCore) {
        this.alCore = alCore;
    }
}

