/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import pviScreen.dataContainers.Chemical;

public class Oxygen
extends Chemical {
    private double cMin;
    private double cSurface;
    private double jSurface;

    public Oxygen() {
        this.sName = "oxygen";
        super.createNewDistribution("Oxygen", "DiffusionInAir");
        super.createNewDistribution("Oxygen", "DiffusionInWater");
        super.createNewDistribution("Oxygen", "MinimumBiodegradationConcentration");
        super.createNewDistribution("Oxygen", "SurfaceConcentration");
    }

    @Override
    public void correctHenrysConstantForTemperature() {
        double dRc = 1.9872;
        double dTempSoil = this.vz.getSoilTemperature() + 273.15;
        this.dHReferenceTemp = 298.15;
        this.dHReference = 32.1;
        this.dHCorrected = Math.exp(-1700.0 * (1.0 / dTempSoil - 1.0 / this.dHReferenceTemp)) * this.dHReference;
        this.setHenrysConstant(this.dHCorrected);
    }

    public void setMinBiodegradationConcentration(double dValue) {
        this.cMin = this.determineOxygenConcentrationFromPerCent(dValue);
        this.setConstantDistribution(dValue, "MinimumBiodegradationConcentration");
    }

    @Override
    public void setSurfaceConcentration(double dValue) {
        this.cSurface = this.determineOxygenConcentrationFromPerCent(dValue);
        this.setConstantDistribution(dValue, "SurfaceConcentration");
    }

    public double determineOxygenConcentrationFromPerCent(double dValue) {
        double dGasConstant = 8.3144;
        return this.dMW * (1.0 / dGasConstant) * (1.0 / (this.vz.getSoilTemperature() + 273.15)) * 101.325 * this.getSurfaceConcentration() / 100.0;
    }

    @Override
    public void setSurfaceFlux(double jSurface) {
        this.jSurface = jSurface;
    }

    @Override
    public void setHenrysConstant(double dValue) {
        this.kh = dValue;
    }

    @Override
    public void setDa(double dValue) {
        this.da = dValue;
        this.setConstantDistribution(dValue, "DiffusionInAir");
    }

    @Override
    public void setDw(double dValue) {
        this.dw = dValue;
        this.setConstantDistribution(dValue, "DiffusionInWater");
    }

    public double getNetSurfaceConcentration() {
        return this.getSurfaceConcentration() - this.getMinBiodegradationConcentration();
    }

    public double getMinBiodegradationConcentration() {
        return this.getCurrentRandomValue("MinimumBiodegradationConcentration", this.getName());
    }

    @Override
    public double getSurfaceConcentration() {
        return this.getCurrentRandomValue("SurfaceConcentration", this.getName());
    }

    @Override
    public double getDa() {
        return this.getCurrentRandomValue("DiffusionInAir", this.getName());
    }

    @Override
    public double getDw() {
        return this.getCurrentRandomValue("DiffusionInWater", this.getName());
    }

    @Override
    public double getSurfaceFlux() {
        return this.jSurface;
    }

    @Override
    public double getHenrysConstant() {
        return this.kh;
    }
}

