/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import java.util.ArrayList;
import pviScreen.dataContainers.AquiferData;
import pviScreen.dataContainers.RawInputLine;
import util.Stripper;

public class RawInput {
    private String sRawInputName;
    private ArrayList<RawInputLine> alRawInputLine;
    private AquiferData aq;

    public RawInput() {
        this.clearAllInput();
    }

    public void clearAllInput() {
        this.alRawInputLine = new ArrayList();
    }

    public void add(RawInputLine ril) {
        this.alRawInputLine.add(ril);
    }

    public void removeRawInputLine(String sGroup, String sParameter, String sParameter2) {
        ArrayList<RawInputLine> alRILtoRemove = new ArrayList<RawInputLine>();
        Stripper s = new Stripper();
        for (RawInputLine ril : this.alRawInputLine) {
            if (!s.areTheyEqual(sGroup, ril.getGroupName()) || !s.areTheyEqual(sParameter, ril.getParameterName()) || !s.areTheyEqual(sParameter2, ril.getParameterName2())) continue;
            alRILtoRemove.add(ril);
        }
        for (RawInputLine ril : alRILtoRemove) {
            this.alRawInputLine.remove(ril);
        }
    }

    public ArrayList<RawInputLine> getRawInputLines(String sName, String sType) {
        ArrayList<RawInputLine> rilReturn = new ArrayList<RawInputLine>();
        Stripper s = new Stripper();
        for (RawInputLine rilTest : this.alRawInputLine) {
            if (!s.areTheyEqual(rilTest.getGroupName(), sName, ' ') || !s.areTheyEqual(rilTest.getParameterName(), sType, ' ')) continue;
            rilReturn.add(rilTest);
        }
        return rilReturn;
    }

    public boolean checkForInputName(String sName) {
        boolean bFound = false;
        Stripper s = new Stripper();
        for (RawInputLine ril : this.alRawInputLine) {
            if (!s.areTheyEqual(sName, ril.getGroupName(), ' ')) continue;
            bFound = true;
            break;
        }
        return bFound;
    }

    public void generateModelParameters() {
        this.aq = new AquiferData();
    }

    public void setName(String sRawInputName) {
        this.sRawInputName = sRawInputName;
    }

    public String getName() {
        return this.sRawInputName;
    }

    public ArrayList<RawInputLine> getAllRawInputLines() {
        return this.alRawInputLine;
    }
}

