/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import java.util.ArrayList;
import pviScreen.dataChecking.InputCheckList;
import pviScreen.dataContainers.VIControlData;
import util.NameConstants;
import util.Stripper;
import util.UnitConverter;

public class RawInputLine {
    private String sRawInputType;
    private String[] sRawInputLine;
    private String sOutputDestination;
    private NameConstants nc;
    private String sGroupName;
    private String sParameterName;
    private String sParameterName2;
    private String sDistributionType;
    private String sValueString;
    private Double dValue;
    private String sUnit;
    private Double dFrequency;
    private String sComment;
    private String sChemicalName;
    private VIControlData viCD;
    private UnitConverter uc;
    private InputCheckList icl;
    ArrayList<Test> alTest = new ArrayList();
    ArrayList<String> alTestName = new ArrayList();

    public RawInputLine(VIControlData viCD) {
        this.viCD = viCD;
        this.init();
    }

    public RawInputLine(UnitConverter uc, VIControlData viCD) {
        this.uc = uc;
        this.viCD = viCD;
        this.init();
    }

    private void init() {
        this.sRawInputType = "";
        this.nc = new NameConstants();
        Stripper s = new Stripper();
        this.sGroupName = "";
        this.sParameterName = "";
        this.sParameterName2 = "";
        this.sDistributionType = "none";
        this.sValueString = "";
        this.dValue = 0.0;
        this.sUnit = "";
        this.dFrequency = 0.0;
        this.sComment = "";
        this.sChemicalName = "";
        this.sOutputDestination = this.nc.file_UserChosenFileForOutput;
    }

    public void setRawInputLine(String sRawInputType, String[] sRawInputLine) {
        this.sRawInputType = sRawInputType;
        this.sRawInputLine = sRawInputLine;
        this.splitInputLine();
        for (Test test : this.alTest) {
            this.alTestName.add(test.getName());
        }
    }

    private void splitInputLine() {
        Stripper s = new Stripper();
        int i = 0;
        while (i < this.sRawInputLine.length) {
            this.sRawInputLine[i] = s.removeCharacter(' ', this.sRawInputLine[i]);
            ++i;
        }
        this.icl = this.viCD.getInputCheckList();
        this.sGroupName = this.sRawInputLine[0];
        this.alTest.add(new Test("GroupName", this.sGroupName, this.icl.isAllowableGroupName(this.sGroupName)));
        if (s.areTheyEqual(this.sRawInputLine[0], "chemical") || s.areTheyEqual(this.sRawInputLine[0], "screeningLevel")) {
            int ijj = 0;
            ++ijj;
        } else {
            this.sParameterName = this.sRawInputLine[1];
            this.alTest.add(new Test("ParameterName", this.sParameterName, this.icl.isAllowableControlParameterName(this.sGroupName, this.sParameterName)));
        }
        if (s.areTheyEqual(this.nc.s_CONTROLSTRING, this.sRawInputType)) {
            if (s.areTheyTheSame(this.sParameterName, "Begin")) {
                this.alTest.add(new Test("Begin", "begin", true));
            } else if (s.areTheyTheSame("End", this.sParameterName)) {
                this.alTest.add(new Test("End", "end", true));
            } else {
                this.alTest.add(new Test("Begin/End Missing", "Begin or end missing", false));
            }
        } else if (s.areTheyEqual(this.nc.s_CONTROL2STRING, this.sRawInputType)) {
            this.sValueString = this.sRawInputLine[2];
            this.alTest.add(new Test("ValueString", this.sValueString, this.icl.isNotBlank(this.sValueString)));
        } else if (s.areTheyEqual(this.nc.s_CONTROL3STRING, this.sRawInputType)) {
            this.sValueString = this.sRawInputLine[3];
            this.alTest.add(new Test("ValueString3", this.sValueString, this.icl.isNotBlank(this.sValueString)));
        } else if (s.areTheyEqual(this.nc.s_CONTROLSTRINGVALUE, this.sRawInputType)) {
            try {
                this.dValue = Double.parseDouble(this.sRawInputLine[2]);
                this.alTest.add(new Test("DValue", this.sRawInputLine[2], this.icl.isZeroOrPositiveNumber(this.dValue)));
            }
            catch (Exception e) {
                this.alTest.add(new Test("DValue", this.sRawInputLine[2], false));
            }
        } else if (s.areTheyEqual(this.nc.s_CONTROL2STRINGVALUE, this.sRawInputType)) {
            this.sParameterName2 = this.sRawInputLine[2];
            this.alTest.add(new Test("ParameterName2", this.sParameterName2, this.icl.isNotBlank(this.sParameterName2)));
            try {
                this.dValue = Double.parseDouble(this.sRawInputLine[3]);
                this.alTest.add(new Test("DValue", this.sRawInputLine[3], this.icl.isZeroOrPositiveNumber(this.dValue)));
            }
            catch (Exception e) {
                this.alTest.add(new Test("DValue", this.sRawInputLine[3], false));
            }
        } else if (s.areTheyEqual(this.nc.s_CONTROLSTRINGCHOICE, this.sRawInputType)) {
            this.sValueString = this.sRawInputLine[2];
            this.alTest.add(new Test("ValueString", this.sValueString, this.icl.isNotBlank(this.sValueString)));
        } else if (s.areTheyEqual(this.nc.s_VALUEINPUT, this.sRawInputType)) {
            this.sDistributionType = this.sRawInputLine[2];
            this.alTest.add(new Test("DistributionType", this.sDistributionType, this.icl.isAllowableDistributionType(this.sRawInputLine[2])));
            this.sValueString = this.sRawInputLine[3];
            this.alTest.add(new Test("ValueString", this.sValueString, this.icl.isNotBlank(this.sRawInputLine[3])));
            try {
                this.dValue = Double.parseDouble(this.sRawInputLine[3]);
                this.alTest.add(new Test("DValue", this.sRawInputLine[3], this.icl.isZeroOrPositiveNumber(this.dValue)));
            }
            catch (Exception e) {
                this.alTest.add(new Test("DValue", this.sRawInputLine[3], false));
            }
            try {
                this.dFrequency = Double.parseDouble(this.sRawInputLine[5]);
                if (s.areTheyTheSame("Constant", this.sDistributionType)) {
                    this.alTest.add(new Test("FrequencyOne", this.sRawInputLine[5], this.icl.isSpecificValue(1.0, this.dFrequency)));
                } else if (s.areTheyTheSame("Variable", this.sDistributionType)) {
                    if (this.icl.isSpecificValue(0.0, this.dFrequency)) {
                        this.alTest.add(new Test("FrequencyZero", this.sRawInputLine[5], true));
                    } else if (this.icl.isSpecificValue(1.0, this.dFrequency)) {
                        this.alTest.add(new Test("FrequencyOne", this.sRawInputLine[5], true));
                    }
                }
            }
            catch (Exception e) {
                this.alTest.add(new Test("FrequencyZero", this.sRawInputLine[5], false));
                this.alTest.add(new Test("FrequencyOne", this.sRawInputLine[5], false));
            }
            this.sUnit = this.sRawInputLine[4];
            this.alTest.add(new Test("Unit", this.sRawInputLine[4], this.icl.isAllowableUnit(this.uc, this.sParameterName, this.sUnit)));
        } else if (s.areTheyEqual(this.nc.s_CHEMICALINPUT, this.sRawInputType) || s.areTheyEqual(this.nc.s_CONTROLSCREENINGLEVELINPUT, this.sRawInputType)) {
            this.sDistributionType = this.sRawInputLine[2];
            this.alTest.add(new Test("DistributionType", this.sDistributionType, this.icl.isAllowableDistributionType(this.sDistributionType)));
            this.sParameterName = this.sRawInputLine[3];
            if (s.areTheyEqual(this.sParameterName, "xylenes")) {
                int iji = 0;
                ++iji;
            }
            this.sChemicalName = this.sRawInputLine[3];
            this.alTest.add(new Test("ChemicalName", this.sChemicalName, this.icl.isAChemicalName(this.viCD, this.sChemicalName)));
            this.sParameterName2 = this.sRawInputLine[1];
            this.alTest.add(new Test("ParameterName2", this.sParameterName2, this.icl.isAllowableChemicalType(this.uc, this.sParameterName2)));
            try {
                this.sValueString = this.sRawInputLine[4];
                this.dValue = Double.parseDouble(this.sRawInputLine[4]);
                this.alTest.add(new Test("DValue", this.sRawInputLine[4], this.icl.isZeroOrPositiveNumber(this.dValue)));
            }
            catch (Exception e) {
                this.alTest.add(new Test("DValue", this.sValueString, false));
            }
            try {
                this.dFrequency = Double.parseDouble(this.sRawInputLine[6]);
                if (s.areTheyTheSame("Constant", this.sDistributionType)) {
                    this.alTest.add(new Test("FrequencyOne", this.sRawInputLine[6], this.icl.isSpecificValue(1.0, this.dFrequency)));
                } else if (s.areTheyTheSame("Variable", this.sDistributionType)) {
                    if (this.icl.isSpecificValue(0.0, this.dFrequency)) {
                        this.alTest.add(new Test("FrequencyZero", this.sRawInputLine[6], true));
                    } else if (this.icl.isSpecificValue(1.0, this.dFrequency)) {
                        this.alTest.add(new Test("FrequencyOne", this.sRawInputLine[6], true));
                    }
                }
            }
            catch (Exception e) {
                this.alTest.add(new Test("FrequencyZero", this.sRawInputLine[6], false));
                this.alTest.add(new Test("FrequencyOne", this.sRawInputLine[6], false));
            }
            this.sUnit = this.sRawInputLine[5];
            this.alTest.add(new Test("Unit", this.sUnit, this.icl.isAllowableUnit(this.uc, this.sParameterName2, this.sUnit)));
        } else if (s.areTheyEqual(this.nc.s_CONTROLRISKINPUT, this.sRawInputType)) {
            this.sParameterName = this.sRawInputLine[1];
            this.sParameterName2 = this.sRawInputLine[2];
            this.sChemicalName = this.sRawInputLine[2];
        }
    }

    public String getOutputLine(String sGroup) {
        Stripper s = new Stripper();
        String sOutput = "";
        if (s.areTheyEqual(this.sGroupName, sGroup)) {
            sOutput = this.getOutputLine();
        }
        return sOutput;
    }

    public String getOutputLine() {
        String sOutput = "";
        sOutput = this.sRawInputLine[0];
        int i = 1;
        while (i < this.sRawInputLine.length) {
            sOutput = String.valueOf(sOutput) + "," + this.sRawInputLine[i];
            ++i;
        }
        return sOutput;
    }

    public boolean getTestResult(String sItem) {
        Stripper s = new Stripper();
        for (Test test : this.alTest) {
            if (!s.areTheyTheSame(test.getName(), sItem)) continue;
            return test.getResult();
        }
        return false;
    }

    public boolean areAllTestsPassed() {
        boolean bReturn = false;
        for (Test test : this.alTest) {
            if (test.getResult()) continue;
            bReturn = true;
        }
        return bReturn;
    }

    public String getAllTestResults() {
        String sReturn = "";
        for (Test test : this.alTest) {
            sReturn = String.valueOf(sReturn) + ", " + test.getName() + ", " + test.getResult();
        }
        return sReturn;
    }

    public ArrayList<String> getAllFailedTestResults() {
        ArrayList<String> sReturn = new ArrayList<String>();
        for (Test test : this.alTest) {
            if (test.getResult()) continue;
            sReturn.add(String.valueOf(this.sParameterName) + ", " + test.getName() + ", " + test.getResult() + ", incorrect input value: " + test.getValue());
        }
        return sReturn;
    }

    public String getUnitType(String sInputName, UnitConverter uc) {
        return uc.getUnitType(sInputName);
    }

    public String getParameterNameForUnits() {
        String sReturn = "";
        Stripper s = new Stripper();
        sReturn = this.sParameterName;
        if (s.areTheyEqual(this.nc.s_CHEMICALINPUT, this.sRawInputType)) {
            sReturn = this.sParameterName2;
        }
        return sReturn;
    }

    public void addNewTestAndResult(String sTestName, String sValue, boolean bResult) {
        this.alTest.add(new Test(sTestName, sValue, bResult));
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setOutputDestination(String sOutput) {
        this.sOutputDestination = sOutput;
    }

    public void setInputCheckList(InputCheckList icl) {
        this.icl = icl;
    }

    public String getGroupName() {
        return this.sRawInputLine[0];
    }

    public String getParameterName() {
        return this.sParameterName;
    }

    public String getParameterName2() {
        return this.sParameterName2;
    }

    public String getDistributionType() {
        return this.sDistributionType;
    }

    public String getValueString() {
        return this.sValueString;
    }

    public double getValue() {
        return this.dValue;
    }

    public String getUnit() {
        return this.sUnit;
    }

    public double getFrequency() {
        return this.dFrequency;
    }

    public String getComment() {
        return this.sComment;
    }

    public String getChemicalName() {
        return this.sChemicalName;
    }

    public String getOutputDestination() {
        return this.sOutputDestination;
    }

    public String getRawInputType() {
        return this.sRawInputType;
    }

    public String[] getRawInputLineAsString() {
        return this.sRawInputLine;
    }

    public String getRawInputLineAsCommaDelimitedString() {
        String sOut = "";
        int i = 0;
        while (i < this.sRawInputLine.length) {
            sOut = String.valueOf(sOut) + "," + this.sRawInputLine[i];
            ++i;
        }
        return sOut;
    }

    public ArrayList<String> getAllTestNames() {
        return this.alTestName;
    }

    class Test {
        String sName;
        String sValue;
        boolean bResult;

        Test() {
        }

        Test(String sName, String sValue, boolean bResult) {
            this.sName = sName;
            this.sValue = sValue;
            this.bResult = bResult;
        }

        public void setName(String sName) {
            this.sName = sName;
        }

        public void setRestul(boolean bResult) {
            this.bResult = bResult;
        }

        public String getName() {
            return this.sName;
        }

        public String getValue() {
            return this.sValue;
        }

        public boolean getResult() {
            return this.bResult;
        }
    }
}

