/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import java.util.ArrayList;
import pviScreen.dataChecking.CheckTheInputData;
import pviScreen.dataChecking.InputCheckList;
import pviScreen.dataContainers.AquiferData;
import pviScreen.dataContainers.Building;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.ExposureFactorData;
import pviScreen.dataContainers.FieldData;
import pviScreen.dataContainers.InputFileNames;
import pviScreen.dataContainers.LinkedParameters;
import pviScreen.dataContainers.OilLens;
import pviScreen.dataContainers.Oxygen;
import pviScreen.dataContainers.ParameterChoices;
import pviScreen.dataContainers.RawInput;
import pviScreen.dataContainers.RunIdentifier;
import pviScreen.dataContainers.VadoseZone;
import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.Stripper;
import util.UnitConverter;
import util.UnitDefinition;

public class VIControlData {
    private boolean bRun;
    private FileLogger flOutputFile;
    private RunIdentifier runID;
    private String sOutputFileName;
    private String sOutputFileTime = "--output time not set--";
    private VadoseZone vz;
    private Building bld;
    private Oxygen oxygen;
    private AquiferData ad;
    private OilLens old;
    private FieldData fd;
    private ParameterChoices pd;
    private ArrayList<Chemical> alChemical;
    private ArrayList<StatisticalDistribution> sDistribution;
    private boolean bMonteCarlo;
    private int iNumberOfRuns;
    private int iNumberOfFrequencyIntervals;
    private String sOilDistributionType;
    private String sOilDistributionFileName;
    private double dMaxAlpha;
    private double dBisectionLowerLimit;
    private double dBisectionTolerance;
    private int iBisectionMaxIterations;
    private ArrayList<UnitDefinition> alUnitDefinition;
    private UnitConverter uc;
    private RawInput ri;
    private LinkedParameters lp;
    private String sBrowserName;
    private double dGroundWaterAdjustmentFactor;
    private double dSoilSampleAdjustmentFactor;
    private ArrayList<String> alErrorOutput;
    private ArrayList<String> alMessageOutput;
    private boolean bScreeningExists = false;
    private double dTargetCancerRiskLevel;
    private double dTargetHazardQuotient;
    private boolean bUIInputEditable;
    private boolean bUnsupportedUnit;
    private ExposureFactorData efd;
    private InputCheckList icl;
    private InputFileNames ifn;
    private String sSystemDataFile;
    ArrayList<Double> alRiskConcentration = new ArrayList();
    ArrayList<Double> alHazardConcentration = new ArrayList();

    public VIControlData() {
        this.refresh();
    }

    public void refresh() {
        this.bRun = false;
        this.bMonteCarlo = false;
        this.dBisectionLowerLimit = 1.0E-4;
        this.iBisectionMaxIterations = 100;
        this.dBisectionTolerance = 1.0E-6;
        this.iNumberOfFrequencyIntervals = 40;
        this.sOilDistributionType = "none";
        this.sOilDistributionFileName = "";
        this.sBrowserName = "";
        this.alErrorOutput = new ArrayList();
        this.alMessageOutput = new ArrayList();
        this.bScreeningExists = false;
        this.bUIInputEditable = true;
        this.dTargetCancerRiskLevel = 1.0E-6;
        this.dTargetHazardQuotient = 1.0;
        this.sOutputFileName = "";
        this.icl = new InputCheckList("Standard");
        this.ifn = new InputFileNames();
        this.sSystemDataFile = "src/systemData/00SystemDataFiles.csv";
    }

    public void checkData() {
        if (!(this.bld.getFoundationDepthBelowGrade() <= this.vz.getDepthToSample()) || !(this.vz.getDepthToSample() <= this.vz.getDepthToWaterTable())) {
            this.addToMessageOutput(this.getMessageOutput(), "Contaminant source NOT between bottom of foundation and water table");
        }
        boolean bAllChemicalAreZero = true;
        for (Chemical c : this.alChemical) {
            double dValue = 0.0;
            if (!c.getIsUsedInSimulation() || !((dValue = c.getCurrentRandomValue(c.getInputName(), c.getName())) > 0.0)) continue;
            bAllChemicalAreZero = false;
        }
        if (bAllChemicalAreZero) {
            this.addToMessageOutput(this.getErrorOutput(), "All chemical concentrations are equal to zero");
        }
    }

    public void setCanRunModel() {
        this.bRun = true;
        CheckTheInputData ctid = new CheckTheInputData("Standard");
        ctid.setVIControlData(this);
        ctid.setFileLogger(this.flOutputFile);
        ctid.check();
        for (String string : this.alErrorOutput) {
            if (string.equals("")) continue;
            this.bRun = false;
        }
    }

    public void clearRiskLevels() {
    }

    public void addToMessageOutput(ArrayList<String> alMessageOutput, String sMessage) {
        Stripper s = new Stripper();
        boolean bAdd = false;
        int i = 0;
        while (i < sMessage.length()) {
            if (sMessage.charAt(i) != ' ') {
                bAdd = true;
            }
            ++i;
        }
        if (sMessage.equalsIgnoreCase("\n")) {
            bAdd = false;
        }
        if (bAdd) {
            boolean bCheck = true;
            for (String sExistingError : alMessageOutput) {
                if (!s.areTheyEqual(sExistingError, sMessage)) continue;
                bCheck = false;
            }
            if (bCheck) {
                alMessageOutput.add(sMessage);
            }
        }
    }

    public void setOutputFileName(String sOutputFileName) {
        this.sOutputFileName = sOutputFileName;
    }

    public void setOutputFileTimeStamp(String sOutputFileTime) {
        this.sOutputFileTime = sOutputFileTime;
    }

    public void setOutputFileLogger(FileLogger fl) {
        this.flOutputFile = fl;
    }

    public void setVadoseZone(VadoseZone vz) {
        this.vz = vz;
    }

    public void setBuilding(Building bld) {
        this.bld = bld;
    }

    public void setOxygen(Oxygen oxygen) {
        this.oxygen = oxygen;
    }

    public void setAquiferData(AquiferData aquiferData) {
        this.ad = aquiferData;
    }

    public void setOilLensData(OilLens old) {
        this.old = old;
    }

    public void setFieldData(FieldData fd) {
        this.fd = fd;
    }

    public void setChemicals(ArrayList<Chemical> alChemical) {
        this.alChemical = alChemical;
    }

    public void setStatisticalDistribution(ArrayList<StatisticalDistribution> sDistribution) {
        this.sDistribution = sDistribution;
    }

    public void setIsMonteCarlo(boolean bMonteCarlo) {
        this.bMonteCarlo = bMonteCarlo;
    }

    public void setNumberOfRuns(int iNumberOfRuns) {
        this.iNumberOfRuns = iNumberOfRuns;
    }

    public void setNumberOfFrequencyDistributionIntervals(int i) {
        this.iNumberOfFrequencyIntervals = i;
    }

    public void setOilDistributionType(String sType) {
        this.sOilDistributionType = sType;
    }

    public void setOilDistributionFileName(String sName) {
        this.sOilDistributionFileName = sName;
    }

    public void setMaxAlpha(double dMaxAlpha) {
        this.dMaxAlpha = dMaxAlpha;
    }

    public void setBisectionLowerLimit(double dBisectionLowerLimit) {
        this.dBisectionLowerLimit = dBisectionLowerLimit;
    }

    public void setBisectionTolerance(double dBisectionTolerance) {
        this.dBisectionTolerance = dBisectionTolerance;
    }

    public void setBisectionMaxIterations(int iBisectionMaxIterations) {
        this.iBisectionMaxIterations = iBisectionMaxIterations;
    }

    public void setOutputUnitDefinition(ArrayList<UnitDefinition> alUnitDefinition) {
        this.alUnitDefinition = alUnitDefinition;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setRawInput(RawInput ri) {
        this.ri = ri;
    }

    public void setRunIdentifier(RunIdentifier runID) {
        this.runID = runID;
    }

    public void setLinkedParameters(LinkedParameters lp) {
        this.lp = lp;
    }

    public void setBrowserName(String s) {
        this.sBrowserName = s;
    }

    public void setParameterChoices(ParameterChoices pd) {
        this.pd = pd;
    }

    public void setGroundWaterConcentrationAdjustmentFactor(double dG) {
        this.dGroundWaterAdjustmentFactor = dG;
    }

    public void setSoilSampleConcentrationAdjustmentFactor(double dSS) {
        this.dSoilSampleAdjustmentFactor = dSS;
    }

    public void setDoesScreeningExist(boolean bScreeningExists) {
        this.bScreeningExists = bScreeningExists;
    }

    public void setTargetCancerRiskLevel(double d) {
        this.dTargetCancerRiskLevel = d;
    }

    public void setTargetHazardQuotient(double d) {
        this.dTargetHazardQuotient = d;
    }

    public void setUIInputEditable(boolean b) {
        this.bUIInputEditable = b;
    }

    public void setUnsupportedUnit(boolean b) {
        this.bUnsupportedUnit = b;
    }

    public void setExposureFactorData(ExposureFactorData efd) {
        this.efd = efd;
    }

    public void setInputFileNames(InputFileNames ifn) {
        this.ifn = ifn;
    }

    public String getOutputFileName() {
        return this.sOutputFileName;
    }

    public String getOutputFileTimeStamp() {
        return this.sOutputFileTime;
    }

    public boolean getCanRunModel() {
        return this.bRun;
    }

    public ArrayList<String> getKnownErrors() {
        return this.alErrorOutput;
    }

    public ArrayList<String> getMessageOutput() {
        return this.alMessageOutput;
    }

    public FileLogger getOutputFileLogger() {
        return this.flOutputFile;
    }

    public VadoseZone getVadoseZone() {
        return this.vz;
    }

    public Building getBuilding() {
        return this.bld;
    }

    public Oxygen getOxygen() {
        return this.oxygen;
    }

    public AquiferData getAquiferData() {
        return this.ad;
    }

    public OilLens getOilLens() {
        return this.old;
    }

    public FieldData getFieldData() {
        return this.fd;
    }

    public ArrayList<Chemical> getChemicals() {
        return this.alChemical;
    }

    public ArrayList<StatisticalDistribution> getStatisticalDistribution() {
        return this.sDistribution;
    }

    public boolean getIsMonteCarlo() {
        return this.bMonteCarlo;
    }

    public int getNumberOfRuns() {
        return this.iNumberOfRuns;
    }

    public int getNumberOfFrequencyDistributionIntervals() {
        return this.iNumberOfFrequencyIntervals;
    }

    public String getOilDistributionType() {
        return this.sOilDistributionType;
    }

    public String getOilDistributionFileName() {
        return this.sOilDistributionFileName;
    }

    public double getMaxAlpha() {
        return this.dMaxAlpha;
    }

    public double getBisectionLowerLimit() {
        return this.dBisectionLowerLimit;
    }

    public double getBisectionTolerance() {
        return this.dBisectionTolerance;
    }

    public int getBisectionMaxIterations() {
        return this.iBisectionMaxIterations;
    }

    public ArrayList<UnitDefinition> getOutputUnitDefinition() {
        return this.alUnitDefinition;
    }

    public UnitConverter getUnitConverter() {
        return this.uc;
    }

    public RawInput getRawInput() {
        return this.ri;
    }

    public ArrayList<Double> getRiskLevels() {
        return this.alRiskConcentration;
    }

    public ArrayList<Double> getHazardQuotients() {
        return this.alHazardConcentration;
    }

    public RunIdentifier getRunIdentifier() {
        return this.runID;
    }

    public LinkedParameters getLinkedParameters() {
        return this.lp;
    }

    public String getBrowserName() {
        return this.sBrowserName;
    }

    public ParameterChoices getParameterChoices() {
        return this.pd;
    }

    public double getGroundWaterConcentrationAdjustmentFactor() {
        return this.dGroundWaterAdjustmentFactor;
    }

    public double getSoilSampleConcentrationAdjustmentFactor() {
        return this.dSoilSampleAdjustmentFactor;
    }

    public InputCheckList getInputCheckList() {
        return this.icl;
    }

    public ArrayList<String> getErrorOutput() {
        return this.alErrorOutput;
    }

    public boolean getDoesScreeningExist() {
        return this.bScreeningExists;
    }

    public boolean getUIInputEditable() {
        return this.bUIInputEditable;
    }

    public boolean getUnsupportedUnit() {
        return this.bUnsupportedUnit;
    }

    public double getTargetCancerRiskLevel() {
        return this.dTargetCancerRiskLevel;
    }

    public double getTargetHazardQuotient() {
        return this.dTargetHazardQuotient;
    }

    public ExposureFactorData getExposureFactorData() {
        return this.efd;
    }

    public InputFileNames getInputFileNames() {
        return this.ifn;
    }

    public String getSystemDataFileName() {
        return this.sSystemDataFile;
    }
}

