/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataContainers;

import java.util.ArrayList;
import pviScreen.dataContainers.LinkedParameters;
import uncertaintyAnalysis.RandomNumber;
import uncertaintyAnalysis.StatisticalDistribution;
import util.Stripper;

public abstract class VIDataAbstractClass {
    protected String sName;
    protected boolean bUsedInSimulation = false;
    protected String sCalculationUnit;
    protected ArrayList<StatisticalDistribution> alSDPVIScreen = new ArrayList();
    protected ArrayList<String[]> alExternalSource = new ArrayList();
    protected ArrayList<LinkedParameters> alLinkedParameters = new ArrayList();
    protected RandomNumber random = new RandomNumber(1451);

    public void createNewDistribution(String sParentName, String sSDName) {
        if (!this.doesStatisticalDistributionExist(sParentName, sSDName)) {
            StatisticalDistribution sd = new StatisticalDistribution();
            sd.setDistributionType(sParentName);
            sd.setName(sSDName);
            sd.setParentName(this.sName);
            sd.setRandomNumberGenerator(this.random);
            this.alSDPVIScreen.add(sd);
        }
    }

    public void setStatisticalDistributionValue(String type, double value) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(type)) continue;
            sd.setIsThisDistributionActuallyUsed(true);
            sd.addAPoint(value, 0.0);
            sd.addAPoint(value, 1.0);
            sd.setValue(0.5);
        }
    }

    public void setConstantDistribution(double dValue, String sSDName) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(sSDName)) continue;
            sd.clear();
            sd.setIsThisDistributionActuallyUsed(true);
            sd.addAPoint(dValue, 0.0);
            sd.addAPoint(dValue, 1.0);
            sd.setValue(0.5);
            sd.setDistributionType("Constant");
            break;
        }
    }

    public void setCurrentRandomValue(String type, double frequency) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(type)) continue;
            sd.setValue(frequency);
        }
    }

    public void setCumulativeDistributionValue(String type, double value, double frequency) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(type)) continue;
            sd.addAPoint(value, frequency);
            sd.setIsThisDistributionActuallyUsed(true);
        }
    }

    public void setCalculationUnit(String type, String sCalculationUnit) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(type)) continue;
            sd.setCalculationUnit(sCalculationUnit);
        }
    }

    public StatisticalDistribution getStatisticalDistribution(String sName, String sParentName) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(sName) || !sd.getParentName().equalsIgnoreCase(sParentName)) continue;
            return sd;
        }
        return null;
    }

    public boolean doesStatisticalDistributionExist(String sParentName, String sName) {
        boolean bReturn = false;
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(sName) || !sd.getParentName().equalsIgnoreCase(sParentName)) continue;
            return true;
        }
        return bReturn;
    }

    public double getCurrentRandomValue(String sName, String sParentName) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(sName) || !sd.getParentName().equalsIgnoreCase(sParentName)) continue;
            return sd.getCurrentRandomValue();
        }
        return 0.0;
    }

    public String getCalculationUnit(String sName, String sParentName) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(sName) || !sd.getParentName().equalsIgnoreCase(sParentName)) continue;
            return sd.getCalculationUnit();
        }
        return "";
    }

    public double getFrequencyWeightedAverageValue(String sName, String sParentName) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(sName) || !sd.getParentName().equalsIgnoreCase(sParentName)) continue;
            return sd.getWeightedAverageValue();
        }
        return 0.0;
    }

    public double[] getConcentrationDistribution(String type) {
        double[] dReturn = null;
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(type)) continue;
            dReturn = sd.getConcentrationDistribution();
            break;
        }
        return dReturn;
    }

    public double[] getFrequencyDistribution(String type) {
        double[] dReturn = null;
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(type)) continue;
            dReturn = sd.getFrequencyDistribution();
            break;
        }
        return dReturn;
    }

    public int getDistributionNumberOfPoints(String type) {
        int iPts = 0;
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(type)) continue;
            iPts = sd.getNumberOfPointsDefiningDistribution();
            break;
        }
        return iPts;
    }

    public double getMiddleValue(String sParameterName, String sParentName) {
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!sd.getName().equalsIgnoreCase(sParameterName) || !sd.getParentName().equalsIgnoreCase(sParentName)) continue;
            return sd.getMiddleValue();
        }
        return 0.0;
    }

    public void addDataSource(String sParameter, String sSource, String sDistributionName) {
        String[] sTemp = new String[]{sParameter, sSource, sDistributionName};
        this.alExternalSource.add(sTemp);
    }

    public void setStatisticalDistributionUse(String sName, String sParentName, boolean isSDUsed) {
        Stripper s = new Stripper();
        for (StatisticalDistribution sd : this.alSDPVIScreen) {
            if (!s.areTheyEqual(sd.getName(), sName) || !s.areTheyEqual(sd.getParentName(), sParentName)) continue;
            sd.setIsThisDistributionActuallyUsed(isSDUsed);
        }
    }

    public void setName(String sName) {
        this.sName = sName;
    }

    public void setUsedInSimulation(boolean bUsedInSimulation) {
        this.bUsedInSimulation = bUsedInSimulation;
    }

    public String getName() {
        return this.sName;
    }

    public boolean getIsUsedInSimulation() {
        return this.bUsedInSimulation;
    }

    public ArrayList<StatisticalDistribution> getStatisticalDistribution() {
        return this.alSDPVIScreen;
    }

    class DataName {
        private String sName;
        private double dValue;

        public void setName(String sName) {
            this.sName = sName;
        }

        public void setValue(double dValue) {
            this.dValue = dValue;
        }

        public String getName() {
            return this.sName;
        }

        public double getValue() {
            return this.dValue;
        }
    }
}

