/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataReaders;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.VIDataAbstractClass;
import pviScreen.dataReaders.InterpretInputName;
import util.FileLogger;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class ChemicalDataReader {
    private FileLogger flChemicalInput;
    private FileLogger flOutput;
    private UnitConverter uc;
    private Chemical c;
    private ArrayList<Chemical> alChemical = new ArrayList();
    private String sErrorOutput = "";
    private InterpretInputName iin;

    public void readChemicalData(String sFileName) throws IOException {
        String currentLine;
        FileReader fr = new FileReader(sFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        Stripper s = new Stripper();
        while ((currentLine = br.readLine()) != null) {
            String sConvertedOutput;
            lineArray = currentLine.split(",", 0);
            String key = lineArray[0];
            if (!s.areTheyEqual("Chemical", key)) continue;
            String key2 = lineArray[1];
            key2.equalsIgnoreCase("Begin");
            if (key2.equalsIgnoreCase("Heading")) continue;
            if (s.areTheyEqual("New Chemical", key2)) {
                this.c = new Chemical();
                System.out.println("name lineArray[3] " + lineArray[3]);
                this.c.setName(lineArray[3]);
                this.c.setInterpretInputName(this.iin);
                this.c.createNewDistribution("Chemical", "MolecularWeight");
                this.c.createNewDistribution("Chemical", "Solubility");
                this.c.createNewDistribution("Chemical", "Density");
                this.c.createNewDistribution("Chemical", "Koc");
                this.c.createNewDistribution("Chemical", "UtilizationFactor");
                this.c.createNewDistribution("Chemical", "DiffusionCoefficientInAir");
                this.c.createNewDistribution("Chemical", "DiffusionCoefficientInWater");
                this.c.createNewDistribution("Chemical", "Degradation");
                this.c.createNewDistribution("Chemical", this.iin.getSoilGasSampleName());
                this.c.createNewDistribution("Chemical", "FuelPhaseConcentrationByVolume");
                this.c.createNewDistribution("Chemical", "FuelPhaseConcentrationByMass");
                this.c.createNewDistribution("Chemical", this.iin.getGroundWaterSampleName());
                this.c.createNewDistribution("Chemical", "SoilSample");
                this.c.setUsedInSimulation(false);
                sConvertedOutput = this.addChemicalData(this.c, lineArray);
                continue;
            }
            if (s.areTheyEqual("AddToNewChemical", key2)) {
                if (lineArray[3].equalsIgnoreCase(this.c.getName())) {
                    sConvertedOutput = this.addChemicalData(this.c, lineArray);
                    continue;
                }
                this.sErrorOutput = String.valueOf(this.sErrorOutput) + "Error in AddToNewChemical:  chemical names do not match /n";
                continue;
            }
            if (!s.areTheyEqual("EndChemical", key2)) continue;
            this.alChemical.add(this.c);
        }
        fr.close();
    }

    public void readHenrysConstantData(String sFileName) throws IOException {
        String currentLine;
        Stripper s = new Stripper();
        FileReader fr = new FileReader(sFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        while ((currentLine = br.readLine()) != null) {
            String key2;
            lineArray = currentLine.split(",", 0);
            String key = lineArray[0];
            if (!key.equalsIgnoreCase("Chemical") || !(key2 = lineArray[1]).equalsIgnoreCase("HenrysConstantData") && !key2.equalsIgnoreCase("Henrys constant data")) continue;
            String sName = lineArray[2];
            Object cMatch = null;
            for (Chemical chemical : this.alChemical) {
                if (!s.areTheyEqual(sName, chemical.getName())) continue;
                cMatch = chemical;
                break;
            }
            if (cMatch.equals(null)) {
                this.sErrorOutput = String.valueOf(this.sErrorOutput) + "Error on Henrys Constant Data input for " + sName + "/n";
            }
            double dValue = Double.parseDouble(lineArray[3]) * this.uc.getUCF("HenrysConstant", lineArray[4]);
            ((Chemical)cMatch).setReferenceHenrysConstant(dValue);
            dValue = Double.parseDouble(lineArray[5]) * this.uc.getUCF("Temperature", lineArray[6]);
            ((Chemical)cMatch).setReferenceHenrysConstantTemp(dValue);
            dValue = Double.parseDouble(lineArray[7]) * this.uc.getUCF("Temperature", lineArray[8]);
            ((Chemical)cMatch).setCritialTemp(dValue);
            dValue = Double.parseDouble(lineArray[9]) * this.uc.getUCF("Temperature", lineArray[10]);
            ((Chemical)cMatch).setNormalBoilingPoint(dValue);
            dValue = Double.parseDouble(lineArray[11]) * this.uc.getUCF("Enthalpy", lineArray[12]);
            ((Chemical)cMatch).setEnthalpy(dValue);
        }
        fr.close();
    }

    public void readChemicalRiskData(String sFileName) throws IOException {
        Stripper s = new Stripper();
        FileReader fr = new FileReader(sFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        String currentLine = br.readLine();
        while ((currentLine = br.readLine()) != null) {
            lineArray = currentLine.split(",", 0);
            if (!s.areTheyTheSame("Chemical", lineArray[0])) continue;
            String sName = lineArray[2];
            Object cMatch = null;
            if (!s.areTheyTheSame("Inhalation Risk", lineArray[1])) continue;
            for (Chemical chemical : this.alChemical) {
                if (!s.areTheyTheSame(chemical.getName(), sName)) continue;
                cMatch = chemical;
                break;
            }
            if (cMatch.equals(null)) {
                this.sErrorOutput = String.valueOf(this.sErrorOutput) + "Error on Inhalation Risk input for " + sName + "/n";
                continue;
            }
            try {
                try {
                    double dValue = Double.parseDouble(lineArray[3]) * this.uc.getUCF("ReciprocalConcentrationAir", lineArray[4]);
                    ((Chemical)cMatch).setIUR(dValue);
                    ((Chemical)cMatch).setIURSet(true);
                }
                catch (Exception e) {
                    ((Chemical)cMatch).setIURSet(false);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                double dRfC = Double.parseDouble(lineArray[5]) * this.uc.getUCF("ConcentrationAir", lineArray[6]);
                ((Chemical)cMatch).setReferenceConcentration(dRfC);
                ((Chemical)cMatch).setReferenceConcentrationSet(true);
            }
            catch (Exception e) {
                ((Chemical)cMatch).setReferenceConcentrationSet(false);
            }
        }
    }

    private String addChemicalData(Chemical c, String[] lineArray) {
        String sEol = System.getProperty("line.separator");
        String key3 = lineArray[2];
        String sOutput = sEol;
        if (key3.equalsIgnoreCase("Constant")) {
            sOutput = String.valueOf(sOutput) + ", Molecular Weight " + ", " + lineArray[4] + ", " + lineArray[5];
            sOutput = String.valueOf(sOutput) + this.addDataItem(c, "MolecularWeight", lineArray[4], lineArray[5], "MolecularWeight") + sEol;
            sOutput = String.valueOf(sOutput) + ", Solubility " + ", " + lineArray[6] + ", " + lineArray[7];
            sOutput = String.valueOf(sOutput) + this.addDataItem(c, "Solubility", lineArray[6], lineArray[7], "Solubility") + sEol;
            sOutput = String.valueOf(sOutput) + ", Density " + ", " + lineArray[8] + ", " + lineArray[9];
            sOutput = String.valueOf(sOutput) + this.addDataItem(c, "Density", lineArray[8], lineArray[9], "Density") + sEol;
            sOutput = String.valueOf(sOutput) + ", Koc " + ", " + lineArray[10] + ", " + lineArray[11];
            sOutput = String.valueOf(sOutput) + this.addDataItem(c, "Koc", lineArray[10], lineArray[11], "Koc") + sEol;
            sOutput = String.valueOf(sOutput) + ", Utilization Factor " + ", " + lineArray[12] + ", " + lineArray[13];
            sOutput = String.valueOf(sOutput) + this.addDataItem(c, "UtilizationFactor", lineArray[12], lineArray[13], "Phi") + sEol;
            sOutput = String.valueOf(sOutput) + ", Diffusion Coefficient in Air " + ", " + lineArray[14] + ", " + lineArray[15];
            sOutput = String.valueOf(sOutput) + this.addDataItem(c, "DiffusionCoefficientInAir", lineArray[14], lineArray[15], "diffusionCoefficient") + sEol;
            sOutput = String.valueOf(sOutput) + ", Diffusion Coefficient in Water " + ", " + lineArray[16] + ", " + lineArray[17];
            sOutput = String.valueOf(sOutput) + this.addDataItem(c, "DiffusionCoefficientInWater", lineArray[16], lineArray[17], "diffusionCoefficient") + sEol;
            sOutput = String.valueOf(sOutput) + ", Degradation Rate Constant " + ", " + lineArray[18] + ", " + lineArray[19];
            sOutput = String.valueOf(sOutput) + this.addDataItem(c, "Degradation", lineArray[18], lineArray[19], "RateConstant") + sEol;
        } else if (key3.equalsIgnoreCase("Variable")) {
            sOutput = String.valueOf(sOutput) + ", Molecular Weight " + ", " + lineArray[4] + ", " + lineArray[5];
            sOutput = String.valueOf(sOutput) + this.addDataItemVariable(c, "MolecularWeight", lineArray[4], lineArray[5], "MolecularWeight", lineArray[20]) + sEol;
            sOutput = String.valueOf(sOutput) + ", Solubility " + ", " + lineArray[6] + ", " + lineArray[7];
            sOutput = String.valueOf(sOutput) + this.addDataItemVariable(c, "Solubility", lineArray[6], lineArray[7], "Solubility", lineArray[20]) + sEol;
            sOutput = String.valueOf(sOutput) + ", Density " + ", " + lineArray[8] + ", " + lineArray[9];
            sOutput = String.valueOf(sOutput) + this.addDataItemVariable(c, "Density", lineArray[8], lineArray[9], "Density", lineArray[20]) + sEol;
            sOutput = String.valueOf(sOutput) + ", Koc " + ", " + lineArray[10] + ", " + lineArray[11];
            sOutput = String.valueOf(sOutput) + this.addDataItemVariable(c, "Koc", lineArray[10], lineArray[11], "Koc", lineArray[20]) + sEol;
            sOutput = String.valueOf(sOutput) + ", Utilization Factor " + ", " + lineArray[12] + ", " + lineArray[13];
            sOutput = String.valueOf(sOutput) + this.addDataItemVariable(c, "UtilizationFactor", lineArray[12], lineArray[13], "Phi", lineArray[20]) + sEol;
            sOutput = String.valueOf(sOutput) + ", Diffusion Coefficient in Air " + ", " + lineArray[14] + ", " + lineArray[15];
            sOutput = String.valueOf(sOutput) + this.addDataItemVariable(c, "DiffusionCoefficientInAir", lineArray[14], lineArray[15], "diffusionCoefficient", lineArray[20]) + sEol;
            sOutput = String.valueOf(sOutput) + ", Diffusion Coefficient in Water " + ", " + lineArray[16] + ", " + lineArray[17];
            sOutput = String.valueOf(sOutput) + this.addDataItemVariable(c, "DiffusionCoefficientInWater", lineArray[16], lineArray[17], "diffusionCoefficient", lineArray[20]) + sEol;
            sOutput = String.valueOf(sOutput) + ", Degradation Rate Constant " + ", " + lineArray[18] + ", " + lineArray[19];
            sOutput = String.valueOf(sOutput) + this.addDataItemVariable(c, "Degradation", lineArray[18], lineArray[19], "RateConstant", lineArray[20]) + sEol;
        }
        return sOutput;
    }

    private String addDataItemVariable(VIDataAbstractClass bvd, String key2m, String sValue, String sUnit, String sUnitType, String sFrequency) {
        String sReturn = "";
        OutputDigits od = new OutputDigits();
        double value = Double.parseDouble(sValue) * this.uc.getUCF(sUnitType, sUnit);
        double frequency = Double.parseDouble(sFrequency);
        bvd.setCumulativeDistributionValue(key2m, value, frequency);
        bvd.setCurrentRandomValue(key2m, 0.5);
        bvd.setCalculationUnit(key2m, this.uc.getModelUnit(sUnitType));
        od.setValue(value);
        sReturn = ", converted to: " + od.num2String() + " " + this.uc.getModelUnit(sUnitType);
        return sReturn;
    }

    private String addDataItem(VIDataAbstractClass bvd, String key2m, String sValue, String sUnit, String sUnitType) {
        String sReturn = "";
        OutputDigits od = new OutputDigits();
        double value = Double.parseDouble(sValue) * this.uc.getUCF(sUnitType, sUnit);
        bvd.setStatisticalDistributionValue(key2m, value);
        bvd.setCurrentRandomValue(key2m, 0.5);
        bvd.setCalculationUnit(key2m, this.uc.getModelUnit(sUnitType));
        od.setValue(value);
        sReturn = ", converted to " + od.num2String() + " " + this.uc.getModelUnit(sUnitType);
        return sReturn;
    }

    public void setFileLoggerOutput(FileLogger flOutput) {
        this.flOutput = flOutput;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setInterpretInputName(InterpretInputName iin) {
        this.iin = iin;
    }

    public ArrayList<Chemical> getChemicalData() {
        return this.alChemical;
    }

    public String getKnownErrorOutput() {
        return this.sErrorOutput;
    }
}

