/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataReaders;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import pviScreen.dataContainers.ExposureFactorData;
import util.Stripper;
import util.UnitConverter;

public class ExposureFactorReader {
    private ExposureFactorData efd = new ExposureFactorData();
    private UnitConverter uc;

    public void read(String pathName) throws IOException {
        FileReader fr = new FileReader(pathName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        String sErrorOutput = "";
        String sConvertedOutput = "";
        Stripper s = new Stripper();
        int iCount = 0;
        String currentLine = br.readLine();
        while ((currentLine = br.readLine()) != null) {
            String sRiskType = "";
            String sBuildingType = "";
            String sName = "";
            double dValue = 0.0;
            String sUnit = "";
            lineArray = currentLine.split(",", 0);
            if (s.areTheyTheSame("Risk", lineArray[0])) {
                sRiskType = lineArray[2];
                sBuildingType = lineArray[1];
                sName = lineArray[3];
                sUnit = lineArray[5];
                dValue = 0.0;
                try {
                    dValue = Double.parseDouble(lineArray[4]);
                    double dUCF = 1.0;
                    if (s.areTheyEqual(lineArray[3], "ExposureFrequency") || s.areTheyEqual(lineArray[3], "ExposureTime")) {
                        dUCF = this.uc.getUCF("NonDimensionalTime", sUnit);
                    }
                    if (s.areTheyEqual(lineArray[3], "AveragingTime") || s.areTheyEqual(lineArray[3], "ExposureDuration")) {
                        dUCF = this.uc.getUCF("Time", sUnit);
                    }
                    dValue *= dUCF;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (iCount == 0) {
                this.efd.createNewExposureFactorGroup(sRiskType, sBuildingType);
                this.efd.addToExposureFactorGroup(sRiskType, sBuildingType, sName, dValue, sUnit);
                ++iCount;
            } else {
                this.efd.addToExposureFactorGroup(sRiskType, sBuildingType, sName, dValue, sUnit);
                ++iCount;
            }
            if (iCount <= 3) continue;
            iCount = 0;
        }
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public ExposureFactorData getExposureFactorData() {
        return this.efd;
    }
}

