/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataReaders;

import java.util.ArrayList;
import pviScreen.dataContainers.AquiferData;
import pviScreen.dataContainers.Building;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.LinkedParameters;
import pviScreen.dataContainers.OilLens;
import pviScreen.dataContainers.Oxygen;
import pviScreen.dataContainers.RawInput;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.RunIdentifier;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataContainers.VIDataAbstractClass;
import pviScreen.dataContainers.VadoseZone;
import pviScreen.dataReaders.ChemicalDataReader;
import pviScreen.dataReaders.InterpretInputName;
import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class FillDataContainer {
    private UnitConverter uc;
    private String sErrorOutput;
    private Building building = new Building();
    private VadoseZone vz = new VadoseZone();
    private AquiferData ad = new AquiferData();
    private Oxygen oxygen = new Oxygen();
    private OilLens oil = new OilLens();
    private ArrayList<StatisticalDistribution> alSDistribution = new ArrayList();
    private RawInput ri;
    private ChemicalDataReader cdr;
    private RunIdentifier runID;
    private VIControlData viCD;
    ArrayList<Chemical> alChemical;
    private LinkedParameters lp = new LinkedParameters();
    private InterpretInputName iin = new InterpretInputName();
    private FileLogger fl;
    boolean bChemicalFound;

    public String addData(VIDataAbstractClass pvisData, String key2, String[] lineArray) {
        String sOutput = "";
        String sOutputError = "";
        String key3 = lineArray[2];
        if (key3.equalsIgnoreCase("Constant")) {
            sOutput = this.addDataItem(pvisData, key2, lineArray[3], lineArray[4], this.getUnitType(key2));
            if (sOutput.equalsIgnoreCase(" ")) {
                sOutputError = ", Error in Input: " + this.arrayToString(lineArray);
            }
        } else if (key3.equalsIgnoreCase("Variable") && (sOutput = this.addDataItemVariable(pvisData, key2, lineArray[3], lineArray[4], this.getUnitType(key2), lineArray[5])).equalsIgnoreCase(" ")) {
            sOutputError = ", Error in Input: " + this.arrayToString(lineArray);
        }
        this.addToKnownErrorOutput(sOutputError);
        return String.valueOf(sOutput) + sOutputError;
    }

    public String addChemicalData(String[] lineArray) {
        String sEol = System.getProperty("line.separator");
        sEol = "";
        String key3 = lineArray[2];
        String sOutput = "";
        Stripper s = new Stripper();
        String[] sNameCondensed = new String[5];
        String[] sUnitName = new String[5];
        sNameCondensed[0] = this.iin.getSoilGasSampleName();
        sUnitName[0] = "ConcentrationAir";
        sNameCondensed[1] = "FuelPhaseConcentrationByMass";
        sUnitName[1] = "MassFraction";
        sNameCondensed[2] = "FuelPhaseConcentrationByVolume";
        sUnitName[2] = "VolumeFraction";
        sNameCondensed[3] = this.iin.getGroundWaterSampleName();
        sUnitName[3] = "ConcentrationWater";
        sNameCondensed[4] = "SoilSample";
        sUnitName[4] = "SoilSample";
        this.bChemicalFound = false;
        block0: for (Chemical chemical : this.alChemical) {
            if (!s.areTheyEqual(chemical.getName(), lineArray[3], ' ')) continue;
            chemical.setUsedInSimulation(true);
            int j = 0;
            while (j < sNameCondensed.length) {
                if (s.areTheyEqual(sNameCondensed[j], lineArray[1], ' ')) {
                    if (j == 3) {
                        for (StatisticalDistribution sd : chemical.getStatisticalDistribution()) {
                            chemical.setStatisticalDistributionUse(this.iin.getSoilGasSampleName(), chemical.getName(), true);
                        }
                    }
                    chemical.setInputType(sNameCondensed[j]);
                    this.bChemicalFound = true;
                    sOutput = String.valueOf(sOutput) + ", " + sNameCondensed[j] + "," + lineArray[4] + ", " + lineArray[5] + " " + sUnitName[j];
                    if (s.areTheyEqual("constant", lineArray[2])) {
                        sOutput = String.valueOf(sOutput) + this.addDataItem(chemical, sNameCondensed[j], lineArray[4], lineArray[5], sUnitName[j]) + sEol;
                        continue block0;
                    }
                    if (!s.areTheyEqual("variable", lineArray[2])) continue block0;
                    sOutput = String.valueOf(sOutput) + this.addDataItemVariable(chemical, sNameCondensed[j], lineArray[4], lineArray[5], sUnitName[j], lineArray[6]) + sEol;
                    continue block0;
                }
                ++j;
            }
        }
        if (!this.bChemicalFound) {
            sOutput = String.valueOf(sOutput) + "Data not found for input chemical" + lineArray[3];
        }
        return sOutput;
    }

    private String addDataItemVariable(VIDataAbstractClass pvisData, String key2m, String sValue, String sUnit, String sUnitType, String sFrequency) {
        String sReturn = "";
        OutputDigits od = new OutputDigits();
        double value = Double.parseDouble(sValue) * this.uc.getUCF(sUnitType, sUnit);
        double frequency = Double.parseDouble(sFrequency);
        pvisData.setCumulativeDistributionValue(key2m, value, frequency);
        pvisData.setCurrentRandomValue(key2m, 0.5);
        pvisData.setCalculationUnit(key2m, this.uc.getModelUnit(sUnitType));
        od.setValue(value);
        sReturn = ", converted to: " + od.num2String() + " " + this.uc.getModelUnit(sUnitType);
        return sReturn;
    }

    private String addDataItem(VIDataAbstractClass bvd, String key2m, String sValue, String sUnit, String sUnitType) {
        String sReturn = "";
        OutputDigits od = new OutputDigits();
        double value = Double.parseDouble(sValue) * this.uc.getUCF(sUnitType, sUnit);
        bvd.setStatisticalDistributionValue(key2m, value);
        bvd.setCurrentRandomValue(key2m, 0.5);
        bvd.setCalculationUnit(key2m, this.uc.getModelUnit(sUnitType));
        od.setValue(value);
        sReturn = ", converted to " + od.num2String() + " " + this.uc.getModelUnit(sUnitType);
        return sReturn;
    }

    private String getUnitType(String sInputName) {
        RawInputLine ril = new RawInputLine(this.viCD);
        String sReturn = ril.getUnitType(sInputName, this.uc);
        return sReturn;
    }

    private String arrayToString(String[] lineArray) {
        String sOut = "";
        int i = 0;
        while (i < lineArray.length) {
            sOut = String.valueOf(sOut) + lineArray[i] + ", ";
            ++i;
        }
        return sOut;
    }

    public void addToKnownErrorOutput(String sError) {
        if (!sError.equalsIgnoreCase("")) {
            this.sErrorOutput = String.valueOf(this.sErrorOutput) + sError + "\n";
        }
    }

    public void assembleModelData() {
        this.collectStatisticalDistributions();
        if (!this.viCD.getOilDistributionType().equalsIgnoreCase("none")) {
            this.oil.setIsLensUsed(true);
            this.oil.setVadoseZone(this.vz);
            this.oil.findTopOfOilZone();
            this.oil.setFieldData(this.viCD.getFieldData());
            this.oil.setElevations();
            this.oil.generateOilProfile();
            this.oil.writeProfile(this.fl);
        } else {
            this.oil.setIsLensUsed(false);
        }
        this.setLinkedParameterDistributions();
        ArrayList<Chemical> alChemicalRevised = new ArrayList<Chemical>();
        for (Chemical chemical : this.alChemical) {
            chemical.setOilLensData(this.oil);
            chemical.setVadoseZone(this.vz);
            chemical.setAquifer(this.ad);
            chemical.setUnitConverter(this.uc);
            chemical.correctHenrysConstantForTemperature();
            if (!chemical.getIsUsedInSimulation()) continue;
            chemical.setAirPhaseConcentration();
            alChemicalRevised.add(chemical);
        }
        this.viCD.setVadoseZone(this.vz);
        this.viCD.setBuilding(this.building);
        this.viCD.setOxygen(this.oxygen);
        this.viCD.setAquiferData(this.ad);
        this.viCD.setOilLensData(this.oil);
        this.viCD.setChemicals(alChemicalRevised);
        this.viCD.setStatisticalDistribution(this.alSDistribution);
        this.viCD.setUnitConverter(this.uc);
        this.viCD.setRawInput(this.ri);
        this.viCD.setRunIdentifier(this.runID);
        this.viCD.setLinkedParameters(this.lp);
        Boolean bUnsupportedUnit = this.uc.getBooleanUnsupportedUnit();
        this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), this.getKnownErrorOutput());
        this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), this.cdr.getKnownErrorOutput());
        this.viCD.setCanRunModel();
    }

    private void collectStatisticalDistributions() {
        for (StatisticalDistribution sd : this.building.getStatisticalDistribution()) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.alSDistribution.add(sd);
        }
        for (StatisticalDistribution sd : this.vz.getStatisticalDistribution()) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.alSDistribution.add(sd);
        }
        for (StatisticalDistribution sd : this.oxygen.getStatisticalDistribution()) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.alSDistribution.add(sd);
        }
        for (StatisticalDistribution sd : this.oil.getStatisticalDistribution()) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.alSDistribution.add(sd);
        }
        for (Chemical c : this.alChemical) {
            for (StatisticalDistribution sd : c.getStatisticalDistribution()) {
                if (!c.getIsUsedInSimulation()) continue;
                this.alSDistribution.add(sd);
            }
        }
    }

    public void linkParameters(String sGroup, String[] lineArray) {
        double dMultiplier = 1.0;
        try {
            dMultiplier = Double.parseDouble(lineArray[5]);
        }
        catch (Exception e) {
            dMultiplier = 1.0;
        }
        this.lp.addLinkedParameter(lineArray[1], lineArray[3], lineArray[4], dMultiplier);
    }

    private void setLinkedParameterDistributions() {
        int iNumber = this.lp.getLinkedParameterCount();
        int i = 0;
        while (i < iNumber) {
            String sIndependent = this.lp.getIndependentParameter(i);
            String sDependent = this.lp.getDependentParameter(i);
            double dMultiplier = this.lp.getMultiplier(i);
            block1: for (StatisticalDistribution sd1 : this.alSDistribution) {
                if (!sd1.getName().equalsIgnoreCase(sIndependent)) continue;
                for (StatisticalDistribution sd : this.alSDistribution) {
                    if (!sd.getName().equalsIgnoreCase(sDependent)) continue;
                    int iCount = sd1.getNumberOfPointsDefiningDistribution();
                    sd.setNumberOfPointsDefiningDistribution(sd1.getNumberOfPointsDefiningDistribution());
                    double[] dValue = sd1.getConcentrationDistribution();
                    int j = 0;
                    while (j < iCount) {
                        dValue[j] = dValue[j] * dMultiplier;
                        ++j;
                    }
                    sd.setConcentrationDistribution(dValue);
                    sd.setFrequencyDistribution(sd1.getFrequencyDistribution());
                    sd.setCalculationUnit(sd1.getCalculationUnit());
                    sd.setCurrentRandomValue(sd1.getCurrentRandomValue());
                    sd.setChosenFrequency(sd1.getChosenFrequency());
                    break block1;
                }
            }
            ++i;
        }
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setPVIScreenControlData(VIControlData pvisCD) {
        this.viCD = pvisCD;
    }

    public void setRunIdentifier(RunIdentifier runID) {
        this.runID = runID;
    }

    public void setChemicals(ArrayList<Chemical> alChemical) {
        this.alChemical = alChemical;
    }

    public void setFileLogger(FileLogger fl) {
        this.fl = fl;
    }

    public void setRawInput(RawInput ri) {
        this.ri = ri;
    }

    public void setChemicalDataReader(ChemicalDataReader cdr) {
        this.cdr = cdr;
    }

    public Building getBuilding() {
        return this.building;
    }

    public VadoseZone getVadoseZone() {
        return this.vz;
    }

    public AquiferData getAquiferData() {
        return this.ad;
    }

    public Oxygen getOxygen() {
        return this.oxygen;
    }

    public OilLens getOilLens() {
        return this.oil;
    }

    public String getKnownErrorOutput() {
        return this.sErrorOutput;
    }

    public ArrayList<StatisticalDistribution> getStatisticalDistributions() {
        return this.alSDistribution;
    }

    public boolean getChemicalFound() {
        return this.bChemicalFound;
    }
}

