/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataReaders;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import pviScreen.dataContainers.InternalName;
import pviScreen.dataReaders.DataReader;
import util.FileLogger;
import util.Stripper;

public class InterpretInputName
extends DataReader {
    private String s_SoilGasConcentration = "Soil Gas Concentration";
    private String s_GroundWaterConcentration = "Ground Water Concentration";
    private ArrayList<InternalName> alInternalName = new ArrayList();

    public void readInput(String sFileName) throws IOException {
        FileReader fr;
        try {
            fr = new FileReader(sFileName);
        }
        catch (Exception e) {
            this.reWriteAlternativeNameFile(sFileName);
            fr = new FileReader(sFileName);
        }
        BufferedReader br = new BufferedReader(fr);
        Stripper s = new Stripper();
        String[] lineArray = new String[]{""};
        String sKey = "";
        String sKey2 = "";
        String currentLine = br.readLine();
        lineArray = currentLine.split(",", 0);
        if (!s.areTheyTheSame("InternalName", lineArray[0])) {
            this.addToKnownErrorOutput("Incorect Internal Name File");
        }
        while ((currentLine = br.readLine()) != null) {
            lineArray = currentLine.split(",", 0);
            InternalName inNewName = new InternalName();
            inNewName.setInternalName(lineArray[0]);
            int i = 1;
            while (i < lineArray.length) {
                inNewName.addToAlternativeName(lineArray[i]);
                ++i;
            }
            this.alInternalName.add(inNewName);
        }
        fr.close();
    }

    public boolean checkForAllowableInternalName(String sInternalName, String sExternalName) {
        boolean bReturn = false;
        Stripper s = new Stripper();
        for (InternalName in : this.alInternalName) {
            if (!s.areTheyTheSame(sInternalName, in.getInternalName())) continue;
            for (String sPossibleName : in.getAllInternalName()) {
                if (!s.areTheyTheSame(sExternalName, sPossibleName)) continue;
                return true;
            }
        }
        return bReturn;
    }

    public void reWriteAlternativeNameFile(String sFileName) {
        FileLogger fl = new FileLogger(sFileName);
        fl.setCompleteFileName(sFileName);
        fl.setWriteFile(true);
        fl.logMessage("Internal Name,Alternate1,Alternate2,Alternate3,Alternate4,Alternate5");
        fl.logMessage(String.valueOf(this.s_GroundWaterConcentration) + "," + "Ground Water Concentration,Water Phase Concentration,Water Concentration,Ground Water,Ground Water Sample");
        fl.logMessage(String.valueOf(this.s_SoilGasConcentration) + "," + "Soil Gas Concentration,AirPhaseConcentration,Soil Air Concentration");
        fl.closeOverWriteFile();
    }

    public ArrayList<InternalName> getAllInternalName() {
        return this.alInternalName;
    }

    public String getSoilGasSampleName() {
        return this.s_SoilGasConcentration;
    }

    public String getGroundWaterSampleName() {
        return this.s_GroundWaterConcentration;
    }
}

