/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataReaders;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import pviScreen.dataContainers.VIControlData;
import util.FileLogger;
import util.Stripper;
import util.UnitConverter;

public class OutputUnitReader {
    private UnitConverter uc;
    private VIControlData viCD;

    public void readOutputUnits(String sFile) throws IOException {
        FileReader fr;
        try {
            fr = new FileReader(sFile);
        }
        catch (Exception e) {
            fr = new FileReader(this.generateReplacementOutputUnitsFile());
        }
        BufferedReader br = new BufferedReader(fr);
        Stripper s = new Stripper();
        String[] lineArray = new String[]{""};
        String currentLine = br.readLine();
        lineArray = currentLine.split(",", 0);
        if (!s.areTheyEqual("Output Unit File", lineArray[0], ' ')) {
            this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), "Incorrect output unit file");
        }
        while ((currentLine = br.readLine()) != null) {
            String key = "";
            String key2 = "";
            String key3 = "";
            lineArray = currentLine.split(",", 0);
            key = lineArray[0];
            key2 = lineArray[1];
            if (!s.areTheyEqual(key2, "OutputUnit", ' ')) continue;
            this.uc.addOutputUnit(lineArray[2], lineArray[3]);
        }
        fr.close();
    }

    private String generateReplacementOutputUnitsFile() {
        FileLogger fl = new FileLogger("src/systemData/07OutputUnits.csv");
        fl.openOverWriteFile();
        fl.logMessageOverWrite("Output Unit File");
        fl.logMessageOverWrite("Control,Begin");
        fl.logMessageOverWrite("Control,Output Unit,length,ft");
        fl.logMessageOverWrite("Control,Output Unit,Concentration Air,ug/m3");
        fl.logMessageOverWrite("Control,Output Unit,RiskConcentration,ug/m3");
        fl.logMessageOverWrite("Control,Output Unit,SoilSample,mg/kg");
        fl.logMessageOverWrite("Control,Output Unit,WaterPhaseConcentration,mg/L");
        fl.logMessageOverWrite("Control,End");
        fl.closeOverWriteFile();
        return "src/systemData/07OutputUnits.csv";
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }
}

