/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataReaders;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import pviScreen.dataContainers.Building;
import pviScreen.dataContainers.Oxygen;
import pviScreen.dataContainers.RawInput;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIDataAbstractClass;
import pviScreen.dataContainers.VadoseZone;
import pviScreen.dataReaders.DataReader;
import pviScreen.dataReaders.FillDataContainer;
import util.FileLogger;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class SuggestedValueReader
extends DataReader {
    private NameConstants nc;
    private UnitConverter uc;
    private RawInput ri;
    private Oxygen oxygen;
    private Building bld;
    private VadoseZone vz;
    private FileLogger flOutput;
    private FillDataContainer fdc;
    private String sConvertedOutput;

    public void readSuggestedValues(String sFile) throws IOException {
        FileReader fr;
        try {
            fr = new FileReader(sFile);
        }
        catch (Exception e) {
            fr = new FileReader(this.generateReplacementSuggestedValueFile());
        }
        BufferedReader br = new BufferedReader(fr);
        Stripper s = new Stripper();
        String[] lineArray = new String[]{""};
        String currentLine = br.readLine();
        lineArray = currentLine.split(",", 0);
        if (!s.areTheyEqual("SuggestedValueFile", lineArray[0], ' ')) {
            this.addToKnownErrorOutput("Incorect Suggested Value File");
        }
        while ((currentLine = br.readLine()) != null) {
            String key = "";
            String key2 = "";
            String key3 = "";
            this.sConvertedOutput = "";
            this.sErrorOutput = "";
            lineArray = currentLine.split(",", 0);
            key = lineArray[0];
            if (s.areTheyEqual(key, "control") || s.areTheyEqual(key, "controll")) {
                key2 = lineArray[1];
                if (s.areTheyEqual("NumberOfSimulations", key2, ' ')) {
                    this.viCD.setNumberOfRuns((int)Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (s.areTheyEqual("NumberOfFrequencyDistributionIntervals", key2, ' ')) {
                    this.viCD.setNumberOfFrequencyDistributionIntervals((int)Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (s.areTheyEqual("MaxAlpha", key2, ' ')) {
                    this.viCD.setMaxAlpha(Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (key2.equalsIgnoreCase("bisection")) {
                    key3 = lineArray[2];
                    if (s.areTheyEqual(key3, "lower limit", ' ')) {
                        this.viCD.setBisectionLowerLimit(Double.parseDouble(lineArray[3]));
                        this.saveRawInput(this.nc.s_CONTROL2STRINGVALUE, lineArray);
                    } else if (s.areTheyEqual(key3, "Max Iterations", ' ') || s.areTheyEqual(key3, "Maximum Iterations", ' ')) {
                        this.viCD.setBisectionMaxIterations((int)Double.parseDouble(lineArray[3]));
                        this.saveRawInput(this.nc.s_CONTROL2STRINGVALUE, lineArray);
                    } else if (s.areTheyEqual(key3, "tolerance", ' ')) {
                        this.viCD.setBisectionTolerance(Double.parseDouble(lineArray[3]));
                        this.saveRawInput(this.nc.s_CONTROL2STRINGVALUE, lineArray);
                    }
                }
            } else if (key.equalsIgnoreCase("Building") || key.equalsIgnoreCase("bld")) {
                key2 = lineArray[1];
                if (!key2.equalsIgnoreCase("Begin") && !key2.equalsIgnoreCase("End")) {
                    this.bld.createNewDistribution("building", key2);
                    this.sConvertedOutput = this.fdc.addData(this.bld, key2, lineArray);
                    this.sConvertedOutput = this.addData(this.bld, key2, lineArray);
                    this.saveRawInput(this.nc.s_VALUEINPUT, lineArray);
                }
            } else if (s.areTheyEqual(key, "VadoseZone", ' ') || s.areTheyEqual(key, "UnsaturatedZone", ' ')) {
                key2 = lineArray[1];
                if (!key2.equalsIgnoreCase("Begin") && !key2.equalsIgnoreCase("End")) {
                    this.sConvertedOutput = this.fdc.addData(this.vz, key2, lineArray);
                    this.sConvertedOutput = this.addData(this.vz, key2, lineArray);
                    this.saveRawInput(this.nc.s_VALUEINPUT, lineArray);
                }
            } else if (key.equalsIgnoreCase("Oxygen")) {
                key2 = lineArray[1];
                if (key2.equalsIgnoreCase("Begin")) {
                    this.oxygen = new Oxygen();
                } else if (!key2.equalsIgnoreCase("End")) {
                    this.sConvertedOutput = this.addData(this.oxygen, key2, lineArray);
                    this.saveRawInput(this.nc.s_VALUEINPUT, lineArray);
                }
            }
            String sOut = this.arrayToString(lineArray);
            this.flOutput.logMessage(String.valueOf(sOut) + this.sConvertedOutput + this.sErrorOutput);
            this.addToKnownErrorOutput(this.sErrorOutput);
        }
        fr.close();
    }

    private void saveRawInput(String sRawInputType, String[] sRawInputLine) {
        RawInputLine ril = new RawInputLine(this.uc, this.viCD);
        String sOut = "";
        int i = 0;
        while (i < sRawInputLine.length) {
            sOut = String.valueOf(sOut) + " " + sRawInputLine[i];
            ++i;
        }
        ril.setRawInputLine(sRawInputType, sRawInputLine);
        ril.setOutputDestination(this.viCD.getInputFileNames().getFile_SuggestedValues());
        this.ri.add(ril);
    }

    private String arrayToString(String[] lineArray) {
        String sOut = "";
        int i = 0;
        while (i < lineArray.length) {
            sOut = String.valueOf(sOut) + lineArray[i] + ", ";
            ++i;
        }
        return sOut;
    }

    private String addData(VIDataAbstractClass pvisData, String key2, String[] lineArray) {
        String sOutput = "";
        String sOutputError = "";
        String key3 = lineArray[2];
        if (key3.equalsIgnoreCase("Constant")) {
            sOutput = this.addDataItem(pvisData, key2, lineArray[3], lineArray[4], this.getUnitType(key2));
            if (sOutput.equalsIgnoreCase(" ")) {
                sOutputError = ", Error in Input: " + this.arrayToString(lineArray);
            }
        } else if (key3.equalsIgnoreCase("Variable") && (sOutput = this.addDataItemVariable(pvisData, key2, lineArray[3], lineArray[4], this.getUnitType(key2), lineArray[5])).equalsIgnoreCase(" ")) {
            sOutputError = ", Error in Input: " + this.arrayToString(lineArray);
        }
        this.addToKnownErrorOutput(sOutputError);
        return String.valueOf(sOutput) + sOutputError;
    }

    private String getUnitType(String sInputName) {
        RawInputLine ril = new RawInputLine(this.viCD);
        String sReturn = ril.getUnitType(sInputName, this.uc);
        return sReturn;
    }

    private String addDataItem(VIDataAbstractClass bvd, String key2m, String sValue, String sUnit, String sUnitType) {
        String sReturn = "";
        OutputDigits od = new OutputDigits();
        double value = Double.parseDouble(sValue) * this.uc.getUCF(sUnitType, sUnit);
        bvd.setStatisticalDistributionValue(key2m, value);
        bvd.setCurrentRandomValue(key2m, 0.5);
        bvd.setCalculationUnit(key2m, this.uc.getModelUnit(sUnitType));
        od.setValue(value);
        sReturn = ", converted to " + od.num2String() + " " + this.uc.getModelUnit(sUnitType);
        return sReturn;
    }

    private String addDataItemVariable(VIDataAbstractClass bvd, String key2m, String sValue, String sUnit, String sUnitType, String sFrequency) {
        String sReturn = "";
        OutputDigits od = new OutputDigits();
        double value = Double.parseDouble(sValue) * this.uc.getUCF(sUnitType, sUnit);
        double frequency = Double.parseDouble(sFrequency);
        bvd.setCumulativeDistributionValue(key2m, value, frequency);
        bvd.setCurrentRandomValue(key2m, 0.5);
        bvd.setCalculationUnit(key2m, this.uc.getModelUnit(sUnitType));
        od.setValue(value);
        sReturn = ", converted to: " + od.num2String() + " " + this.uc.getModelUnit(sUnitType);
        return sReturn;
    }

    private String generateReplacementSuggestedValueFile() {
        FileLogger fl = new FileLogger("src/systemData/06SuggestedValues.csv");
        fl.openOverWriteFile();
        fl.logMessageOverWrite("Suggested Value File");
        fl.logMessageOverWrite("Control,Begin");
        fl.logMessageOverWrite("Control,Groundwater Concentration Factor,0.1");
        fl.logMessageOverWrite("Control,Soil Sample Concentration Factor,0.1");
        fl.logMessageOverWrite("Control,Bisection,Lower Limit,1.00E-4");
        fl.logMessageOverWrite("Control,Bisection,Max iterations,5000");
        fl.logMessageOverWrite("Control,Bisection,tolerance,1.00E-12");
        fl.logMessageOverWrite("Control,max alpha,200");
        fl.logMessageOverWrite("Control,Number of Simulations,1000");
        fl.logMessageOverWrite("Control,Number of frequency distribution intervals,50");
        fl.logMessageOverWrite("Control,End");
        fl.logMessageOverWrite("Oxygen,Begin");
        fl.logMessageOverWrite("Oxygen,DiffusionInAir,Constant,0.175,cm2/s,1");
        fl.logMessageOverWrite("Oxygen,DiffusionInWater,Constant,1.70E-5,cm2/s,1");
        fl.logMessageOverWrite("Oxygen,SurfaceConcentration,Constant,289000,mg/m3,1");
        fl.logMessageOverWrite("Oxygen,MinimumBiodegradationConcentration,Constant,13800,mg/m3,1");
        fl.logMessageOverWrite("Oxygen,End");
        fl.logMessageOverWrite("Building,Begin");
        fl.logMessageOverWrite("Building,Qsoil,Variable,1,L/m,0");
        fl.logMessageOverWrite("Building,Qsoil,Variable,10,L/m,1");
        fl.logMessageOverWrite("Building,End");
        fl.logMessageOverWrite("VadoseZone,Begin");
        fl.logMessageOverWrite("VadoseZone,SoilRespirationRate,Constant,1.69,mg/g-d,1");
        fl.logMessageOverWrite("VadoseZone,End");
        fl.closeOverWriteFile();
        return "src/systemData/06SuggestedValues.csv";
    }

    public void setNameConstants(NameConstants nc) {
        this.nc = nc;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setRawInputContainer(RawInput ri) {
        this.ri = ri;
    }

    public void setBuildingObject(Building bld) {
        this.bld = bld;
    }

    public void setMainOutputFileLogger(FileLogger flOutput) {
        this.flOutput = flOutput;
    }

    public void setFillDataContainer(FillDataContainer fdc) {
        this.fdc = fdc;
    }

    public void setExistingErrorOutput(String s) {
        this.sErrorOutput = s;
    }

    public void setVadoseZoneObject(VadoseZone vz) {
        this.vz = vz;
    }

    public Oxygen getOxygenObject() {
        return this.oxygen;
    }
}

