/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataReaders;

import java.io.BufferedReader;
import java.io.FileReader;
import pviScreen.dataContainers.InputFileNames;
import util.Stripper;

public class SystemDataFileReader {
    private InputFileNames ifn;
    private String[] sFiles = new String[]{"Chemical Properties", "Unit Conversions", "Unit Definitions", "Chemical Properties-Henrys", "Chemical Properties-Risk", "Chemical Properties - ExternalScreening", "Exposure Factors", "Parameter Choices", "Suggested Values", "Output Units", "Equivalent Input Names"};

    public SystemDataFileReader() {
        this.ifn = new InputFileNames();
    }

    public void read(String pathName) {
        try {
            String currentLine;
            FileReader fr = new FileReader(pathName);
            BufferedReader br = new BufferedReader(fr);
            String[] lineArray = new String[]{""};
            Stripper s = new Stripper();
            String sDir = "src/systemData/";
            while ((currentLine = br.readLine()) != null) {
                lineArray = currentLine.split(",", 0);
                if (s.areTheyEqual("Chemical Properties", lineArray[0])) {
                    this.ifn.setFile_ChemicalData(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Unit Conversions", lineArray[0])) {
                    this.ifn.setFile_UnitConversions(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Unit Definitions", lineArray[0])) {
                    this.ifn.setFile_UnitDefinitions(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Chemical Properties-Henrys", lineArray[0])) {
                    this.ifn.setFile_HenrysConstantData(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Chemical Properties-Risk", lineArray[0])) {
                    this.ifn.setFile_ChemicalRiskData(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Chemical Properties - ExternalScreening", lineArray[0])) {
                    this.ifn.setFile_ChemicalExternalScreeningLevels(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Exposure Factors", lineArray[0])) {
                    this.ifn.setFile_ExposureFactorData(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Parameter Choices", lineArray[0])) {
                    this.ifn.setFile_ParameterChoices(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Suggested Values", lineArray[0])) {
                    this.ifn.setFile_SuggestedValues(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (s.areTheyEqual("Output Units", lineArray[0])) {
                    this.ifn.setFile_OutputUnits(String.valueOf(sDir) + lineArray[1]);
                    continue;
                }
                if (!s.areTheyEqual("Equivalent Input Names", lineArray[0])) continue;
                this.ifn.setFile_EquivalentInputNames(String.valueOf(sDir) + lineArray[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputFileNames getInputFileNames() {
        return this.ifn;
    }
}

