/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.dataReaders;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import numerics.bisection.Bisection;
import pviScreen.dataContainers.AquiferData;
import pviScreen.dataContainers.Building;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.ExposureFactorData;
import pviScreen.dataContainers.FieldData;
import pviScreen.dataContainers.InputFileNames;
import pviScreen.dataContainers.LinkedParameters;
import pviScreen.dataContainers.OilLens;
import pviScreen.dataContainers.Oxygen;
import pviScreen.dataContainers.ParameterChoices;
import pviScreen.dataContainers.RawInput;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.RunIdentifier;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataContainers.VIDataAbstractClass;
import pviScreen.dataContainers.VadoseZone;
import pviScreen.dataReaders.ChemicalDataReader;
import pviScreen.dataReaders.ExposureFactorReader;
import pviScreen.dataReaders.FillDataContainer;
import pviScreen.dataReaders.InterpretInputName;
import pviScreen.dataReaders.OutputUnitReader;
import pviScreen.dataReaders.ParameterChoiceDataReader;
import pviScreen.dataReaders.SuggestedValueReader;
import pviScreen.dataReaders.SystemDataFileReader;
import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.FileModifier;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class VIDataReader {
    private String sTitle;
    private String sShortFileName;
    private String sOutputFileName;
    private String sMessageFileName;
    private String sOutputFileTime;
    private String sErrorOutput;
    protected Oxygen oxygen;
    protected VadoseZone vz;
    protected Building bld;
    protected Chemical c;
    protected AquiferData ad;
    protected OilLens old;
    protected RunIdentifier runID;
    protected ArrayList<Chemical> alChemical;
    protected double aerobicZoneDepth;
    protected double anaerobicZoneDepth;
    protected double aerobicZoneDepthConcentration;
    protected double aerobicZoneDepthFlux;
    protected double totalDepth;
    protected double soilRespiration;
    protected double efdo2;
    protected double jeo2;
    protected double ceo2;
    protected double eq29LHS;
    protected double eq37;
    protected double dMaxAlpha;
    private FileLogger flOutputFile;
    private FileLogger flMessage;
    private boolean bWriteFile;
    private String sOutput;
    private Bisection bisection;
    private double dBisectionLowerLimit;
    private int iBisectionMaxIterations;
    private double dBisectionTolerance;
    private boolean bConcentration;
    private boolean bMonteCarlo;
    private int iNumberOfRuns;
    private UnitConverter uc;
    private ChemicalDataReader cdr;
    private ExposureFactorReader efr;
    private SuggestedValueReader svr;
    SystemDataFileReader sfdr;
    private FieldData fd;
    private ArrayList<StatisticalDistribution> sDistribution;
    private VIControlData viCD;
    private boolean bUnsupportedUnit;
    private RawInput ri;
    private FileModifier fm;
    private LinkedParameters lp;
    private FillDataContainer fdc;
    private ParameterChoices pc;
    private ParameterChoiceDataReader pcdr;
    private OutputUnitReader our;
    private NameConstants nc = new NameConstants();
    private InterpretInputName iin;
    private InputFileNames ifn = new InputFileNames();

    public void initial() throws IOException {
        this.sShortFileName = "";
        this.sOutput = "";
        this.sOutputFileTime = "";
        this.sErrorOutput = "";
        this.sDistribution = new ArrayList();
        this.bMonteCarlo = true;
        this.bisection = new Bisection();
        this.dBisectionLowerLimit = 1.0E-4;
        this.iBisectionMaxIterations = 100;
        this.dBisectionTolerance = 0.0;
        this.nc = new NameConstants();
        this.sfdr = new SystemDataFileReader();
        String sSystemData = this.viCD.getSystemDataFileName();
        this.sfdr.read(sSystemData);
        this.viCD.setInputFileNames(this.sfdr.getInputFileNames());
        this.ifn = this.viCD.getInputFileNames();
        this.iin = new InterpretInputName();
        this.iin.readInput(this.ifn.getFile_EquivalentInputNames());
        this.uc = new UnitConverter();
        this.uc.readUnits(this.ifn.getFile_UnitConversions());
        this.uc.readUnitTypes(this.ifn.getFile_UnitDefinitions());
        this.cdr = new ChemicalDataReader();
        this.cdr.setUnitConverter(this.uc);
        this.cdr.setInterpretInputName(this.iin);
        this.efr = new ExposureFactorReader();
        this.efr.setUnitConverter(this.uc);
        this.svr = new SuggestedValueReader();
        this.our = new OutputUnitReader();
        this.our.setVIControlData(this.viCD);
        this.old = new OilLens();
        this.old.setIsLensUsed(false);
        this.viCD.setUnitConverter(this.uc);
        this.bUnsupportedUnit = false;
        this.bWriteFile = true;
        this.ri = new RawInput();
        this.fm = new FileModifier();
        this.runID = new RunIdentifier();
        this.runID.saveItem("Date", "");
        this.lp = new LinkedParameters();
        this.fdc = new FillDataContainer();
        this.pcdr = new ParameterChoiceDataReader();
    }

    public void readFile(String pathName) throws IOException {
        FileReader fr = new FileReader(pathName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        String sErrorOutput = "";
        String sConvertedOutput = "";
        Stripper s = new Stripper();
        String currentLine = br.readLine();
        lineArray = currentLine.split(",", 0);
        this.cdr.setUnitConverter(this.uc);
        this.cdr.readChemicalData(this.ifn.getFile_ChemicalData());
        this.cdr.readHenrysConstantData(this.ifn.getFile_HenrysConstantData());
        this.cdr.readChemicalRiskData(this.ifn.getFile_ChemicalRiskData());
        this.efr.read(this.ifn.getFile_ExposureFactorData());
        ExposureFactorData efd = this.efr.getExposureFactorData();
        efd.determineAllRiskLevels(this.cdr.getChemicalData());
        this.viCD.setExposureFactorData(efd);
        this.nc.getClass();
        this.sOutputFileName = this.fm.getOutputFileAndPathName(pathName, "", 1, this.nc.s_Extension_Results, true);
        this.sOutputFileTime = this.fm.getTimeStamp();
        this.nc.getClass();
        this.sMessageFileName = this.fm.getOutputFileAndPathName(pathName, "-RunTimeMessages", 1, this.nc.s_Extension_Message, true);
        this.flOutputFile = new FileLogger(this.sOutputFileName);
        this.flOutputFile.setWriteFile(this.bWriteFile);
        this.viCD.setOutputFileLogger(this.flOutputFile);
        this.flOutputFile.logMessage("Input File:," + pathName);
        this.uc.setFileLogger(this.flOutputFile);
        this.cdr.setFileLoggerOutput(this.flOutputFile);
        this.viCD.setIsMonteCarlo(true);
        this.alChemical = this.cdr.getChemicalData();
        this.viCD.setChemicals(this.alChemical);
        this.pcdr.readParameterData(this.ifn.getFile_ParameterChoices());
        this.pc = this.pcdr.getParameterDefinitions();
        this.fdc.setUnitConverter(this.uc);
        this.fdc.setPVIScreenControlData(this.viCD);
        this.fdc.setRunIdentifier(this.runID);
        this.fdc.setChemicals(this.alChemical);
        this.our.setUnitConverter(this.uc);
        this.our.readOutputUnits(this.ifn.getFile_OutputUnits());
        while ((currentLine = br.readLine()) != null) {
            String key = "";
            String key2 = "";
            String key3 = "";
            sErrorOutput = "";
            sConvertedOutput = "";
            lineArray = currentLine.split(",", 0);
            key = lineArray[0];
            try {
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "input file," + key + " " + lineArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (key.equalsIgnoreCase("Control") || key.equalsIgnoreCase("controll")) {
                key2 = lineArray[1];
                if (key2.equalsIgnoreCase("Analyst")) {
                    this.runID.setAnalyst(lineArray[2]);
                    this.saveRawInput(this.nc.s_CONTROL2STRING, lineArray);
                } else if (key2.equalsIgnoreCase("Affiliation")) {
                    this.runID.setAffiliation(lineArray[2]);
                    this.saveRawInput(this.nc.s_CONTROL2STRING, lineArray);
                } else if (key2.equalsIgnoreCase("Site")) {
                    this.runID.setSite(lineArray[2]);
                    this.saveRawInput(this.nc.s_CONTROL2STRING, lineArray);
                } else if (key2.equalsIgnoreCase("SiteLocation")) {
                    this.runID.setLocation(lineArray[2]);
                    this.saveRawInput(this.nc.s_CONTROL2STRING, lineArray);
                } else if (key2.equalsIgnoreCase("City")) {
                    this.runID.setCity(lineArray[2]);
                    this.saveRawInput(this.nc.s_CONTROL2STRING, lineArray);
                } else if (key2.equalsIgnoreCase("State")) {
                    this.runID.setState(lineArray[2]);
                    this.saveRawInput(this.nc.s_CONTROL2STRING, lineArray);
                }
                if (s.areTheyEqual("NumberOfSimulations", key2)) {
                    this.viCD.setNumberOfRuns((int)Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (s.areTheyEqual("NumberOfFrequencyDistributionIntervals", key2)) {
                    this.viCD.setNumberOfFrequencyDistributionIntervals((int)Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (s.areTheyEqual("MaxAlpha", key2)) {
                    this.viCD.setMaxAlpha(Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (key2.equalsIgnoreCase("bisection")) {
                    key3 = lineArray[2];
                    if (key3.equalsIgnoreCase("lowerLimit") || key3.equalsIgnoreCase("Lower limit")) {
                        this.viCD.setBisectionLowerLimit(Double.parseDouble(lineArray[3]));
                        this.saveRawInput(this.nc.s_CONTROL2STRINGVALUE, lineArray);
                    } else if (key3.equalsIgnoreCase("MaxIterations") || key3.equalsIgnoreCase("max iterations")) {
                        this.viCD.setBisectionMaxIterations((int)Double.parseDouble(lineArray[3]));
                        this.saveRawInput(this.nc.s_CONTROL2STRINGVALUE, lineArray);
                    } else if (key3.equalsIgnoreCase("tolerance")) {
                        this.viCD.setBisectionTolerance(Double.parseDouble(lineArray[3]));
                        this.saveRawInput(this.nc.s_CONTROL2STRINGVALUE, lineArray);
                    }
                } else if (s.areTheyEqual("GroundwaterConcentrationFactor", key2)) {
                    this.viCD.setGroundWaterConcentrationAdjustmentFactor(Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (s.areTheyEqual("ExternalScreeningLevels", key2, ' ')) {
                    this.saveRawInput(this.nc.s_CONTROLSTRINGCHOICE, lineArray);
                    if (s.areTheyTheSame("Yes", lineArray[2]) || s.areTheyTheSame("y", lineArray[2])) {
                        this.viCD.setDoesScreeningExist(true);
                    }
                } else if (s.areTheyEqual("SoilSampleConcentrationFactor", key2)) {
                    this.viCD.setSoilSampleConcentrationAdjustmentFactor(Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (s.areTheyEqual(key2, "OilDistribution")) {
                    key3 = lineArray[2];
                    if (s.areTheyEqual(key3, "field")) {
                        this.viCD.setOilDistributionType("Field");
                        this.saveRawInput(this.nc.s_CONTROL2STRING, lineArray);
                    } else if (s.areTheyEqual(key3, "capillary")) {
                        this.viCD.setOilDistributionType("capillary");
                        this.saveRawInput(this.nc.s_CONTROLSTRINGCHOICE, lineArray);
                    } else if (s.areTheyEqual(key3, "none")) {
                        this.viCD.setOilDistributionType("none");
                        this.saveRawInput(this.nc.s_CONTROL2STRING, lineArray);
                    }
                } else if (s.areTheyEqual("TargetCancerRisk", key2, ' ')) {
                    this.viCD.setTargetCancerRiskLevel(Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if (s.areTheyEqual("TargetHazardQuotient", key2, ' ')) {
                    this.viCD.setTargetHazardQuotient(Double.parseDouble(lineArray[2]));
                    this.saveRawInput(this.nc.s_CONTROLSTRINGVALUE, lineArray);
                } else if ("browser".equalsIgnoreCase(s.removeCharacter(' ', key2))) {
                    this.viCD.setBrowserName(lineArray[2]);
                    this.saveRawInput(this.nc.s_CONTROLSTRINGCHOICE, lineArray);
                }
            } else if (s.areTheyEqual(key, "VadoseZone", ' ') || s.areTheyEqual(key, "UnsaturatedZone", ' ')) {
                key2 = lineArray[1];
                if (key2.equalsIgnoreCase("Begin")) {
                    this.vz = new VadoseZone();
                } else if (!key2.equalsIgnoreCase("End")) {
                    sConvertedOutput = this.fdc.addData(this.vz, key2, lineArray);
                    sConvertedOutput = this.addData(this.vz, key2, lineArray);
                    this.saveRawInput(this.nc.s_VALUEINPUT, lineArray);
                }
            } else if (key.equalsIgnoreCase("Aquifer")) {
                key2 = lineArray[1];
                if (key2.equalsIgnoreCase("Begin")) {
                    this.ad = new AquiferData();
                } else if (!key2.equalsIgnoreCase("End")) {
                    sConvertedOutput = this.fdc.addData(this.ad, key2, lineArray);
                    sConvertedOutput = this.addData(this.ad, key2, lineArray);
                    this.saveRawInput(this.nc.s_VALUEINPUT, lineArray);
                }
            } else if (key.equalsIgnoreCase("OilLens") || key.equalsIgnoreCase("Oil Lens")) {
                key2 = lineArray[1];
                if (!key2.equalsIgnoreCase("Begin") && !key2.equalsIgnoreCase("End")) {
                    sConvertedOutput = this.fdc.addData(this.old, key2, lineArray);
                    sConvertedOutput = this.addData(this.old, key2, lineArray);
                    this.saveRawInput(this.nc.s_VALUEINPUT, lineArray);
                }
            } else if (key.equalsIgnoreCase("Building") || key.equalsIgnoreCase("bld")) {
                key2 = lineArray[1];
                try {
                    key3 = lineArray[2];
                }
                catch (Exception e) {
                    key3 = "";
                }
                if (key2.equalsIgnoreCase("DirtFloor") || key2.equalsIgnoreCase("Dirt Floor")) {
                    if (lineArray[2].equalsIgnoreCase("yes") || lineArray[2].equalsIgnoreCase("y")) {
                        this.bld.setIsItADirtFloor(true);
                    } else if (lineArray[2].equalsIgnoreCase("no") || lineArray[2].equalsIgnoreCase("n")) {
                        this.bld.setIsItADirtFloor(false);
                    } else {
                        this.bld.setIsItADirtFloor(false);
                    }
                    this.saveRawInput(this.nc.s_CONTROLSTRINGCHOICE, lineArray);
                } else if (s.areTheyTheSame("BuildingType", key2)) {
                    if (s.areTheyTheSame(lineArray[2], "residential")) {
                        this.nc.getClass();
                        this.bld.setBuildingType("Residential");
                    } else if (lineArray[2].equalsIgnoreCase("commercial")) {
                        this.nc.getClass();
                        this.bld.setBuildingType("Commercial");
                    }
                    this.saveRawInput(this.nc.s_CONTROLSTRINGCHOICE, lineArray);
                } else if (key2.equalsIgnoreCase("Begin")) {
                    this.bld = new Building();
                } else if (key2.equalsIgnoreCase("End")) {
                    this.lp.addLinkedParameter("AirFlowBelowBuilding", "Qsoil", "times", 1.0);
                } else if (key3.equalsIgnoreCase("Distribution")) {
                    this.readDistribution("Building", lineArray);
                } else if (key3.equalsIgnoreCase("Linked")) {
                    this.fdc.linkParameters("Building", lineArray);
                } else {
                    this.bld.createNewDistribution("building", key2);
                    if (s.areTheyEqual("MixingZone/CeilingHeight", key2) || s.areTheyEqual("CeilingHeight", key2)) {
                        this.bld.setMixingZoneName(key2);
                    }
                    sConvertedOutput = this.fdc.addData(this.bld, key2, lineArray);
                    sConvertedOutput = this.addData(this.bld, key2, lineArray);
                    this.saveRawInput(this.nc.s_VALUEINPUT, lineArray);
                }
            } else if (s.areTheyEqual(key, "ScreeningLevel")) {
                key2 = lineArray[1];
                if (s.areTheyEqual(key2, "Begin")) {
                    this.viCD.setDoesScreeningExist(true);
                } else if (!s.areTheyEqual(key2, "End") && s.areTheyTheSame(key2, "IndoorAirConcentration")) {
                    double dValue = 0.0;
                    String sName = lineArray[3];
                    try {
                        dValue = Double.parseDouble(lineArray[4]) * this.uc.getUCF("ConcentrationAir", lineArray[5]);
                    }
                    catch (Exception ee) {
                        this.addToKnownErrorOutput("screening level unit conversion not found: " + sName);
                    }
                    String sScreeningLevelAssignedToAChemical = "";
                    for (Chemical c : this.alChemical) {
                        String sChemicalName = c.getName();
                        if (!s.areTheyTheSame(sChemicalName, sName)) continue;
                        c.setExternalScreeningLevel(dValue);
                        sScreeningLevelAssignedToAChemical = ", screening level assigned to: " + sChemicalName;
                    }
                    if (s.areTheyEqual(sScreeningLevelAssignedToAChemical, "")) {
                        this.addToKnownErrorOutput("Screening level not assigned to a chemical: " + sName);
                    }
                    OutputDigits od = new OutputDigits();
                    od.setValue(dValue);
                    sConvertedOutput = ", converted to " + od.num2String() + " " + this.uc.getModelUnit("ConcentrationAir");
                    this.saveRawInput(this.nc.s_CONTROLSCREENINGLEVELINPUT, lineArray);
                }
            } else if (key.equalsIgnoreCase("Chemical")) {
                key2 = lineArray[1];
                boolean bWater = this.iin.checkForAllowableInternalName(this.iin.getGroundWaterSampleName(), key2);
                boolean bAir = this.iin.checkForAllowableInternalName(this.iin.getSoilGasSampleName(), key2);
                key2.equalsIgnoreCase("Begin");
                if (!key2.equalsIgnoreCase("Heading") && (bWater || bAir)) {
                    if (bWater) {
                        lineArray[1] = this.iin.getGroundWaterSampleName();
                    }
                    if (bAir) {
                        lineArray[1] = this.iin.getSoilGasSampleName();
                    }
                    sConvertedOutput = this.fdc.addChemicalData(lineArray);
                    if (!this.fdc.getChemicalFound()) {
                        this.addToKnownErrorOutput("Chemical not Found in Database: " + lineArray[3]);
                    }
                    this.saveRawInput(this.nc.s_CHEMICALINPUT, lineArray);
                }
            }
            String sOut = this.arrayToString(lineArray);
            this.flOutputFile.logMessage(String.valueOf(sOut) + sConvertedOutput + sErrorOutput);
            this.addToKnownErrorOutput(sErrorOutput);
        }
        if (this.viCD.getOilDistributionType().equalsIgnoreCase("field")) {
            this.fd = new FieldData();
            this.fd.setFileLogger(this.flOutputFile);
            this.fd.setUnitConverter(this.uc);
            this.fd.readFile(this.viCD.getOilDistributionFileName());
            this.viCD.setFieldData(this.fd);
        }
        this.svr.setVIControlData(this.viCD);
        this.svr.setRawInputContainer(this.ri);
        this.svr.setNameConstants(this.nc);
        this.svr.setUnitConverter(this.uc);
        this.svr.setBuildingObject(this.bld);
        this.svr.setVadoseZoneObject(this.vz);
        this.svr.setMainOutputFileLogger(this.flOutputFile);
        this.svr.setFillDataContainer(this.fdc);
        this.svr.setExistingErrorOutput(sErrorOutput);
        this.svr.readSuggestedValues(this.ifn.getFile_SuggestedValues());
        this.oxygen = this.svr.getOxygenObject();
        this.collectStatisticalDistributions();
        if (this.viCD.getOilDistributionType().equalsIgnoreCase("none")) {
            this.old.setIsLensUsed(false);
        } else {
            this.old.setIsLensUsed(true);
            this.old.setVadoseZone(this.vz);
            this.old.findTopOfOilZone();
            this.old.setFieldData(this.fd);
            this.old.setElevations();
            this.old.generateOilProfile();
            this.old.writeProfile(this.flOutputFile);
        }
        this.setLinkedParameterDistributions();
        ArrayList<Chemical> alChemicalRevised = new ArrayList<Chemical>();
        String sBuildingType = this.bld.getBuildingType();
        for (Chemical chemical : this.alChemical) {
            chemical.setOilLensData(this.old);
            chemical.setVadoseZone(this.vz);
            chemical.setAquifer(this.ad);
            chemical.setUnitConverter(this.uc);
            chemical.correctHenrysConstantForTemperature();
            String sName = chemical.getName();
            alChemicalRevised.add(chemical);
            if (chemical.getIsUsedInSimulation()) {
                chemical.setConcentrationAdjustmentGroundWater(this.viCD.getGroundWaterConcentrationAdjustmentFactor());
                chemical.setConcentrationAdjustmentSoilSample(this.viCD.getSoilSampleConcentrationAdjustmentFactor());
                chemical.setAirPhaseConcentration();
            }
            sBuildingType = this.bld.getBuildingType();
            chemical.determineFinalRiskChoice(false, sBuildingType);
        }
        this.viCD.setVadoseZone(this.vz);
        this.viCD.setBuilding(this.bld);
        this.viCD.setOxygen(this.oxygen);
        this.viCD.setAquiferData(this.ad);
        this.viCD.setOilLensData(this.old);
        this.viCD.setChemicals(alChemicalRevised);
        this.viCD.setStatisticalDistribution(this.sDistribution);
        this.viCD.setParameterChoices(this.pc);
        this.viCD.setRawInput(this.ri);
        this.viCD.setRunIdentifier(this.runID);
        this.viCD.setLinkedParameters(this.lp);
        this.viCD.setUnsupportedUnit(this.bUnsupportedUnit);
        this.viCD.setUnsupportedUnit(this.uc.getBooleanUnsupportedUnit());
        this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), this.getKnownErrorOutput());
        this.viCD.setCanRunModel();
        fr.close();
    }

    private void addToErrorOutput(String sErrorOutput2) {
    }

    private void readDistribution(String sGroup, String[] lineArray) throws IOException {
        String currentLine;
        String sFileNameDistribution = lineArray[3];
        String sParameterName = lineArray[1];
        FileReader frDistribution = new FileReader(sFileNameDistribution);
        BufferedReader brDistribution = new BufferedReader(frDistribution);
        while ((currentLine = brDistribution.readLine()) != null) {
            lineArray = currentLine.split(",", 0);
            String key = lineArray[0];
            String key2 = lineArray[1];
            String key3 = lineArray[2];
            String sConvertedOutput = "";
            if (!key2.equalsIgnoreCase("Distribution") || !key2.equalsIgnoreCase("Begin")) {
                if (key2.equalsIgnoreCase("name")) {
                    String sDistributionName = lineArray[2];
                    if (sGroup.equalsIgnoreCase("Building")) {
                        this.bld.addDataSource(sParameterName, sFileNameDistribution, sDistributionName);
                    }
                } else if (!(key2.equalsIgnoreCase("Distribution") && key2.equalsIgnoreCase("end") || !key3.equalsIgnoreCase("variable"))) {
                    sConvertedOutput = this.addData(this.bld, key2, lineArray);
                    this.saveRawInput(this.nc.s_VALUEINPUT, lineArray);
                }
            }
            String sOut = this.arrayToString(lineArray);
            this.flOutputFile.logMessage(String.valueOf(sOut) + sConvertedOutput + this.sErrorOutput);
            this.addToKnownErrorOutput(this.sErrorOutput);
        }
    }

    private void linkParameters(String sGroup, String[] lineArray) {
        double dMultiplier = 1.0;
        try {
            dMultiplier = Double.parseDouble(lineArray[5]);
        }
        catch (Exception e) {
            dMultiplier = 1.0;
        }
        this.lp.addLinkedParameter(lineArray[1], lineArray[3], lineArray[4], dMultiplier);
    }

    private void setLinkedParameterDistributions() {
        int iNumber = this.lp.getLinkedParameterCount();
        int i = 0;
        while (i < iNumber) {
            String sIndependent = this.lp.getIndependentParameter(i);
            String sDependent = this.lp.getDependentParameter(i);
            double dMultiplier = this.lp.getMultiplier(i);
            block1: for (StatisticalDistribution sd1 : this.sDistribution) {
                if (!sd1.getName().equalsIgnoreCase(sIndependent)) continue;
                for (StatisticalDistribution sd : this.sDistribution) {
                    if (!sd.getName().equalsIgnoreCase(sDependent)) continue;
                    int iCount = sd1.getNumberOfPointsDefiningDistribution();
                    sd.setNumberOfPointsDefiningDistribution(sd1.getNumberOfPointsDefiningDistribution());
                    double[] dValue = sd1.getConcentrationDistribution();
                    int j = 0;
                    while (j < iCount) {
                        dValue[j] = dValue[j] * dMultiplier;
                        ++j;
                    }
                    sd.setConcentrationDistribution(dValue);
                    sd.setFrequencyDistribution(sd1.getFrequencyDistribution());
                    sd.setCalculationUnit(sd1.getCalculationUnit());
                    sd.setCurrentRandomValue(sd1.getCurrentRandomValue());
                    sd.setChosenFrequency(sd1.getChosenFrequency());
                    break block1;
                }
            }
            ++i;
        }
    }

    private String addData(VIDataAbstractClass pvisData, String key2, String[] lineArray) {
        String sOutput = "";
        String sOutputError = "";
        String key3 = lineArray[2];
        if (key3.equalsIgnoreCase("Constant")) {
            sOutput = this.addDataItem(pvisData, key2, lineArray[3], lineArray[4], this.getUnitType(key2));
            if (sOutput.equalsIgnoreCase(" ")) {
                sOutputError = ", Error in Input: " + this.arrayToString(lineArray);
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Error in Input," + this.arrayToString(lineArray));
            }
        } else if (key3.equalsIgnoreCase("Variable") && (sOutput = this.addDataItemVariable(pvisData, key2, lineArray[3], lineArray[4], this.getUnitType(key2), lineArray[5])).equalsIgnoreCase(" ")) {
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Error in Input," + this.arrayToString(lineArray));
        }
        this.addToKnownErrorOutput(sOutputError);
        return String.valueOf(sOutput) + sOutputError;
    }

    private String addDataItemVariable(VIDataAbstractClass vid, String key2m, String sValue, String sUnit, String sUnitType, String sFrequency) {
        String sReturn = "";
        OutputDigits od = new OutputDigits();
        double value = Double.parseDouble(sValue) * this.uc.getUCF(sUnitType, sUnit);
        double frequency = Double.parseDouble(sFrequency);
        vid.setCumulativeDistributionValue(key2m, value, frequency);
        vid.setCurrentRandomValue(key2m, 0.5);
        vid.setCalculationUnit(key2m, this.uc.getModelUnit(sUnitType));
        od.setValue(value);
        sReturn = ", converted to: " + od.num2String() + " " + this.uc.getModelUnit(sUnitType);
        return sReturn;
    }

    private String addDataItem(VIDataAbstractClass bvd, String key2m, String sValue, String sUnit, String sUnitType) {
        String sReturn = "";
        OutputDigits od = new OutputDigits();
        double value = Double.parseDouble(sValue) * this.uc.getUCF(sUnitType, sUnit);
        bvd.setStatisticalDistributionValue(key2m, value);
        bvd.setCurrentRandomValue(key2m, 0.5);
        bvd.setCalculationUnit(key2m, this.uc.getModelUnit(sUnitType));
        od.setValue(value);
        sReturn = ", converted to " + od.num2String() + " " + this.uc.getModelUnit(sUnitType);
        return sReturn;
    }

    private void saveRawInput(String sRawInputType, String[] sRawInputLine) {
        RawInputLine ril = new RawInputLine(this.uc, this.viCD);
        ril.setRawInputLine(sRawInputType, sRawInputLine);
        this.ri.add(ril);
    }

    private void collectStatisticalDistributions() {
        for (StatisticalDistribution sd : this.bld.getStatisticalDistribution()) {
            this.sDistribution.add(sd);
        }
        for (StatisticalDistribution sd : this.vz.getStatisticalDistribution()) {
            this.sDistribution.add(sd);
        }
        for (StatisticalDistribution sd : this.oxygen.getStatisticalDistribution()) {
            this.sDistribution.add(sd);
        }
        for (StatisticalDistribution sd : this.old.getStatisticalDistribution()) {
            this.sDistribution.add(sd);
        }
        for (Chemical c : this.alChemical) {
            for (StatisticalDistribution sd : c.getStatisticalDistribution()) {
                if (!c.getIsUsedInSimulation()) continue;
                this.sDistribution.add(sd);
            }
        }
    }

    private String getUnitType(String sInputName) {
        RawInputLine ril = new RawInputLine(this.viCD);
        String sReturn = ril.getUnitType(sInputName, this.uc);
        return sReturn;
    }

    private String arrayToString(String[] lineArray) {
        String sOut = "";
        int i = 0;
        while (i < lineArray.length) {
            sOut = String.valueOf(sOut) + lineArray[i] + ", ";
            ++i;
        }
        return sOut;
    }

    public void addToKnownErrorOutput(String sError) {
        boolean bAdd = false;
        int i = 0;
        while (i < sError.length()) {
            if (sError.charAt(i) != ' ') {
                bAdd = true;
                break;
            }
            ++i;
        }
        if (bAdd) {
            this.sErrorOutput = String.valueOf(this.sErrorOutput) + sError + "\n";
        }
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setWriteFile(boolean b) {
        this.bWriteFile = b;
    }

    public void setFileModifier(FileModifier fm) {
        this.fm = fm;
    }

    public ArrayList<StatisticalDistribution> getStatisticalDistributions() {
        return this.sDistribution;
    }

    public VIControlData getVIControlData() {
        return this.viCD;
    }

    public boolean getBooleanUnsupportedUnit() {
        return this.bUnsupportedUnit;
    }

    public String getOutputFileName() {
        return this.sOutputFileName;
    }

    public String getOutputFileTime() {
        return this.sOutputFileTime;
    }

    public String getMessageFileName() {
        return this.sMessageFileName;
    }

    public UnitConverter getUnitConverter() {
        return this.uc;
    }

    public FileLogger getFileLogger() {
        return this.flOutputFile;
    }

    public String getKnownErrorOutput() {
        return this.sErrorOutput;
    }

    public void setOutputFileTime(String sOutputFileTime) {
        this.sOutputFileTime = sOutputFileTime;
    }
}

