/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.outputProcessor;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import numerics.sort.MergeSort;
import pviScreen.dataContainers.VIControlData;
import statistics.DataFitting;
import statistics.Histogram;
import statistics.Interval;
import statistics.ResistantStatisticalMeasures;
import statistics.ResultsColumn;
import util.FileLogger;
import util.Stripper;
import util.UnitConverter;

public class OutputProcessor {
    private String sName;
    private String sResultFileName;
    private String sResultsText;
    private String sHeadingText;
    private String sSortedResultsText;
    private String sModelName;
    private FileLogger fl;
    private FileLogger flOut;
    private int iFrequencyInterval;
    private int iCount;
    private int iColumns;
    private String sColumnToFind;
    private String sHeadOne;
    private String sHeadTwo;
    private int iNumberOfResults;
    private String[] sString;
    private double[] dValue;
    private double[] dValue2;
    private double[] dFreq;
    private Integer[] iIndex;
    private ArrayList<ResultsColumn> alResultsColumn;
    private ArrayList<ResultsColumn> alResultsColumnSubordinateLessThanCriterion;
    private ArrayList<ResultsColumn> alResultsColumnSubordinateGreaterThanCriterion;
    private String[] sHeadingExtension;
    private ResistantStatisticalMeasures rsm;
    private Histogram histogram;
    private DataFitting df;
    private String sFittingType;
    private double dFittingA;
    private double dFittingB;
    private VIControlData viCD;
    private UnitConverter uc;
    String[] sNameChemical = new String[50];
    double[] dRiskConcentration = new double[50];
    double[] dRiskLevel = new double[50];
    double[] dRfC = new double[50];
    int iNumberChemical = 0;
    int iNumberRisk = 0;
    int iNumberRiskLevel = 0;
    int iNumberRfC = 0;
    String sOutputRiskConcentrationUnit = "";
    private Stripper stripper;
    private boolean bInput;
    boolean bHistogramMade;
    ArrayList<Interval> alLogInterval;

    public void initial() {
        this.sName = "OP";
        this.flOut = new FileLogger();
        this.stripper = new Stripper();
        this.sHeadingExtension = new String[2];
        this.bInput = true;
        this.sHeadingText = "Heading";
        this.sResultsText = "Result";
        this.sSortedResultsText = "Sorted Result";
    }

    public void readSortedResultsToArrayList() throws IOException {
        String currentLine;
        this.alResultsColumn = new ArrayList();
        Stripper s = new Stripper();
        FileReader fr = new FileReader(this.sResultFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        this.sString = new String[this.iNumberOfResults];
        this.iCount = 0;
        this.iNumberChemical = 0;
        this.iNumberRisk = 0;
        while ((currentLine = br.readLine()) != null) {
            ResultsColumn rc;
            int i;
            String key = "";
            String key2 = "";
            lineArray = currentLine.split(",", 0);
            key = lineArray[0];
            if (key.equalsIgnoreCase("Risk Level")) {
                key2 = lineArray[1];
                if (key2.equalsIgnoreCase("Chemical")) {
                    i = 2;
                    while (i < lineArray.length) {
                        if (!lineArray[i].equals("")) {
                            this.sNameChemical[this.iNumberChemical] = lineArray[i];
                            ++this.iNumberChemical;
                        }
                        ++i;
                    }
                } else if (key2.equalsIgnoreCase("value")) {
                    i = 2;
                    while (i < lineArray.length) {
                        if (!lineArray[i].equals("")) {
                            try {
                                this.dRiskConcentration[this.iNumberRisk] = Double.parseDouble(lineArray[i]);
                                ++this.iNumberRisk;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                } else if (key2.equalsIgnoreCase("risk level")) {
                    i = 2;
                    while (i < lineArray.length) {
                        if (!lineArray[i].equals("")) {
                            try {
                                this.dRiskLevel[this.iNumberRiskLevel] = Double.parseDouble(lineArray[i]);
                                ++this.iNumberRiskLevel;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                } else if (key2.equalsIgnoreCase("RfC")) {
                    i = 2;
                    while (i < lineArray.length) {
                        if (!lineArray[i].equals("")) {
                            try {
                                this.dRfC[this.iNumberRfC] = Double.parseDouble(lineArray[i]);
                                ++this.iNumberRfC;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
            }
            this.bInput = true;
            if (!s.areTheyTheSame(this.sSortedResultsText, key)) continue;
            this.iColumns = lineArray.length;
            if (this.iColumns <= 1) continue;
            key2 = lineArray[1];
            if (key2.equalsIgnoreCase(this.sHeadingText)) {
                this.sHeadOne = currentLine;
                i = 0;
                while (i < lineArray.length) {
                    boolean bDataColumn = true;
                    if (s.areTheyEqual(lineArray[i], this.sHeadingText) || s.areTheyEqual(lineArray[i], this.sSortedResultsText) || s.areTheyEqual(lineArray[i], "")) {
                        bDataColumn = false;
                    }
                    rc = new ResultsColumn();
                    rc.setNumber(this.iNumberOfResults);
                    rc.initializeArray();
                    rc.setControlCharacter("*ValidData*");
                    rc.setHeading(lineArray[i]);
                    if (s.areTheyEqual(lineArray[i], "**")) {
                        this.bInput = false;
                    }
                    rc.setInputOrNot(this.bInput);
                    rc.setIsThisADoubleDataColumn(bDataColumn);
                    this.alResultsColumn.add(rc);
                    ++i;
                }
                continue;
            }
            if (key2.equalsIgnoreCase("Unit/Count")) {
                this.sHeadTwo = currentLine;
                i = 0;
                while (i < lineArray.length) {
                    boolean bDataColumn = true;
                    if (lineArray[i].equalsIgnoreCase(this.sHeadingText) || lineArray[i].equalsIgnoreCase("Unit/Count")) {
                        bDataColumn = false;
                        rc = this.alResultsColumn.get(i);
                        rc.setInputOrNot(false);
                    }
                    rc = this.alResultsColumn.get(i);
                    rc.setIsThisADoubleDataColumn(bDataColumn);
                    rc.setUnit(lineArray[i]);
                    ++i;
                }
                continue;
            }
            ++this.iCount;
            i = 0;
            while (i < lineArray.length) {
                double dValue;
                boolean bDataColumn = true;
                rc = this.alResultsColumn.get(i);
                try {
                    dValue = Double.parseDouble(lineArray[i]);
                    bDataColumn = true;
                }
                catch (Exception e) {
                    bDataColumn = false;
                    dValue = 0.0;
                }
                rc.setIsThisADoubleDataColumn(bDataColumn);
                rc.addValue(dValue, "*ValidData*", lineArray[i]);
                ++i;
            }
        }
        this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "validating data");
        for (ResultsColumn rc : this.alResultsColumn) {
            rc.validateData();
        }
        fr.close();
    }

    public void writeStatistics() {
        double dTemp;
        int iCount = 0;
        String sOut = "";
        String sOut2 = "";
        this.sOutputRiskConcentrationUnit = this.uc.getOutputNameFromType("RiskConcentration");
        this.flOut.logMessage("");
        this.flOut.logMessage("Simple Statistics: " + this.sModelName);
        this.writeHeadings("Simple Statistics:");
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getMin() + "," : (iCount == 0 ? "Minimum " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getAverage() + "," : (iCount == 0 ? "Average " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getMax() + "," : (iCount == 0 ? "Maximum " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        this.flOut.logMessage("");
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getRange() + "," : (iCount == 0 ? "Range " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        sOut2 = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            if (rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn()) {
                dTemp = rc.getVariance();
                sOut = String.valueOf(sOut) + dTemp + ",";
                sOut2 = dTemp > 0.0 ? String.valueOf(sOut2) + Math.sqrt(dTemp) + "," : String.valueOf(sOut2) + "--" + ",";
            } else if (iCount == 0) {
                sOut = "Variance " + this.sModelName + ",";
                sOut2 = "Standard Deviation " + this.sModelName + ",";
            } else {
                sOut = String.valueOf(sOut) + ",";
                sOut2 = String.valueOf(sOut2) + ",";
            }
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        this.flOut.logMessage(sOut2);
        this.flOut.logMessage("");
        this.flOut.logMessage("Resistant Statistical Measures " + this.sModelName);
        this.writeHeadings("Resistant Statistical Measures ");
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getRSMMinimum() + "," : (iCount == 0 ? "Minimum " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.get5thPercentile() + "," : (iCount == 0 ? "5th percentile " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getFirstQuartile() + "," : (iCount == 0 ? "First Quartile " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        sOut2 = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            if (rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn()) {
                dTemp = rc.getMedian();
                sOut = String.valueOf(sOut) + dTemp + ",";
                sOut2 = String.valueOf(sOut2) + (dTemp += 1.5 * rc.getInterQuartileRange()) + ",";
            } else if (iCount == 0) {
                sOut = "Median " + this.sModelName + ",";
                sOut2 = "Median + 1/2 InterQuartile Range " + this.sModelName + ",";
            } else {
                sOut = String.valueOf(sOut) + ",";
                sOut2 = String.valueOf(sOut2) + ",";
            }
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getThirdQuartile() + "," : (iCount == 0 ? "Third Quartile " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        this.flOut.logMessage(sOut2);
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.get95thPercentile() + "," : (iCount == 0 ? "95th percentile " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getRSMMaximum() + "," : (iCount == 0 ? "Maximum " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
        iCount = 0;
        sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + rc.getInterQuartileRange() + "," : (iCount == 0 ? "Inter-quartile Range " + this.sModelName + "," : String.valueOf(sOut) + ",");
            ++iCount;
        }
        this.flOut.logMessage(sOut);
    }

    public void generateStatistics() {
        for (ResultsColumn rc : this.alResultsColumn) {
            this.generateStatistics(rc);
        }
    }

    private void generateStatistics(ResultsColumn rc) {
        double dMin = 1.0E20;
        double dMax = -1.0E20;
        if (rc.getIsThisADoubleDataColumn()) {
            double[] dValue = rc.getAllDoubleValues();
            int iNumber = dValue.length;
            double dSumX = 0.0;
            double dSumXX = 0.0;
            int i = 0;
            while (i < iNumber) {
                if (dValue[i] < dMin) {
                    dMin = dValue[i];
                }
                if (dValue[i] > dMax) {
                    dMax = dValue[i];
                }
                dSumX += dValue[i];
                dSumXX += dValue[i] * dValue[i];
                ++i;
            }
            double dAverage = dSumX / (double)iNumber;
            double dVar = 1.0 / (double)(iNumber - 1) * (dSumXX - 1.0 / (double)iNumber * dSumX * dSumX);
            rc.setAverage(dAverage);
            rc.setMin(dMin);
            rc.setMax(dMax);
            rc.setRange(dMax - dMin);
            rc.setVariance(dVar);
            this.rsm.setData(dValue);
            this.rsm.determineMeasures();
            rc.set5thPercentile(this.rsm.get5thPercentile());
            rc.setFirstQuartile(this.rsm.getFirstQuartile());
            rc.setMedian(this.rsm.getMedian());
            rc.setThirdQuartile(this.rsm.getThirdQuartile());
            rc.set95thPercentile(this.rsm.get95thPercentile());
            rc.setInterQuartileRange(this.rsm.getInterQuartileRange());
            rc.setRSMMinimum(this.rsm.getMinimum());
            rc.setRSMMaximum(this.rsm.getMaximum());
            rc.setHaveTheStatisticsBeenCalculated(true);
        } else {
            rc.setHaveTheStatisticsBeenCalculated(false);
        }
    }

    public void openOutputFile(String sOutFileName) {
        this.flOut = new FileLogger(sOutFileName);
    }

    public void sortResults() {
        boolean bChanged = true;
        while (bChanged) {
            bChanged = false;
            int i = 0;
            while (i < this.iCount - 1) {
                if (this.dValue[i] > this.dValue[i + 1]) {
                    double dValueTemp = this.dValue[i + 1];
                    int iValueTemp = this.iIndex[i + 1];
                    String sValueTemp = this.sString[i + 1];
                    this.dValue[i + 1] = this.dValue[i];
                    this.iIndex[i + 1] = this.iIndex[i];
                    this.sString[i + 1] = this.sString[i];
                    this.dValue[i] = dValueTemp;
                    this.iIndex[i] = iValueTemp;
                    this.sString[i] = sValueTemp;
                    bChanged = true;
                }
                ++i;
            }
        }
        this.assignFrequencies();
    }

    public void sortByMergeSortAndReWrite() {
        MergeSort ms = new MergeSort();
        ms.sortWithDependentString(this.dValue, this.sString);
        this.flOut.logMessage("Sorted Result");
        this.flOut.logMessage("");
        this.writeHeadings("Sorted");
        int i = this.sString.length - 1;
        while (i >= 0) {
            this.flOut.logMessage("Sorted " + this.sString[i]);
            --i;
        }
        this.flOut.logMessage(" ");
    }

    public void sortResultsColumn(String sResultsColumnName) {
        double[] dValidated = null;
        int iCount = 0;
        boolean bAllDouble = false;
        MergeSort ms = new MergeSort();
        for (ResultsColumn rc : this.alResultsColumn) {
            if (!rc.getHeading().equalsIgnoreCase(sResultsColumnName)) continue;
            dValidated = rc.getValidatedData();
            break;
        }
        iCount = dValidated.length;
        dValidated = ms.sort(dValidated);
        double[] dValidatedFrequency = this.assignRankings(dValidated);
        for (ResultsColumn rc : this.alResultsColumn) {
            if (!rc.getHeading().equalsIgnoreCase(sResultsColumnName)) continue;
            rc.setAllDoubleValues(dValidated);
            rc.setCumulativeDistributionFrequencies(dValidatedFrequency);
            rc.setIsTheCumulativeDistributionSet(true);
            break;
        }
    }

    private double[] assignRankings(double[] dValue) {
        double[] dFreq = new double[dValue.length];
        int i = 0;
        while (i < dValue.length) {
            dFreq[i] = (double)i / (double)(dValue.length - 1);
            ++i;
        }
        return dFreq;
    }

    public void sortCoupledResults() {
        boolean bChanged = true;
        while (bChanged) {
            bChanged = false;
            int i = 0;
            while (i < this.iCount - 1) {
                if (this.dValue[i] > this.dValue[i + 1]) {
                    double dValueTempOne = this.dValue[i + 1];
                    double dValueTempTwo = this.dValue2[i + 1];
                    int iValueTemp = this.iIndex[i + 1];
                    String sValueTemp = this.sString[i + 1];
                    this.dValue[i + 1] = this.dValue[i];
                    this.dValue2[i + 1] = this.dValue2[i];
                    this.iIndex[i + 1] = this.iIndex[i];
                    this.sString[i + 1] = this.sString[i];
                    this.dValue[i] = dValueTempOne;
                    this.dValue2[i] = dValueTempTwo;
                    this.iIndex[i] = iValueTemp;
                    this.sString[i] = sValueTemp;
                    bChanged = true;
                }
                ++i;
            }
        }
        this.assignFrequencies();
    }

    private void assignFrequencies() {
        int i = 0;
        while (i < this.dValue.length) {
            this.dFreq[i] = (double)i / (double)(this.dValue.length - 1);
            ++i;
        }
    }

    public void fitCoupledResults(String sFittingType) {
        this.sFittingType = sFittingType;
        this.df = new DataFitting();
        this.df.setFittingType(sFittingType);
        this.df.setXValues(this.dValue);
        this.df.setYValues(this.dValue2);
        this.df.setNumberOfValues(this.iCount);
        this.df.fitTheData();
        this.dFittingA = this.df.getIntercept();
        this.dFittingB = this.df.getSlope();
    }

    public void writeCoupledFittingResults() {
        this.df.writeResults(this.flOut);
    }

    public void makeCoupledHistogram() {
        this.histogram = new Histogram();
        this.histogram.setOutputUnit(this.sOutputRiskConcentrationUnit);
        this.histogram.setOutputText(this.sModelName);
        this.histogram.setIntervalFrequency(this.iFrequencyInterval);
        this.histogram.setCoupledHistogram(true);
        this.histogram.setCoupledHistogramData(this.dValue2);
        this.histogram.generateHistogram(this.dValue, this.iCount);
    }

    public void makeHistogram() {
        this.histogram = new Histogram();
        this.histogram.setOutputUnit(this.sOutputRiskConcentrationUnit);
        this.histogram.setOutputText("Histogram " + this.sModelName);
        this.histogram.setIntervalFrequency(this.iFrequencyInterval);
        this.histogram.generateHistogram(this.dValue, this.iCount);
    }

    public void makeLogHistogram() {
        this.histogram = new Histogram();
        this.histogram.setOutputUnit(this.sOutputRiskConcentrationUnit);
        this.histogram.generateLogHistogram(this.dValue, this.iCount);
    }

    public void makeResultsColumnLogHistogram(String sResultsColumnName, String sHistogramChemical) {
        double[] dValidated = null;
        for (ResultsColumn rc : this.alResultsColumn) {
            if (!rc.getHeading().equalsIgnoreCase(sResultsColumnName)) continue;
            dValidated = rc.getAllDoubleValues();
            break;
        }
        this.histogram = new Histogram();
        this.histogram.setHistogramChemical(sHistogramChemical);
        this.histogram.setIntervalFrequency(this.iFrequencyInterval);
        this.histogram.setOutputUnit(this.sOutputRiskConcentrationUnit);
        this.histogram.determineLevelOfConcern(sHistogramChemical, this.dRiskConcentration, this.dRiskLevel, this.sNameChemical, this.iNumberRisk);
        this.histogram.determineRfC(sHistogramChemical, this.dRfC, this.sNameChemical, this.iNumberRfC);
        this.histogram.makeLogHistogram(dValidated, dValidated.length);
    }

    public void writeSortedData() {
        this.flOut.logMessage("");
        this.flOut.logMessage(this.sHeadOne);
        this.flOut.logMessage(this.sHeadTwo);
        int i = 0;
        while (i < this.iCount) {
            this.flOut.logMessage(this.sString[i]);
            ++i;
        }
    }

    public void characterizeAndWriteData() throws IOException {
        String sOut = "";
        for (ResultsColumn rc : this.alResultsColumn) {
            rc.characterizeData();
        }
        this.flOut.logMessage("");
        this.flOut.logMessage("Characterized " + this.sHeadOne);
        this.flOut.logMessage("Characterized " + this.sHeadTwo);
        int i = 0;
        while (i < this.iNumberOfResults) {
            sOut = "Characterized " + this.sModelName + " Result,";
            for (ResultsColumn rc : this.alResultsColumn) {
                if (rc.getInputOrNot()) {
                    if (!rc.getIsThisADoubleDataColumn()) continue;
                    sOut = String.valueOf(sOut) + rc.getCharacterizedValue(i) + ",";
                    continue;
                }
                sOut = String.valueOf(sOut) + rc.getOriginalValue(i) + ",";
            }
            this.flOut.logMessage(sOut);
            ++i;
        }
        this.flOut.logMessage("");
    }

    public void writeHistogram(String sTitle) {
        this.histogram.setHistogramTitle(sTitle);
        this.histogram.setOutputText("Histogram " + this.sModelName);
        this.histogram.writeLinearHistogram(this.flOut);
    }

    public void writeLogHistogram(String sTitle) {
        this.histogram.setHistogramTitle(sTitle);
        this.histogram.setOutputText("Histogram " + this.sModelName);
        this.histogram.writeLogHistogram(this.flOut);
    }

    public void writeCoupledHistogram(String sTitle) {
        this.histogram.setHistogramTitle(sTitle);
        this.histogram.setOutputText("Histogram " + this.sModelName);
        this.histogram.writeCoupledHistgram(this.flOut);
    }

    private void setRiskLevels(Histogram h) {
        String sHChemical = h.getHistogramChemical();
        int i = 0;
        while (i < this.sNameChemical.length) {
            if (this.sNameChemical[i].equalsIgnoreCase(sHChemical)) {
                h.setLevelOfConcern(this.dRiskConcentration[i]);
                break;
            }
            ++i;
        }
    }

    public void writeCumulativeFrequencyCurve() {
        this.flOut.logMessage("");
        this.flOut.logMessage("Cumulative Frequency Curve");
        this.flOut.logMessage("Cumulative Frequency, Value");
        int i = 0;
        while (i < this.dValue.length) {
            this.flOut.logMessage(String.valueOf(this.dFreq[i]) + "," + this.dValue[i]);
            ++i;
        }
    }

    public void writeRunFileInformation(String sModelName, String sInputDataFile, String sOutputFileName) {
        this.sModelName = sModelName;
        this.flOut.logMessage("");
        this.flOut.logMessage("Control,Statistics");
        this.flOut.logMessage(sModelName);
        this.flOut.logMessage("Post-Processed Output:  Statistics-Histograms-Cumulative Probabilities");
        this.flOut.logMessage("Input Data File: " + sInputDataFile);
        this.flOut.logMessage("Output File Name: " + sOutputFileName);
        this.flOut.logMessage("");
    }

    public void readResults(String sColumnToFind) throws IOException {
        String currentLine;
        FileReader fr = new FileReader(this.sResultFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        this.sString = new String[this.iNumberOfResults];
        this.dValue = new double[this.iNumberOfResults];
        this.iIndex = new Integer[this.iNumberOfResults];
        this.dFreq = new double[this.iNumberOfResults];
        this.sColumnToFind = sColumnToFind;
        int iResultColumn = 0;
        this.iColumns = 0;
        this.iCount = 0;
        block0: while ((currentLine = br.readLine()) != null) {
            String key = "";
            String key2 = "";
            lineArray = currentLine.split(",", 0);
            key = lineArray[0];
            if (!key.equalsIgnoreCase(this.sResultsText)) continue;
            this.iColumns = lineArray.length;
            key2 = lineArray[1];
            if (key2.equalsIgnoreCase(this.sHeadingText)) {
                this.sHeadOne = currentLine;
                int i = 2;
                while (i < lineArray.length) {
                    if (lineArray[i].equalsIgnoreCase(sColumnToFind)) {
                        iResultColumn = i;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (key2.equalsIgnoreCase("Unit/Count")) {
                this.sHeadTwo = currentLine;
                continue;
            }
            this.dValue[this.iCount] = Double.parseDouble(lineArray[iResultColumn]);
            this.iIndex[this.iCount] = Integer.parseInt(lineArray[1]);
            this.sString[this.iCount] = currentLine;
            ++this.iCount;
        }
        fr.close();
    }

    public void readCoupledResults(String sColumnToFindOne, String sColumnToFindTwo) throws IOException {
        String currentLine;
        FileReader fr = new FileReader(this.sResultFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        this.sString = new String[this.iNumberOfResults];
        this.dValue = new double[this.iNumberOfResults];
        this.dValue2 = new double[this.iNumberOfResults];
        this.iIndex = new Integer[this.iNumberOfResults];
        this.dFreq = new double[this.iNumberOfResults];
        this.sColumnToFind = sColumnToFindOne;
        int iResultColumnOne = 0;
        int iResultColumnTwo = 0;
        this.iColumns = 0;
        this.iCount = 0;
        while ((currentLine = br.readLine()) != null) {
            String key = "";
            String key2 = "";
            lineArray = currentLine.split(",", 0);
            key = lineArray[0];
            if (!key.equalsIgnoreCase(this.sResultsText)) continue;
            this.iColumns = lineArray.length;
            key2 = lineArray[1];
            if (key2.equalsIgnoreCase(this.sHeadingText)) {
                this.sHeadOne = currentLine;
                int i = 2;
                while (i < lineArray.length) {
                    if (lineArray[i].equalsIgnoreCase(sColumnToFindOne)) {
                        iResultColumnOne = i;
                    }
                    if (lineArray[i].equalsIgnoreCase(sColumnToFindTwo)) {
                        iResultColumnTwo = i;
                    }
                    ++i;
                }
                continue;
            }
            if (key2.equalsIgnoreCase("Unit/Count")) {
                this.sHeadTwo = currentLine;
                continue;
            }
            this.dValue[this.iCount] = Double.parseDouble(lineArray[iResultColumnOne]);
            this.dValue2[this.iCount] = Double.parseDouble(lineArray[iResultColumnTwo]);
            this.iIndex[this.iCount] = Integer.parseInt(lineArray[1]);
            this.sString[this.iCount] = currentLine;
            ++this.iCount;
        }
        fr.close();
    }

    public void setUpSubordinateResultsColumns(String sHeadingForSelectionCriterion, double dSelectionCriterion) {
        int i;
        String sSubordinateName;
        int iSelectionCriterionColumn = 0;
        int iColumnNumber = 0;
        iColumnNumber = this.alResultsColumn.size();
        int i2 = 0;
        while (i2 < iColumnNumber) {
            ResultsColumn rc = this.alResultsColumn.get(i2);
            if (this.stripper.areTheyEqual(rc.getHeading(), sHeadingForSelectionCriterion)) {
                iSelectionCriterionColumn = i2;
                break;
            }
            ++i2;
        }
        ResultsColumn rcSelection = this.alResultsColumn.get(iSelectionCriterionColumn);
        double[] dSelectionValues = rcSelection.getAllDoubleValues();
        this.sHeadingExtension[0] = " Values with " + rcSelection.getHeading() + " <" + Double.toString(dSelectionCriterion);
        for (ResultsColumn rcc : this.alResultsColumn) {
            sSubordinateName = String.valueOf(rcc.getHeading()) + this.sHeadingExtension[0];
            rcc.addSubordinateResult(this.sHeadingExtension[0]);
            i = 0;
            while (i < dSelectionValues.length) {
                if (dSelectionValues[i] <= dSelectionCriterion) {
                    rcc.addToSubordinateResultColumn(this.sHeadingExtension[0], rcc.getValue(i));
                }
                ++i;
            }
        }
        this.sHeadingExtension[1] = " Values with " + rcSelection.getHeading() + " >" + Double.toString(dSelectionCriterion);
        for (ResultsColumn rcc : this.alResultsColumn) {
            sSubordinateName = String.valueOf(rcc.getHeading()) + this.sHeadingExtension[1];
            rcc.addSubordinateResult(this.sHeadingExtension[1]);
            i = 0;
            while (i < dSelectionValues.length) {
                if (dSelectionValues[i] > dSelectionCriterion) {
                    rcc.addToSubordinateResultColumn(this.sHeadingExtension[1], rcc.getValue(i));
                }
                ++i;
            }
        }
        for (ResultsColumn rcc : this.alResultsColumn) {
            ArrayList<ResultsColumn> alRC = rcc.getSubordinateResultsColumns();
            for (ResultsColumn rccc : alRC) {
                this.generateStatistics(rccc);
            }
        }
    }

    public void writeStatisticsForSubordinateResultsColumns() {
        int iCount = 0;
        String sOut = "";
        String sOut2 = "";
        double dTemp = 0.0;
        ArrayList<Object> alRCSubordinate = new ArrayList();
        this.flOut.logMessage("");
        this.flOut.logMessage("Simple Statistics: " + this.sModelName);
        Stripper s = new Stripper();
        int j = 0;
        while (j < 2) {
            this.flOut.logMessage(this.sHeadingExtension[j]);
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getMin() + "," : (iCount == 0 ? "Minimum " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getAverage() + "," : (iCount == 0 ? "Average " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getMax() + "," : (iCount == 0 ? "Maximum " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            this.flOut.logMessage("");
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getRange() + "," : (iCount == 0 ? "Range " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    if (rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn()) {
                        dTemp = resultsColumn.getVariance();
                        sOut = String.valueOf(sOut) + dTemp + ",";
                        sOut2 = String.valueOf(sOut2) + Math.sqrt(dTemp) + ",";
                    } else if (iCount == 0) {
                        sOut = "Variance " + this.sModelName + ",";
                        sOut2 = "Standard Deviation " + this.sModelName + ",";
                    } else {
                        sOut = String.valueOf(sOut) + ",";
                        sOut2 = String.valueOf(sOut2) + ",";
                    }
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            this.flOut.logMessage(sOut2);
            sOut = "";
            sOut2 = "";
            iCount = 0;
            this.flOut.logMessage("");
            this.flOut.logMessage("Resistant Statistical Measures " + this.sModelName);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getMin() + "," : (iCount == 0 ? "Minimum " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.get5thPercentile() + "," : (iCount == 0 ? "5th Percentile " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getFirstQuartile() + "," : (iCount == 0 ? "First Quartile " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    if (rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn()) {
                        dTemp = resultsColumn.getMedian();
                        sOut = String.valueOf(sOut) + dTemp + ",";
                        sOut2 = String.valueOf(sOut2) + (dTemp += 1.5 * resultsColumn.getInterQuartileRange()) + ",";
                    } else if (iCount == 0) {
                        sOut = "Median " + this.sModelName + ",";
                        sOut2 = "Median + 1/2 InterQuartile Range " + this.sModelName + ",";
                    } else {
                        sOut = String.valueOf(sOut) + ",";
                        sOut2 = String.valueOf(sOut2) + ",";
                    }
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getThirdQuartile() + "," : (iCount == 0 ? "Third Quartile " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            this.flOut.logMessage(sOut2);
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.get95thPercentile() + "," : (iCount == 0 ? "95th Percentile " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getMax() + "," : (iCount == 0 ? "Maximum " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            iCount = 0;
            sOut = "";
            for (ResultsColumn rc : this.alResultsColumn) {
                alRCSubordinate = rc.getSubordinateResultsColumns();
                for (ResultsColumn resultsColumn : alRCSubordinate) {
                    if (!s.areTheyEqual(this.sHeadingExtension[j], resultsColumn.getHeadingExtension())) continue;
                    sOut = rc.getHaveTheStatisticsBeenSet() && rc.getIsThisADoubleDataColumn() ? String.valueOf(sOut) + resultsColumn.getInterQuartileRange() + "," : (iCount == 0 ? "Inter Quartile Range " + this.sModelName + "," : String.valueOf(sOut) + ",");
                    ++iCount;
                }
            }
            this.flOut.logMessage(sOut);
            this.flOut.logMessage("");
            sOut = "";
            sOut2 = "";
            iCount = 0;
            ++j;
        }
    }

    public void writeHeadings(String sMessage) {
        this.flOut.logMessage(String.valueOf(sMessage) + " " + this.sHeadOne);
        this.flOut.logMessage(String.valueOf(sMessage) + " " + this.sHeadTwo);
    }

    public void setIntervalFrequency(int iIntervalFrequency) {
        this.iFrequencyInterval = iIntervalFrequency;
    }

    public void setResultsFileName(String sOutputFileName) {
        this.sResultFileName = sOutputFileName;
    }

    public void setNumberOfResults(int iNumber) {
        this.iNumberOfResults = iNumber;
    }

    public void setNumberOfFrequencyDistributionIntervals(int iFrequencyInterval) {
        this.iFrequencyInterval = iFrequencyInterval;
    }

    public void setResistantStatisticalMeasures(ResistantStatisticalMeasures rsm) {
        this.rsm = rsm;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public void setHeadingText(String sHeadingText) {
        this.sHeadingText = sHeadingText;
    }

    public void setResultsText(String sResultsText) {
        this.sResultsText = sResultsText;
    }

    public void setSortedResultsText(String sSortedResultsText) {
        this.sSortedResultsText = sSortedResultsText;
    }

    public int getIntervalFrequency() {
        return this.iFrequencyInterval;
    }

    public double[] getDistributionValues() {
        return this.dValue;
    }

    public FileLogger getOutputFileLogger() {
        return this.flOut;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public String getHeadingOne() {
        return this.sHeadOne;
    }

    public String getHeadingTwo() {
        return this.sHeadTwo;
    }

    public String getOutputRiskConcentrationUnit() {
        return this.sOutputRiskConcentrationUnit;
    }
}

