/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.outputWriters;

import java.util.ArrayList;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.VIControlData;
import pviScreen.outputWriters.OutputWriter;
import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.UnitConverter;

public class JEMOutputWriter
extends OutputWriter {
    private FileLogger flJEM;
    private VIControlData viCD;
    private UnitConverter uc;
    private ArrayList<StatisticalDistribution> alSDistribution;
    private ArrayList<Chemical> alChemical;

    public JEMOutputWriter() {
        this.sModelName = "JEM";
    }

    @Override
    public void writeOutputHeadingsBase(String sColumnOneHeading) {
        this.sOutputHeading = "";
        this.addToOutputHeading(String.valueOf(sColumnOneHeading) + "," + this.sModelName + " Heading");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(", " + sd.getParentName() + " " + sd.getName());
        }
        this.addToOutputHeading(",**");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getName() + " Indoor Air Concentration" + "," + c.getName() + " Source Concentration");
        }
        this.flJEM.logMessage(this.sOutputHeading);
        this.sOutputHeadingUnit = "";
        this.addToOutputHeadingUnit(String.valueOf(sColumnOneHeading) + "," + "Unit/Count");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeadingUnit(",  (" + sd.getCalculationUnit() + ") ");
        }
        String sLengthUnit = "";
        UnitConverter uc = this.viCD.getUnitConverter();
        this.addToOutputHeadingUnit(",**");
        String sConcentrationUnit = uc.getOutputNameFromType("concentrationAir");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeadingUnit(", (" + sConcentrationUnit + "),  (" + sConcentrationUnit + ")");
        }
        this.flJEM.logMessage(this.sOutputHeadingUnit);
    }

    public void writeOutputHeadingsRisk() {
        this.sOutputHeading = "";
        this.addToOutputHeading("JEM Risk Level,Heading");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",**");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading(",Risk Level,");
        }
        this.flJEM.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading("Risk Level,Chemical");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",**");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getName() + ",");
        }
        this.flJEM.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading("Result,Value");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(", " + sd.getParentName() + " " + sd.getName());
        }
        this.sOutputHeading = "";
        this.addToOutputHeading("Risk Level,Value");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",**");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getCancerRisk() + ",");
        }
        this.flJEM.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading("JEM Risk Level,Risk Level");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",**");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getCancerRisk() + ",");
        }
        this.flJEM.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading("Risk Level,Rfc");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",**");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getReferenceConcentration() * this.uc.getOutputUCFFromType("RiskConcentration") + ",");
        }
        this.flJEM.logMessage(this.sOutputHeading);
    }

    public void writeResultBase(String sFirstColumnText, int iIteration) {
        String sTemp = "";
        double dUCF = 1.0;
        this.addToOutputString(",**");
        dUCF = this.uc.getOutputUCFFromType("concentrationAir");
        sTemp = "";
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            sTemp = "";
            sTemp = ", " + c.getIndoorAirConcentration() * dUCF + ", " + c.getSourceConcentration() * dUCF;
            this.addToOutputString(sTemp);
        }
        this.flJEM.logMessage(String.valueOf(sFirstColumnText) + "," + iIteration + this.sOutput);
    }

    public void setFileLogger(FileLogger flJEM) {
        this.flJEM = flJEM;
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public void setUnitCnverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setAllChemical(ArrayList<Chemical> alChemical) {
        this.alChemical = alChemical;
    }

    public void setAllStatisticalDistribution(ArrayList<StatisticalDistribution> alSDistribution) {
        this.alSDistribution = alSDistribution;
    }
}

