/*
 * Decompiled with CFR 0.152.
 */
package pviScreen.outputWriters;

import java.util.ArrayList;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.VIControlData;
import pviScreen.outputWriters.OutputWriter;
import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.UnitConverter;

public class PVIScreenOutputWriter
extends OutputWriter {
    private FileLogger fl;
    private VIControlData viCD;
    private UnitConverter uc;
    private ArrayList<StatisticalDistribution> alSDistribution;
    private ArrayList<Chemical> alChemical;

    public PVIScreenOutputWriter() {
        this.sModelName = "PVIScreen";
    }

    public void writeOutputHeadingsRisk() {
        this.sOutputHeading = "";
        this.addToOutputHeading("Risk Level,Heading");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",,");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading(",Risk Level,,,");
        }
        this.fl.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading("Risk Level,Chemical");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",,");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getName() + "," + "," + ",");
        }
        this.fl.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading("Result,Value");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(", " + sd.getParentName() + " " + sd.getName());
        }
        this.sOutputHeading = "";
        this.addToOutputHeading("Risk Level,Value");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",,");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getIUR() * this.uc.getOutputUCFFromType("RiskConcentration") + "," + "," + ",");
        }
        this.fl.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading("Risk Level,Risk Level");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",,");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getCancerRisk() + "," + "," + ",");
        }
        this.fl.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading("Risk Level,Rfc");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",");
        }
        this.addToOutputHeading(",,");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        this.addToOutputHeading(",");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getNonCancerRisk() + "," + "," + ",");
        }
        this.fl.logMessage(this.sOutputHeading);
    }

    @Override
    public void writeOutputHeadingsBase(String sColumnOneHeading) {
        this.sOutputHeading = "";
        this.addToOutputHeading(String.valueOf(sColumnOneHeading) + "," + this.sModelName + " Heading");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(", " + sd.getParentName() + " " + sd.getName());
        }
        this.addToOutputHeading(",**,Aerobic Zone Thickness From Concentration");
        this.addToOutputHeading(",Aerobic Zone Thickness From Flux");
        this.addToOutputHeading(",Aerobic Zone Thickness");
        this.addToOutputHeading(",Result from: ");
        this.addToOutputHeading(",TransitionPointDepth");
        this.addToOutputHeading(",**");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading("," + c.getName() + " Indoor Air Concentration" + "," + c.getName() + " Foundation Concentration" + "," + c.getName() + " Transition Point Concentration" + "," + c.getName() + " Source Concentration");
        }
        this.fl.logMessage(this.sOutputHeading);
        this.sOutputHeading = "";
        this.addToOutputHeading(String.valueOf(sColumnOneHeading) + "," + "Unit/Count");
        for (StatisticalDistribution sd : this.alSDistribution) {
            if (!sd.getIsThisDistributionActuallyUsed()) continue;
            this.addToOutputHeading(",  (" + sd.getCalculationUnit() + ") ");
        }
        String sLengthUnit = "";
        UnitConverter uc = this.viCD.getUnitConverter();
        sLengthUnit = uc.getOutputNameFromType("length");
        this.addToOutputHeading(",** ");
        this.addToOutputHeading(", (" + sLengthUnit + "), (" + sLengthUnit + " ), (" + sLengthUnit + " ), ** ,(" + sLengthUnit + " )");
        this.addToOutputHeading(",** ");
        String sConcentrationUnit = uc.getOutputNameFromType("concentrationAir");
        for (Chemical c : this.alChemical) {
            if (!c.getIsUsedInSimulation()) continue;
            this.addToOutputHeading(", (" + sConcentrationUnit + "), (" + sConcentrationUnit + "), (" + sConcentrationUnit + "), (" + sConcentrationUnit + ")");
        }
        this.fl.logMessage(this.sOutputHeading);
    }

    public void logMessage() {
        this.fl.logMessage(this.sOutput);
    }

    public String getOutputString() {
        return this.sOutput;
    }

    public void setFileLogger(FileLogger fl) {
        this.fl = fl;
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public void setUnitCnverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setAllChemical(ArrayList<Chemical> alChemical) {
        this.alChemical = alChemical;
    }

    public void setAllStatisticalDistribution(ArrayList<StatisticalDistribution> alSDistribution) {
        this.alSDistribution = alSDistribution;
    }
}

