/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import util.FileLogger;

public class DataFitting {
    private int iCount;
    private double[] dX;
    private double[] dY;
    private double dFittedA;
    private double dFittedB;
    private double dSumSquaredError;
    private double dS2;
    private double dR2;
    private String sFittingType;

    public void fitTheData() {
        if (this.sFittingType.equalsIgnoreCase("linear")) {
            this.linearFit();
        } else if (this.sFittingType.equalsIgnoreCase("power")) {
            this.powerFit();
        }
    }

    public void powerFit() {
        double[] dLogX = new double[this.iCount];
        double[] dLogY = new double[this.iCount];
        int i = 0;
        while (i < this.iCount) {
            dLogX[i] = Math.log10(this.dX[i]);
            dLogY[i] = Math.log10(this.dY[i]);
            ++i;
        }
        this.linearFit(dLogX, dLogY);
        this.dFittedA = Math.pow(10.0, this.dFittedA);
    }

    public void linearFit() {
        this.linearFit(this.dX, this.dY);
    }

    public void linearFit(double[] dX, double[] dY) {
        double dSumX = 0.0;
        double dSumY = 0.0;
        double dSumXX = 0.0;
        double dSumYY = 0.0;
        double dSumXY = 0.0;
        int i = 0;
        while (i < this.iCount) {
            dSumX += dX[i];
            dSumY += dY[i];
            dSumXY += dX[i] * dY[i];
            dSumXX += dX[i] * dX[i];
            dSumYY += dY[i] * dY[i];
            ++i;
        }
        double dXBar = dSumX / (double)this.iCount;
        double dYBar = dSumY / (double)this.iCount;
        double dSXX = dSumXX - dSumX * dSumX / (double)this.iCount;
        double dSYY = dSumYY - dSumY * dSumY / (double)this.iCount;
        double dSXY = dSumXY - dSumX * dSumY / (double)this.iCount;
        this.dFittedB = dSXY / dSXX;
        this.dFittedA = dYBar - this.dFittedB * dXBar;
        this.dSumSquaredError = dSYY - dSXY * (dSXY / dSXX);
        this.dS2 = this.dSumSquaredError / (double)(this.iCount - 2);
        this.dR2 = 1.0 - this.dSumSquaredError / dSYY;
    }

    public double getEstimate(double dValue) {
        double dFY = 0.0;
        if (this.sFittingType.equalsIgnoreCase("linear")) {
            dFY = this.dFittedA + this.dFittedB * dValue;
        } else if (this.sFittingType.equalsIgnoreCase("power")) {
            dFY = this.dFittedA * Math.pow(dValue, this.dFittedB);
        }
        return dFY;
    }

    public void writeResults(FileLogger flOut) {
        flOut.logMessage("");
        flOut.logMessage("Fitted Results");
        flOut.logMessage("Fitted Results,Independent Variable,Dependent Variable,Fitted Result,Error");
        int i = 0;
        while (i < this.iCount) {
            double dFittedY = this.getEstimate(this.dX[i]);
            double dError = this.dY[i] - dFittedY;
            flOut.logMessage("Fitted Results," + this.dX[i] + "," + this.dY[i] + "," + dFittedY + "," + dError);
            ++i;
        }
        flOut.logMessage("Fitted Results," + this.getFittingType() + ",parameter a:," + this.getIntercept() + ",parameter b:," + this.getSlope() + ",goodness of fit (r2)," + this.getGoodnessOfFit());
    }

    public void setXValues(double[] dX) {
        this.dX = dX;
    }

    public void setYValues(double[] dY) {
        this.dY = dY;
    }

    public void setNumberOfValues(int iCount) {
        this.iCount = iCount;
    }

    public void setFittingType(String sFittingType) {
        this.sFittingType = sFittingType;
    }

    public double getIntercept() {
        return this.dFittedA;
    }

    public double getSlope() {
        return this.dFittedB;
    }

    public double getEstimateOfErrorVariance() {
        return this.dS2;
    }

    public double getGoodnessOfFit() {
        return this.dR2;
    }

    public String getFittingType() {
        return this.sFittingType;
    }
}

