/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import statistics.Interval;
import statistics.RiskContainer;
import util.FileLogger;
import util.Stripper;

public class Histogram {
    private boolean bHistogramMade = false;
    private int iTotalCount;
    private int iFrequencyInterval;
    private String sHistogramTitle;
    private String sHistogramChemical = "";
    private String sHistogramOutputText = "Histogram";
    private double dHistogramLevelOfConcern = 0.0;
    private String sOutputUnit = "";
    private double dHistogramLevelOfConcernCumulativeFrequency;
    private boolean bLevelOfConcernSet = false;
    private double dRiskLevel = 0.0;
    private double dRfC;
    private boolean bRfCSet = false;
    ArrayList<Interval> alInterval = new ArrayList();
    private double[] dValue2;
    private boolean bCoupled = false;
    private boolean bHistogramLinear = true;
    private RiskContainer rc;
    double dV;
    double dMinHistogram;
    double dMaxHistogram;
    double dHighestProbabilityDensity = -1.0;

    public void generateHistogram(double[] dValue, int iCount) {
        this.bHistogramMade = false;
        this.bHistogramLinear = true;
        this.alInterval = new ArrayList();
        this.dMinHistogram = 1.0E20;
        this.dMaxHistogram = -1.0E20;
        int i = 0;
        while (i < iCount) {
            if (dValue[i] > this.dMaxHistogram) {
                this.dMaxHistogram = dValue[i];
            }
            if (dValue[i] < this.dMinHistogram) {
                this.dMinHistogram = dValue[i];
            }
            ++i;
        }
        this.dMaxHistogram *= 1.000001;
        this.dMinHistogram *= 0.999999;
        this.dV = (this.dMaxHistogram - this.dMinHistogram) / (double)(this.iFrequencyInterval - 1);
        if (this.dV > 0.0) {
            this.bHistogramMade = true;
            double d1 = this.dMinHistogram;
            double d2 = d1 + this.dV;
            int i2 = 0;
            while (i2 < this.iFrequencyInterval) {
                Interval interval = new Interval();
                interval.setLowPointValue(d1);
                interval.setMidPointValue(0.5 * (d2 + d1));
                interval.setHighPointValue(d2);
                int j = 0;
                while (j < iCount) {
                    if (d1 <= dValue[j] && dValue[j] <= d2) {
                        interval.addOneMember(j);
                        if (this.bCoupled) {
                            interval.addCoupledDataPoint(this.dValue2[j]);
                        }
                    }
                    ++j;
                }
                if (this.bCoupled) {
                    interval.generateCoupledHistogram();
                }
                this.alInterval.add(interval);
                d1 = d2;
                d2 = d1 + this.dV;
                ++i2;
            }
        } else if (iCount > 0) {
            Interval interval = new Interval();
            interval.setLowPointValue(this.dMinHistogram);
            interval.setMidPointValue(0.5 * (this.dMaxHistogram + this.dMinHistogram));
            interval.setHighPointValue(this.dMaxHistogram);
            interval.addOneMember(0);
            this.alInterval.add(interval);
        }
        this.iTotalCount = 0;
        for (Interval i3 : this.alInterval) {
            this.iTotalCount += i3.getIntervalCount();
        }
    }

    public void generateLogHistogram(double[] dValue, int iCount) {
        this.bHistogramMade = false;
        this.bHistogramLinear = false;
        double[] dLogLevel = new double[]{-4.5, -4.25, -4.0, -3.75, -3.5, -3.25, -3.0, -2.75, -2.5, -2.25, -2.0, -1.75, -1.5, -1.25, -1.0, -0.75, -0.5, -0.25, 0.0, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.25, 2.5, 2.75, 3.0, 3.25, 3.5, 3.75, 4.0, 4.25, 4.5, 4.75, 5.0, 5.25, 5.5, 5.75, 6.0};
        this.bHistogramMade = true;
        this.iFrequencyInterval = dLogLevel.length;
        int iInterval = dLogLevel.length;
        Interval interval = new Interval();
        interval.setMidPointValue(dLogLevel[0] + 0.5 * dLogLevel[0]);
        interval.setHighPointValue(dLogLevel[1]);
        int j = 0;
        while (j < dValue.length) {
            if (Math.log10(dValue[j]) < dLogLevel[0]) {
                interval.addOneMember(j);
            }
            ++j;
        }
        this.alInterval.add(interval);
        int i = 1;
        while (i < iInterval - 1) {
            interval = new Interval();
            interval.setLowPointValue(dLogLevel[i]);
            interval.setMidPointValue(0.5 * (dLogLevel[i] + dLogLevel[i + 1]));
            interval.setHighPointValue(dLogLevel[i + 1]);
            int j2 = 0;
            while (j2 < dValue.length) {
                double dLogVal = Math.log10(dValue[j2]);
                if (dLogLevel[i] <= dLogVal && dLogVal <= dLogLevel[i + 1]) {
                    interval.addOneMember(j2);
                }
                ++j2;
            }
            this.alInterval.add(interval);
            ++i;
        }
        interval = new Interval();
        interval.setLowPointValue(dLogLevel[iInterval - 1]);
        interval.setMidPointValue(1.5 * dLogLevel[iInterval - 1]);
        j = 0;
        while (j < dValue.length) {
            if (Math.log10(dValue[j]) > dLogLevel[iInterval - 1]) {
                interval.addOneMember(j);
            }
            ++j;
        }
        this.alInterval.add(interval);
        this.iTotalCount = 0;
        for (Interval i2 : this.alInterval) {
            this.iTotalCount += i2.getIntervalCount();
        }
    }

    public void writeLinearHistogram(FileLogger flOut) {
        this.writeHistogram(flOut, this.alInterval, "Linear Intervals");
    }

    public void writeLogHistogram(FileLogger flOut) {
        this.writeHistogram(flOut, this.alInterval, "Log Intervals");
    }

    public void writeHistogram(FileLogger flOut, ArrayList<Interval> alHistogram, String sMessage) {
        flOut.logMessage("");
        double dSum = 0.0;
        flOut.logMessage(String.valueOf(this.sHistogramOutputText) + ",begin");
        flOut.logMessage(String.valueOf(this.sHistogramOutputText) + "," + this.getHistogramTitle() + "," + sMessage + ",histogram beginning point," + this.dMinHistogram + ",histogram ending," + this.dMaxHistogram + ",histogram interval," + this.dV);
        flOut.logMessage(String.valueOf(this.sHistogramOutputText) + ", Valid?," + this.bHistogramMade);
        flOut.logMessage(String.valueOf(this.sHistogramOutputText) + ",chemical," + this.sHistogramChemical + "," + this.dHistogramLevelOfConcern + "," + this.sOutputUnit + "," + this.dRiskLevel + "," + this.dRfC + "," + this.sOutputUnit);
        flOut.logMessage(String.valueOf(this.sHistogramOutputText) + ",Interval Begining Point,Interval Mid-Point, Interval EndingPoint,  Count, Frequency, Cumulative Frequency");
        for (Interval i : alHistogram) {
            double dLowPointValue = i.getLowPointValue();
            double dMidPointValue = i.getMidPointValue();
            double dHighPointValue = i.getHighPointValue();
            int iCount = i.getIntervalCount();
            double dFrequency = (double)iCount / (double)this.iTotalCount;
            dSum += dFrequency;
            if (iCount <= 0) continue;
            flOut.logMessage(String.valueOf(this.sHistogramOutputText) + "," + dLowPointValue + "," + dMidPointValue + "," + dHighPointValue + "," + iCount + "," + dFrequency + "," + dSum);
        }
        flOut.logMessage(String.valueOf(this.sHistogramOutputText) + ",,,Total Count," + this.iTotalCount + ",Total Cumulative Frequency," + dSum);
        flOut.logMessage(String.valueOf(this.sHistogramOutputText) + ",end");
    }

    public void writeCoupledHistgram(FileLogger flOut) {
        flOut.logMessage("");
        double dSum = 0.0;
        flOut.logMessage("Summary Coupled Histogram for:, " + this.getHistogramTitle());
        flOut.logMessage("Summary Coupled Histogram, Interval Mid-Point, Count, Frequency, Cumulative Frequency,Coupled Histograms,");
        ArrayList<Interval> alHistogram = this.getHistogramIntervals();
        for (Interval i : alHistogram) {
            double dMidPointValue = i.getMidPointValue();
            int iCount = i.getIntervalCount();
            double dFrequency = (double)iCount / (double)this.iTotalCount;
            dSum += dFrequency;
            Histogram h = i.getCoupledHistogram();
            ArrayList<Interval> alCoupledIntervals = h.getHistogramIntervals();
            double dSumCoupled = 0.0;
            String sOut = "";
            String sOut2 = "Summary Coupled Histogram,,,,,,";
            String sOut3 = "Summary Coupled Histogram,,,,,,";
            String sOut4 = "Summary Coupled Histogram,,,,,,";
            int iIntervalCount = 0;
            for (Interval iCoupled : alCoupledIntervals) {
                sOut = String.valueOf(sOut) + iCoupled.getMidPointValue() + ",";
                sOut2 = String.valueOf(sOut2) + iCoupled.getIntervalCount() + ",";
                int iCountCoupled = iCoupled.getIntervalCount();
                int iTotalCountCoupled = h.getTotalCount();
                double dFrequencyCoupled = (double)iCountCoupled / (double)iTotalCountCoupled;
                sOut3 = String.valueOf(sOut3);
                sOut3 = String.valueOf(sOut3) + dFrequencyCoupled + ",";
                sOut4 = String.valueOf(sOut4) + (dSumCoupled += dFrequencyCoupled) + ",";
                ++iIntervalCount;
            }
            if (iIntervalCount != 0) {
                if (iIntervalCount == 1) {
                    int j = 0;
                    while (j < h.getIntervalFrequency() - 1) {
                        sOut = String.valueOf(sOut) + ",";
                        sOut2 = String.valueOf(sOut2) + ",";
                        sOut3 = String.valueOf(sOut3) + ",";
                        sOut4 = String.valueOf(sOut4) + ",";
                        ++j;
                    }
                }
                sOut = String.valueOf(sOut) + "Intervals";
                sOut2 = String.valueOf(sOut2) + "Counts";
                sOut3 = String.valueOf(sOut3) + "Frequency";
                sOut4 = String.valueOf(sOut4) + "Cumulative Frequency";
            }
            flOut.logMessage("Summary Histogram," + dMidPointValue + "," + iCount + "," + dFrequency + "," + dSum + ",," + sOut);
            flOut.logMessage(sOut2);
            flOut.logMessage(sOut3);
            flOut.logMessage(sOut4);
        }
        flOut.logMessage("Summary Histogram,," + this.iTotalCount + ",," + dSum);
    }

    public void readHistogram(String sFilePathAndName, String sType, String sType2) throws IOException {
        boolean bHistogramOne = false;
        boolean bHistogramTwo = false;
        boolean bHistogramThree = false;
        boolean bHistogramFour = false;
        boolean bHistogramFive = false;
        boolean bHistogramSix = false;
        Stripper s = new Stripper();
        FileReader fr = new FileReader(sFilePathAndName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        String currentLine = br.readLine();
        lineArray = currentLine.split(",", 0);
        while ((currentLine = br.readLine()) != null) {
            lineArray = currentLine.split(",", 0);
            if (!s.areTheFirstWordsEqual(lineArray[0], "Histogram")) continue;
            if (bHistogramSix && s.removeCharacter(' ', lineArray[1]).equalsIgnoreCase("end")) {
                bHistogramOne = false;
                bHistogramTwo = false;
                bHistogramThree = false;
                bHistogramFour = false;
                bHistogramFive = false;
                return;
            }
            if (bHistogramFive && s.removeCharacter(' ', lineArray[1]) != "") {
                Interval i = new Interval();
                try {
                    i.setLowPointValue(Double.parseDouble(lineArray[1]));
                    i.setMidPointValue(Double.parseDouble(lineArray[2]));
                    i.setHighPointValue(Double.parseDouble(lineArray[3]));
                    i.setIntervalCount(Integer.parseInt(lineArray[4]));
                    i.setFrequency(Double.parseDouble(lineArray[5]));
                    i.setCumulativeFrequency(Double.parseDouble(lineArray[6]));
                    this.alInterval.add(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bHistogramSix = true;
                continue;
            }
            if (bHistogramFour) {
                bHistogramThree = false;
                bHistogramFour = false;
                bHistogramFive = true;
                continue;
            }
            if (bHistogramThree && lineArray[1].equalsIgnoreCase("chemical")) {
                this.sHistogramChemical = lineArray[2];
                try {
                    this.dHistogramLevelOfConcern = Double.parseDouble(lineArray[3]);
                    this.sOutputUnit = lineArray[4];
                    this.dRiskLevel = Double.parseDouble(lineArray[5]);
                    this.dRfC = Double.parseDouble(lineArray[6]);
                    this.bLevelOfConcernSet = true;
                    this.bRfCSet = true;
                }
                catch (Exception e) {
                    this.dHistogramLevelOfConcern = 0.0;
                    this.dRiskLevel = 0.0;
                    this.dRfC = 0.0;
                }
                bHistogramThree = false;
                bHistogramFour = true;
                continue;
            }
            if (bHistogramTwo && s.areTheyEqual("valid?", lineArray[1])) {
                try {
                    if (s.areTheyEqual("false", lineArray[2])) {
                        this.bHistogramMade = false;
                    } else if (s.areTheyEqual("true", lineArray[2])) {
                        this.bHistogramMade = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.bHistogramMade) {
                    bHistogramTwo = false;
                    bHistogramThree = true;
                    continue;
                }
                return;
            }
            if (bHistogramOne && s.removeCharacter(' ', lineArray[1]).equalsIgnoreCase(s.removeCharacter(' ', sType)) && s.removeCharacter(' ', lineArray[2]).equalsIgnoreCase(s.removeCharacter(' ', sType2))) {
                this.sHistogramTitle = lineArray[1];
                this.bHistogramLinear = sType2.equalsIgnoreCase("LinearIntervals");
                bHistogramTwo = true;
                bHistogramOne = false;
                continue;
            }
            if (!s.removeCharacter(' ', lineArray[1]).equalsIgnoreCase("begin")) continue;
            bHistogramOne = true;
        }
    }

    public void makeLogHistogram(double[] dValue, int iCount) {
        double[] dLogLevel = null;
        int iAdd = 0;
        boolean bNew = true;
        this.bHistogramMade = false;
        int i = 0;
        while (i < dValue.length) {
            if (Double.isNaN(dValue[i])) {
                return;
            }
            if (dValue[i] == 0.0) {
                ++iAdd;
            }
            ++i;
        }
        if (iAdd == dValue.length) {
            return;
        }
        if (bNew) {
            double xMin = 1.0E308;
            double xMax = 1.0E-308;
            int i2 = 0;
            while (i2 < dValue.length) {
                if (0.0 < dValue[i2] && dValue[i2] < xMin) {
                    xMin = dValue[i2];
                }
                if (dValue[i2] > xMax) {
                    xMax = dValue[i2];
                }
                ++i2;
            }
            double dLogIntervalLength = Math.log10(xMax) - Math.log10(xMin);
            double dLogIncrement = 0.25;
            dLogIncrement = dLogIntervalLength / 100.0;
            int iNumber = 1 + (int)(dLogIntervalLength / dLogIncrement);
            dLogLevel = new double[iNumber];
            dLogLevel[0] = Math.log10(xMin);
            int i3 = 1;
            while (i3 < iNumber) {
                dLogLevel[i3] = dLogLevel[i3 - 1] + dLogIncrement;
                ++i3;
            }
        }
        this.bHistogramMade = true;
        this.bHistogramLinear = false;
        int iInterval = dLogLevel.length;
        Interval interval = new Interval();
        interval.setLowPointValue((double)dLogLevel[0]);
        interval.setMidPointValue((double)(dLogLevel[0] + 0.5 * dLogLevel[0]));
        interval.setHighPointValue(1.5 * dLogLevel[0]);
        int j = 0;
        while (j < iCount) {
            if (Math.log10(dValue[j]) < dLogLevel[0]) {
                interval.addOneMember(j);
            }
            ++j;
        }
        this.alInterval.add(interval);
        int i4 = 1;
        while (i4 < iInterval - 1) {
            interval = new Interval();
            interval.setLowPointValue(dLogLevel[i4]);
            interval.setMidPointValue(0.5 * (dLogLevel[i4] + dLogLevel[i4 + 1]));
            interval.setHighPointValue(dLogLevel[i4 + 1]);
            int j2 = 0;
            while (j2 < iCount) {
                double dLogVal = Math.log10(dValue[j2]);
                if (dLogLevel[i4] < dLogVal && dLogVal <= dLogLevel[i4 + 1]) {
                    interval.addOneMember(j2);
                }
                ++j2;
            }
            this.alInterval.add(interval);
            ++i4;
        }
        if (iInterval > 3) {
            interval = new Interval();
            double dPreviousInterval = dLogLevel[iInterval - 2] - dLogLevel[iInterval - 3];
            interval.setLowPointValue(dLogLevel[iInterval - 1]);
            interval.setMidPointValue(dLogLevel[iInterval - 1] + 0.5 * dPreviousInterval);
            interval.setHighPointValue(dLogLevel[iInterval - 1] + 1.0 * dPreviousInterval);
            int j3 = 0;
            while (j3 < iCount) {
                if (Math.log10(dValue[j3]) > dLogLevel[iInterval - 1]) {
                    interval.addOneMember(j3);
                }
                ++j3;
            }
            this.alInterval.add(interval);
        }
        this.iTotalCount = 0;
        for (Interval i5 : this.alInterval) {
            this.iTotalCount += i5.getIntervalCount();
        }
    }

    public void determineLevelOfConcern(String sHistogramChemical, double[] dRiskConcentration, double[] dRiskValue, String[] sChemicalName, int iNumberRisk) {
        int i = 0;
        while (i < iNumberRisk) {
            if (sHistogramChemical.equalsIgnoreCase(sChemicalName[i])) {
                this.dHistogramLevelOfConcern = dRiskConcentration[i];
                this.dRiskLevel = dRiskValue[i];
                this.bLevelOfConcernSet = true;
                break;
            }
            ++i;
        }
    }

    public void determineRfC(String sHistogramChemical, double[] dRfC, String[] sChemicalName, int iNumberRfC) {
        int i = 0;
        while (i < iNumberRfC) {
            if (sHistogramChemical.equalsIgnoreCase(sChemicalName[i])) {
                this.dRfC = dRfC[i];
                this.bRfCSet = true;
                break;
            }
            ++i;
        }
    }

    public double getCumulativeProbability(double dConcentrationToCheck, boolean bNormalConcentrationUnit) {
        double dReturn = 0.0;
        double dLow = 0.0;
        double dCFLow = 0.0;
        double dHigh = 0.0;
        double dCFHigh = 0.0;
        double dLowOld = 0.0;
        double dCFLowOld = 0.0;
        double dLogLOC = dConcentrationToCheck;
        if (bNormalConcentrationUnit) {
            dLogLOC = Math.log10(dConcentrationToCheck);
        }
        if (dLogLOC < this.alInterval.get(0).getMidPointValue()) {
            return 0.0;
        }
        if (dLogLOC > this.alInterval.get(this.alInterval.size() - 1).getMidPointValue()) {
            return 1.0;
        }
        for (Interval i : this.alInterval) {
            dLow = i.getMidPointValue();
            dCFLow = i.getCumulativeFrequency();
            if (dLow > dLogLOC) {
                dHigh = i.getMidPointValue();
                dCFHigh = i.getCumulativeFrequency();
                dLow = dLowOld;
                dCFLow = dCFLowOld;
                break;
            }
            dLowOld = dLow;
            dCFLowOld = dCFLow;
        }
        if (dLow <= dLogLOC && dLogLOC <= dHigh) {
            double sl = (dCFHigh - dCFLow) / (dHigh - dLow);
            double dCumulativeFrequency = dCFLow + (dLogLOC - dLow) * sl;
            if (dCumulativeFrequency < 1.0E-5) {
                dCumulativeFrequency = 0.0;
            } else if (dCumulativeFrequency > 1.0) {
                dCumulativeFrequency = 1.0;
            }
            dReturn = dCumulativeFrequency;
        }
        return dReturn;
    }

    public void determineCumulativeProbabilityOfTheLevelOfConcern(double dConcentrationToCheck) {
        double dLow = 0.0;
        double dCFLow = 0.0;
        double dHigh = 0.0;
        double dCFHigh = 0.0;
        double dLowOld = 0.0;
        double dCFLowOld = 0.0;
        double dLogLOC = Math.log10(dConcentrationToCheck);
        if (dLogLOC < this.alInterval.get(0).getMidPointValue()) {
            this.dHistogramLevelOfConcernCumulativeFrequency = 0.0;
            return;
        }
        if (dLogLOC > this.alInterval.get(this.alInterval.size() - 1).getMidPointValue()) {
            this.dHistogramLevelOfConcernCumulativeFrequency = 1.0;
            return;
        }
        for (Interval i : this.alInterval) {
            dLow = i.getMidPointValue();
            dCFLow = i.getCumulativeFrequency();
            if (dLow > dLogLOC) {
                dHigh = i.getMidPointValue();
                dCFHigh = i.getCumulativeFrequency();
                dLow = dLowOld;
                dCFLow = dCFLowOld;
                break;
            }
            dLowOld = dLow;
            dCFLowOld = dCFLow;
        }
        if (dLow <= dLogLOC && dLogLOC <= dHigh) {
            double sl = (dCFHigh - dCFLow) / (dHigh - dLow);
            double dCumulativeFrequency = dCFLow + (dLogLOC - dLow) * sl;
            if (dCumulativeFrequency < 1.0E-5) {
                dCumulativeFrequency = 0.0;
            } else if (dCumulativeFrequency > 1.0) {
                dCumulativeFrequency = 1.0;
            }
            this.dHistogramLevelOfConcernCumulativeFrequency = dCumulativeFrequency;
        }
    }

    public double getIntervalWithHighestProbabilityDensity() {
        int iTotalCount = 0;
        int iCount = 0;
        this.dHighestProbabilityDensity = 0.0;
        double dMaxInterval = 0.0;
        for (Interval i : this.alInterval) {
            iCount = i.getIntervalCount();
            iTotalCount += i.getIntervalCount();
        }
        double dFrequency = 0.0;
        for (Interval i : this.alInterval) {
            iCount = i.getIntervalCount();
            dFrequency = (double)iCount / (double)iTotalCount;
            if (!(dFrequency >= this.dHighestProbabilityDensity)) continue;
            this.dHighestProbabilityDensity = dFrequency;
            dMaxInterval = i.getMidPointValue();
        }
        return dMaxInterval;
    }

    public double getValueForCumulativeFrequency(double dFrequency) {
        double dValue = 0.0;
        int iInterval = this.alInterval.size();
        if (iInterval > 0) {
            Interval iFirst = this.alInterval.get(0);
            Interval iLast = this.alInterval.get(iInterval - 1);
            double dFreq0 = iFirst.getCumulativeFrequency();
            double dFreqN = iLast.getCumulativeFrequency();
            if (dFrequency < dFreq0) {
                dValue = iFirst.getMidPointValue();
            } else if (dFrequency > dFreqN) {
                dValue = iLast.getMidPointValue();
            } else {
                int i = 0;
                while (i < iInterval - 1) {
                    Interval interval1 = this.alInterval.get(i);
                    Interval interval2 = this.alInterval.get(i + 1);
                    double dFreq1 = interval1.getCumulativeFrequency();
                    double dFreq2 = interval2.getCumulativeFrequency();
                    if (dFreq1 <= dFrequency && dFrequency <= dFreq2) {
                        double dConc1 = interval1.getMidPointValue();
                        double dConc2 = interval2.getMidPointValue();
                        dValue = dConc1 + (dFrequency - dFreq1) * (dConc2 - dConc1) / (dFreq2 - dFreq1);
                        break;
                    }
                    ++i;
                }
            }
        }
        return dValue;
    }

    public void setIntervalFrequency(int iFrequencyInterval) {
        this.iFrequencyInterval = iFrequencyInterval;
    }

    public void setHistogramTitle(String sHistogramTitle) {
        this.sHistogramTitle = sHistogramTitle;
    }

    public void setHistogramChemical(String sHistogramChemical) {
        this.sHistogramChemical = sHistogramChemical;
    }

    public void setOutputText(String sHistogramOutputText) {
        this.sHistogramOutputText = sHistogramOutputText;
    }

    public void setRiskLevel(double dRiskLevel) {
        this.dRiskLevel = dRiskLevel;
    }

    public void setLevelOfConcern(double dHistogramLevelOfConcern) {
        this.dHistogramLevelOfConcern = dHistogramLevelOfConcern;
        this.bLevelOfConcernSet = true;
    }

    public void setCoupledHistogram(boolean bCoupled) {
        this.bCoupled = bCoupled;
    }

    public void setCoupledHistogramData(double[] dValue2) {
        this.dValue2 = dValue2;
    }

    public void setOutputUnit(String s) {
        this.sOutputUnit = s;
    }

    public void setRiskContainer(RiskContainer rc) {
        this.rc = rc;
    }

    public int getIntervalFrequency() {
        return this.iFrequencyInterval;
    }

    public boolean getIsHistogramMake() {
        return this.bHistogramMade;
    }

    public ArrayList<Interval> getHistogramIntervals() {
        return this.alInterval;
    }

    public String getHistogramTitle() {
        return this.sHistogramTitle;
    }

    public String getHistogramChemical() {
        return this.sHistogramChemical;
    }

    public double getLevelOfConcern() {
        return this.dHistogramLevelOfConcern;
    }

    public boolean getLevelOfConcernSet() {
        return this.bLevelOfConcernSet;
    }

    public int getTotalCount() {
        return this.iTotalCount;
    }

    public double getHistogramLevelOfConcernCumulativeFrequency() {
        return this.dHistogramLevelOfConcernCumulativeFrequency;
    }

    public double getRiskLevel() {
        return this.dRiskLevel;
    }

    public double getRfC() {
        return this.dRfC;
    }

    public String getOutputUnit() {
        return this.sOutputUnit;
    }

    public boolean doesHistogramExist() {
        return this.bHistogramMade;
    }

    public double getHighestProbabilityDensity() {
        return this.dHighestProbabilityDensity;
    }
}

