/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import numerics.bisection.DiscreteBisection;
import util.FileLogger;

public class ResistantStatisticalMeasures {
    private String sName = "RSM";
    double[] dX;
    double dMedian;
    double dMinimum;
    double dMaximum;
    double dFirstQuartile;
    double dThirdQuartile;
    double dInterQuartileRange;
    double d5thPercentile;
    double d95thPercentile;
    int iMedian;
    private FileLogger fl;

    public void determineMeasures() {
        this.clear();
        this.sort();
        this.findMinMax();
        this.findMedian();
        this.findFirstQuartile();
        this.findThirdQuartile();
        this.findInterQuartileRange();
        this.find5thPercentile();
        this.find95thPercentile();
    }

    public void sort() {
        boolean bChanged = true;
        while (bChanged) {
            bChanged = false;
            int i = 0;
            while (i < this.dX.length - 1) {
                if (this.dX[i] > this.dX[i + 1]) {
                    double dValueTemp = this.dX[i + 1];
                    this.dX[i + 1] = this.dX[i];
                    this.dX[i] = dValueTemp;
                    bChanged = true;
                }
                ++i;
            }
        }
    }

    public void findMedian() {
        this.dMedian = this.calculateMedian(this.dX);
    }

    public double calculateMedian(double[] dX) {
        int iCount = dX.length;
        boolean bEven = this.isEven(iCount);
        double dMedianInternal = bEven ? 0.5 * (dX[iCount / 2 - 1] + dX[iCount / 2]) : dX[(iCount - 1) / 2];
        return dMedianInternal;
    }

    public void findFirstQuartile() {
        int iLength = this.dX.length;
        boolean bIsEven = this.isEven(iLength);
        int iEnd = bIsEven ? iLength / 2 - 1 : (iLength - 1) / 2 - 1;
        double[] dTemp = new double[iEnd + 1];
        int i = 0;
        while (i < iEnd + 1) {
            dTemp[i] = this.dX[i];
            ++i;
        }
        this.dFirstQuartile = this.calculateMedian(dTemp);
    }

    public void findThirdQuartile() {
        int iLength = this.dX.length;
        boolean bIsEven = this.isEven(iLength);
        int iBegin = bIsEven ? iLength / 2 : (iLength - 1) / 2 + 1;
        int iDimension = iLength - iBegin;
        double[] dTemp = new double[iDimension];
        int i = iBegin;
        while (i < iLength) {
            dTemp[i - iBegin] = this.dX[i];
            ++i;
        }
        this.dThirdQuartile = this.calculateMedian(dTemp);
    }

    public void findInterQuartileRange() {
        this.dInterQuartileRange = this.dThirdQuartile - this.dFirstQuartile;
    }

    public void find5thPercentile() {
        this.d5thPercentile = this.findPercentile(5.0);
    }

    public void find95thPercentile() {
        this.d95thPercentile = this.findPercentile(95.0);
    }

    public double findPercentile(double dPercentile) {
        DiscreteBisection db = new DiscreteBisection();
        double[] dFrequency = new double[this.dX.length];
        int i = 0;
        while (i < dFrequency.length) {
            dFrequency[i] = (double)i / (double)dFrequency.length;
            ++i;
        }
        db.setDiscreteBisectableArray(dFrequency);
        db.setValue(dPercentile / 100.0);
        db.bisect();
        int iSolution = db.getIndexOfSolution();
        return this.dX[++iSolution];
    }

    public void findMinMax() {
        this.dMinimum = 1.0E200;
        this.dMaximum = -1.0E200;
        int i = 0;
        while (i < this.dX.length) {
            if (this.dX[i] < this.dMinimum) {
                this.dMinimum = this.dX[i];
            }
            if (this.dX[i] > this.dMaximum) {
                this.dMaximum = this.dX[i];
            }
            ++i;
        }
    }

    private boolean isEven(int iNumber) {
        double dTest = 0.5 * (double)iNumber;
        int iTest = iNumber / 2;
        double dTolerance = 1.0E-4;
        return !(dTest - (double)iTest > dTolerance);
    }

    public void clear() {
        this.d5thPercentile = 0.0;
        this.d95thPercentile = 0.0;
        this.dMinimum = 0.0;
        this.dMaximum = 0.0;
        this.dMedian = 0.0;
        this.dFirstQuartile = 0.0;
        this.dThirdQuartile = 0.0;
        this.dInterQuartileRange = 0.0;
    }

    public void writeResistantMeasuresOutput() {
        this.fl.logMessage("");
        String sOut = "Resistant Statistical Measures Output";
        this.fl.logMessage(sOut);
        String sOutput = String.valueOf(sOut) + ",Minimum,";
        sOutput = String.valueOf(sOutput) + this.dMinimum;
        this.fl.logMessage(sOutput);
        sOutput = String.valueOf(sOut) + ",5th Percentile,";
        sOutput = String.valueOf(sOutput) + this.d5thPercentile;
        this.fl.logMessage(sOutput);
        sOutput = String.valueOf(sOut) + ",Median - 1.5 InterQuartileRange,";
        double dOut = this.dMedian - 1.5 * this.dInterQuartileRange;
        sOutput = String.valueOf(sOutput) + dOut;
        sOutput = String.valueOf(sOut) + ",First Quartile/25th Percentile,";
        sOutput = String.valueOf(sOutput) + this.dFirstQuartile;
        this.fl.logMessage(sOutput);
        sOutput = String.valueOf(sOut) + ",Median,";
        sOutput = String.valueOf(sOutput) + this.dMedian;
        this.fl.logMessage(sOutput);
        sOutput = String.valueOf(sOut) + ",Third Quartile/75th Percentile,";
        sOutput = String.valueOf(sOutput) + this.dThirdQuartile;
        this.fl.logMessage(sOutput);
        sOutput = String.valueOf(sOut) + ",Median + 1.5 InterQuartileRange,";
        dOut = this.dMedian + 1.5 * this.dInterQuartileRange;
        sOutput = String.valueOf(sOutput) + dOut;
        this.fl.logMessage(sOutput);
        sOutput = String.valueOf(sOut) + ",95th Percentile,";
        sOutput = String.valueOf(sOutput) + this.d95thPercentile;
        this.fl.logMessage(sOutput);
        sOutput = String.valueOf(sOut) + ",Maximum,";
        sOutput = String.valueOf(sOutput) + this.dMaximum;
        this.fl.logMessage(sOutput);
    }

    public void setData(double[] dX) {
        this.dX = dX;
    }

    public void setFileLogger(FileLogger fl) {
        this.fl = fl;
    }

    public double getMaximum() {
        return this.dMaximum;
    }

    public double getMinimum() {
        return this.dMinimum;
    }

    public double getMedian() {
        return this.dMedian;
    }

    public double getFirstQuartile() {
        return this.dFirstQuartile;
    }

    public double getThirdQuartile() {
        return this.dThirdQuartile;
    }

    public double getInterQuartileRange() {
        return this.dInterQuartileRange;
    }

    public double get5thPercentile() {
        return this.d5thPercentile;
    }

    public double get95thPercentile() {
        return this.d95thPercentile;
    }

    public double[] getData() {
        return this.dX;
    }
}

