/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import java.util.ArrayList;
import numerics.sort.MergeSort;
import statistics.Histogram;
import util.Stripper;

public class ResultsColumn {
    private boolean bInput = false;
    private boolean bDoubleDataColumn = true;
    private boolean bStatisticsSet = false;
    private boolean bCumulativeDistributionSet = false;
    private String sHeading;
    private String sHeadingExtension;
    private String sUnit;
    private int iNumber;
    private int iNumberStatistics;
    private int iCount = 0;
    private double[] dValue;
    private String[] sValue;
    private String[] sOriginalValue;
    private String sControlCharacter;
    private double[] dValidated;
    private double[] dValidatedFrequency;
    private double[] dValidatedNormalized;
    ArrayList<ResultsColumn> alSubordinateResultsColumn;
    private Stripper s;
    double dMin;
    double dMax;
    double dAverage;
    double dTotal;
    double dVariance;
    double dRange;
    double d5thPercentile;
    double d95thPercentile;
    double dFirstQuartile;
    double dThirdQuartile;
    double dMedian;
    double dInterQuartileRange;
    double dRSMMinimum;
    double dRSMMaximum;
    double d90LowConfidenceInterval;
    double d90HighConfidenceInterval;
    double d95LowConfidenceInterval;
    double d95HighConfidenceInterval;
    double d99LowConfidenceInterval;
    double d99HighConfidenceInterval;
    Histogram histogram;
    private String[] sCharacterization = new String[]{"Lowest", "Low", "Middle", "High", "Highest"};
    private String[] sCharacterizedData;
    private double[] dCharacterizationBreakPoints = new double[]{0.1, 0.25, 0.75, 0.9};
    private boolean bCharacterized = false;

    public ResultsColumn() {
        this.alSubordinateResultsColumn = new ArrayList();
        this.s = new Stripper();
    }

    public void initializeArray() {
        this.dValue = new double[1];
        this.sValue = new String[1];
        this.sOriginalValue = new String[1];
        this.dValidatedFrequency = new double[1];
    }

    public void addValue(double dValueNew, String sValueNew, String sOriginalValue) {
        if (this.iCount < this.dValue.length) {
            this.dValue[this.iCount] = dValueNew;
            this.sValue[this.iCount] = sValueNew;
            this.sOriginalValue[this.iCount] = sOriginalValue;
            ++this.iCount;
        } else {
            double[] dTemp = new double[this.dValue.length];
            String[] sTemp = new String[this.sValue.length];
            String[] sTempO = new String[this.sOriginalValue.length];
            int iLength = this.dValue.length;
            int i = 0;
            while (i < iLength) {
                dTemp[i] = this.dValue[i];
                sTemp[i] = this.sValue[i];
                sTempO[i] = this.sOriginalValue[i];
                ++i;
            }
            this.dValue = new double[iLength + 1];
            this.sValue = new String[iLength + 1];
            this.sOriginalValue = new String[iLength + 1];
            this.dValidatedFrequency = new double[iLength + 1];
            i = 0;
            while (i < iLength) {
                this.dValue[i] = dTemp[i];
                this.sValue[i] = sTemp[i];
                this.sOriginalValue[i] = sTempO[i];
                ++i;
            }
            this.dValue[this.dValue.length - 1] = dValueNew;
            this.sValue[this.sValue.length - 1] = sValueNew;
            this.sOriginalValue[this.sOriginalValue.length - 1] = sOriginalValue;
            ++this.iCount;
        }
    }

    public void validateData() {
        if (this.bDoubleDataColumn) {
            int iValidCount = 0;
            int i = 0;
            while (i < this.dValue.length) {
                if (this.sValue[i].equalsIgnoreCase(this.sControlCharacter)) {
                    ++iValidCount;
                }
                ++i;
            }
            this.bDoubleDataColumn = iValidCount > 0;
            this.dValidated = new double[iValidCount];
            this.dValidatedFrequency = new double[iValidCount];
            int iCountHere = 0;
            int i2 = 0;
            while (i2 < this.dValue.length) {
                if (this.sValue[i2].equalsIgnoreCase(this.sControlCharacter)) {
                    this.dValidated[iCountHere] = this.dValue[i2];
                    ++iCountHere;
                }
                ++i2;
            }
        }
    }

    public void addSubordinateResult(String sHeadingExtension) {
        this.sHeadingExtension = sHeadingExtension;
        ResultsColumn rc = new ResultsColumn();
        rc.setHeading(String.valueOf(this.getHeading()) + sHeadingExtension);
        rc.setHeadingExtension(sHeadingExtension);
        rc.setControlCharacter(this.getControlCharacter());
        rc.initializeArray();
        rc.setIsThisADoubleDataColumn(this.getIsThisADoubleDataColumn());
        this.alSubordinateResultsColumn.add(rc);
    }

    public void addToSubordinateResultColumn(String sHeadingExtension, double dValue) {
        for (ResultsColumn rc : this.alSubordinateResultsColumn) {
            if (!this.s.areTheyEqual(rc.getHeading(), String.valueOf(this.getHeading()) + sHeadingExtension)) continue;
            rc.addValue(dValue, Double.toString(dValue), Double.toString(dValue));
            break;
        }
    }

    public ArrayList<ResultsColumn> getSubordinateResultsColumns() {
        return this.alSubordinateResultsColumn;
    }

    public ResultsColumn getSubordinateResultsColumn(String sHeadingExtension) {
        ResultsColumn rcReturn = new ResultsColumn();
        for (ResultsColumn rc : this.alSubordinateResultsColumn) {
            if (!this.s.areTheyEqual(sHeadingExtension, rc.getHeadingExtension())) continue;
            rcReturn = rc;
            break;
        }
        return rcReturn;
    }

    public void characterizeData() {
        if (this.bDoubleDataColumn && this.bStatisticsSet && this.dMax != 0.0) {
            this.dValidatedNormalized = new double[this.dValidated.length];
            this.sCharacterizedData = new String[this.dValidated.length];
            int i = 0;
            while (i < this.dValidatedNormalized.length) {
                this.dValidatedNormalized[i] = this.dValidated[i] / this.dMax;
                ++i;
            }
            i = 0;
            while (i < this.dValidatedNormalized.length) {
                if (this.dValidatedNormalized[i] <= this.dCharacterizationBreakPoints[0]) {
                    this.sCharacterizedData[i] = this.sCharacterization[0];
                }
                int j = 1;
                while (j < this.sCharacterization.length - 1) {
                    if (this.dCharacterizationBreakPoints[j - 1] < this.dValidatedNormalized[i] && this.dValidatedNormalized[i] <= this.dCharacterizationBreakPoints[j]) {
                        this.sCharacterizedData[i] = this.sCharacterization[j];
                    }
                    ++j;
                }
                if (this.dCharacterizationBreakPoints[this.dCharacterizationBreakPoints.length - 1] < this.dValidatedNormalized[i]) {
                    this.sCharacterizedData[i] = this.sCharacterization[this.sCharacterization.length - 1];
                }
                ++i;
            }
            this.bCharacterized = true;
        }
    }

    public String getCharacterizedValue(int iIndex) {
        if (this.bCharacterized) {
            return this.sCharacterizedData[iIndex];
        }
        return "";
    }

    public void sortByExternalData(double[] dSortBy) {
        MergeSort ms = new MergeSort();
        ms.sortWithDependentDouble(dSortBy, this.dValidated);
    }

    public void setInputOrNot(boolean bInput) {
        this.bInput = bInput;
    }

    public void setHeading(String sHeading) {
        this.sHeading = sHeading;
    }

    public void setHeadingExtension(String sHeadingExtension) {
        this.sHeadingExtension = sHeadingExtension;
    }

    public void setUnit(String sUnit) {
        this.sUnit = sUnit;
    }

    public void setNumber(int iNumber) {
        this.iNumber = iNumber;
    }

    public void setNumberOfPointsUsedInStatisticalAnalysis(int i) {
        this.iNumberStatistics = i;
    }

    public void setValue(int iIndex, double dValue) {
        this.dValue[iIndex] = dValue;
    }

    public void setAllDoubleValues(double[] dValue) {
        this.dValue = dValue;
    }

    public void setAllStringValues(String[] sValue) {
        this.sValue = sValue;
    }

    public void setControlCharacter(String sControlCharacter) {
        this.sControlCharacter = sControlCharacter;
    }

    public void setIsThisADoubleDataColumn(boolean bDoubleDataColumn) {
        this.bDoubleDataColumn = bDoubleDataColumn;
    }

    public void setMax(double dMax) {
        this.dMax = dMax;
    }

    public void setMin(double dMin) {
        this.dMin = dMin;
    }

    public void setAverage(double dAverage) {
        this.dAverage = dAverage;
    }

    public void setTotal(double dTotal) {
        this.dTotal = dTotal;
    }

    public void setVariance(double dVariance) {
        this.dVariance = dVariance;
    }

    public void setRange(double dRange) {
        this.dRange = dRange;
    }

    public void setHaveTheStatisticsBeenCalculated(boolean bStatisticsSet) {
        this.bStatisticsSet = bStatisticsSet;
    }

    public void setMedian(double dMedian) {
        this.dMedian = dMedian;
    }

    public void setFirstQuartile(double dFirstQuartile) {
        this.dFirstQuartile = dFirstQuartile;
    }

    public void setThirdQuartile(double dThirdQuartile) {
        this.dThirdQuartile = dThirdQuartile;
    }

    public void setInterQuartileRange(double dInterQuartileRange) {
        this.dInterQuartileRange = dInterQuartileRange;
    }

    public void set5thPercentile(double d5thPercentile) {
        this.d5thPercentile = d5thPercentile;
    }

    public void set95thPercentile(double d95thPercentile) {
        this.d95thPercentile = d95thPercentile;
    }

    public void setRSMMinimum(double dRSMMinimum) {
        this.dRSMMinimum = dRSMMinimum;
    }

    public void setRSMMaximum(double dRSMMaximum) {
        this.dRSMMaximum = dRSMMaximum;
    }

    public void set90LowConfidenceInterval(double d90LowConfidenceInterval) {
        this.d90LowConfidenceInterval = d90LowConfidenceInterval;
    }

    public void set90HighConfidenceInterval(double d90HighConfidenceInterval) {
        this.d90HighConfidenceInterval = d90HighConfidenceInterval;
    }

    public void set95LowConfidenceInterval(double d95LowConfidenceInterval) {
        this.d95LowConfidenceInterval = d95LowConfidenceInterval;
    }

    public void set95HighConfidenceInterval(double d95HighConfidenceInterval) {
        this.d95HighConfidenceInterval = d95HighConfidenceInterval;
    }

    public void set99LowConfidenceInterval(double d99LowConfidenceInterval) {
        this.d99LowConfidenceInterval = d99LowConfidenceInterval;
    }

    public void set99HighConfidenceInterval(double d99HighConfidenceInterval) {
        this.d99HighConfidenceInterval = d99HighConfidenceInterval;
    }

    public void setHistogram(Histogram h) {
        this.histogram = h;
    }

    public void setIsTheCumulativeDistributionSet(boolean b) {
        this.bCumulativeDistributionSet = b;
    }

    public void setCumulativeDistributionFrequencies(double[] dFreq) {
        this.dValidatedFrequency = dFreq;
    }

    public void setValidatedData(double[] dValidated) {
        this.dValidated = dValidated;
    }

    public boolean getInputOrNot() {
        return this.bInput;
    }

    public String getHeading() {
        return this.sHeading;
    }

    public String getUnit() {
        return this.sUnit;
    }

    public int getNumber() {
        return this.iNumber;
    }

    public int getNumberOfPointsUsedInStatisticalAnalysis() {
        return this.iNumberStatistics;
    }

    public double getValue(int iIndex) {
        return this.dValue[iIndex];
    }

    public double[] getAllDoubleValues() {
        return this.dValue;
    }

    public String[] getAllStringValues() {
        return this.sValue;
    }

    public String getControlCharacter() {
        return this.sControlCharacter;
    }

    public boolean getIsThisADoubleDataColumn() {
        return this.bDoubleDataColumn;
    }

    public double getMin() {
        return this.dMin;
    }

    public double getMax() {
        return this.dMax;
    }

    public double getAverage() {
        return this.dAverage;
    }

    public double getTotal() {
        return this.dTotal;
    }

    public double getVariance() {
        return this.dVariance;
    }

    public double getRange() {
        return this.dRange;
    }

    public boolean getHaveTheStatisticsBeenSet() {
        return this.bStatisticsSet;
    }

    public double getMedian() {
        return this.dMedian;
    }

    public double getFirstQuartile() {
        return this.dFirstQuartile;
    }

    public double getThirdQuartile() {
        return this.dThirdQuartile;
    }

    public double getInterQuartileRange() {
        return this.dInterQuartileRange;
    }

    public double get5thPercentile() {
        return this.d5thPercentile;
    }

    public double get95thPercentile() {
        return this.d95thPercentile;
    }

    public double getRSMMinimum() {
        return this.dRSMMinimum;
    }

    public double getRSMMaximum() {
        return this.dRSMMaximum;
    }

    public double get90LowConfidenceInterval() {
        return this.d90LowConfidenceInterval;
    }

    public double get90HighConfidenceInterval() {
        return this.d90HighConfidenceInterval;
    }

    public double get95LowConfidenceInterval() {
        return this.d95LowConfidenceInterval;
    }

    public double get95HighConfidenceInterval() {
        return this.d95HighConfidenceInterval;
    }

    public double get99LowConfidenceInterval() {
        return this.d99LowConfidenceInterval;
    }

    public double get99HighConfidenceInterval() {
        return this.d99HighConfidenceInterval;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public boolean getIsTheCumulativeDistributionSet() {
        return this.bCumulativeDistributionSet;
    }

    public double[] getValidatedData() {
        return this.dValidated;
    }

    public double[] getCumulativeDistributionFrequencies() {
        return this.dValidatedFrequency;
    }

    public String getHeadingExtension() {
        return this.sHeadingExtension;
    }

    public String getOriginalValue(int i) {
        return this.sOriginalValue[i];
    }
}

