/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import util.Stripper;

public class RiskContainer {
    private Stripper s;
    private String[] sName;
    private double[] dRiskLevel;
    private double[] dRiskConcentration;
    private double[] dRiskPerCent;
    private boolean[] bRiskChemical;
    private int iRisk;
    private String[] sHazardName;
    private double[] dHazardQuotient;
    private double[] dHazardConcentration;
    private double[] dHazardPerCent;
    private boolean[] bHazardChemical;
    private int iHazard;
    private int iDem;
    private int iCount;
    private String[] sScreeningName;
    private double[] dScreeningConcentration;
    private double[] dScreeningLevel;
    private double[] dScreeningPerCent;
    private boolean[] bScreeningChemical;
    private int iScreening;

    public RiskContainer() {
        this.initialize();
    }

    public void initialize() {
        this.iDem = 100;
        this.sName = new String[this.iDem];
        this.dRiskLevel = new double[this.iDem];
        this.dRiskConcentration = new double[this.iDem];
        this.dRiskPerCent = new double[this.iDem];
        this.bRiskChemical = new boolean[this.iDem];
        this.iRisk = 0;
        this.sHazardName = new String[this.iDem];
        this.dHazardQuotient = new double[this.iDem];
        this.dHazardConcentration = new double[this.iDem];
        this.dHazardPerCent = new double[this.iDem];
        this.bHazardChemical = new boolean[this.iDem];
        this.iHazard = 0;
        this.sScreeningName = new String[this.iDem];
        this.dScreeningConcentration = new double[this.iDem];
        this.dScreeningLevel = new double[this.iDem];
        this.dScreeningPerCent = new double[this.iDem];
        this.bScreeningChemical = new boolean[this.iDem];
        this.iScreening = 0;
        this.s = new Stripper();
        this.iCount = 0;
    }

    public void addCancerRisk(String sName, boolean bRiskChemical, double dRiskLevel, double dRiskConcentration, double dRiskPerCent) {
        int iUse = this.iRisk;
        int i = 0;
        while (i < this.iRisk) {
            if (this.s.areTheyEqual(sName, this.sName[i])) {
                iUse = i;
            }
            ++i;
        }
        this.sName[iUse] = sName;
        this.dRiskLevel[iUse] = dRiskLevel;
        this.dRiskConcentration[iUse] = dRiskConcentration;
        this.dRiskPerCent[iUse] = dRiskPerCent;
        this.bRiskChemical[iUse] = bRiskChemical;
        ++this.iRisk;
    }

    public void addCancerRisk(String sName, boolean bRiskChemical) {
        this.addCancerRisk(sName, bRiskChemical, 0.0, 0.0, 0.0);
    }

    public void addHazard(String sHazardName, boolean bHazardChemical, double dHazardQuotient, double dHazardConcentration, double dHazardPerCent) {
        int iUse = this.iHazard;
        int i = 0;
        while (i < this.iHazard) {
            if (this.s.areTheyEqual(sHazardName, this.sHazardName[i])) {
                iUse = i;
            }
            ++i;
        }
        this.sHazardName[iUse] = sHazardName;
        this.dHazardQuotient[iUse] = dHazardQuotient;
        this.dHazardConcentration[iUse] = dHazardConcentration;
        this.dHazardPerCent[iUse] = dHazardPerCent;
        this.bHazardChemical[iUse] = bHazardChemical;
        ++this.iHazard;
    }

    public void addHazard(String sName, boolean bRiskChemical) {
        this.addHazard(sName, bRiskChemical, 0.0, 0.0, 0.0);
    }

    public void addScreeningRisk(String sScreeningName, boolean bScreeningChemical, double dScreeningConcentration, double dScreeningPerCent) {
        int iUse = this.iScreening;
        int i = 0;
        while (i < this.iScreening) {
            if (this.s.areTheyEqual(sScreeningName, this.sScreeningName[i])) {
                iUse = i;
            }
            ++i;
        }
        this.sScreeningName[iUse] = sScreeningName;
        this.dScreeningLevel[iUse] = 1.0;
        this.dScreeningConcentration[iUse] = dScreeningConcentration;
        this.dScreeningPerCent[iUse] = dScreeningPerCent;
        this.bScreeningChemical[iUse] = bScreeningChemical;
        ++this.iScreening;
    }

    public void addScreeningRisk(String sScreeningName, boolean bScreeningChemical) {
        this.addCancerRisk(sScreeningName, bScreeningChemical, 0.0, 0.0, 0.0);
    }

    public void sortCancerRiskByPerCentExceeds() {
        this.sortByPerCent(this.dRiskPerCent, this.dRiskLevel, this.dRiskConcentration, this.bRiskChemical, this.sName);
    }

    public void sortHazardByPerCentExceeds() {
        this.sortByPerCent(this.dHazardPerCent, this.dHazardQuotient, this.dHazardConcentration, this.bHazardChemical, this.sHazardName);
    }

    public void sortScreeningByPerCentExceeds() {
        this.sortByPerCent(this.dScreeningPerCent, this.dScreeningLevel, this.dScreeningConcentration, this.bScreeningChemical, this.sScreeningName);
    }

    private void sortByPerCent(double[] dPerCent, double[] dLevel, double[] dConcentration, boolean[] bFlag, String[] sName) {
        int iCount = dPerCent.length;
        boolean bChanged = true;
        while (bChanged) {
            bChanged = false;
            int i = 0;
            while (i < iCount - 1) {
                if (dPerCent[i] < dPerCent[i + 1]) {
                    double dTempPerCent = dPerCent[i + 1];
                    double dTempLevel = dLevel[i + 1];
                    double dTempConcentration = dConcentration[i + 1];
                    String sTempName = sName[i + 1];
                    boolean bTempFlag = bFlag[i + 1];
                    dPerCent[i + 1] = dPerCent[i];
                    dLevel[i + 1] = dLevel[i];
                    dConcentration[i + 1] = dConcentration[i];
                    sName[i + 1] = sName[i];
                    bFlag[i + 1] = bFlag[i];
                    dPerCent[i] = dTempPerCent;
                    dLevel[i] = dTempLevel;
                    dConcentration[i] = dTempConcentration;
                    sName[i] = sTempName;
                    bFlag[i] = bTempFlag;
                    bChanged = true;
                }
                ++i;
            }
        }
    }

    public int getRiskCount() {
        int iReturn = 0;
        int i = 0;
        while (i < this.iRisk) {
            if (this.bRiskChemical[i]) {
                ++iReturn;
            }
            ++i;
        }
        return iReturn;
    }

    public int getHazardCount() {
        int iReturn = 0;
        int i = 0;
        while (i < this.iHazard) {
            if (this.bHazardChemical[i]) {
                ++iReturn;
            }
            ++i;
        }
        return iReturn;
    }

    public int getScreeningCount() {
        int iReturn = 0;
        int i = 0;
        while (i < this.iScreening) {
            if (this.bScreeningChemical[i]) {
                ++iReturn;
            }
            ++i;
        }
        return iReturn;
    }

    public int getTotalCount() {
        int iReturn = 0;
        iReturn = Math.max(this.iRisk, this.iHazard);
        iReturn = Math.max(iReturn, this.iScreening);
        return iReturn;
    }

    public String getCancerName(int i) {
        return this.sName[i];
    }

    public double getRiskLevel(int i) {
        return this.dRiskLevel[i];
    }

    public double getRiskConcentration(int i) {
        return this.dRiskConcentration[i];
    }

    public double getRiskPerCent(int i) {
        return this.dRiskPerCent[i];
    }

    public boolean getIsRiskChemical(int i) {
        return this.bRiskChemical[i];
    }

    public String getHazardName(int i) {
        return this.sHazardName[i];
    }

    public double getHazardQuotient(int i) {
        return this.dHazardQuotient[i];
    }

    public double getHazardConcentration(int i) {
        return this.dHazardConcentration[i];
    }

    public double getHazardPerCent(int i) {
        return this.dHazardPerCent[i];
    }

    public boolean getIsHazardChemical(int i) {
        return this.bHazardChemical[i];
    }

    public String getScreeningdName(int i) {
        return this.sScreeningName[i];
    }

    public double getScreeningLevel(int i) {
        return this.dScreeningLevel[i];
    }

    public double getScreeningConcentration(int i) {
        return this.dScreeningConcentration[i];
    }

    public double getScreeningPerCent(int i) {
        return this.dScreeningPerCent[i];
    }

    public boolean getIsScreeningChemical(int i) {
        return this.bScreeningChemical[i];
    }
}

