/*
 * Decompiled with CFR 0.152.
 */
package ui;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import ui.ChartAnnotationNode;

public class ChartAnnotationOverlay
extends Pane {
    private LineChart<Number, Number> lc;
    private ObservableList<ChartAnnotationNode> olAnnotations;

    public ChartAnnotationOverlay(LineChart<Number, Number> lc) {
        this.lc = lc;
        this.olAnnotations = FXCollections.observableArrayList();
        InvalidationListener listener = new InvalidationListener(){

            public void invalidated(Observable observable) {
                ChartAnnotationOverlay.this.update();
            }
        };
        lc.needsLayoutProperty().addListener(listener);
        this.olAnnotations.addListener(listener);
    }

    public void addAnnotation(boolean bMouseAnnotation, double displayX, double displayY, String sText) {
        Axis xAxis = this.lc.getXAxis();
        Axis yAxis = this.lc.getYAxis();
        double x = displayX;
        double y = displayY;
        if (bMouseAnnotation) {
            double dValue = xAxis.parentToLocal(displayX, 0.0).getX() - this.lc.getPadding().getLeft();
            x = ((Number)xAxis.getValueForDisplay(dValue)).doubleValue();
            double dValueY = yAxis.parentToLocal(0.0, displayY).getY() - this.lc.getPadding().getTop();
            y = ((Number)yAxis.getValueForDisplay(dValueY)).doubleValue();
        }
        if (xAxis.isValueOnAxis((Object)displayX) && xAxis.isValueOnAxis((Object)displayY)) {
            this.olAnnotations.add((Object)new ChartAnnotationNode((Node)new Label(sText), x, y));
        }
    }

    public void update() {
        this.getChildren().clear();
        Axis xAxis = this.lc.getXAxis();
        Axis yAxis = this.lc.getYAxis();
        for (ChartAnnotationNode can : this.olAnnotations) {
            double dX = xAxis.getDisplayPosition((Object)can.getX());
            double dY = yAxis.getDisplayPosition((Object)can.getY());
            double x = xAxis.localToParent(dX, 0.0).getX() + this.lc.getPadding().getLeft();
            double y = yAxis.localToParent(0.0, dY).getY() + this.lc.getPadding().getTop();
            Circle indicator = new Circle(3.0);
            indicator.setStroke((Paint)Color.BLUEVIOLET);
            indicator.setCenterX(x);
            indicator.setCenterY(y);
            this.getChildren().add((Object)indicator);
            Node node = can.getNode();
            this.getChildren().add((Object)node);
            node.relocate(x + 10.0, y - node.prefHeight(2.147483647E9) / 2.0);
            node.autosize();
        }
    }

    public ChartAnnotationOverlay getAnnotations() {
        return this;
    }
}

