/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import pviScreen.dataContainers.Building;
import pviScreen.dataContainers.OilLens;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataContainers.VadoseZone;
import ui.Repository;
import util.ClipPathOrFile;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class DrawSchematic {
    private VIControlData viCD;
    private Stage stage;
    private BorderPane border;
    private Repository repository;
    private Canvas canvas;
    private Scene scene;
    private ScrollPane sp;
    private Label lTopLabel;
    private UnitConverter uc;
    private String sOutputLengthUnit;
    private double dUCF;
    private double dStageHeight;
    private double dStageWidth;
    private double dCanvasHeight;
    private double dCanvasWidth;
    private WritableImage wiSiteSchematic;
    private Stripper s;
    private NameConstants nc;
    private ObservableList<Button> olButton;
    private double dTotalHeight;
    private double dTotalWidth;
    private double dSky;
    private double dHouse;
    private double dVadose;
    private double dVadoseMax;
    private double dAquifer;
    private double dUnderworld;
    private double dDepthOfFoundation;
    private double dSample;
    private double dLensTop;
    private double dLensBottom;
    private double dWidth;
    private double dLensWidth;
    private double dLength;
    private double dLensLength;
    private VadoseZone vz;
    private Building bldg;
    private OilLens ol;
    private double dSFY;
    private double dSFX;
    double dMarginX;
    double dMarginY;
    double dLandY;
    double dLandX0;
    double dLandX1;
    double dLandX2;
    double dLandX3;
    double dLandX4;
    double dLand2p5;
    double dWaterTableY;
    double dWaterTableMaxY;
    double dAquiferBottomY;
    double dBuildingY0;
    double dBuildingY1;
    double dBuildingY2;
    double dLensTopPlot;
    double dLensBottomPlot;
    double dSampleY0;
    double dSampleY1;
    double dSampleX;

    public void drawSchematic() {
        this.nc = new NameConstants();
        this.viCD = this.repository.getVIControlData();
        this.dCanvasWidth = this.nc.pref_WIDTH;
        this.dCanvasHeight = this.nc.pref_HEIGHT;
        this.canvas = new Canvas(this.dCanvasWidth, this.dCanvasHeight);
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        this.dCanvasHeight = this.canvas.getHeight();
        this.dCanvasWidth = this.canvas.getWidth();
        this.adjustGeometry(this.dCanvasHeight, this.dCanvasWidth);
        this.drawSchematic(gc);
        this.addArrowsAndLabels(gc);
        this.addWaterTableMark(gc, this.dWaterTableY, 10.0, 1.1 * this.dLandX0, 10.0);
        if (this.dAquifer > 0.0) {
            this.addAquiferBottomHatching(gc);
        }
        try {
            this.wiSiteSchematic = this.canvas.snapshot(new SnapshotParameters(), null);
            this.repository.setSiteSchematic(this.wiSiteSchematic);
        }
        catch (Exception ee) {
            this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), "Error in forming site schematic snapshot2");
        }
    }

    public void displayTheScene(Stage stage) {
        this.sp = new ScrollPane();
        this.sp.setContent((Node)this.canvas);
        stage.setHeight(this.dStageHeight);
        this.border = this.repository.getBorder();
        this.border.setCenter((Node)this.sp);
        stage.show();
    }

    public void writeTheImageToAFile(String sPNGFileName) {
        ClipPathOrFile cpof = new ClipPathOrFile();
        if (!cpof.clipPathOrFile(sPNGFileName, "extension").equalsIgnoreCase("png")) {
            sPNGFileName = cpof.clipPathOrFile(sPNGFileName, "PathAndFile");
            sPNGFileName = String.valueOf(sPNGFileName) + "." + this.nc.s_Extension_PNG_Schematic;
        }
        File outFile = new File(sPNGFileName);
        try {
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)this.repository.getSiteSchematic(), null), "png", outFile);
            this.repository.setPNGSiteSchematicFileName(sPNGFileName);
        }
        catch (IOException ex) {
            this.viCD.addToMessageOutput(this.viCD.getErrorOutput(), ex.getMessage());
        }
    }

    private void adjustGeometry(double dStageHeight, double dStageWidth) {
        try {
            this.vz = this.viCD.getVadoseZone();
            this.bldg = this.viCD.getBuilding();
            this.ol = this.viCD.getOilLens();
            this.dSample = this.vz.getDepthToSample();
            this.dVadose = this.vz.getDepthToWaterTable();
            this.dVadoseMax = this.vz.getDepthToHistoricWaterTable();
            this.dAquifer = this.vz.getDepthToBottom();
            this.dLensTop = this.ol.getSurfaceElevation() - this.ol.getOilZoneTopElevation();
            this.dLensBottom = this.ol.getSurfaceElevation() - this.ol.getMobileOilZoneBottomElevation();
            this.dLensWidth = this.ol.getLensWidth();
            this.dLensLength = this.ol.getLensLength();
            this.dHouse = this.bldg.getMixingZoneHeight();
            this.dWidth = this.bldg.getWidth();
            this.dLength = this.bldg.getLength();
            this.dDepthOfFoundation = this.bldg.getFoundationDepthBelowGrade();
            this.uc = this.viCD.getUnitConverter();
            this.sOutputLengthUnit = this.uc.getOutputNameFromType("Length");
            this.dUCF = this.uc.getOutputUCFFromType("Length");
        }
        catch (Exception e) {
            this.dVadose = 25.0;
            this.dVadoseMax = 29.0;
            this.dLensTop = this.dVadose - 1.0;
            this.dLensBottom = this.dVadoseMax;
            this.dLensWidth = 15.0;
            this.dLensLength = 9.0;
            this.dSample = 10.0;
            this.dAquifer = 35.0;
            this.dHouse = 8.0;
            this.dWidth = 10.0;
            this.dLength = 10.0;
            this.dDepthOfFoundation = 4.0;
            this.sOutputLengthUnit = "ft";
            this.dUCF = 1.0;
        }
        this.dUnderworld = this.dSky = 1.2 * (0.5 * this.dWidth * Math.tan(0.5235987755982988));
        this.dTotalHeight = this.dSky + this.dHouse + this.dVadose + this.dAquifer + this.dUnderworld;
        this.dTotalWidth = 7.0 * this.dWidth;
        this.dSFY = this.dCanvasHeight / this.dTotalHeight;
        this.dSFX = this.dCanvasWidth / this.dTotalWidth;
    }

    private void drawSchematic(GraphicsContext gc) {
        this.dMarginX = 10.0;
        this.dMarginY = 10.0;
        gc.setStroke((Paint)Color.BROWN);
        gc.setLineWidth(5.0);
        this.dLandY = this.dMarginY + this.dSFY * (this.dSky + this.dHouse);
        this.dLandX0 = this.dMarginX + this.dSFX * this.dWidth;
        this.dLandX1 = this.dLandX0 + this.dSFX * this.dWidth;
        this.dLandX2 = this.dLandX1 + this.dSFX * this.dWidth;
        this.dLandX3 = this.dLandX2 + this.dSFX * this.dWidth;
        this.dLandX4 = this.dLandX3 + this.dSFX * this.dWidth;
        gc.strokeLine(this.dLandX0, this.dLandY, 0.88 * this.dLandX1, this.dLandY);
        if (this.dDepthOfFoundation > 0.075 * (this.dAquifer + this.dVadose)) {
            gc.strokeLine(1.06 * this.dLandX2, this.dLandY, this.dLandX3, this.dLandY);
        } else {
            double dLandXGap = this.dLandX2 + 0.6 * (this.dLandX3 - this.dLandX2);
            gc.strokeLine(dLandXGap, this.dLandY, this.dLandX3, this.dLandY);
        }
        gc.strokeLine(1.04 * this.dLandX3, this.dLandY, this.dLandX4, this.dLandY);
        if (this.dLensTop > 0.0 && this.dLensWidth > 0.0) {
            gc.setStroke((Paint)Color.ORANGE);
            this.dLensTopPlot = this.dLandY + this.dSFY * this.dLensTop;
            this.dLensBottomPlot = this.dLandY + this.dSFY * this.dLensBottom;
            double dLW = this.dSFX * (this.dLensWidth - this.dWidth);
            double d1 = this.dLandX1 - 0.5 * dLW;
            double d2 = d1 + this.dSFX * this.dLensWidth;
            gc.strokeLine(d1, this.dLensTopPlot, d2, this.dLensTopPlot);
            gc.strokeLine(d1, this.dLensBottomPlot, d2, this.dLensBottomPlot);
            gc.strokeLine(d1, this.dLensTopPlot, d1, this.dLensBottomPlot);
            gc.strokeLine(d2, this.dLensTopPlot, d2, this.dLensBottomPlot);
        }
        gc.setStroke((Paint)Color.GREEN);
        this.dBuildingY0 = this.dMarginY + this.dSFY * (this.dSky + this.dDepthOfFoundation);
        this.dBuildingY1 = this.dBuildingY0 + this.dSFY * this.dHouse;
        this.dBuildingY2 = this.dBuildingY0 - this.dSFY * (0.4 * this.dHouse);
        this.dLand2p5 = this.dLandX1 + this.dSFX * 0.5 * this.dWidth;
        gc.strokeLine(this.dLandX1, this.dBuildingY0, this.dLandX1, this.dBuildingY1);
        gc.strokeLine(this.dLandX1, this.dBuildingY1, this.dLandX2, this.dBuildingY1);
        gc.strokeLine(this.dLandX2, this.dBuildingY1, this.dLandX2, this.dBuildingY0);
        gc.strokeLine(this.dLandX2, this.dBuildingY0, this.dLand2p5, this.dBuildingY2);
        gc.strokeLine(this.dLand2p5, this.dBuildingY2, this.dLandX1, this.dBuildingY0);
        gc.setStroke((Paint)Color.CHARTREUSE);
        if (this.dSample > 0.0) {
            double dSampleY0 = this.dMarginY + this.dSFY * (this.dSky + this.dHouse);
            double dSampleY1 = this.dMarginY + this.dSFY * (this.dSky + this.dHouse + this.dSample);
            double dSampleX0 = this.dLandX1;
            gc.strokeRect(0.94 * this.dLandX1, 0.99 * dSampleY1, 0.02 * this.dLandX1, 0.01 * dSampleY1);
        }
        gc.setStroke((Paint)Color.BLUE);
        gc.setLineWidth(2.0);
        this.dWaterTableY = this.dLandY + this.dSFY * this.dVadose;
        this.dWaterTableMaxY = this.dLandY + this.dSFY * this.dVadoseMax;
        this.dAquiferBottomY = this.dLandY + this.dSFY * this.dAquifer;
        gc.strokeLine(1.0 * this.dLandX0, this.dWaterTableY, 1.01 * this.dLandX2, this.dWaterTableY);
        gc.strokeLine(1.05 * this.dLandX2, this.dWaterTableY, 1.0 * this.dLandX3, this.dWaterTableY);
        gc.strokeLine(1.04 * this.dLandX3, this.dWaterTableY, 1.0 * this.dLandX4, this.dWaterTableY);
        if (this.dAquifer > 0.0) {
            gc.setStroke((Paint)Color.BLACK);
            gc.setLineWidth(5.0);
            gc.strokeLine(this.dLandX0, this.dAquiferBottomY, this.dLandX3, this.dAquiferBottomY);
            gc.strokeLine(1.04 * this.dLandX3, this.dAquiferBottomY, this.dLandX4, this.dAquiferBottomY);
        }
    }

    public void addWaterTableMark(GraphicsContext gc, double dYValue, double dY, double dLandX, double dX) {
        gc.setStroke((Paint)Color.BLUE);
        gc.setLineWidth(2.0);
        gc.strokeLine(dLandX - dX, dYValue - dY, dLandX, dYValue);
        gc.strokeLine(dLandX, dYValue, dLandX + dX, dYValue - dY);
        gc.strokeLine(dLandX - dX, 1.02 * dYValue, dLandX + dX, 1.02 * dYValue);
        gc.strokeLine(dLandX - 0.85 * dX, 1.04 * dYValue, dLandX + 0.85 * dX, 1.04 * dYValue);
        gc.strokeLine(dLandX - 0.75 * dX, 1.06 * dYValue, dLandX + 0.75 * dX, 1.06 * dYValue);
    }

    public void addAquiferBottomHatching(GraphicsContext gc) {
        gc.setStroke((Paint)Color.BLACK);
        gc.setLineWidth(2.0);
        double dStart = 1.0;
        double dEnd = 1.05;
        while (dEnd * this.dLandX0 < this.dLandX3) {
            gc.strokeLine(dStart * this.dLandX0, 1.05 * this.dAquiferBottomY, dEnd * this.dLandX0, this.dAquiferBottomY);
            dStart = dEnd;
            dEnd += 0.05;
        }
        gc.setStroke((Paint)Color.BLACK);
        dStart = 3.95;
        dEnd = 4.0;
        while (dEnd * this.dLandX0 <= 0.99 * this.dLandX4) {
            gc.strokeLine(dStart * this.dLandX0, 1.05 * this.dAquiferBottomY, dEnd * this.dLandX0, this.dAquiferBottomY);
            dStart = dEnd;
            dEnd += 0.05;
        }
    }

    public void addArrowsAndLabels(GraphicsContext gc) {
        OutputDigits od = new OutputDigits();
        gc.setStroke((Paint)Color.BLACK);
        gc.setLineWidth(2.0);
        gc.strokeLine(1.03 * this.dLandX2, this.dLandY, 1.03 * this.dLandX2, this.dBuildingY1);
        gc.strokeLine(1.02 * this.dLandX2, this.dLandY, 1.04 * this.dLandX2, this.dLandY);
        gc.strokeLine(1.02 * this.dLandX2, this.dBuildingY1, 1.04 * this.dLandX2, this.dBuildingY1);
        gc.strokeLine(1.03 * this.dLandX2, this.dBuildingY1, 1.03 * this.dLandX2, this.dWaterTableY);
        gc.strokeLine(1.02 * this.dLandX2, this.dWaterTableY, 1.04 * this.dLandX2, this.dWaterTableY);
        gc.strokeLine(1.02 * this.dLandX3, this.dLandY, 1.02 * this.dLandX3, this.dWaterTableY);
        gc.strokeLine(1.01 * this.dLandX3, this.dLandY, 1.03 * this.dLandX3, this.dLandY);
        gc.strokeLine(1.01 * this.dLandX3, this.dWaterTableY, 1.03 * this.dLandX3, this.dWaterTableY);
        if (this.dAquifer > 0.0) {
            gc.strokeLine(1.02 * this.dLandX3, this.dWaterTableY, 1.02 * this.dLandX3, this.dAquiferBottomY);
            gc.strokeLine(1.01 * this.dLandX3, this.dAquiferBottomY, 1.03 * this.dLandX3, this.dAquiferBottomY);
        }
        if (this.dSample > 0.0) {
            double dSampleY0 = this.dMarginY + this.dSFY * (this.dSky + this.dHouse);
            double dSampleY1 = this.dMarginY + this.dSFY * (this.dSky + this.dHouse + this.dSample);
            double dSampleX0 = this.dLandX1;
            gc.strokeLine(0.9 * this.dLandX1, dSampleY0, 0.92 * this.dLandX1, dSampleY0);
            gc.strokeLine(0.91 * this.dLandX1, dSampleY0, 0.91 * this.dLandX1, dSampleY1);
            gc.strokeLine(0.9 * this.dLandX1, dSampleY1, 0.92 * this.dLandX1, dSampleY1);
        }
        gc.setStroke((Paint)Color.BLACK);
        gc.setFill((Paint)Color.BLACK);
        gc.setLineWidth(1.0);
        double dDepth1 = 0.5 * (this.dLandY + this.dWaterTableY);
        String sOut1 = String.valueOf(od.num2String(this.dVadose * this.dUCF)) + " (" + this.sOutputLengthUnit + ")";
        gc.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)14.0));
        gc.fillText(sOut1, 1.05 * this.dLandX3, dDepth1);
        if (this.dAquifer > 0.0) {
            gc.setStroke((Paint)Color.BLACK);
            double dDepth3 = 0.5 * (this.dWaterTableY + this.dAquiferBottomY);
            String sOut3 = String.valueOf(od.num2String((this.dAquifer - this.dVadose) * this.dUCF)) + " (" + this.sOutputLengthUnit + ")";
            gc.fillText(sOut3, 1.05 * this.dLandX3, dDepth3);
        }
        double dDepth4 = this.dLandY + 0.75 * this.dSFY * this.dDepthOfFoundation;
        String sOut4 = String.valueOf(od.num2String(this.dDepthOfFoundation * this.dUCF)) + " (" + this.sOutputLengthUnit + ")";
        gc.fillText(sOut4, 1.05 * this.dLandX2, dDepth4);
        double dDepth5 = this.dLandY + this.dSFY * this.dDepthOfFoundation + 0.75 * this.dSFY * (this.dVadose - this.dDepthOfFoundation);
        String sOut5 = String.valueOf(od.num2String((this.dVadose - this.dDepthOfFoundation) * this.dUCF)) + " (" + this.sOutputLengthUnit + ")";
        gc.fillText(sOut5, 1.05 * this.dLandX2, dDepth5);
        if (this.dSample > 0.0) {
            double dDepth7 = this.dLandY + this.dSFY * this.dDepthOfFoundation + 0.5 * this.dSFY * (this.dSample - this.dDepthOfFoundation);
            String sOut7 = String.valueOf(od.num2String((this.dSample - this.dDepthOfFoundation) * this.dUCF)) + " (" + this.sOutputLengthUnit + ")";
            sOut7 = String.valueOf(od.num2String(this.dSample * this.dUCF)) + " (" + this.sOutputLengthUnit + ")";
            gc.fillText(sOut7, 0.65 * this.dLandX1, dDepth7);
        }
    }

    public void setRepository(Repository r) {
        this.repository = r;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setStageGeometry(double dStageHeight, double dStageWidth) {
        this.dStageHeight = dStageHeight;
        this.dStageWidth = dStageWidth;
    }
}

