/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import pviScreen.dataContainers.InputFileNames;
import ui.EstimatedConcentrationDialogData;
import ui.WrappedRadioButton;
import ui.handler.HandlerPositiveNumberEntry;
import ui.handler.HandlerSampleTypeDialog;
import util.Stripper;
import util.UnitConverter;

public class EstimatedConcentrationDialog {
    private String sResult;
    private EstimatedConcentrationDialogData ecdd;
    InputFileNames ifn;
    UnitConverter uc;
    private ComboBox cbUnit;
    private ComboBox cbSampleType;
    private Label[] lChemicalName = new Label[this.iCount];
    private TextField[] tfValue = new TextField[this.iCount];
    private WrappedRadioButton wrbNAPLFresh;
    private WrappedRadioButton wrbNAPLWeathered;
    private ToggleGroup tgNAPL;
    private int iCount = 4;

    public void displayDialog() throws IOException {
        Dialog dialog = new Dialog();
        dialog.setTitle("Estimated TPH");
        dialog.setHeaderText("TPH concentrations are estimated from the BTEX/benzene concentration.  Enter all available data");
        dialog.setResizable(true);
        GridPane gpChemical = new GridPane();
        gpChemical.setAlignment(Pos.CENTER);
        gpChemical.setHgap(10.0);
        gpChemical.setVgap(10.0);
        gpChemical.setPadding(new Insets(20.0, 35.0, 20.0, 35.0));
        String sUnitType = "ConcentrationAir";
        String sUnitSelected = "ug/m3";
        Stripper s = new Stripper();
        this.uc = new UnitConverter();
        this.uc.readUnits(this.ifn.getFile_UnitConversions());
        this.uc.readUnitTypes(this.ifn.getFile_UnitDefinitions());
        ArrayList<String> alUnitNames = this.uc.getAllUnitNamesForAType(sUnitType);
        ObservableList optionsUnit = FXCollections.observableArrayList(alUnitNames);
        ArrayList<String> alSampleType = new ArrayList<String>();
        alSampleType.add("Soil Gas");
        alSampleType.add("Ground Water");
        int iSampleType = 0;
        ObservableList optionsType = FXCollections.observableArrayList(alSampleType);
        this.cbSampleType = new ComboBox(optionsType);
        this.cbUnit = new ComboBox(optionsUnit);
        this.cbUnit.setDisable(false);
        int i = 0;
        while (i < this.iCount) {
            this.lChemicalName[i] = new Label();
            this.tfValue[i] = new TextField();
            final HandlerPositiveNumberEntry hpne = new HandlerPositiveNumberEntry();
            hpne.setTextField(this.tfValue[i]);
            hpne.setInitialText(this.tfValue[i].getText());
            this.tfValue[i].focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                    if (!newPropertyValue.booleanValue()) {
                        hpne.setTestForPositiveNumber(true);
                        hpne.getValueFromTextField();
                        hpne.handle();
                        hpne.setTextValue(hpne.getValue());
                    }
                }
            });
            ++i;
        }
        this.lChemicalName[0].setText("Benzene");
        this.lChemicalName[1].setText("Toluene");
        this.lChemicalName[2].setText("EthylBenzene");
        this.lChemicalName[3].setText("Xylenes");
        int iUnitIndexUnit = 0;
        for (String sUnit : alUnitNames) {
            if (!s.areTheyEqual(sUnitSelected, sUnit)) continue;
            iUnitIndexUnit = alUnitNames.indexOf(sUnit);
        }
        HandlerSampleTypeDialog hstd = new HandlerSampleTypeDialog();
        this.cbUnit.setValue((Object)alUnitNames.get(iUnitIndexUnit));
        this.cbUnit.setVisible(true);
        this.cbUnit.setDisable(false);
        this.cbSampleType.setValue(alSampleType.get(iSampleType));
        hstd = new HandlerSampleTypeDialog();
        hstd.setUnitConverter(this.uc);
        hstd.setAllSampleType(alSampleType);
        hstd.setSampleTypeComboBox(this.cbSampleType);
        hstd.setUnitComboBox(this.cbUnit);
        this.cbSampleType.addEventHandler(ActionEvent.ACTION, (EventHandler)hstd);
        this.cbSampleType.setVisible(true);
        int i2 = 0;
        while (i2 < this.iCount) {
            gpChemical.add((Node)this.lChemicalName[i2], 1, i2 + 1);
            gpChemical.add((Node)this.tfValue[i2], 2, i2 + 1);
            ++i2;
        }
        gpChemical.add((Node)this.cbSampleType, 1, this.iCount + 1);
        gpChemical.add((Node)this.cbUnit, 2, this.iCount + 1);
        this.tgNAPL = new ToggleGroup();
        this.wrbNAPLFresh = new WrappedRadioButton("Fresh NAPL Source");
        this.wrbNAPLFresh.setSelected(true);
        this.wrbNAPLFresh.setToggleGroup(this.tgNAPL);
        this.wrbNAPLWeathered = new WrappedRadioButton("Weathered NAPL Source");
        this.wrbNAPLWeathered.setSelected(false);
        this.wrbNAPLWeathered.setToggleGroup(this.tgNAPL);
        gpChemical.add((Node)this.wrbNAPLFresh, 1, this.iCount + 2);
        gpChemical.add((Node)this.wrbNAPLWeathered, 2, this.iCount + 2);
        dialog.getDialogPane().setContent((Node)gpChemical);
        final ButtonType btOK = new ButtonType("Finished", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().add((Object)btOK);
        dialog.setResultConverter((Callback)new Callback<ButtonType, EstimatedConcentrationDialogData>(){

            public EstimatedConcentrationDialogData call(ButtonType bt) {
                if (bt == btOK) {
                    EstimatedConcentrationDialogData ecdd = new EstimatedConcentrationDialogData();
                    ecdd.setSampleType((String)EstimatedConcentrationDialog.this.cbSampleType.getValue());
                    ecdd.setUnit((String)EstimatedConcentrationDialog.this.cbUnit.getValue());
                    ecdd.setCount(EstimatedConcentrationDialog.this.iCount);
                    int i = 0;
                    while (i < EstimatedConcentrationDialog.this.iCount) {
                        ecdd.add(EstimatedConcentrationDialog.this.lChemicalName[i].getText(), EstimatedConcentrationDialog.this.tfValue[i].getText());
                        ++i;
                    }
                    return ecdd;
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            this.ecdd = (EstimatedConcentrationDialogData)result.get();
        }
    }

    public void setInputFileNames(InputFileNames ifn) {
        this.ifn = ifn;
    }

    public EstimatedConcentrationDialogData getResult() {
        return this.ecdd;
    }
}

