/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import pviScreen.dataContainers.ParameterChoices;
import pviScreen.dataContainers.VIControlData;
import ui.Repository;
import ui.VIUIInputData;
import ui.handler.HandlerEdit;
import util.NameConstants;
import util.Stripper;

public class PVIFileChooser {
    private String sCurrentDirectory;
    private String sInputFile;
    private String sInputFileAndPath;
    private String sInitialDirectory;
    private String sActiveDirectory;
    private Stage stage;
    private FileChooser fc;
    private ComboBox cbChemical;
    private VIUIInputData viUIInputData;
    private VIControlData viCD;
    private Repository repository;
    private ObservableList<Button> olButton;
    private NameConstants nc;
    private Stripper s;
    private ParameterChoices pc;

    public PVIFileChooser() {
    }

    public PVIFileChooser(Stage stage) {
        this.stage = stage;
        this.nc = new NameConstants();
        this.s = new Stripper();
    }

    public File selectFile() {
        this.fc = new FileChooser();
        this.sInitialDirectory = "projects";
        this.viCD = this.repository.getVIControlData();
        try {
            ArrayList<String> alInitialDirectory = this.pc.getValue("Project Directory", 1);
            this.sInitialDirectory = alInitialDirectory.get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fc.setTitle("PVIScreen File Input");
        try {
            this.sCurrentDirectory = new File(".").getCanonicalPath();
            this.sActiveDirectory = this.repository.getDirectory();
            this.sCurrentDirectory = this.sActiveDirectory != "" ? this.sActiveDirectory : String.valueOf(this.sCurrentDirectory) + "\\" + this.sInitialDirectory;
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Found Path " + this.sCurrentDirectory);
            this.fc.setInitialDirectory(new File(this.sCurrentDirectory));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.repository.getInputType().equalsIgnoreCase(this.nc.s_Radio_ExistingInput) || this.repository.getInputType().equalsIgnoreCase(this.nc.s_Radio_Template)) {
            this.fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PVIScreen ", new String[]{"*." + this.nc.s_Extension_Input}));
        } else if (this.repository.getInputType().equalsIgnoreCase(this.nc.s_Radio_PreviousResults)) {
            this.fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Results   ", new String[]{"*." + this.nc.s_Extension_Results}));
        }
        this.repository.setFileChooser(this.fc);
        return this.fc.showOpenDialog((Window)this.stage);
    }

    public void openFile(File fInputFile) throws IOException {
        block7: {
            block5: {
                block6: {
                    if (fInputFile == null) break block5;
                    this.sInputFile = fInputFile.getName();
                    this.sInputFileAndPath = fInputFile.getPath();
                    String sDirectory = fInputFile.getParent();
                    this.repository.setDirectory(sDirectory);
                    if (!this.repository.getInputType().equalsIgnoreCase(this.nc.s_Radio_ExistingInput) && !this.repository.getInputType().equalsIgnoreCase(this.nc.s_Radio_Template)) break block6;
                    this.viUIInputData = new VIUIInputData();
                    this.viUIInputData.setFileAndPathName(this.sInputFileAndPath);
                    String string = this.nc.s_Extension_Results;
                    this.nc.getClass();
                    this.viUIInputData.setResultsFileAndPathName(this.sInputFileAndPath, string, 3);
                    this.viUIInputData.setVIControlData(this.repository.getVIControlData());
                    this.viUIInputData.readInputData();
                    this.repository.setVIUIInputData(this.viUIInputData);
                    this.viCD = this.viUIInputData.getPVIScreenControlData();
                    this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Existing Input File Loaded to Interface.");
                    this.repository.setVIControlData(this.viCD);
                    break block7;
                }
                if (!this.repository.getInputType().equalsIgnoreCase(this.nc.s_Radio_PreviousResults)) break block7;
                HandlerEdit he = this.repository.getHandlerEdit();
                he.removeTabs();
                this.viUIInputData = new VIUIInputData();
                this.viUIInputData.extractInputFileNameFromOutputFile(this.sInputFile, this.sInputFileAndPath);
                this.viUIInputData.setVIControlData(this.repository.getVIControlData());
                this.viUIInputData.readInputData();
                this.repository.setVIUIInputData(this.viUIInputData);
                this.viCD = this.viUIInputData.getPVIScreenControlData();
                this.repository.setFilePathAndNameResults(this.sInputFileAndPath);
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "Results File Loaded to Interface.");
                break block7;
            }
            this.olButton = this.repository.getButtonList();
            for (Button button : this.olButton) {
                String sButton = button.getText();
                if (this.s.equals(this.nc.s_ButtonEdit, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                    continue;
                }
                if (this.s.equals(this.nc.s_ButtonRun, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                    continue;
                }
                if (this.s.equals(this.nc.s_ButtonSchematic, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                    continue;
                }
                if (this.s.equals(this.nc.s_ButtonResults, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                    continue;
                }
                if (!this.s.equals(this.nc.s_ButtonReport, sButton)) continue;
                button.setDisable(true);
                button.setStyle(this.nc.s_StyleDisable);
            }
        }
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setChemicalComboBox(ComboBox cbChemical) {
        this.cbChemical = cbChemical;
    }

    public String getInputFile() {
        return this.sInputFile;
    }

    public String getInputFileAndPath() {
        return this.sInputFileAndPath;
    }

    public VIControlData getPVIScreenControlData() {
        return this.viCD;
    }
}

