/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import jem.JEMMain;
import pviScreen.PVIScreenMain;
import pviScreen.VIModelController;
import pviScreen.dataContainers.VIControlData;
import statistics.RiskContainer;
import ui.Repository;
import ui.WriteTemplateFile;
import ui.handler.HandlerAbout;
import ui.handler.HandlerEdit;
import ui.handler.HandlerExit;
import ui.handler.HandlerInput;
import ui.handler.HandlerInputChoice;
import ui.handler.HandlerMainLabel;
import ui.handler.HandlerPrepareForRun;
import ui.handler.HandlerReport;
import ui.handler.HandlerRun;
import ui.handler.HandlerSitePlot;
import ui.handler.HandlerStatisticsPlot;
import util.CalendarClock;
import util.NameConstants;
import util.UnitConverter;

public class PVIScreenUI
extends Application {
    VIModelController viMC;
    VIControlData viCD;
    PVIScreenMain pvisMain;
    JEMMain jemMain;
    UnitConverter uc;
    BorderPane border;
    ScrollPane sp;
    HBox hbTopLabel;
    Label lTopLabel;
    HandlerMainLabel hml;
    String sInputFile;
    Button bEditInputFile;
    Button bSelectInputFile;
    Button bRunPVIScreenModel;
    Button bPrepareForRun;
    Button bDisplayStatisticalResults;
    Button bDisplaySchematic;
    Button bWriteReport;
    Button bAbout;
    Button bExit;
    ObservableList<Button> olButton;
    Repository repository;
    HandlerRun hr;
    HandlerStatisticsPlot hsp;
    HandlerInputChoice hic;
    HandlerEdit he;
    HandlerPrepareForRun hPrepareForRun;
    HandlerSitePlot hSitePlot;
    HandlerReport hReport;
    HandlerAbout hAbout;
    private NameConstants nc;

    public static void main(String[] args) {
        PVIScreenUI.launch(PVIScreenUI.class, (String[])args);
    }

    public void start(Stage stage) throws IOException {
        this.createModels();
        this.uc = new UnitConverter();
        try {
            this.uc.readUnits(this.viMC.getVIControlData().getInputFileNames().getFile_UnitConversions());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.border = new BorderPane();
        this.hbTopLabel = new HBox();
        this.hbTopLabel.getStyleClass().add((Object)"hbox");
        this.lTopLabel = new Label();
        this.lTopLabel.setId("top label");
        this.lTopLabel.setFont(new Font("Arial", 15.0));
        this.lTopLabel.setText("Welcome to PVIScreen:  Select an input file to begin");
        this.hbTopLabel.getChildren().add((Object)this.lTopLabel);
        HBox hbox = this.addHBox(stage);
        hbox.setId("Box 1");
        hbox.prefWidthProperty().bind((ObservableValue)stage.widthProperty());
        GridPane gpTop = new GridPane();
        gpTop.add((Node)hbox, 0, 0);
        gpTop.add((Node)this.hbTopLabel, 0, 1);
        this.border.setTop((Node)gpTop);
        this.sp = new ScrollPane();
        GridPane grid = null;
        try {
            FileInputStream fis = new FileInputStream("src/systemData/PVIScreenSchematic.jpg");
            Image imagePVIS = new Image((InputStream)fis);
            ImageView iv = new ImageView(imagePVIS);
            HBox hbImage = new HBox();
            hbImage.setAlignment(Pos.CENTER);
            hbImage.getChildren().add((Object)iv);
            grid = new GridPane();
            grid.add((Node)hbImage, 1, 1);
            grid.setAlignment(Pos.CENTER);
            grid.setPrefSize(this.nc.pref_WIDTH, this.nc.pref_HEIGHT);
            this.border.setCenter((Node)grid);
        }
        catch (Exception fis) {
            // empty catch block
        }
        Scene scene = new Scene((Parent)this.border);
        scene.getStylesheets().add((Object)"ui/layoutstyles.css");
        stage.setScene(scene);
        stage.setTitle("EPA PVIScreen");
        stage.centerOnScreen();
        Date date = new Date();
        CalendarClock cc = new CalendarClock();
        int iYear = cc.getYear();
        int iMonth = cc.getMonth();
        int iDay = cc.getDay();
        String sTemplateDirectory = String.valueOf(new File(".").getCanonicalPath()) + "\\projects\\templates";
        WriteTemplateFile wtf = new WriteTemplateFile();
        wtf.writeGroundWaterExample(sTemplateDirectory);
        wtf.writeGroundWaterExampleResidential(sTemplateDirectory);
        wtf.writeSoilGasExample(sTemplateDirectory);
        wtf.writeSoilGasExampleResidential(sTemplateDirectory);
        stage.show();
    }

    public void createModels() throws IOException {
        this.viMC = new VIModelController();
        this.viCD = new VIControlData();
        this.viMC.setVIControlData(this.viCD);
        this.viMC.manageModels();
        this.pvisMain = this.viMC.getPVIScreenMain();
        this.jemMain = this.viMC.getJEMMain();
    }

    private HBox addHBox(Stage stage) {
        this.repository = new Repository();
        this.repository.setVIControlData(this.viCD);
        this.repository.setStage(stage);
        this.repository.setBorder(this.border);
        this.repository.setTopLabelHBox(this.hbTopLabel);
        this.nc = new NameConstants();
        this.olButton = FXCollections.observableArrayList();
        RiskContainer rc = new RiskContainer();
        this.repository.setRiskContainer(rc);
        HBox hbox = new HBox();
        hbox.getStyleClass().add((Object)"hbox");
        ToggleGroup tgRadiButton = new ToggleGroup();
        RadioButton rb2 = new RadioButton(this.nc.s_Radio_Template);
        rb2.setSelected(false);
        rb2.setToggleGroup(tgRadiButton);
        RadioButton rb0 = new RadioButton(this.nc.s_Radio_ExistingInput);
        rb0.setSelected(true);
        rb0.setToggleGroup(tgRadiButton);
        RadioButton rb1 = new RadioButton(this.nc.s_Radio_PreviousResults);
        rb1.setSelected(false);
        rb1.setToggleGroup(tgRadiButton);
        this.repository.setInputType(rb0.getText());
        this.repository.setInputTypeFlagSet(true);
        this.hic = new HandlerInputChoice(stage);
        this.hic.setInputGroup(tgRadiButton);
        this.hic.setHandlerRepository(this.repository);
        rb0.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hic);
        rb1.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hic);
        rb2.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hic);
        VBox vbRadioButtonInput = new VBox();
        vbRadioButtonInput.getChildren().addAll((Object[])new Node[]{rb2});
        vbRadioButtonInput.getChildren().addAll((Object[])new Node[]{rb0});
        vbRadioButtonInput.getChildren().addAll((Object[])new Node[]{rb1});
        this.bSelectInputFile = new Button(this.nc.s_ButtonInput);
        this.bSelectInputFile.setStyle(this.nc.s_StyleEnable);
        this.bSelectInputFile.setDisable(false);
        HandlerInput hi = new HandlerInput(stage);
        hi.setTopLabel(this.lTopLabel);
        hi.setRadioButtonToggleGroup(tgRadiButton);
        hi.setHandlerRepository(this.repository);
        this.bSelectInputFile.addEventHandler(ActionEvent.ACTION, (EventHandler)hi);
        hi.setHandlerRepository(this.repository);
        this.olButton.add((Object)this.bSelectInputFile);
        this.bEditInputFile = new Button(this.nc.s_ButtonEdit);
        this.he = new HandlerEdit(stage);
        this.he.setButton(this.bEditInputFile);
        this.bEditInputFile.addEventHandler(ActionEvent.ACTION, (EventHandler)this.he);
        this.he.setHandlerRepository(this.repository);
        this.he.setTopLabel(this.lTopLabel);
        this.repository.setHandlerEdit(this.he);
        this.bEditInputFile.setDisable(true);
        this.bEditInputFile.setStyle(this.nc.s_StyleDisable);
        this.olButton.add((Object)this.bEditInputFile);
        this.bPrepareForRun = new Button(this.nc.s_ButtonSave);
        this.hPrepareForRun = new HandlerPrepareForRun(stage);
        this.hPrepareForRun.setButton(this.bPrepareForRun);
        this.hPrepareForRun.setTopLabel(this.lTopLabel);
        this.bPrepareForRun.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hPrepareForRun);
        this.hPrepareForRun.setHandlerRepository(this.repository);
        this.hPrepareForRun.setHandlerEdit(this.he);
        this.bPrepareForRun.setDisable(true);
        this.bPrepareForRun.setStyle(this.nc.s_StyleDisable);
        this.olButton.add((Object)this.bPrepareForRun);
        this.bDisplaySchematic = new Button(this.nc.s_ButtonSchematic);
        this.hSitePlot = new HandlerSitePlot(stage);
        this.hSitePlot.setRepository(this.repository);
        this.hSitePlot.setTopLabel(this.lTopLabel);
        this.bDisplaySchematic.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hSitePlot);
        this.bDisplaySchematic.setDisable(true);
        this.bDisplaySchematic.setStyle(this.nc.s_StyleDisable);
        this.olButton.add((Object)this.bDisplaySchematic);
        this.bRunPVIScreenModel = new Button(this.nc.s_ButtonRun);
        this.hr = new HandlerRun(stage);
        this.hr.setVIModelController(this.viMC);
        this.hr.setTopLabel(this.lTopLabel);
        this.bRunPVIScreenModel.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hr);
        this.hr.setHandlerRepository(this.repository);
        this.bRunPVIScreenModel.setDisable(true);
        this.bRunPVIScreenModel.setStyle(this.nc.s_StyleDisable);
        this.olButton.add((Object)this.bRunPVIScreenModel);
        this.bDisplayStatisticalResults = new Button(this.nc.s_ButtonResults);
        this.hsp = new HandlerStatisticsPlot(stage);
        this.bDisplayStatisticalResults.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hsp);
        this.hsp.setHandlerRepository(this.repository);
        this.hsp.setTopLabel(this.lTopLabel);
        this.repository.setHandlerStatisticsPlot(this.hsp);
        this.bDisplayStatisticalResults.setDisable(true);
        this.bDisplayStatisticalResults.setStyle(this.nc.s_StyleDisable);
        this.olButton.add((Object)this.bDisplayStatisticalResults);
        this.bWriteReport = new Button(this.nc.s_ButtonReport);
        this.hReport = new HandlerReport();
        this.hReport.setHandlerName("Report");
        this.hReport.setHandlerStage(stage);
        this.hReport.setHandlerRepository(this.repository);
        this.hReport.setHandlerSitePlot(this.hSitePlot);
        this.hReport.setTopLabel(this.lTopLabel);
        this.bWriteReport.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hReport);
        this.bWriteReport.setDisable(true);
        this.bWriteReport.setStyle(this.nc.s_StyleDisable);
        this.olButton.add((Object)this.bWriteReport);
        this.bAbout = new Button(this.nc.s_ButtonAbout);
        this.bAbout.setDisable(false);
        this.bAbout.setStyle(this.nc.s_StyleEnable);
        this.hAbout = new HandlerAbout();
        this.hAbout.setHandlerName("About");
        this.hAbout.setHandlerStage(stage);
        this.hAbout.setTopLabel(this.lTopLabel);
        this.bAbout.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hAbout);
        this.hAbout.setRepository(this.repository);
        this.repository.addEventHandler(this.hAbout);
        this.olButton.add((Object)this.bAbout);
        this.bExit = new Button(this.nc.s_ButtonExit);
        this.bExit.setDisable(false);
        this.bExit.setStyle(this.nc.s_StyleEnable);
        HandlerExit he = new HandlerExit();
        he.setHandlerName("Exit");
        he.setHandlerStage(stage);
        this.repository.addEventHandler(he);
        this.bExit.addEventHandler(ActionEvent.ACTION, (EventHandler)he);
        this.olButton.add((Object)this.bExit);
        this.repository.setButtonList(this.olButton);
        hbox.getChildren().addAll((Object[])new Node[]{vbRadioButtonInput, this.bSelectInputFile, this.bEditInputFile, this.bDisplaySchematic, this.bPrepareForRun, this.bRunPVIScreenModel, this.bDisplayStatisticalResults, this.bWriteReport, this.bAbout, this.bExit});
        return hbox;
    }

    private AnchorPane addAnchorPane(GridPane grid) {
        AnchorPane anchorpane = new AnchorPane();
        anchorpane.getStyleClass().add((Object)"pane");
        Button buttonSave = new Button("Save");
        buttonSave.setId("button-custom");
        Button buttonCancel = new Button("Cancel");
        buttonCancel.setId("button-custom");
        HBox hb = new HBox();
        hb.getStyleClass().add((Object)"hbox");
        hb.setId("hbox-custom");
        hb.getChildren().addAll((Object[])new Node[]{buttonSave, buttonCancel});
        anchorpane.getChildren().addAll((Object[])new Node[]{grid, hb});
        AnchorPane.setBottomAnchor((Node)hb, (Double)8.0);
        AnchorPane.setRightAnchor((Node)hb, (Double)5.0);
        AnchorPane.setTopAnchor((Node)grid, (Double)10.0);
        return anchorpane;
    }
}

