/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javax.imageio.ImageIO;
import pviScreen.dataContainers.Building;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.OilLens;
import pviScreen.dataContainers.RawInput;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.RunIdentifier;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataContainers.VadoseZone;
import statistics.RiskContainer;
import ui.ReadOutputForResults;
import ui.Repository;
import ui.handler.HandlerSitePlot;
import ui.handler.HandlerStatisticsPlot;
import util.CalendarClock;
import util.ClipPathOrFile;
import util.FileLogger;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class ReportWriter {
    private Repository repository;
    private HandlerStatisticsPlot hsp;
    private VIControlData viCD;
    private RunIdentifier runID;
    private RiskContainer rc;
    private String sOutputFileAndPath;
    private String sInputFileAndPath;
    private String sModelName;
    private FileLogger flReport;
    private String sReportFileName;
    private int iFigureCount;
    private int iTableCount;
    private OutputDigits od;
    private Stripper s;
    private NameConstants nc;
    private UnitConverter uc;
    private double[] dColorLow;
    private double[] dColorHigh;
    private HandlerSitePlot hSitePlot;
    private String sOut;
    private String sOutputUnit;
    private String sSectionTitle;
    private String sTableTitle;
    private TableRow tr;
    private ArrayList<String> alParagraph = new ArrayList();
    private ArrayList<TableRow> alHeading = new ArrayList();
    private ArrayList<TableRow> alTableRow = new ArrayList();
    private ArrayList<TableRow> alTableNotes;
    private ArrayList<ModelComparison> alModelComparison;
    ArrayList<String> alHeadings;

    public ReportWriter() {
        this.od = new OutputDigits();
        this.od.setParameters(2, -500, 500, -4, 4);
        this.alModelComparison = new ArrayList();
    }

    public void prepareGraphics() {
        BorderPane border = this.repository.getBorder();
        final TabPane tp2 = (TabPane)border.getCenter();
        Task<Void> task = new Task<Void>(){

            public Void call() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ObservableList olTab = tp2.getTabs();
                            int iCount = 0;
                            for (Tab tab : olTab) {
                                if (!tab.getText().equalsIgnoreCase("benzene")) continue;
                                WritableImage snapshot = tab.getContent().snapshot(new SnapshotParameters(), null);
                                String sFilePNG = "test2Name" + iCount + ".png";
                                File outFile = new File(sFilePNG);
                                try {
                                    ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)snapshot, null), "png", outFile);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                ReportWriter.this.repository.addOutputImage(snapshot);
                                ReportWriter.this.repository.addOutputImageName(tab.getText());
                                ++iCount;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                return null;
            }
        };
        Thread th = new Thread((Runnable)task);
        th.start();
    }

    public void startWritingReport() {
        this.s = new Stripper();
        this.nc = new NameConstants();
        this.hsp = this.repository.getHandlerStatisticsPlot();
        this.rc = this.repository.getRiskContainer();
        this.viCD = this.repository.getVIControlData();
        this.uc = this.viCD.getUnitConverter();
        this.runID = this.viCD.getRunIdentifier();
        this.sInputFileAndPath = this.repository.getInputFileAndPath();
        this.sOutputFileAndPath = this.repository.getFilePathAndNameResults();
        this.dColorLow = this.repository.getColorLow();
        this.dColorHigh = this.repository.getColorHigh();
        this.iFigureCount = 1;
        this.iTableCount = 1;
        this.od = new OutputDigits();
        this.sOutputUnit = this.uc.getOutputNameFromType("AirPhaseConcentration");
    }

    public void writeReportHeadings() {
        String sOut = "";
        this.flReport.logMessage("<!DOCTYPE html>");
        this.flReport.logMessage("<html>");
        this.flReport.logMessage("<head>");
        sOut = "<style>table, th, td{border-collapse:collapse;}</style>";
        this.flReport.logMessage(sOut);
        sOut = "<style>table, th, td{border:1px solid green;}</style>";
        this.flReport.logMessage(sOut);
        sOut = "<style>td{text-align:center;}</style>";
        this.flReport.logMessage(sOut);
        sOut = "<style>th{background-color:green;color:white;}</style>";
        this.flReport.logMessage(sOut);
        sOut = "<style>caption {caption-side:top;}</style>";
        sOut = "";
        sOut = String.valueOf(sOut) + "<style>#risk{font-family:\"Trebuchet MS\", Arial, Helvetica, sans-serif;width:80%;border-collapse:collapse;}";
        sOut = String.valueOf(sOut) + "#risk td {font-size:1em;padding:3px 7px 2px 7px;}";
        sOut = String.valueOf(sOut) + "#risk th {font-size:1.1em;text-align:left;padding-top:5px;padding-bottom:4px;background-color:#A7C942;color:#ffffff;}";
        sOut = String.valueOf(sOut) + "#risk tr.alt td {color:#000000;background-color:#EAF2D3;}";
        sOut = String.valueOf(sOut) + "#risk tr.high td{color:#990033;background-color:#FFFFFF;}";
        sOut = String.valueOf(sOut) + "</style>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "<style>#norisk{font-family:\"Trebuchet MS\", Arial, Helvetica, sans-serif;width:60%;border-collapse:collapse;}";
        sOut = String.valueOf(sOut) + "#norisk td {font-size:1em;padding:3px 7px 2px 7px;}";
        sOut = String.valueOf(sOut) + "#norisk th {font-size:1.1em;text-align:left;padding-top:5px;padding-bottom:4px;background-color:#A7C942;color:#ffffff;}";
        sOut = String.valueOf(sOut) + "#norisk tr.alt td {color:#000000;background-color:#EAF2D3;}";
        sOut = String.valueOf(sOut) + "#norisk tr.high td{color:#990033;background-color:#FFFFFF;}";
        sOut = String.valueOf(sOut) + "</style>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "<style>#source{font-family:\"Trebuchet MS\", Arial, Helvetica, sans-serif;width:80%;border-collapse:collapse;}";
        sOut = String.valueOf(sOut) + "#source td {font-size:1em;padding:3px 7px 2px 7px;}";
        sOut = String.valueOf(sOut) + "#source th {font-size:1.1em;text-align:left;padding-top:5px;padding-bottom:4px;background-color:#A7C942;color:#ffffff;}";
        sOut = String.valueOf(sOut) + "#source tr.alt td {color:#000000;background-color:#EAF2D3;}";
        sOut = String.valueOf(sOut) + "#source tr.high td{color:#990033;background-color:#FFFFFF;}";
        sOut = String.valueOf(sOut) + "</style>";
        this.flReport.logMessage(sOut);
        this.flReport.logMessage("</head>");
        this.flReport.logMessage("<body>");
        this.flReport.logMessage("<FONT face=\"verdana\">");
        this.flReport.logMessage("<center>");
        this.flReport.logMessage("<br>");
        this.flReport.logMessage("<h1>");
        this.flReport.logMessage("PVIScreen Model Report");
        this.flReport.logMessage("</h1>");
        this.flReport.logMessage("<br>");
        this.flReport.logMessage("</center>");
    }

    public void writeRunIdentification() {
        String sOut = "";
        this.flReport.logMessage("<h2>Run Identification</h2>");
        sOut = "";
        sOut = String.valueOf(sOut) + "<br>";
        sOut = String.valueOf(sOut) + "Site: " + this.runID.getSite();
        sOut = String.valueOf(sOut) + "<br>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "Location: " + this.runID.getLocation();
        sOut = String.valueOf(sOut) + "<br>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "City: " + this.runID.getCity();
        sOut = String.valueOf(sOut) + "<br>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "State: " + this.runID.getState();
        sOut = String.valueOf(sOut) + "<br>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "Analyst: " + this.runID.getAnalyst();
        sOut = String.valueOf(sOut) + "<br>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "Affiliation: " + this.runID.getAffiliation();
        sOut = String.valueOf(sOut) + "<br>";
        this.flReport.logMessage(sOut);
        sOut = "";
        String sDate = this.runID.getDate();
        if (sDate.equalsIgnoreCase("")) {
            CalendarClock cc = new CalendarClock();
            sDate = String.valueOf(cc.getThreeLetterMonth()) + " " + cc.getDay() + " " + cc.getYear();
        }
        sOut = String.valueOf(sOut) + "Date: " + sDate;
        sOut = String.valueOf(sOut) + "<br>";
        this.flReport.logMessage(sOut);
    }

    public void writePVIScreenParagraph() {
        this.renewArrayListsOfTables();
        this.sSectionTitle = "PVIScreen Background";
        this.sOut = "PVIScreen is a model for assessing impacts from petroleum vapors on residences. ";
        this.sOut = String.valueOf(this.sOut) + "PVIScreen was designed for automatic uncertainty analysis using Monte Carlo simulation, ";
        this.sOut = String.valueOf(this.sOut) + "and can add one line-of-evidence to a petroleum vapor intrusion investigation.  ";
        this.sOut = String.valueOf(this.sOut) + "The main result from the model is a probabiliy distribution for indoor air concentration for each simulated chemical. ";
        this.sOut = String.valueOf(this.sOut) + "The model results are compared against screening levels supplied by the user. ";
        this.alParagraph.add(this.sOut);
        this.sOut = "PVIScreen is available from <a href='https://www.epa.gov/land-research/pviscreen'>U.S. EPA</a>. ";
        this.sOut = String.valueOf(this.sOut) + "The reference guide is titled 'Petroleum Vapor Intrusion Modeling Assessment with PVIScreen, EPA/600/R-16/175.' ";
        this.alParagraph.add(this.sOut);
        this.sOut = "PVIScreen is based on the BioVapor model (Devaull, 2007; API, 2010). ";
        this.sOut = String.valueOf(this.sOut) + "PVIScreen extends the capabilities of BioVapor by including automatic uncertainty analysis, " + "flexible unit selection, and direct inclusion of liquid gasoline (NAPL). ";
        this.sOut = String.valueOf(this.sOut) + "Major assumptions of the model include:";
        this.sOut = "<ul>";
        this.sOut = String.valueOf(this.sOut) + this.addListItem("Oxygen supply permits/limits biodegradation of petroleum vapors");
        this.sOut = String.valueOf(this.sOut) + this.addListItem("Multiple components of fuel contribute to oxygen demand");
        this.sOut = String.valueOf(this.sOut) + this.addListItem("Soil Respiration contributes to oxygen demand");
        this.sOut = String.valueOf(this.sOut) + this.addListItem("Homogeneous vadose zone");
        this.sOut = String.valueOf(this.sOut) + this.addListItem("Steady state conditions");
        this.sOut = String.valueOf(this.sOut) + "</ul>";
        this.alParagraph.add(this.sOut);
        this.writeReportSection(this.sSectionTitle, this.alParagraph, "", null, null, null);
    }

    public void writeIOInformation() {
        ClipPathOrFile cpof = new ClipPathOrFile();
        this.sSectionTitle = "Input and Output File Information";
        String sOut = "The results in this report were generated from: " + cpof.clipPathOrFile(this.sInputFileAndPath, "file") + ".";
        this.alParagraph.add(sOut);
        sOut = "The result file is: " + cpof.clipPathOrFile(this.sOutputFileAndPath, "file") + ".";
        this.alParagraph.add(sOut);
        sOut = "This file is: " + cpof.clipPathOrFile(this.sReportFileName, "file") + ".";
        this.alParagraph.add(sOut);
        sOut = "All of these are located in directory: " + cpof.clipPathOrFile(this.sInputFileAndPath, "path") + ".";
        this.alParagraph.add(sOut);
        this.writeReportSection(this.sSectionTitle, this.alParagraph, "", null, null, null);
    }

    public void writeSiteSchmatic() {
        File fSchematic;
        Building bldg = this.viCD.getBuilding();
        VadoseZone vz = this.viCD.getVadoseZone();
        OilLens ol = this.viCD.getOilLens();
        UnitConverter uc = this.viCD.getUnitConverter();
        double dUCF = uc.getOutputUCFFromType("Length");
        String sUCF = uc.getOutputNameFromType("Length");
        this.sSectionTitle = "Site Description";
        String sOut = "The depths of the foundation, water table, historic water table, top of contamination are shown in Figure ";
        sOut = String.valueOf(sOut) + this.iFigureCount + ".  ";
        sOut = String.valueOf(sOut) + "The depth of the foundation is ";
        sOut = String.valueOf(sOut) + this.od.num2String(bldg.getFoundationDepthBelowGrade() * dUCF);
        sOut = String.valueOf(sOut) + " ";
        sOut = String.valueOf(sOut) + sUCF;
        sOut = String.valueOf(sOut) + ", and ";
        sOut = String.valueOf(sOut) + "the depth to the water table is ";
        sOut = String.valueOf(sOut) + this.od.num2String(vz.getDepthToWaterTable() * dUCF) + " " + sUCF + ".  ";
        sOut = String.valueOf(sOut) + "The depth to the historic water table is ";
        sOut = String.valueOf(sOut) + this.od.num2String(vz.getDepthToHistoricWaterTable() * dUCF) + " " + sUCF + ".  ";
        sOut = String.valueOf(sOut) + "The distance between the bottom of the foundation and the sample that defines the contamination is ";
        double dFoundationElevation = ol.getSurfaceElevation() - bldg.getFoundationDepthBelowGrade();
        sOut = String.valueOf(sOut) + this.od.num2String((vz.getDepthToSample() - dFoundationElevation) * dUCF) + " " + sUCF + ".  ";
        sOut = String.valueOf(sOut) + "The depth of sample is " + this.od.num2String(vz.getDepthToSample() * dUCF) + " " + sUCF + ".  ";
        this.alParagraph.add(sOut);
        this.writeReportSection(this.sSectionTitle, this.alParagraph, "", null, null, null);
        sOut = "<div class=\"figure\">";
        this.flReport.logMessage(sOut);
        String sPNGSchematic = this.repository.getPNGSiteSchematicFileName();
        if (sPNGSchematic == null) {
            ClipPathOrFile cpof = new ClipPathOrFile();
            sPNGSchematic = cpof.clipPathOrFile(this.repository.getFilePathAndNameHTML(), "PathAndFile");
            sPNGSchematic = String.valueOf(sPNGSchematic) + "." + this.nc.s_Extension_PNG_Schematic;
        }
        if ((fSchematic = new File(sPNGSchematic)).exists()) {
            sOut = "<p><img src=\"" + sPNGSchematic + "\" alt=\"Site Schematic\" ></img>" + "</p>";
            this.flReport.logMessage(sOut);
            sOut = "<p>Figure " + this.iFigureCount + "   Site Schematic." + "</p>" + "</div>";
            ++this.iFigureCount;
            this.flReport.logMessage(sOut);
        }
    }

    public void writeSourceDefinition() {
        UnitConverter uc = this.viCD.getUnitConverter();
        this.renewArrayListsOfTables();
        this.sSectionTitle = "Source Definition";
        this.alParagraph.add("The source of contamination is defined by: " + this.getSourceDescription() + ".");
        this.sTableTitle = "Source Definition";
        this.tr = new TableRow();
        this.tr.add("Name");
        this.tr.add("Source Data");
        this.tr.add("Concentration");
        this.alHeading.add(this.tr);
        boolean bFirst = false;
        for (Chemical chemical : this.viCD.getChemicals()) {
            if (!chemical.getIsUsedInSimulation()) continue;
            this.tr = new TableRow();
            this.tr.add(chemical.getName());
            this.tr.add(chemical.getInputType());
            String sUnitType = chemical.getInputType();
            double[] dChemicalDistrubtion = chemical.getConcentrationDistribution("Chemical");
            double dConc = chemical.getSourceConcentration(sUnitType);
            double dUC = uc.getOutputUCFFromType(sUnitType);
            this.tr.add(String.valueOf(this.od.num2String(chemical.getSourceConcentration(sUnitType) * uc.getOutputUCFFromType(sUnitType))) + " " + uc.getOutputNameFromType(sUnitType));
            this.alTableRow.add(this.tr);
        }
        this.writeReportSection(this.sSectionTitle, this.alParagraph, this.sTableTitle, this.alHeading, this.alTableRow, null);
    }

    private String getSourceDescription() {
        String sReturn = "";
        String sInputType = "";
        int iAirPhase = 0;
        int iSoilSample = 0;
        int iNAPLMass = 0;
        int iNAPLVolume = 0;
        int iWater = 0;
        int iType = 0;
        for (Chemical chemical : this.viCD.getChemicals()) {
            sInputType = chemical.getInputType();
            if (!chemical.getIsUsedInSimulation()) continue;
            if (this.s.areTheyEqual("AirPhaseConcentration", sInputType)) {
                ++iAirPhase;
                continue;
            }
            if (this.s.areTheyEqual("SoilSample", sInputType)) {
                ++iSoilSample;
                continue;
            }
            if (this.s.areTheyEqual("WaterPhaseConcentration", sInputType)) {
                ++iWater;
                continue;
            }
            if (this.s.areTheyEqual("FuelPhaseConcentrationByMass", sInputType)) {
                ++iNAPLMass;
                continue;
            }
            if (!this.s.areTheyEqual("FuelPhaseConcentrationByVolume", sInputType)) continue;
            ++iNAPLVolume;
        }
        if (iAirPhase > 0) {
            sReturn = String.valueOf(sReturn) + " " + iAirPhase + " chemicals with soil gas data";
            ++iType;
        }
        if (iSoilSample > 0) {
            sReturn = String.valueOf(sReturn) + " " + iSoilSample + " chemicals with soil sample data";
            ++iType;
        }
        if (iWater > 0) {
            sReturn = String.valueOf(sReturn) + " " + iWater + " chemicals with water phase data";
            ++iType;
        }
        if (iNAPLMass > 0) {
            sReturn = String.valueOf(sReturn) + " " + iNAPLMass + " chemicals with NAPL (concentration by mass) data";
            ++iType;
        }
        if (iNAPLVolume > 0) {
            sReturn = String.valueOf(sReturn) + " " + iNAPLVolume + " chemicals with NAPL (concentration by volume) data";
            ++iType;
        }
        if (iType > 1) {
            sReturn = String.valueOf(sReturn) + " " + "Mixed input concentration sources, check these for consistency.";
        }
        return sReturn;
    }

    public void writeScreeningLevelTable() {
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        int iCount = 0;
        this.renewArrayListsOfTables();
        for (Chemical c : alChemical) {
            if (!c.getScreeningLevelSet()) continue;
            ++iCount;
        }
        if (iCount == 0) {
            return;
        }
        this.sSectionTitle = "Results";
        String sOut = "Modeled indoor air concentrations are compared to the following screening levels.  ";
        sOut = String.valueOf(sOut) + "The percentage of simulations that exceeded the screening level are given in the last column.  ";
        sOut = String.valueOf(sOut) + "If this percentage is zero, then none of the simulations exceed the screening level for the chemical. ";
        sOut = String.valueOf(sOut) + "The results are ranked by highest modeled risk first. ";
        this.alParagraph.add(sOut);
        this.sTableTitle = "ScreeningLevelResults";
        String sScreeningUnit = this.uc.getOutputNameFromType("RiskConcentration");
        this.tr = new TableRow();
        this.tr.add("Name");
        this.tr.add("Screening Level (" + sScreeningUnit + ")");
        this.tr.add("% Simulations Above Screening Level");
        this.alHeading.add(this.tr);
        this.rc.sortScreeningByPerCentExceeds();
        int i = 0;
        while (i < this.rc.getTotalCount()) {
            if (this.rc.getIsScreeningChemical(i)) {
                this.tr = new TableRow();
                this.tr.add(this.rc.getScreeningdName(i));
                this.tr.add(this.od.num2String(this.rc.getScreeningConcentration(i)));
                this.tr.add(this.od.num2String(this.rc.getScreeningPerCent(i)));
                this.alTableRow.add(this.tr);
            }
            ++i;
        }
        this.writeReportSection(this.sSectionTitle, this.alParagraph, this.sTableTitle, this.alHeading, this.alTableRow, null);
    }

    public void writeRiskResults() {
        this.flReport.logMessage("<h2>Risk Results</h2>");
        String sOut = "";
        sOut = String.valueOf(sOut) + "The model determines cancer risk for carcinogenic constituents of gasoline, ";
        sOut = String.valueOf(sOut) + "and non-cancer risks for as many consituents as possible.  ";
        sOut = String.valueOf(sOut) + "<A href=\"http://www.epa.gov/iris\")> EPA's Integrated Risk Assessment System (IRIS) </A> ";
        sOut = String.valueOf(sOut) + " was consulted for cancer risk levels and non-cancer reference concentrations (RfCs). ";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "</p>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "Results are given separately for cancer (Table " + this.iTableCount + ")";
        int iTemp = this.iTableCount + 1;
        sOut = String.valueOf(sOut) + ", and non-cancer risks (Table " + iTemp + ").";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "For each kind of risk, the chemicals are listed from highest to lowest risk, ";
        sOut = String.valueOf(sOut) + "according to the percentage of simulations exceeding the specified risk levels.  ";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "For example, if 20% of simulations exceed a hazard quotient of 1.0 for xylenes, and 3% exceed a hazard ";
        sOut = String.valueOf(sOut) + "quotient of 0.2 for toluene, then xylenes will appear first as the highest risk chemical and hazard quotient.  ";
        sOut = String.valueOf(sOut) + "This happens because more simulations for xylenes (20%) exceed the hazard quotient, than do for toluene (3%).  ";
        this.flReport.logMessage(sOut);
    }

    public void writeChemicalInput() {
        RawInputLine ril;
        ClipPathOrFile cpof = new ClipPathOrFile();
        String sOut = "";
        sOut = String.valueOf(sOut) + "<h2>";
        sOut = String.valueOf(sOut) + "Chemical Input Data";
        sOut = String.valueOf(sOut) + "</h2>";
        this.flReport.logMessage(sOut);
        String sClippedFile = cpof.clipPathOrFile(this.sInputFileAndPath, "file");
        RawInput ri = this.viCD.getRawInput();
        this.flReport.logMessage("<center>");
        this.flReport.logMessage("<table id='risk'>");
        sOut = "";
        sOut = String.valueOf(sOut) + "<tr><th colspan='7'>";
        sOut = String.valueOf(sOut) + "Table " + this.iTableCount + " Variable parameters from file:  " + sClippedFile + ".";
        sOut = String.valueOf(sOut) + "</th></tr>";
        this.flReport.logMessage(sOut);
        sOut = "<tr>";
        sOut = String.valueOf(sOut) + this.addHeadingCell("Group");
        sOut = String.valueOf(sOut) + this.addHeadingCell("InputType");
        sOut = String.valueOf(sOut) + this.addHeadingCell("Distribution Type");
        sOut = String.valueOf(sOut) + this.addHeadingCell("Chemical");
        sOut = String.valueOf(sOut) + this.addHeadingCell("Value");
        sOut = String.valueOf(sOut) + this.addHeadingCell("Unit");
        sOut = String.valueOf(sOut) + this.addHeadingCell("Frequency");
        sOut = String.valueOf(sOut) + "</tr>";
        this.flReport.logMessage(sOut);
        ArrayList<RawInputLine> alRIL = ri.getAllRawInputLines();
        int iSize = alRIL.size();
        boolean bWrite = true;
        String sPrevName = "";
        String sName = "";
        boolean bTRAlt = true;
        int i = 0;
        while (i < iSize - 1) {
            ril = alRIL.get(i);
            sName = ril.getParameterName();
            String sRawInputType = ril.getRawInputType();
            bWrite = false;
            if (this.s.areTheyEqual(this.nc.s_CHEMICALINPUT, sRawInputType)) {
                bWrite = true;
            }
            String sTest = ril.getDistributionType();
            double dThisValue = ril.getValue();
            try {
                RawInputLine rilNext = alRIL.get(i + 1);
                double dNextValue = rilNext.getValue();
                double dTestValue = (dThisValue - dNextValue) / (0.5 * (dThisValue + dNextValue));
                if (Math.abs(dTestValue) <= 1.0E-6) {
                    bWrite = false;
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bWrite) {
                sOut = "";
                if (!sPrevName.equalsIgnoreCase(sName)) {
                    bTRAlt = !bTRAlt;
                }
                sOut = bTRAlt ? String.valueOf(sOut) + "<tr class='alt'>" : String.valueOf(sOut) + "<tr>";
                sOut = String.valueOf(sOut) + this.addDataCell(ril.getGroupName());
                sOut = String.valueOf(sOut) + this.addDataCell(ril.getParameterName2());
                sOut = String.valueOf(sOut) + this.addDataCell(ril.getDistributionType());
                sOut = String.valueOf(sOut) + this.addDataCell(ril.getParameterName());
                sOut = String.valueOf(sOut) + this.addDataCell("" + ril.getValue());
                sOut = String.valueOf(sOut) + this.addDataCell(ril.getUnit());
                sOut = String.valueOf(sOut) + this.addDataCell("" + ril.getFrequency());
                sOut = String.valueOf(sOut) + "</tr>";
                this.flReport.logMessage(sOut);
            } else {
                sOut = "";
            }
            sPrevName = sName;
            ++i;
        }
        if (bWrite && !(ril = alRIL.get(iSize - 1)).getDistributionType().equalsIgnoreCase("Constant")) {
            sOut = String.valueOf(sOut) + this.addDataCell(ril.getGroupName());
            sOut = String.valueOf(sOut) + this.addDataCell(ril.getParameterName2());
            sOut = String.valueOf(sOut) + this.addDataCell(ril.getDistributionType());
            sOut = String.valueOf(sOut) + this.addDataCell(ril.getParameterName());
            sOut = String.valueOf(sOut) + this.addDataCell("" + ril.getValue());
            sOut = String.valueOf(sOut) + this.addDataCell(ril.getUnit());
            sOut = String.valueOf(sOut) + this.addDataCell("" + ril.getFrequency());
        }
        this.flReport.logMessage("</table>");
        this.flReport.logMessage("</CENTER>");
        sOut = "<BR><BR><BR>";
        this.flReport.logMessage(sOut);
    }

    public void writeInputData() {
        double dTestValue;
        double dNextValue;
        RawInputLine rilNext;
        double dThisValue;
        String sTest;
        RawInputLine ril;
        ClipPathOrFile cpof = new ClipPathOrFile();
        this.renewArrayListsOfTables();
        this.sSectionTitle = "Input Data";
        String sOut = "Input parameters can be chosen to vary according to a statistical distribution or be set as constants.  ";
        int iC2 = this.iTableCount + 1;
        sOut = String.valueOf(sOut) + "Tables separately give the values of the variable (Table " + this.iTableCount + ") and constant (Table " + iC2 + ") parameters.  ";
        this.alParagraph.add(sOut);
        String sClippedFile = cpof.clipPathOrFile(this.sInputFileAndPath, "file");
        RawInput ri = this.viCD.getRawInput();
        this.sTableTitle = " Variable parameters from file:  " + sClippedFile + ".";
        this.tr = new TableRow();
        this.tr.add("Group");
        this.tr.add("Parameter");
        this.tr.add("Distribution Type");
        this.tr.add("Value");
        this.tr.add("Unit");
        this.tr.add("Frequency");
        this.alHeading.add(this.tr);
        ArrayList<RawInputLine> alRIL = ri.getAllRawInputLines();
        int iSize = alRIL.size();
        boolean bWrite = true;
        String sPrevName = "";
        String sName = "";
        int i = 0;
        while (i < iSize - 1) {
            ril = alRIL.get(i);
            sName = ril.getParameterName();
            String sRawInputType = ril.getRawInputType();
            bWrite = false;
            if (this.s.areTheyEqual(this.nc.s_VALUEINPUT, sRawInputType)) {
                bWrite = true;
            }
            if ((sTest = ril.getDistributionType()).equalsIgnoreCase("Constant")) {
                bWrite = false;
            } else {
                dThisValue = ril.getValue();
                try {
                    rilNext = alRIL.get(i + 1);
                    dNextValue = rilNext.getValue();
                    dTestValue = (dThisValue - dNextValue) / (0.5 * (dThisValue + dNextValue));
                    if (Math.abs(dTestValue) <= 1.0E-6) {
                        bWrite = false;
                        ++i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bWrite) {
                sOut = "";
                this.tr = new TableRow();
                this.tr.add(ril.getGroupName());
                this.tr.add(ril.getParameterName());
                this.tr.add(ril.getDistributionType());
                this.tr.add("" + ril.getValue());
                this.tr.add(ril.getUnit());
                this.tr.add("" + ril.getFrequency());
                this.alTableRow.add(this.tr);
            } else {
                sOut = "";
            }
            sPrevName = sName;
            ++i;
        }
        if (bWrite && !(ril = alRIL.get(iSize - 1)).getDistributionType().equalsIgnoreCase("Constant")) {
            this.tr.add(ril.getGroupName());
            this.tr.add(ril.getParameterName());
            this.tr.add(ril.getDistributionType());
            this.tr.add("" + ril.getValue());
            this.tr.add(ril.getUnit());
            this.tr.add("" + ril.getFrequency());
            this.alTableRow.add(this.tr);
        }
        this.writeReportSection(this.sSectionTitle, this.alParagraph, this.sTableTitle, this.alHeading, this.alTableRow, null);
        this.renewArrayListsOfTables();
        this.sSectionTitle = "";
        this.sTableTitle = " Constant parameters (and effectively constant parameters) from file:  " + sClippedFile + ".";
        this.tr = new TableRow();
        this.tr.add("Group");
        this.tr.add("Parameter");
        this.tr.add("Distribution Type");
        this.tr.add("Value");
        this.tr.add("Unit");
        this.alHeading.add(this.tr);
        boolean bAdditionalText = false;
        String sDistribution = "";
        bWrite = false;
        int i2 = 0;
        while (i2 < iSize - 1) {
            ril = alRIL.get(i2);
            sDistribution = ril.getDistributionType();
            bWrite = false;
            sOut = "";
            String sAdditionalText = "";
            sTest = ril.getDistributionType();
            if (sTest.equalsIgnoreCase("Constant")) {
                bWrite = true;
            } else {
                dThisValue = ril.getValue();
                String sThisName = ril.getGroupName();
                try {
                    rilNext = alRIL.get(i2 + 1);
                    dNextValue = rilNext.getValue();
                    String sNextName = rilNext.getGroupName();
                    if (sThisName.equalsIgnoreCase(sNextName) && Math.abs(dTestValue = (dThisValue - dNextValue) / (0.5 * (dThisValue + dNextValue))) <= 1.0E-6) {
                        bWrite = true;
                        sDistribution = "Effectively Constant";
                        sAdditionalText = "(*)";
                        bAdditionalText = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bWrite) {
                this.tr = new TableRow();
                this.tr.add(ril.getGroupName());
                this.tr.add(ril.getParameterName());
                this.tr.add(String.valueOf(sDistribution) + " " + sAdditionalText);
                this.tr.add("" + ril.getValue());
                this.tr.add(ril.getUnit());
                this.alTableRow.add(this.tr);
            } else {
                sOut = "";
            }
            ++i2;
        }
        if (bWrite && (ril = alRIL.get(iSize - 1)).getDistributionType().equalsIgnoreCase("Constant")) {
            this.tr = new TableRow();
            this.tr.add(ril.getGroupName());
            this.tr.add(ril.getParameterName());
            this.tr.add(ril.getDistributionType());
            this.tr.add("" + ril.getValue());
            this.tr.add(ril.getUnit());
            this.alTableRow.add(this.tr);
        }
        if (bAdditionalText) {
            this.tr = new TableRow();
            this.tr.add("(*) Parameter is effectively constant because input was declared variable, but the two or more input values were the same.");
            this.alTableNotes.add(this.tr);
        }
        this.writeReportSection(this.sSectionTitle, this.alParagraph, this.sTableTitle, this.alHeading, this.alTableRow, this.alTableNotes);
    }

    public void writeRiskData() {
        String sName = "";
        boolean bExit = true;
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        for (Chemical chemical : alChemical) {
            sName = chemical.getName();
            if (!chemical.getIsUsedInSimulation() || chemical.getScreeningLevelSet()) continue;
            bExit = false;
        }
        if (bExit) {
            return;
        }
        this.uc = this.viCD.getUnitConverter();
        String sOut = "";
        sOut = String.valueOf(sOut) + "<h2>";
        sOut = String.valueOf(sOut) + "Toxicity Values";
        sOut = String.valueOf(sOut) + "</h2>";
        this.flReport.logMessage(sOut);
        sOut = "";
        sOut = String.valueOf(sOut) + "<p>";
        sOut = String.valueOf(sOut) + "Toxicity parameters are found in the systemData file 03ChemicalProperties.cvs and Table (" + this.iTableCount + ")";
        sOut = String.valueOf(sOut) + "</p>";
        this.flReport.logMessage(sOut);
        this.flReport.logMessage("<center>");
        this.flReport.logMessage("<table id='risk'>");
        sOut = "";
        sOut = String.valueOf(sOut) + "<tr><th colspan='4'>";
        sOut = String.valueOf(sOut) + "Table " + this.iTableCount + " Risk parameters from system data file 03ChemicalProperties.csv.";
        sOut = String.valueOf(sOut) + "</th></tr>";
        this.flReport.logMessage(sOut);
        sOut = "<tr>";
        sOut = String.valueOf(sOut) + "</tr>";
        this.flReport.logMessage(sOut);
        this.od = new OutputDigits();
        boolean bWrite = true;
        boolean bTRAlt = true;
        for (Chemical chemical : alChemical) {
            sName = chemical.getName();
            if (!chemical.getIsUsedInSimulation() || chemical.getScreeningLevelSet()) continue;
            if (bWrite) {
                sOut = "";
                bTRAlt = !bTRAlt;
                sOut = bTRAlt ? String.valueOf(sOut) + "<tr class='alt'>" : String.valueOf(sOut) + "<tr>";
                sOut = String.valueOf(sOut) + this.addDataCell(sName);
                sOut = String.valueOf(sOut) + this.addDataCell(this.od.num2String(chemical.getCancerRisk()));
                sOut = String.valueOf(sOut) + this.addDataCell(this.od.num2String(chemical.getNonCancerRisk()));
                sOut = String.valueOf(sOut) + "</tr>";
                this.flReport.logMessage(sOut);
                continue;
            }
            sOut = "";
        }
    }

    public void writeChemicalData() {
        this.renewArrayListsOfTables();
        this.uc = this.viCD.getUnitConverter();
        this.sSectionTitle = "Chemical Properties";
        this.alParagraph.add("Chemical parameters are found in the systemData file 02ChemicalProperties.cvs and Table (" + this.iTableCount + ")");
        this.sTableTitle = "Chemical parameters from system data file 01ChemicalProperties.csv.";
        this.tr = new TableRow();
        this.tr.add("Chemical");
        this.tr.add("Molecular Weight");
        this.tr.add("Solubility");
        this.tr.add("Density");
        this.tr.add("Koc");
        this.tr.add("Phi");
        this.tr.add("Diffusion in Air");
        this.tr.add("Diffusion in Water");
        this.tr.add("Median First Order Rate Constant");
        this.alHeading.add(this.tr);
        this.od = new OutputDigits();
        this.od.setParameters(2, -500, 500, -4, 4);
        boolean bWrite = true;
        String sName = "";
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        int iSize = alChemical.size();
        for (Chemical chemical : alChemical) {
            this.tr = new TableRow();
            sName = chemical.getName();
            if (!chemical.getIsUsedInSimulation()) continue;
            if (bWrite) {
                this.tr.add(sName);
                this.tr.add(this.od.num2String(chemical.getMolecularWeight()));
                this.tr.add(this.od.num2String(chemical.getSolubility()));
                this.tr.add(this.od.num2String(chemical.getDensity()));
                this.tr.add(this.od.num2String(chemical.getKoc()));
                this.tr.add(this.od.num2String(chemical.getPhi()));
                this.tr.add(this.od.num2String(chemical.getDa()));
                this.tr.add(this.od.num2String(chemical.getDw()));
                this.tr.add(this.od.num2String(chemical.getKw()));
                this.alTableRow.add(this.tr);
                continue;
            }
            this.sOut = "";
        }
        this.writeReportSection(this.sSectionTitle, this.alParagraph, this.sTableTitle, this.alHeading, this.alTableRow, null);
    }

    public void writeStatisticsOfOutputParagraph() throws IOException {
        String sOut = "";
        this.renewArrayListsOfTables();
        this.sSectionTitle = "Statistics of Output: ";
        sOut = "The VI Models (PVIScreen and Johnson & Ettinger) produce modeled indoor air results which range from a minimum to a maximum concentration. ";
        sOut = String.valueOf(sOut) + "These results are interpreted as that no results were less than the minimum and no results were greater than the maximum concentration. ";
        sOut = String.valueOf(sOut) + "The statistical distribution of the results is indicated by the minimum and maximum endpoints and intermediate concentrations. ";
        sOut = String.valueOf(sOut) + "The intermediate concentration are given by percentiles. ";
        sOut = String.valueOf(sOut) + "For example, 5% of the results were between the minimum and the 5<sup>th</sup> percentile. ";
        sOut = String.valueOf(sOut) + "The 50<sup>th</sup> percentile or 'median' represents the midpoint concentration where half of the results were below the 50<sup>th</sup> percentile, " + "and half were above.";
        this.alParagraph.add(sOut);
        sOut = "The VI Models calculate the indoor air concentration for the input data set which consists of the average of all input parameters. ";
        sOut = String.valueOf(sOut) + "This result will usually be lower than the maximum concentration determined through the Monte Carlo analysis, ";
        sOut = String.valueOf(sOut) + "and indicates that average-paramter solutions underestimate the maximum impacts.  See last column. ";
        this.alParagraph.add(sOut);
        this.writeReportSection(this.sSectionTitle, this.alParagraph, "", null, null, null);
    }

    public void generateHeadingsForStatistics() {
        this.renewArrayListsOfTables();
        ReadOutputForResults rofr = new ReadOutputForResults();
        rofr.setModelName(this.sModelName);
        rofr.setFileAndPathName(this.repository.getFilePathAndNameResults());
        this.alHeadings = new ArrayList();
        this.sTableTitle = String.valueOf(this.sModelName) + " Model Output Statistics";
        this.tr = new TableRow();
        this.alHeadings.add("Chemical");
        String[] dHeading = rofr.getStatisticsTypes();
        int i = 0;
        while (i < dHeading.length) {
            if (this.s.areTheyTheSame(dHeading[i], "First Quartile")) {
                this.alHeadings.add("25th Percentile");
            } else if (this.s.areTheyTheSame(dHeading[i], "Third Quartile")) {
                this.alHeadings.add("75th Percentile");
            } else {
                this.alHeadings.add(dHeading[i]);
            }
            ++i;
        }
        this.alHeadings.add("Averaged-Parameter Solution");
    }

    public void writeStatisticsOfOutput(String sModelName) throws IOException {
        this.renewArrayListsOfTables();
        ReadOutputForResults rofr = new ReadOutputForResults();
        rofr.setModelName(sModelName);
        rofr.setFileAndPathName(this.repository.getFilePathAndNameResults());
        this.sTableTitle = String.valueOf(sModelName) + " Model Output Statistics";
        this.tr = new TableRow();
        for (String sHeading : this.alHeadings) {
            this.tr.add(sHeading);
        }
        this.alHeading.add(this.tr);
        String sChemical = "";
        this.tr = new TableRow();
        this.tr.add("-");
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        for (Chemical chemical : alChemical) {
            if (!chemical.getIsUsedInSimulation()) continue;
            sChemical = chemical.getName();
            break;
        }
        double[] dResult = rofr.getOutputStatisticsUsingStandardCategories(sChemical);
        int i = 0;
        while (i < dResult.length) {
            this.tr.add(this.sOutputUnit);
            ++i;
        }
        this.tr.add(this.sOutputUnit);
        this.alHeading.add(this.tr);
        for (Chemical chemical : alChemical) {
            sChemical = "";
            if (!chemical.getIsUsedInSimulation()) continue;
            this.sOut = "";
            this.tr = new TableRow();
            sChemical = chemical.getName();
            this.tr.add(sChemical);
            dResult = rofr.getOutputStatisticsUsingStandardCategories(sChemical);
            int i2 = 0;
            while (i2 < dResult.length) {
                ModelComparison mc = new ModelComparison();
                mc.setChemicalName(sChemical);
                mc.setStatisticalCategory(this.alHeadings.get(i2 + 1));
                mc.setModelName(sModelName);
                mc.setValue(dResult[i2]);
                this.alModelComparison.add(mc);
                this.tr.add(this.od.num2String(dResult[i2]));
                ++i2;
            }
            this.tr.add(this.od.num2String(rofr.getSingleParameterResult(sChemical, "Averaged-ParameterResult")));
            this.alTableRow.add(this.tr);
            ModelComparison mc = new ModelComparison();
            mc.setChemicalName(sChemical);
            mc.setStatisticalCategory(this.alHeadings.get(this.alHeadings.size() - 1));
            mc.setModelName(sModelName);
            mc.setValue(rofr.getSingleParameterResult(sChemical, "Averaged-ParameterResult"));
            this.alModelComparison.add(mc);
        }
        this.writeReportSection("", null, this.sTableTitle, this.alHeading, this.alTableRow, null);
    }

    public void writeDifferenceBetweenPVIScreenAndJEM(boolean bPercent) {
        ArrayList<TableRow> alTableRow = new ArrayList<TableRow>();
        Stripper s = new Stripper();
        this.sTableTitle = "Reduction in Indoor Air Concentration Due to Biodegradation";
        if (bPercent) {
            this.sTableTitle = "Percent " + this.sTableTitle;
        }
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        for (Chemical chemical : alChemical) {
            if (!chemical.getIsUsedInSimulation()) continue;
            String sChemical = chemical.getName();
            this.sOut = "";
            this.tr = new TableRow();
            this.tr.add(sChemical);
            double dValueJEM = 0.0;
            double dValuePVIScreen = 0.0;
            String sHeading = "";
            int iHeading = this.alHeadings.size();
            int i = 1;
            while (i < iHeading) {
                sHeading = this.alHeadings.get(i);
                for (ModelComparison mc : this.alModelComparison) {
                    if (!s.areTheyEqual(sChemical, mc.getChemicalName()) || !s.areTheyEqual(sHeading, mc.getStatisticalCategory())) continue;
                    if (s.areTheyEqual("JEM", mc.getModelName())) {
                        dValueJEM = mc.getValue();
                    }
                    if (!s.areTheyEqual("PVIScreen", mc.getModelName())) continue;
                    dValuePVIScreen = mc.getValue();
                }
                if (bPercent) {
                    this.tr.add(this.od.num2String(100.0 * (dValueJEM - dValuePVIScreen) / dValueJEM));
                } else {
                    this.tr.add(this.od.num2String(dValueJEM - dValuePVIScreen));
                }
                ++i;
            }
            alTableRow.add(this.tr);
        }
        this.writeReportSection("", null, this.sTableTitle, this.alHeading, alTableRow, null);
    }

    public void writeAveragedParameterSolution() throws IOException {
        this.renewArrayListsOfTables();
        this.sSectionTitle = "Averaged-Parameter Solution";
        String sOut = "PVIScreen calculates the indoor air concentration for the input data set which consists of the average of all input parameters. ";
        sOut = String.valueOf(sOut) + "This result will be lower than the maximum concentration determined through the Monte Carlo analysis, ";
        sOut = String.valueOf(sOut) + "and indicates that average-paramter solutions underestimate the maximum impacts. ";
        this.alParagraph.add(sOut);
        ReadOutputForResults rofr = new ReadOutputForResults();
        rofr.setFileAndPathName(this.repository.getFilePathAndNameResults());
        this.sTableTitle = "Averaged-Parameter Solution";
        String sOutputUnit = this.uc.getOutputNameFromType("AirPhaseConcentration");
        this.tr = new TableRow();
        this.tr.add(" Chemical ");
        this.tr.add(" Averaged-Parameter Solution (" + sOutputUnit + ")");
        String sChemical = "";
        for (Chemical chemical : this.viCD.getChemicals()) {
            if (!chemical.getIsUsedInSimulation()) continue;
            TableRow tr = new TableRow();
            sChemical = chemical.getName();
            tr.add(sChemical);
            tr.add(this.od.num2String(rofr.getSingleParameterResult(sChemical, "Averaged-ParameterResult")));
            this.alTableRow.add(tr);
        }
        this.writeReportSection(this.sSectionTitle, this.alParagraph, this.sTableTitle, this.alHeading, this.alTableRow, null);
    }

    public void writeReportSection(String sSectionTitle, ArrayList<String> alParagraph, String sTableTitle, ArrayList<TableRow> alHeading, ArrayList<TableRow> alTableRow, ArrayList<TableRow> alTableNotes) {
        boolean bTRAlt = true;
        if (!sSectionTitle.equals("")) {
            this.flReport.logMessage("<h2>" + sSectionTitle + "</h2>");
        }
        if (alParagraph != null) {
            for (String sParagraph : alParagraph) {
                this.flReport.logMessage("<p>" + sParagraph + "</p>");
            }
        }
        if (!sTableTitle.equals("")) {
            ArrayList<String> alEntry;
            this.flReport.logMessage("<center><table id='risk'>");
            ++this.iTableCount;
            this.flReport.logMessage("<tr><th colspan='10'>Table " + this.iTableCount + " " + sTableTitle + "</th></tr>");
            if (alHeading != null) {
                for (TableRow tr : alHeading) {
                    alEntry = tr.getTableRow();
                    String sOut = "<tr>";
                    for (String sEntry : alEntry) {
                        sOut = String.valueOf(sOut) + this.addHeadingCell(sEntry);
                    }
                    sOut = String.valueOf(sOut) + "</tr>";
                    this.flReport.logMessage(sOut);
                }
            }
            if (alTableRow != null) {
                for (TableRow tr : alTableRow) {
                    this.sOut = "";
                    bTRAlt = !bTRAlt;
                    this.sOut = bTRAlt ? String.valueOf(this.sOut) + "<tr class='alt'>" : String.valueOf(this.sOut) + "<tr>";
                    alEntry = tr.getTableRow();
                    for (String sEntry : tr.getTableRow()) {
                        this.sOut = String.valueOf(this.sOut) + this.addDataCell(sEntry);
                    }
                    this.sOut = String.valueOf(this.sOut) + "</tr>";
                    this.flReport.logMessage(this.sOut);
                }
                if (alTableNotes != null) {
                    for (TableRow tr : alTableNotes) {
                        alEntry = tr.getTableRow();
                        for (String sEntry : alEntry) {
                            this.flReport.logMessage("<tr>" + this.addDataCell(sEntry) + "</td></tr>");
                        }
                    }
                }
                this.flReport.logMessage("</table></center>");
                this.flReport.logMessage("<br>");
            }
        }
    }

    public void renewArrayListsOfTables() {
        this.alParagraph = new ArrayList();
        this.alHeading = new ArrayList();
        this.alTableRow = new ArrayList();
        this.alTableNotes = new ArrayList();
    }

    private String addHeadingCell(String sData) {
        return "<th> " + sData + " " + "</th>";
    }

    private String addDataCell(String sData) {
        return "<td> " + sData + " " + "</td>";
    }

    private String addDataCell(double dData) {
        return "<td> " + dData + " " + "</td>";
    }

    private String addListItem(String sItem) {
        return "<li>" + sItem + "</li>";
    }

    public void endReport() {
        this.flReport.logMessage("</body>");
        this.flReport.logMessage("</html>");
    }

    public void generateImagesAndRisk() {
        ObservableList<String> olChemical = this.repository.getAllChemicalChoices();
        block0: for (String sChemical : olChemical) {
            for (Chemical c : this.viCD.getChemicals()) {
                if (!this.s.areTheyEqual(sChemical, c.getName())) continue;
                this.hsp.drawStatistics(c, sChemical, false, true, false);
                continue block0;
            }
        }
    }

    public String getReportFileName(String sFileAndPath) {
        int iLength;
        int iDot = 0;
        iDot = iLength = sFileAndPath.length();
        int i = iLength - 1;
        while (i == 0) {
            char c = sFileAndPath.charAt(i);
            if (c == '.') {
                iDot = i;
                break;
            }
            --i;
        }
        String sNew = "";
        i = 0;
        while (i < iDot) {
            sNew = String.valueOf(sNew) + sFileAndPath.charAt(i);
            ++i;
        }
        sNew = String.valueOf(sNew) + ".";
        this.sReportFileName = sNew = String.valueOf(sNew) + "htm";
        return sNew;
    }

    public void setFileLogger(FileLogger flReport) {
        this.flReport = flReport;
    }

    public void setInputFileAndPath(String sInputFileAndPath) {
        this.sInputFileAndPath = sInputFileAndPath;
    }

    public void setOutputFileAndPath(String sOutputFileAndPath) {
        this.sOutputFileAndPath = sOutputFileAndPath;
    }

    public void setHandlerRepository(Repository repository) {
        this.repository = repository;
    }

    public void setHandlerSitePlot(HandlerSitePlot hSitePlot) {
        this.hSitePlot = hSitePlot;
    }

    public void setModelName(String sModelName) {
        this.sModelName = sModelName;
    }

    class ModelComparison {
        String sChemicalName;
        String sStatisticalCategory;
        String sModelName;
        double dValue;

        public void setChemicalName(String sChemicalName) {
            this.sChemicalName = sChemicalName;
        }

        public void setStatisticalCategory(String sStatisticalCategory) {
            this.sStatisticalCategory = sStatisticalCategory;
        }

        public void setModelName(String sModelName) {
            this.sModelName = sModelName;
        }

        public void setValue(double dValue) {
            this.dValue = dValue;
        }

        public String getChemicalName() {
            return this.sChemicalName;
        }

        public String getStatisticalCategory() {
            return this.sStatisticalCategory;
        }

        public String getModelName() {
            return this.sModelName;
        }

        public double getValue() {
            return this.dValue;
        }
    }

    class TableRow {
        ArrayList<String> alTableRow = new ArrayList();

        public void add(String sEntry) {
            this.alTableRow.add(sEntry);
        }

        public ArrayList<String> getTableRow() {
            return this.alTableRow;
        }
    }
}

