/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import pviScreen.dataContainers.VIControlData;
import statistics.RiskContainer;
import ui.DefaultNameRange;
import ui.VIUIInputData;
import ui.handler.HandlerEdit;
import ui.handler.HandlerRiskChoice;
import ui.handler.HandlerStatisticsPlot;
import ui.handler.WrappedEventHandler;
import util.ClipPathOrFile;
import util.Stripper;

public class Repository {
    private BorderPane border;
    private String sInputFile;
    private String sInputFileAndPath;
    private String sDirectory = "";
    private boolean bInputFileFlagSet = false;
    private String sInputChemical;
    private boolean bInputChemicalFlagSet = false;
    private String sInputType;
    private boolean bInputTypeFlagSet = false;
    private String sFilePathAndNameResults;
    private String sFilePathAndNameHTML;
    private boolean bFileResultsNameFlagSet;
    private String sTopLabelText;
    private VIControlData viCD;
    private boolean bEditControlChanged = false;
    private ArrayList<String[]> alControlMade = new ArrayList();
    private TabPane tpStatistics;
    private WritableImage wiSite;
    private ArrayList<WritableImage> alOutputImages = new ArrayList();
    private ArrayList<String> alOutputImageNames = new ArrayList();
    private RiskContainer rc;
    private ObservableList<String> olChemical;
    private ArrayList<DefaultNameRange> alAirExchange = new ArrayList();
    private HandlerStatisticsPlot hsp;
    private HandlerEdit he;
    private HandlerRiskChoice hrc;
    private FileChooser fc;
    private ArrayList<HBox> alHbox;
    private ObservableList<Button> olButton;
    private double[] dColorLow;
    private double[] dColorHigh;
    private Tab tabScreening;
    private boolean bInputEditable = true;
    private VIUIInputData viUIInputData;
    private boolean bSelectAFile = true;
    private boolean bSpecifiedFile = false;
    private String sSpecifiedDirectoryFullPath = "";
    private String sSpecifiedDirectoryStem = "";
    private String sSpecifiedFileStem = "";
    private String sInputEstimationType = "";
    private ArrayList<WrappedEventHandler> alWrappedEventHandler = new ArrayList();
    private String sPNGSiteSchematicFileName;
    private Stage stage;
    private HBox hBoxTopLabel;

    Repository() {
    }

    public void addPriorControl(String sDataGroup, String sDescription, String sDescription2) {
        String[] sInput = new String[]{sDataGroup, sDescription, sDescription2};
        this.alControlMade.add(sInput);
    }

    public void removePriorControl(String sDataGroup, String sDescription, String sDescription2) {
        Stripper s = new Stripper();
        ArrayList<String[]> alControlToRemove = new ArrayList<String[]>();
        for (String[] string : this.alControlMade) {
            boolean bReturn = false;
            if (!s.areTheyEqual(sDataGroup, string[0]) || !s.areTheyEqual(sDescription, string[1]) || !s.areTheyEqual(sDescription2, string[2])) continue;
            alControlToRemove.add(string);
            break;
        }
        for (String[] string : alControlToRemove) {
            this.alControlMade.remove(string);
            this.viCD.getRawInput().removeRawInputLine(string[0], string[1], string[2]);
        }
        for (HBox hBox : this.alHbox) {
        }
    }

    private ArrayList<String[]> removeScreeningLevel(String[] string) {
        ArrayList<String[]> alControlMadeNew = new ArrayList<String[]>();
        Stripper s = new Stripper();
        string[0] = "ScreeningLevel";
        string[2] = "";
        for (String[] ss : this.alControlMade) {
            if (s.areTheyEqual(string[0], ss[0], ' ') && s.areTheyEqual(string[1], ss[1], ' ') && s.areTheyEqual(string[2], ss[2], ' ')) continue;
            alControlMadeNew.add(ss);
        }
        return alControlMadeNew;
    }

    public void clearPriorControls() {
        this.alControlMade.clear();
    }

    public boolean checkForPreviousControl(String sDataGroup, String sDescription, String sDescription2) {
        Stripper s = new Stripper();
        boolean bReturn = false;
        String s0Input = s.removeCharacter(' ', sDataGroup);
        String s1Input = s.removeCharacter(' ', sDescription);
        String s2Input = s.removeCharacter(' ', sDescription2);
        for (String[] string : this.alControlMade) {
            String s0 = s.removeCharacter(' ', string[0]);
            String s1 = s.removeCharacter(' ', string[1]);
            String s2 = s.removeCharacter(' ', string[2]);
            if (!s0.equalsIgnoreCase(s0Input) || !s1.equalsIgnoreCase(s1Input) || !s2.equalsIgnoreCase(s2Input)) continue;
            bReturn = true;
            break;
        }
        return bReturn;
    }

    public void clearPreviousPVIScreenControlData() {
        this.viCD = new VIControlData();
        this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), "New viControlData created");
    }

    public void addOutputImage(WritableImage wi) {
        this.alOutputImages.add(wi);
    }

    public void addOutputImageName(String sName) {
        this.alOutputImageNames.add(sName);
    }

    public void addAirExchange(String sName, String sBuildingType, double dMin, double dMax) {
        this.alAirExchange.add(new DefaultNameRange(sName, sBuildingType, dMin, dMax));
    }

    public void addEventHandler(WrappedEventHandler weh) {
        this.alWrappedEventHandler.add(weh);
    }

    public void clearPreviousControlArrayList() {
        this.alControlMade = new ArrayList();
    }

    public void removeAirExchangeRates() {
        this.alAirExchange = new ArrayList();
    }

    public void refreshRiskResults() {
        this.rc.initialize();
    }

    public void setInputFile(String s) {
        this.sInputFile = s;
    }

    public void setInputFileAndPath(String s) {
        this.sInputFileAndPath = s;
    }

    public void setInputFileFlagSet(boolean b) {
        this.bInputFileFlagSet = b;
    }

    public void setDirectory(String s) {
        this.sDirectory = s;
    }

    public void setInputChemical(String s) {
        this.sInputChemical = s;
    }

    public void setInputChemicalFlagSet(boolean b) {
        this.bInputChemicalFlagSet = b;
    }

    public void setInputType(String s) {
        this.sInputType = s;
    }

    public void setInputTypeFlagSet(boolean b) {
        this.bInputTypeFlagSet = b;
    }

    public void setBorder(BorderPane border) {
        this.border = border;
    }

    public void setFilePathAndNameResults(String s) {
        this.sFilePathAndNameResults = s;
    }

    public void setFilePathAndNameHTML(String s) {
        this.sFilePathAndNameHTML = s;
    }

    public void setFileResultsNameFlagSet(boolean b) {
        this.bFileResultsNameFlagSet = b;
    }

    public void setTopLabelText(String s) {
        this.sTopLabelText = s;
    }

    public void setVIControlData(VIControlData viControlData) {
        this.viCD = viControlData;
    }

    public void setEditControlChanged(boolean bEditControlChanged) {
        this.bEditControlChanged = bEditControlChanged;
    }

    public void setSiteSchematic(WritableImage wiSite) {
        this.wiSite = wiSite;
    }

    public void setRiskContainer(RiskContainer rc) {
        this.rc = rc;
    }

    public void setAllChemicalChoices(ObservableList<String> alChemical) {
        this.olChemical = alChemical;
    }

    public void setHandlerStatisticsPlot(HandlerStatisticsPlot hsp) {
        this.hsp = hsp;
    }

    public void setHandlerEdit(HandlerEdit he) {
        this.he = he;
    }

    public void setHandlerRiskChoice(HandlerRiskChoice hrc) {
        this.hrc = hrc;
    }

    public void setStatisticsTabPane(TabPane tp) {
        this.tpStatistics = tp;
    }

    public void setFileChooser(FileChooser fc) {
        this.fc = fc;
    }

    public void setHboxList(ArrayList<HBox> alHbox) {
        this.alHbox = alHbox;
    }

    public void setButtonList(ObservableList<Button> olButton) {
        this.olButton = olButton;
    }

    public void setColorLow(double[] dColorLow) {
        this.dColorLow = dColorLow;
    }

    public void setColorHigh(double[] dColorHigh) {
        this.dColorHigh = dColorHigh;
    }

    public void setScreeningTab(Tab tabScreening) {
        this.tabScreening = tabScreening;
    }

    public void setVIUIInputData(VIUIInputData viUIInputData) {
        this.viUIInputData = viUIInputData;
    }

    public void setInputEditable(boolean bInputEditable) {
        this.bInputEditable = bInputEditable;
    }

    public void setSelectAFile(boolean bSelectAFile) {
        this.bSelectAFile = bSelectAFile;
    }

    public void setSpecifiedFile(boolean b) {
        this.bSpecifiedFile = b;
    }

    public void setSpecifiedDirectryFullPath(String s) {
        this.sSpecifiedDirectoryFullPath = s;
        this.bSelectAFile = true;
    }

    public void setSpecifiedDirectoryStem(String sSpecifiedDirectory) {
        String sFileStem;
        this.sSpecifiedDirectoryStem = sFileStem = sSpecifiedDirectory;
        this.bSelectAFile = true;
    }

    public void setSpecifiedFileStem(String sSpecifiedFile) {
        String sFileStem;
        ClipPathOrFile cpof = new ClipPathOrFile();
        this.sSpecifiedFileStem = sFileStem = cpof.clipPathOrFile(sSpecifiedFile, "stem");
        this.bSelectAFile = true;
    }

    public void setInputEstimationType(String s) {
        this.sInputEstimationType = s;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setTopLabelHBox(HBox hBoxTopLabel) {
        this.hBoxTopLabel = hBoxTopLabel;
    }

    public void setPNGSiteSchematicFileName(String sPNGSiteSchematicFileName) {
        this.sPNGSiteSchematicFileName = sPNGSiteSchematicFileName;
    }

    public String getInputFile() {
        return this.sInputFile;
    }

    public String getInputFileAndPath() {
        return this.sInputFileAndPath;
    }

    public boolean getInputFileFlagSet() {
        return this.bInputFileFlagSet;
    }

    public String getDirectory() {
        return this.sDirectory;
    }

    public String getInputChemical() {
        return this.sInputChemical;
    }

    public boolean getInputChemicalFlagSet() {
        return this.bInputChemicalFlagSet;
    }

    public ArrayList<DefaultNameRange> getAirExchange() {
        return this.alAirExchange;
    }

    public String getInputType() {
        return this.sInputType;
    }

    public boolean getInputTypeFlagSet() {
        return this.bInputTypeFlagSet;
    }

    public BorderPane getBorder() {
        return this.border;
    }

    public String getFilePathAndNameResults() {
        return this.sFilePathAndNameResults;
    }

    public String getFilePathAndNameHTML() {
        return this.sFilePathAndNameHTML;
    }

    public boolean getFileResultsNameFlagSet() {
        return this.bFileResultsNameFlagSet;
    }

    public String getTopLabelText() {
        return this.sTopLabelText;
    }

    public VIControlData getVIControlData() {
        return this.viCD;
    }

    public boolean getEditControlChanged() {
        return this.bEditControlChanged;
    }

    public WritableImage getSiteSchematic() {
        return this.wiSite;
    }

    public ArrayList<WritableImage> getOutputImages() {
        return this.alOutputImages;
    }

    public ArrayList<String> getOutputImageNames() {
        return this.alOutputImageNames;
    }

    public RiskContainer getRiskContainer() {
        return this.rc;
    }

    public ObservableList<String> getAllChemicalChoices() {
        return this.olChemical;
    }

    public HandlerStatisticsPlot getHandlerStatisticsPlot() {
        return this.hsp;
    }

    public HandlerEdit getHandlerEdit() {
        return this.he;
    }

    public HandlerRiskChoice getHandlerRiskChoice() {
        return this.hrc;
    }

    public TabPane getStatisticsTabPane() {
        return this.tpStatistics;
    }

    public FileChooser getFileChooser() {
        return this.fc;
    }

    public ArrayList<HBox> getHBoxList() {
        return this.alHbox;
    }

    public ObservableList<Button> getButtonList() {
        return this.olButton;
    }

    public double[] getColorLow() {
        return this.dColorLow;
    }

    public double[] getColorHigh() {
        return this.dColorHigh;
    }

    public Tab getScreeningTab() {
        return this.tabScreening;
    }

    public VIUIInputData getPVIScreenUIInputData() {
        return this.viUIInputData;
    }

    public boolean getInputEditable() {
        return this.bInputEditable;
    }

    public boolean getSelectAFile() {
        return this.bSelectAFile;
    }

    public boolean getSpecifiedFile() {
        return this.bSpecifiedFile;
    }

    public String getSpecifiedDirectoryFullPath() {
        return this.sSpecifiedDirectoryFullPath;
    }

    public String getSpecifiedDirectoryStem() {
        return this.sSpecifiedDirectoryStem;
    }

    public String getSpecifiedFileStem() {
        return this.sSpecifiedFileStem;
    }

    public String getInputEstimationType() {
        return this.sInputEstimationType;
    }

    public double getStageWidth() {
        return this.stage.getWidth();
    }

    public double getStageHeight() {
        return this.stage.getHeight();
    }

    public HBox getTopLabelHBox() {
        return this.hBoxTopLabel;
    }

    public String getPNGSiteSchematicFileName() {
        return this.sPNGSiteSchematicFileName;
    }

    public WrappedEventHandler getEventHandler(String sNameToFind) {
        WrappedEventHandler wehReturn = new WrappedEventHandler();
        Stripper s = new Stripper();
        for (WrappedEventHandler weh : this.alWrappedEventHandler) {
            if (!s.areTheyEqual(weh.getHandlerName(), sNameToFind)) continue;
            return weh;
        }
        return wehReturn;
    }
}

