/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.IOException;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import pviScreen.dataContainers.VIControlData;
import ui.AddToTheGridPane;
import ui.Repository;
import ui.WrappedRadioButton;
import ui.handler.HandlerEdit;
import ui.handler.HandlerFetchTemplate;
import ui.handler.HandlerInput;
import ui.handler.HandlerSampleType;
import ui.handler.HandlerSourceAndDataInput;
import util.NameConstants;
import util.Stripper;

public class SelectATemplate {
    private NameConstants nc;
    private Repository repository;
    private HandlerEdit he;
    private HandlerInput hi;
    private VIControlData viCD;
    private String sInputType;
    private Stripper s;
    private ComboBox cbChemical;
    private BorderPane border;
    private AddToTheGridPane attgp = new AddToTheGridPane();
    private String sFileName = "";
    private String sDirectory = "";
    private ArrayList<ToggleGroup> alToggleGroup;
    private ObservableList<Button> olButton;
    private Label lTopLabel;
    private ObservableList<Node> olNodes;
    private TextField tfDirectoryName;
    private TextField tfProjectName;

    public SelectATemplate() {
        this.nc = new NameConstants();
        this.s = new Stripper();
        this.alToggleGroup = new ArrayList();
    }

    public void selectATemplate(Stage stage) throws IOException {
        BorderPane border = this.repository.getBorder();
        int iCount = 0;
        GridPane gpTop = new GridPane();
        ScrollPane sp = new ScrollPane();
        Button bFetch = new Button();
        bFetch = new Button(this.nc.s_ButtonTemplateSelect);
        HandlerFetchTemplate hFetchTemplate = new HandlerFetchTemplate(stage);
        hFetchTemplate.setHandlerInput(this.hi);
        bFetch.addEventHandler(ActionEvent.ACTION, (EventHandler)hFetchTemplate);
        hFetchTemplate.setSelectATemplate(this);
        hFetchTemplate.setRepository(this.repository);
        hFetchTemplate.setToggleGroup(this.alToggleGroup);
        int iSpacer = 10;
        iCount = this.attgp.addBlankLines(gpTop, 5, iCount, iSpacer);
        iCount = this.attgp.addTextLines(gpTop, "Select Simulation Characteristics", new HBox(new Node[]{new Text("")}), iCount, iSpacer);
        iCount = this.attgp.addBlankLines(gpTop, 2, iCount, iSpacer);
        String sGroupName = this.nc.s_TemplateProjectName;
        this.tfProjectName = new TextField();
        hFetchTemplate.setTextFieldProjectName(this.tfProjectName);
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)this.tfProjectName);
        HBox hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        sGroupName = String.valueOf(this.nc.s_TemplateDirectory) + " (below c\\:" + this.nc.s_TemplateDirectryStub + ")";
        this.tfDirectoryName = new TextField();
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)this.tfDirectoryName);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        ToggleGroup tgSampleType = new ToggleGroup();
        WrappedRadioButton rbGW = new WrappedRadioButton(this.nc.s_RadioGroundWater);
        sGroupName = this.nc.s_RadioGNSample;
        rbGW.setGroupName(sGroupName);
        rbGW.setSelected(true);
        rbGW.setToggleGroup(tgSampleType);
        WrappedRadioButton rbSG = new WrappedRadioButton(this.nc.s_RadioSoilGas);
        rbSG.setGroupName(sGroupName);
        rbSG.setSelected(false);
        rbSG.setToggleGroup(tgSampleType);
        this.alToggleGroup.add(tgSampleType);
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)rbGW);
        this.olNodes.add((Object)rbSG);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        ToggleGroup tgSourceConcentration = new ToggleGroup();
        WrappedRadioButton rbDissolved = new WrappedRadioButton(this.nc.s_RadioDissolved);
        sGroupName = this.nc.s_RadioGNSource;
        rbDissolved.setGroupName(sGroupName);
        rbDissolved.setSelected(true);
        rbDissolved.setToggleGroup(tgSourceConcentration);
        WrappedRadioButton rbNAPL = new WrappedRadioButton(this.nc.s_RadioNAPL);
        rbNAPL.setGroupName(sGroupName);
        rbNAPL.setSelected(false);
        rbNAPL.setToggleGroup(tgSourceConcentration);
        this.alToggleGroup.add(tgSourceConcentration);
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)rbDissolved);
        this.olNodes.add((Object)rbNAPL);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        ++iCount;
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        ToggleGroup tgNAPLType = new ToggleGroup();
        WrappedRadioButton rbNAPLFresh = new WrappedRadioButton(this.nc.s_RadioNAPLFresh);
        sGroupName = this.nc.s_RadioGNNAPL;
        rbNAPLFresh.setGroupName(sGroupName);
        rbNAPLFresh.setSelected(true);
        rbNAPLFresh.setDisable(true);
        rbNAPLFresh.setToggleGroup(tgNAPLType);
        WrappedRadioButton rbNAPLWeathered = new WrappedRadioButton(this.nc.s_RadioNAPLWeathered);
        rbNAPLWeathered.setGroupName(sGroupName);
        rbNAPLWeathered.setSelected(false);
        rbNAPLWeathered.setDisable(true);
        rbNAPLWeathered.setToggleGroup(tgNAPLType);
        WrappedRadioButton rbNAPLOther = new WrappedRadioButton(this.nc.s_RadioNAPLOther);
        rbNAPLOther.setGroupName(sGroupName);
        rbNAPLOther.setSelected(false);
        rbNAPLOther.setDisable(true);
        rbNAPLOther.setToggleGroup(tgNAPLType);
        this.alToggleGroup.add(tgNAPLType);
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)rbNAPLFresh);
        this.olNodes.add((Object)rbNAPLWeathered);
        this.olNodes.add((Object)rbNAPLOther);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        ++iCount;
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        ToggleGroup tgConcInputType = new ToggleGroup();
        WrappedRadioButton rbTPHEstimate = new WrappedRadioButton(this.nc.s_RadioEstimatedTPH);
        sGroupName = this.nc.s_RadioGNConc;
        rbTPHEstimate.setGroupName(sGroupName);
        rbTPHEstimate.setSelected(false);
        rbTPHEstimate.setDisable(true);
        rbTPHEstimate.setToggleGroup(tgConcInputType);
        WrappedRadioButton rbEnter = new WrappedRadioButton(this.nc.s_RadioEnterTPH);
        rbEnter.setGroupName(sGroupName);
        rbEnter.setSelected(true);
        rbEnter.setToggleGroup(tgConcInputType);
        this.alToggleGroup.add(tgConcInputType);
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)rbEnter);
        this.olNodes.add((Object)rbTPHEstimate);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        ++iCount;
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        rbDissolved.setSelected(true);
        ToggleGroup tgCapillary = new ToggleGroup();
        WrappedRadioButton rbYes = new WrappedRadioButton(this.nc.s_RadioCapillaryYes);
        sGroupName = this.nc.s_RadioGNCapillary;
        rbYes.setGroupName(sGroupName);
        rbYes.setSelected(true);
        rbYes.setToggleGroup(tgCapillary);
        WrappedRadioButton rbNo = new WrappedRadioButton(this.nc.s_RadioCapillaryNo);
        rbNo.setGroupName(sGroupName);
        rbNo.setSelected(false);
        rbNo.setToggleGroup(tgCapillary);
        this.alToggleGroup.add(tgCapillary);
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)rbYes);
        this.olNodes.add((Object)rbNo);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        ++iCount;
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        HandlerSourceAndDataInput hsadi = new HandlerSourceAndDataInput();
        hsadi.setTGNAPL(tgNAPLType);
        hsadi.setTGSource(tgSourceConcentration);
        hsadi.setTGConcInputType(tgConcInputType);
        hsadi.setTGCapillary(tgCapillary);
        rbDissolved.addEventHandler(ActionEvent.ACTION, hsadi);
        rbNAPL.addEventHandler(ActionEvent.ACTION, hsadi);
        rbNAPLFresh.addEventHandler(ActionEvent.ACTION, hsadi);
        rbNAPLWeathered.addEventHandler(ActionEvent.ACTION, hsadi);
        rbNAPLOther.addEventHandler(ActionEvent.ACTION, hsadi);
        rbEnter.addEventHandler(ActionEvent.ACTION, hsadi);
        rbTPHEstimate.addEventHandler(ActionEvent.ACTION, hsadi);
        HandlerSampleType hst = new HandlerSampleType();
        hst.setTGNAPL(tgNAPLType);
        hst.setTGSource(tgSourceConcentration);
        hst.setTGConcInputType(tgConcInputType);
        hst.setTGCapillary(tgCapillary);
        hst.setTGSampelType(tgSampleType);
        rbGW.addEventHandler(ActionEvent.ACTION, hst);
        rbSG.addEventHandler(ActionEvent.ACTION, hst);
        ToggleGroup tgBuildingUse = new ToggleGroup();
        this.nc.getClass();
        WrappedRadioButton rb2 = new WrappedRadioButton("Residential");
        sGroupName = this.nc.s_RadioGNBuilding;
        rb2.setGroupName(sGroupName);
        rb2.setSelected(true);
        rb2.setToggleGroup(tgBuildingUse);
        this.nc.getClass();
        WrappedRadioButton rb0 = new WrappedRadioButton("Commercial");
        rb0.setGroupName(sGroupName);
        rb0.setSelected(false);
        rb0.setToggleGroup(tgBuildingUse);
        this.alToggleGroup.add(tgBuildingUse);
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)rb2);
        this.olNodes.add((Object)rb0);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        ++iCount;
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        ToggleGroup tgAER = new ToggleGroup();
        WrappedRadioButton rbFull = new WrappedRadioButton(this.nc.s_RadioAERFull);
        sGroupName = this.nc.s_RadioGNAirExchange;
        rbFull.setGroupName(sGroupName);
        rbFull.setSelected(true);
        rbFull.setToggleGroup(tgAER);
        WrappedRadioButton rbDrafty = new WrappedRadioButton(this.nc.s_RadioAERDrafty);
        rbDrafty.setGroupName(sGroupName);
        rbDrafty.setSelected(false);
        rbDrafty.setToggleGroup(tgAER);
        WrappedRadioButton rbTight = new WrappedRadioButton(this.nc.s_RadioAERTight);
        rbTight.setGroupName(sGroupName);
        rbTight.setSelected(false);
        rbTight.setToggleGroup(tgAER);
        this.alToggleGroup.add(tgAER);
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)rbFull);
        this.olNodes.add((Object)rbDrafty);
        this.olNodes.add((Object)rbTight);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        ++iCount;
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        ToggleGroup tgRisk = new ToggleGroup();
        sGroupName = this.nc.s_RadioGNRisk;
        WrappedRadioButton rbScreeningLevel = new WrappedRadioButton(this.nc.s_RadioScreeningLevel);
        sGroupName = this.nc.s_RadioGNRisk;
        rbScreeningLevel.setGroupName(sGroupName);
        rbScreeningLevel.setSelected(true);
        rbScreeningLevel.setToggleGroup(tgRisk);
        HBox hbRisk = new HBox();
        hbRisk.getChildren().addAll((Object[])new Node[]{rbScreeningLevel});
        this.olNodes = FXCollections.observableArrayList();
        this.olNodes.add((Object)rbScreeningLevel);
        hbox = new HBox();
        hbox.getChildren().addAll(this.olNodes);
        ++iCount;
        iCount = this.attgp.addTextLines(gpTop, sGroupName, hbox, iCount, iSpacer);
        iCount = this.attgp.addBlankLines(gpTop, 2, iCount, iSpacer);
        HBox hbox7 = new HBox();
        hbox7.getChildren().addAll((Object[])new Node[]{bFetch});
        gpTop.add((Node)hbox7, 1, ++iCount);
        sp.setContent((Node)gpTop);
        border.setCenter((Node)sp);
        stage.show();
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setHandlerInput(HandlerInput hi) {
        this.hi = hi;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public void setChemicalComboBox(ComboBox cbChemical) {
        this.cbChemical = cbChemical;
    }

    public String getProjectName() {
        return this.tfProjectName.getText();
    }

    public String getDirectoryName() {
        return this.tfDirectoryName.getText();
    }
}

