/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.IOException;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataReaders.VIDataReader;
import util.FileModifier;
import util.NameConstants;
import util.UnitConverter;

public class VIUIInputData {
    private VIDataReader viReader;
    private String sFileAndPathName;
    private String sStatisticsFileAndPathName;
    private String sResultsFileAndPathName;
    private String sOutputFileTime;
    private VIControlData viCD;
    private UnitConverter uc;
    private FileModifier fm = new FileModifier();

    public VIUIInputData() {
        this.fm.setTimeStamp();
    }

    public void readInputData() throws IOException {
        this.viReader = new VIDataReader();
        this.viReader.setVIControlData(this.viCD);
        this.viReader.initial();
        this.viReader.setFileModifier(this.fm);
        this.viReader.setWriteFile(false);
        this.viReader.readFile(this.sFileAndPathName);
        this.viCD = this.viReader.getVIControlData();
    }

    public void extractInputFileNameFromOutputFile(String sOutputFileName, String sOutputFileAndPathName) {
        NameConstants nc = new NameConstants();
        this.sResultsFileAndPathName = sOutputFileAndPathName;
        this.sStatisticsFileAndPathName = sOutputFileAndPathName;
        this.sFileAndPathName = String.valueOf(this.fm.removeExtensionAndTimeStamp(sOutputFileAndPathName)) + '.' + nc.s_Extension_Input;
    }

    public void setFileAndPathName(String sFileAndPathName) {
        this.sFileAndPathName = sFileAndPathName;
    }

    public void setResultsFileAndPathName(String sFileAndPathName, String sNewFileType, int iDots) {
        this.sResultsFileAndPathName = this.fm.getOutputFileAndPathName(sFileAndPathName, "", iDots, sNewFileType, true);
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public VIControlData getPVIScreenControlData() {
        return this.viCD;
    }

    public FileModifier getFileModifier() {
        return this.fm;
    }
}

